/**
 * @name		jQuery Countdown Plugin
 * @author		Martin Angelov
 * @version 	1.0
 * @url			http://tutorialzine.com/2011/12/countdown-jquery/
 * @license		MIT License
 * GuyF : modifié en compteur pour 2 digit
 */

(function($){


	// Creating the plugin
	$.fn.compteur = function(prop){

		var options = $.extend({
			callback	: function(){},
			target	: 0
		},prop);

		// Initialize the plugin
		init(this, options);

		positions = this.find('.position');
		updateDuo(0, 1, options.target);


		// This function updates two digit positions at once
		function updateDuo(minor,major,value){


			switchDigit(positions.eq(minor),250,positions.eq(minor).data('digit'),Math.floor(value/10)%10);



			switchDigit(positions.eq(major),150,positions.eq(major).data('digit'),value%10);
		}

		return this;
	};


	function init(elem, options){
		/*
		elem.removeClass('countdownHolder');
		elem.remove('count');
		elem.addClass('countdownHolder');
		$('<span class="count">' +
				 '<span class="position">' +
				 '<span class="digit static">0</span>' +
				 '</span>' +
				 '<span class="position">' +
				 '<span class="digit static">0</span>' +
				 '</span>' +
				 '</span>').appendTo(elem);

			*/
	}

	// Creates an animated transition between the two numbers
	function switchDigit(position,delay,number,target){
		if (isNaN(number)) number=0;

		var digit = position.find('.digit');






		var current = position.data('digit');
		if( current == target){
			// We are already showing this number
			return false;
		}

		digit.stop(true,true);
		digit.removeClass('static');
		for (var i = 1; i < digit.length-1; i++) {
			digit[i].remove();
		}

		var inc=0;
		var next=current;
		if (target>current) {
			next=(current+1)%10;
			inc=1;
		} else {
			next=(current-1)%10;
			inc=-1;
		}
		if (target==0 && current==9) {
			next=target;
			inc=+1;
		}
		if (current==0 && target==9) {
			next=target
			inc=-1;
		}

		if( current == number){
			switchDigit(position,0,(next)%10,target);
			return;
		}

		position.data('digit', number);



		// The .static class is added when the animation
		// completes. This makes it run smoother.
		if (inc>=0)
		{
			var replacement = $('<span>',{
				'class':'digit',
				css:{
					top:'-2.1em',
					opacity:0
				},
				html:number
			});
		digit
			.before(replacement)
			.removeClass('static')
			.animate({top:'2.5em',opacity:0},250,function(){
				digit.remove();
			});

		replacement
			.delay(delay)
			.animate({top:0,opacity:1},250,function(){
				replacement.addClass('static');
				digit.remove();
				if (number==target)
					return;
				switchDigit(position,0,next,target);
			});
		} else {

			var replacement = $('<span>',{
				'class':'digit',
				css:{
					top:'+2.1em',
					opacity:0
				},
				html:number
			});
		digit
			.before(replacement)
			.removeClass('static')
			.animate({top:'-2.5em',opacity:0},250,function(){
				digit.remove();
			});

		replacement
			.delay(delay)
			.animate({top:0,opacity:1},250,function(){
				replacement.addClass('static');
				digit.remove();
				if (number==target)
					return;
				switchDigit(position,0,next,target);
			});
		}
	}
})(jQuery);
