
var currentDate = new Date();
var currentYear = currentDate.getFullYear();
var popbirdyear = 0;
var popcurrentyear = 0;
var dataZone = {};
var dataZoneGen = {};
var dataZonePlace = {};
var dataSurvie = {};
var dataTrads = {};
var lg = getParam("lang") ? getParam("lang") : "fr";
var activeAjaxCount = 0;
//var q = new binder(function() {q.getZones(parseDataForZones);});




$(document).ajaxStart(function() {
    activeAjaxCount++;
    $("#loading").show();
});
$(document).ajaxStop(function() {
    setTimeout(function() {
        activeAjaxCount--;
        $("#loading").fadeOut(100);
    }, 200);
});
$(document).ready(function() {

    var q = new binder(function(b) {

        FastClick.attach(document.body);

//On commence par récupérer toutes les trads associés à la population
//et on les stoques dans un tableau.
        q.getPopTrads(function(data) {
//console.log(data);
            dataTrads["fr"] = {};
            dataTrads["en"] = {};
            dataTrads["es"] = {};
            for (p in data) {

//Version lg => identifiant => trad.
                dataTrads["fr"][data[p].trad_id] = data[p].trad_fr;
                dataTrads["en"][data[p].trad_id] = data[p].trad_en;
                dataTrads["es"][data[p].trad_id] = data[p].trad_es;
            }


//Avant toute chose, on load le template avec les trads adaptées à la langue.
            $("#script_template_container").loadTemplate("#template", dataTrads[lg]);
            genSliders(); //Les sliders.
            window.pyr = new pyramid('#graphique_tableau');
            genTabs(); //Les onglets.


            //Affichage des zones.
            b.getZones(parseDataForZones);
            //On déclare le maphilight sur la carte.
            $('.monde_zone_img').maphilight({
                alwaysOn: false,
                fillColor: "E5382F",
                stroke: false,
                strokeColor: "E5382F",
                strokeWidth: 1,
                fillOpacity: 0.7
            });
        });
    });
    //Au redimensionnement de la fenêtre.
    $(window).resize(function() {
        var tabSelected = $("#tabs_population ul li.ui-state-active");
        TweenMax.to("#tabs_cursor", 0, {opacity: 1, "left": getCursorPos(tabSelected)});
    });
    /*********************************************************************/
    //On déclare tous les sliders dont on a besoin.
    /*********************************************************************/

    //Les sliders.
    function genSliders() {
        genCustomSlider("#slider_population", 25, 0, 125, " " + dataTrads[lg]["population_titre_ans"], ".slider_age", "setPopulationStats", "", "population");
        genCustomSlider("#slider_generation", 25, 0, 125, " " + dataTrads[lg]["population_titre_ans"], ".slider_age", "setGenerationStats", "", "generation");
        genCustomSlider("#slider_place", 25, 0, 125, " " + dataTrads[lg]["population_titre_ans"], ".slider_age", "updatePyramid", 1, "place");
        genCustomSlider("#slider_place_annee", currentYear, 1950, 2100, "", "", "updatePyramid", 1, "place", true);
    }




    /*********************************************************************/
    //Gestion des pages (catégories).
    /*********************************************************************/

    function genTabs() {

        //On commence par récupérer la liste des pages.
        $("#contenu").prepend('<div id="tabs_population"><ul id="tabs_population_content"></ul><div id="tabs_cursor"></div></div>');
        $("#contenu .categorie h2").each(function(index) {
            var tabTitre = $(this).html();
            var tabId = $(this).parent('section').attr("id");
            var tabCat = $(this).parent('section').attr("data-categorie");
            $("#tabs_population_content").append('<li><a href="#' + tabId + '" data-categorie="' + tabCat + '"><span>' + tabTitre + '</span></a></li>');
            $(this).hide(); //On cache tous les titres h2 du contenu qui apparaissent dans les onglets.
        });
        //Création des onglets.
        $("#contenu").tabs({
            create: function(event, ui) {
                var tabSelected = $("#tabs_population ul li.ui-state-active");
                TweenMax.to("#tabs_cursor", 0, {opacity: 1, "left": getCursorPos(tabSelected)});
                TweenMax.to(tabSelected, 1, {backgroundColor: "#1FBDC3"});
            },
            activate: function(event, ui) {
                var tabSelected = $(ui.newTab.context).parent('li');
                TweenMax.to("#tabs_cursor", 0.5, {opacity: 1, "left": getCursorPos(tabSelected)});
                TweenMax.to("#tabs_population li", 0.6, {backgroundColor: "#222E3B"});
                TweenMax.to(tabSelected, 1, {backgroundColor: "#1FBDC3"});
                //On met à jour les stats sur toutes les pages.
                setPopulationStats();
                setGenerationStats();
                updatePyramid();
            }

        });
    }

    function getCursorPos(tabSelected) {
        var tabSelected = (tabSelected) ? tabSelected : $("#tabs_population ul li.ui-state-active");

        var tabPosX = $(tabSelected).position().left;
        var tabWidth = $(tabSelected).width();
        return tabPosX + (tabWidth / 2) - 5;
    }


    /*********************************************************************/
    //Gestion de l'introduction.
    /*********************************************************************/

    //On ajoute une petite astuce pour les écrans tactiles afin de gérer le grow sur les boutons.
    $(document).on('touchstart touchend', '.hvr-grow', function(e) {
        //e.preventDefault();
        //$(this).toggleClass('hvr-grow-hover');

        if(e.type == 'touchend'){
            $(this).css({'-webkit-transform':'scale(1)', 'transform':'scale(1)'});
        }else{
            $(this).css({'-webkit-transform':'scale(1.1)', 'transform':'scale(1.1)'});
        }
    });

   	$(document).on("click", ".btn_intro", function(e) {
        var tlIntro = new TimelineMax();

		//On récupère le type de bouton cliqué.
		var btn_type = $(this).attr('id');

		//On masque l'introduction et on affiche le module.
		tlIntro.to('#simulateur_introduction', 0.3, {opacity:0, display:"none"});
		tlIntro.to('#simulateur_module', 0, {opacity:0, display:"block"});
		tlIntro.to('#simulateur_module', 0.5, {opacity:1});
		// tlIntro.to("#tabs_cursor", 0, {"left": getCursorPos()});

		//On sélectionne le bon onglet.
		tlIntro.addCallback(function(){
			TweenMax.to("#tabs_cursor", 0, {"left": getCursorPos()});
		});
	});



    /*********************************************************************/
    //Gestion des zones.
    /*********************************************************************/

    /**
     * On réaffiche les boutons dans la liste des continents
     * à partir de la base de données.
     */
    //q.getZones(parseDataForZones);
    function parseDataForZones(data) {

        $(".liste_continents, select#select_liste_continents").html(""); //On vide la liste des continents sur chaque page.
        for (p in data) {

            var pays_id = data[p].pays_id;
            var pays_titre = data[p]['pays_nom_' + lg];
            var pays_titre_nice = niceName(pays_titre);
            var pays_titre_zone = niceName(data[p].pays_nom_fr);
            var pressed = (p == 0) ? true : false;
            //On rempli les boutons.
            $(".liste_continents").append('<a role="button" aria-pressed="' + pressed + '" class="map_button" data-zone="' + pays_titre_zone + '" value="' + pays_id + '" href="#' + pays_titre_nice + '">' + pays_titre + '</a>');
            //On rempli le select des régions (zones).
            $("select#select_liste_continents").append('<option role="option" aria-selected="' + pressed + '" data-zone="' + pays_titre_zone + '" value="' + pays_id + '">' + pays_titre.toUpperCase() + '</option>');
        }

        //Après avoir attribué les différentes valeurs aux zones,
        //on affiche les infos du monde par défaut.
        setTimeout(function() {
            updateSelectedZone("monde");
            updateZoneList(900);
            updateOptionSelectedAria("select#select_liste_continents");
            //On déclare les class de select à customiser.
            $('.select_style').customSelect();
        }, 100);
    }


    //Au clique sur une zone de la carte, on fait un update de la carte et des boutons.
    $("body").on("click", ".monde_zone_carte area, .liste_continents .map_button, .monde_zone_mondepicto a", function(e) {
        e.preventDefault();
        var clickedZone = $(this);
        var zone = clickedZone.attr('data-zone');
        updateSelectedZone(zone);
        return false;
    });
    //Au passage de la souris sur le picto de la terre, on change la couleur du picto.
    $(".monde_zone_mondepicto a").on({
        mouseover: function() {
            $(this).children("img").attr("src", "img/picto_world_r.png");
        },
        mouseout: function() {
            $(this).not(".selected").children("img").attr("src", "img/picto_world_b.png");
        }
    });
    /**
     * Permet de sélectionner la bonne zone sur la map
     * Permet également de sélectionner le bouton associé.
     */
    function updateSelectedZone(zone) {
        var clickedZone = $('.' + zone);
        //On récupère l'année sélectionnée.
        var selectedAge = $("#slider_generation .sliderValue").html();
        var selectedYear = currentYear - selectedAge;
        //Pour toutes les zones.
        $('.monde_zone_carte area').each(function() {
            hData = $(this).data('maphilight') || {}; //On récupère la configue de la zone.
            hData.alwaysOn = $(this).is(clickedZone); //On montre seulement la zone cliquée.
            hData.fillOpacity = 0.7; //On modifie l'opacité.

            $(this).data('maphilight', hData).trigger('alwaysOn.maphilight');
        });
        //Pour la zone sélectionnée.
        hDataClicked = $(clickedZone).data('maphilight') || {}; //On récupère la configue de la zone.
        hDataClicked.fillOpacity = 1; //On modifie l'opacité.
        $(clickedZone).data('maphilight', hDataClicked).trigger('alwaysOn.maphilight');
        //Si la zone sélectionnée est le monde, on change la couleur du picto.
        if (zone == "monde") {
            $(".monde_zone_mondepicto img").attr("src", "img/picto_world_r.png");
            $(".monde_zone_mondepicto a").addClass("selected");
        } else {
            $(".monde_zone_mondepicto img").attr("src", "img/picto_world_b.png");
            $(".monde_zone_mondepicto a").removeClass("selected");
        }

        //On sélectionne le bouton associé à la zone et on change son style.
        $('.map_button').attr('aria-pressed', false);
        $('.map_button[data-zone="' + zone + '"]').attr('aria-pressed', true);
        TweenMax.to('.map_button', 0.5, {backgroundColor: "#FFFFFF", fontWeight: "normal"});
        TweenMax.to('.map_button[data-zone="' + zone + '"]', 0.5, {backgroundColor: "#1FBDC3", fontWeight: "bold"});
        //Et on affiche la bonne zone dans le titre.
        var niceTitleZone = $('.map_button[data-zone="' + zone + '"]').html();
        $('.monde_zone_titre').html(niceTitleZone);
        //on fait une seule requete par type d'info au changement de zone.
        var idCountry = $('.liste_continents a[aria-pressed="true"]').attr('value');
        q.getDataForZone(idCountry, function(data) {
            for (p in data) {
                if (data[p].popu_sexe == "Both") {
                    dataZone[data[p].popu_annee] = data[p];
                }
            }
            setPopulationStats();
        });
        q.getDataForZoneGen(idCountry, function(data) {
            for (p in data) {
                dataZoneGen[data[p].donnee_annee] = data[p];
            }


            //console.log(dataZoneGen[selectedYear].donnee_annee);
            //if (currentYear > 2005 && dataZoneGen[selectedYear].donnee_annee < 2005) {

                var idCountry = $('.liste_continents a[aria-pressed="true"]').attr('value');
                q.getDataForSurvie(idCountry, function(data) {

                    for (p in data) {
                        dataSurvie[data[p].quot_survie_age] = data[p];
                    }
                    setGenerationStats();
                });
            //}

        });
    }






    /*********************************************************************/
    //Gestion d'évolution de la population.
    /*********************************************************************/


    function setPopulationStats() {

        //On récupère l'année sélectionnée.
        var selectedAge = $("#slider_population .sliderValue").html();
        var selectedYear = currentYear - selectedAge;
        //Population en fonction de l'age sélectionné.
        var popu_total = (dataZone[selectedYear].popu_total) * 1000;
        popbirdyear = popu_total;
        $("#population_naissance_age").html(formatNb(popu_total)).attr('data-number', popu_total);
        //Multiplication de la population.
        var popu_total = (dataZone[currentYear].popu_total) * 1000;
        popcurrentyear = popu_total;
        $("#population_naissance_annee").html(formatNb(popu_total)).attr('data-number', popu_total);
        var multi = (popcurrentyear / popbirdyear);
        $("#population_evolution_chiffre").html(formatNb(multi.toFixed(2)));
        $("#population_jauge").css({'width': (multi.toFixed(2) * 10) + '%'});
    }



    /*********************************************************************/
    //Gestion d'évolution de la génération.
    /*********************************************************************/

    function setGenerationStats() {

        //On récupère l'année sélectionnée.
        var selectedAge = $("#slider_generation .sliderValue").html();
        var selectedYear = currentYear - selectedAge;
        
        // année fixe dans t_trad
        var fixedYear = dataTrads[lg]["annee_code"];
        // console.log(fixedYear);

        //on récupère les infos en fonction de la zone et de l'année.
        if (dataZoneGen[selectedYear]) {

            var naissance_annuelle = (dataZoneGen[selectedYear].donnee_naissance_annuelle) * 1000;
            $("#generation_naissance_age").html(formatNb(naissance_annuelle.toFixed(0))).attr('data-number', naissance_annuelle.toFixed(0));
            var nb_vivant = "";
            var nb_naissance_actuelle = dataZoneGen[selectedYear].donnee_naissance_annuelle;
            var r_cpt = currentYear - dataZoneGen[selectedYear].donnee_annee;
            if (dataZoneGen[selectedYear].donnee_annee >= 1950) {
                //selectedYear = fixedYear - selectedAge;
                nb_vivant = (nb_naissance_actuelle * 1000) * (dataZoneGen[selectedYear].donnee_txsurvie);
            } else {
                nb_vivant = (dataZoneGen[selectedYear].donnee_naissance_annuelle * 1000) * (dataZoneGen[selectedYear].donnee_tx_mortalite);
            }


            if (currentYear > 2023 && dataZoneGen[selectedYear].donnee_annee < 2023) {
                getPurcentPop(0, r_cpt, nb_vivant, nb_naissance_actuelle);
            } else {
                genPurcentPop(nb_vivant, nb_naissance_actuelle);
            }

        }
    }



    /**
     * Récupère le pourcentage de personnes vivantes et décédée
     * en fonction de l'age de référence.
     */
    function getPurcentPop(i, r_cpt, nb_vivant, nb_naissance_actuelle) {

        var temp = r_cpt - i; //Age temporaire.
        if (i < (currentYear - 2023)) {

            //N'existe pas pour les ages suppérieurs à 120 ans donc on le force à 0.5.
            if(!dataSurvie[temp]){
                dataSurvie[temp] = {};
                dataSurvie[temp].quot_survie_valeur = 0.5;
            }

            nb_vivant = nb_vivant * (1 - (dataSurvie[temp].quot_survie_valeur));
            getPurcentPop(i + 1, r_cpt, nb_vivant, nb_naissance_actuelle);
        } else if (i >= (currentYear - 2023)) {

            nb_vivant = nb_vivant * (1 - (dataSurvie[temp].quot_survie_valeur));
            genPurcentPop(nb_vivant, nb_naissance_actuelle);
        }
    }



    /**
     * Affiche les pourcentages et ajuste la barre dans les zones concernées.
     */
    function genPurcentPop(nb_vivant, nb_naissance_actuelle) {
        var prct_vivant = (nb_vivant * 100 / (nb_naissance_actuelle * 1000));
        var prct_dead = 100 - prct_vivant;
        $("#generation_alive_chiffre").html(prct_vivant.toFixed(0) + '%');
        $("#generation_dead_chiffre").html(prct_dead.toFixed(0) + '%');
        $("#generation_alive_jauge").css({'width': (prct_vivant.toFixed(0)) + '%'});
        $("#generation_dead_jauge").css({'width': (prct_dead.toFixed(0)) + '%'});
    }








    /*********************************************************************/
    //Gestion de la region.
    /*********************************************************************/

    $("body").on("change", "select#select_liste_continents", function() {
        var valueSelected = $(this).val();
        updateZoneList(valueSelected);
        updateOptionSelectedAria(this);
    });

    $("body").on("change", "select#select_liste_pays", function() {
        updateOptionSelectedAria(this);
    });



    function updateOptionSelectedAria(element) {

    	var elementId = $(element).attr('id');
    	var selectType = (elementId.indexOf("continents") != -1) ? 'zone' : 'pays';

        $(element).find('option').attr('aria-selected', false);
        var optionSelected = $(element).find('option:selected');
        $(optionSelected).attr('aria-selected', true);

        //On met à jour le titre de la zone sélectionnée.
        var formId = $(element).parent('div').parent('form').attr('id');
        var optionZone = $('#'+formId+' select:eq(0)').find('option:selected');
        var optionPays = $('#'+formId+' select:eq(1)').find('option:selected');

        //On met à jour le titre de la zone sélectionnée.
    	var zoneSelectedName = (selectType == 'pays' && optionPays.val() && optionPays.val() != 0) ? $(optionPays).html() : $(optionZone).html();
		$('.place_zone_titre').html(zoneSelectedName);
        //$('.place_zone_titre').html(optionSelected.html());

        //Seulement pour la liste des pays, on affiche la nouvelle pyramide.
        if ($(element).attr("id") == "select_liste_pays") {
            getDataAndUpdate();
        }
    }



    function updateZoneList(idZone) {

        if (idZone == 900) {
            q.getPays(lg, updatePaysList);
        } else {
            if(lg == "fr"){
                q.getPaysZone(idZone, updatePaysList);
            }else{
                q.getPaysZoneEN(idZone, updatePaysList);
            }
        }
    }



    function updatePaysList(data) {

        $("#choix_pays").find('span.customSelectInner').html('-----');
        $("select#select_liste_pays").html('<option role="option" aria-selected="true" data-pays="null" value="0">-----</option>');
        for (p in data) {

            var pays_id = data[p].pays_id;
            var pays_titre = data[p]['pays_nom_' + lg];
            var pays_titre_nice = niceName(pays_titre);
            var pays_titre_zone = niceName(data[p].pays_nom_fr);
            //var pressed = (p == 0) ? true : false;
            var pressed = false;
            //On rempli le select des pays.
            $("select#select_liste_pays").append('<option role="option" aria-selected="' + pressed + '" data-pays="' + pays_titre_nice + '" value="' + pays_id + '">' + pays_titre + '</option>');
        }

        getDataAndUpdate();
    }





    /*********************************************************************/
    //Gestion de la pyramide.
    /*********************************************************************/

    /**
     * V2. Permet de mettre à jour la pyramide en fonction du lieu
     * sans effectuer de requête à chaque fois.
     */
    var sliderAnnee = false;
    function updatePyramid() {
        if (!sliderAnnee) {
            sliderAnnee = $('#slider_place_annee a.ui-slider-handle');
        }
        //On récupère l'année sélectionnée.
        var selectedYear = sliderAnnee.attr('aria-valuenow');
        //On affiche la nouvelle pyramide.

        window.pyr.gen(dataZonePlace[selectedYear]["Male"], dataZonePlace[selectedYear]["Female"], function() {
            getPercent(dataZonePlace[selectedYear]["Male"], dataZonePlace[selectedYear]["Female"]);
        });
    }



    /**
     * Permet de récupérer les données et de mettre la pyramide à jour.
     */
    function getDataAndUpdate() {
        setTimeout(function() {
            var idPays = $("select#select_liste_pays").find('option:selected').val();
            var idZone = $("select#select_liste_continents").find('option:selected').val();
            var id = (idPays != 0) ? idPays : idZone;
            var popu_total_max = 0;
            q.getDataForZonePlace(id, function(data) {

                for (p in data) {

                    if (!dataZonePlace[data[p].popu_annee]) {
                        dataZonePlace[data[p].popu_annee] = {};
                    }

                    var sexe = data[p].popu_sexe;
                    dataZonePlace[data[p].popu_annee][sexe] = data[p];
                    //On essaye de récupérer la valeur maximum de la population
                    //sur toutes les années dont on possède les données.
                    var max = 0;
                    for (var i = 99; i >= 0; i--) {
                        max = Math.max(data[p]['popu_age' + i], max);
                    }

                    if (popu_total_max < max) {
                        popu_total_max = max;
                    }

                }

                var max = dataZonePlace['max'] = roundSup(popu_total_max);
                var maxm = Math.round(max / 2);

                $("#graphique_legende .val_homme_max")[0].innerHTML = (max);
                $("#graphique_legende .val_homme_medium")[0].innerHTML = (maxm);
                $("#graphique_legende .val_femme_medium")[0].innerHTML = (maxm);
                $("#graphique_legende .val_femme_max")[0].innerHTML = (max);

                updatePyramid();
            });
        }, 100);
    }



    /**
     * Affichage des pourcentages dans la colonne de gauche.
     */

    function getPercent(homme, femme) {
        //On change la couleur de la pyramide pour les ages inférieurs à l'age de référence.
        var selectedAge = $("#slider_place").slider('value');
        var selectedAnnee = $("#slider_place_annee").slider('value');
        var limitAge = parseInt(selectedAnnee) - parseInt(currentYear) + parseInt(selectedAge);
        //Calcul du total de personne au dessus de l'age sélectionné.
        var totalOlder = 0;
        for (var p = limitAge; p < 99; p++) {
            totalOlder = homme['popu_age' + p] + femme['popu_age' + p] + totalOlder;
        }

        //Calcul du total de personne au dessous de l'age sélectionné.
        var totalYounger = 0;
        for (var p = 0; p < limitAge; p++) {
            totalYounger = homme['popu_age' + p] + femme['popu_age' + p] + totalYounger;
        }


        //On calcul les pourcentages de chaque partie et on les affichent.
        totalOlder = (totalOlder || totalOlder === 0) ? totalOlder : 100;
        totalYounger = (totalYounger || totalYounger === 0) ? totalYounger : 100;
        var percentOlder = (totalOlder * 100) / (totalOlder + totalYounger);
        var percentYounger = (totalYounger * 100) / (totalOlder + totalYounger);
        document.getElementById('place_older_chiffre').innerHTML = " " + percentOlder.toFixed(0) + "%";
        document.getElementById('place_younger_chiffre').innerHTML = " " + percentYounger.toFixed(0) + "%";
        document.getElementById('place_older_jauge').style.width = (percentOlder.toFixed(0)) + '%';
        document.getElementById('place_younger_jauge').style.width = " " + percentYounger.toFixed(0) + "%";
    }



    /**
     * Construction de la pyramide.
     */
    pyramid = function(obj) {
        var conteneur = $(obj);
        //On récupère la limite de l'age recherché.
        var selectedAge = $("#slider_place .sliderValue").html();
        var selectedAnnee = $("#slider_place_annee .sliderValue").html();
        var limitAge = parseInt(selectedAnnee) - parseInt(currentYear) + parseInt(selectedAge);
        //On construit le tableau de 100 valeurs.
        var table = ['<table class="pyramid" width="100%" cellspacing="0" cellpadding="0"><caption></caption>'];
        var tabObj = {};
        var ageTexte = '';
        for (var p = 99; p >= 0; p--) {
            ageTexte = p + ' ' + dataTrads[lg]["population_titre_ans"];
            table.push('<tr data-age="' + p + '">');
            table.push('<td><span id="sh' + p + '" class="sh" style="width:100%;"></span></td>');
            table.push('<th>' + p + '</th>');
            table.push('<td><span id="sf' + p + '" class="sf" style="width:100%;"></span><span id="cf' + p + '" class="cf">' + ageTexte + '</span></td></tr>');
        }

        table.push('</table>');
        conteneur.html(table.join(''));
        for (var p = 99; p >= 0; p--) {
            tabObj['sh' + p] = document.getElementById('sh' + p);
            tabObj['sf' + p] = document.getElementById('sf' + p);
        }

        var tableDiv = conteneur.find('>table');

        var sliderPlace = $("#slider_place");
        var sliderAnnee = $("#slider_place_annee");
        var previousYear = false;
        //On insert les valeurs correspondantes aux hommes et aux femmes.
        this.gen = function(homme, femme, callback) {

            /**
             * On récupère les valeurs actuelles
             */
            var selectedAge = sliderPlace.slider('value');
            var selectedAnnee = sliderAnnee.slider('value');

            /**
             * On cherche l'année en cours
             * pour mettre la démarcation rouge
             */
            limitAge = parseInt(selectedAnnee) - parseInt(currentYear) + parseInt(selectedAge);
            /**
             * On l'enlève sur la précédente
             */
            tableDiv.find('tr.limiteAge').removeAttr('class');
            var cf = $('#cf' + limitAge);
            if (cf.length) {
                /**
                 * On la met sur la nouvelle
                 */
                cf.closest('tr').addClass('limiteAge');
            }
            if (limitAge > 99) {
                /**
                 * Ou sur 99 si on est plus agé ...
                 * Mais en désactivé
                 */
                tableDiv.find('tr[data-age=99]').addClass('limiteAge disabled');
            }
            //Récupération de la population max sur l'ensemble des années.
            var max = dataZonePlace['max'];

            /**
             * Test pour ne pas refaire tout le tableau si on juste changé
             * d'age et pas d'année
             */
            //if (previousYear !== selectedAnnee) {

                for (var p = 99; p >= 0; p--) {

                    tabObj['sh' + p].style.width = (homme['popu_age' + p] / max * 100) + '%';
                    tabObj['sf' + p].style.width = (femme['popu_age' + p] / max * 100) + '%';

                    /*
                     * Bizarrement : Plus lent en temps de calcul mais
                     * plus fluide à l'affichage (sur ipad au moins) !
                     * Mais moins bon support global ....
                     *
                     tabObj['sh' + p].style.webkitTransform =
                     tabObj['sh' + p].style.mozTransform =
                     tabObj['sh' + p].style.webkitTransform =
                     tabObj['sh' + p].style.transform =
                     'scaleX(' + (homme['popu_age' + p] / max) + ')';
                     tabObj['sf' + p].style.webkitTransform = '
                     scaleX(' + (femme['popu_age' + p] / max) + ')';
                     */
                    /* tabObj['sh' + p].style.backgroundColor = couleurCode;
                     tabObj['sf' + p].style.backgroundColor = couleurCode;*/

                }
            //}
            previousYear = selectedAnnee;

            if (callback) {
                callback();
            }
        };
    };
    /*********************************************************************/
    //Gestion des sliders.
    /*********************************************************************/


    /**
     * Génère un jquery-ui slider avec les attributs d'accessibilité "aria".
     */
    function genCustomSlider(element, defaultValue, minValue, maxValue, txtSuffix, sliderClass, slideFunction, slideFunctionInterval, categorie, vertical) {

        var categorie = (categorie) ? categorie : '';
        var txtSuffix = (txtSuffix) ? txtSuffix : '';
        var slideFunction = (slideFunction) ? slideFunction : '';
        var slideOrientation = (vertical) ? "vertical" : 'horizontal';
        var sliderElement = (sliderClass) ? sliderClass : element;
        var trimelement = element.replace("#", "").replace(".", "");
        var count = 0;

        //Création du slider.
        /********************************************************************/
        $(element).empty().slider({
            orientation: slideOrientation,
            range: "min",
            animate: true,
            value: defaultValue,
            min: minValue,
            max: maxValue,
            slide: function(event, ui) {
                //console.log('slide');
                var slideHandle = $(ui.handle);
                var vlu = slideHandle.find('.sliderValue')[0];
                if (vlu.innerHTML === ui.value) {
                    return;
                }
                vlu.innerHTML = ui.value;
                slideHandle.attr("aria-valuenow", ui.value).attr("aria-valuetext", ui.value + txtSuffix);
                updateSliders(ui.value, sliderElement, element);
                var currentCat = $("#tabs_population ul li.ui-state-active a").attr("data-categorie");

                if (slideFunction && categorie === currentCat /*&& slideFunctionInterval && count == slideFunctionInterval*/) {
                    eval(slideFunction + "()");
                }
            },
            change: function(event, ui) {
                //console.log('change');
                var slideHandle = $(ui.handle);
                var vlu = slideHandle.find('.sliderValue')[0];
                if (vlu.innerHTML === ui.value) {
                    return;
                }
                vlu.innerHTML = ui.value;
                slideHandle.attr("aria-valuenow", ui.value).attr("aria-valuetext", ui.value + txtSuffix);
                var currentCat = $("#tabs_population ul li.ui-state-active a").attr("data-categorie");
                if (slideFunction && categorie == currentCat) {
                    eval(slideFunction + "()");
                }
                ;
            }

        });
        //Au chargement du slider.
        /********************************************************************/
        setTimeout(function() {

            //On affiche les valeurs par défaut.
            var slideHandle = $(element + " .ui-slider-handle");
            slideHandle.html('<span class="sliderPointer"></span><span class="sliderValue">' + defaultValue + '</span>' + txtSuffix);
            slideHandle.attr("role", "slider");
            slideHandle.attr("aria-valuenow", defaultValue).attr("aria-valuemin", minValue).attr("aria-valuemax", maxValue);
            slideHandle.attr("aria-valuetext", defaultValue + txtSuffix);
            //On ajoute un wrapper autour du slider.
            $(element).wrap('<div id="' + trimelement + '_wrapper" class="slider_' + slideOrientation + ' slider_wrapper ' + sliderElement.replace(".", "") + '_wrapper"></div>');
            //On ajoute les boutons "+" et "-".
            var prependBtn = (slideOrientation == 'vertical') ? 'more' : 'less';
            $(element + "_wrapper").prepend('<span class="sbutton sbutton_' + prependBtn + '" role="button"></a>');
            var appendBtn = (slideOrientation == 'vertical') ? 'less' : 'more';
            $(element + "_wrapper").append('<span class="sbutton sbutton_' + appendBtn + '" role="button"></a>');
            //On ajoute également dynamiquement les valeurs min et max sous le slider.
            $(element + "_wrapper ").append('<div class="sdefault_values"><div class="sdefault_min">' + minValue + '</div><div class="sdefault_max">' + maxValue + txtSuffix + '</div></div>');
        }, 100);
        //Ajout des actions.
        /********************************************************************/
        $("body").on("click", element + "_wrapper .sbutton_more", function() {
            var valuenow = $(element).slider("value");
            updateSliders(valuenow + 1, sliderElement);
        });
        $("body").on("click", element + "_wrapper .sbutton_less", function() {
            var valuenow = $(element).slider("value");
            updateSliders(valuenow - 1, sliderElement);
        });
    }


    /**
     * On met à jour tous les sliders associés.
     */
    function updateSliders(value, groupElement, currentElement) {
        $(groupElement).not(currentElement).each(function(index) {
            $(this).slider("value", value);
        });
    }



    /*********************************************************************/
    //Gestion des traductions.
    /*********************************************************************/

    /*function genAllTrads(){

     $("section#population h2, ul#tabs_population_content a span").html(t("population_rubrique_0"));
     $("section#population h3").html(t("population_evolution_population_chapo"));

     $("section#generation h2").html(t("population_rubrique_1"));
     $("section#generation h3").html(t("population_evolution_generation_chapo"));

     $("section#place h2").html(t("population_rubrique_2"));
     $("section#place h3").html(t("population_evolution_place_chapo"));

     }

     function t(id){

     var lg = getParam("lang") ? getParam("lang") : "fr";
     return dataTrads[id][lg];
     }*/


});
/*********************************************************************/
//Autres fonctions.
/*********************************************************************/

/**
 * Recupere la valeur d'un parametre defini dans l'url.
 */
function getParam(param) {

    //On separe la chaine des parametres en fonction du &.
    var spath = window.location.search.split("&"), i;
    //Bouclage des parametres.
    for (i = 0; i < spath.length; ++i) {

        hash = spath[i].split("=");
        hash_param = hash[0].replace("?", "");
        hash_val = hash[1];
        //On recupere le parametre de l'url si il existe.
        if (hash_param == param) {
            return hash_val;
        }
    }
}



/**
 * Transforme un nom de fichier pour qu'il soit propre.
 */
function niceName(str) {
    str = str.toLowerCase();
    //On remplace les caractères accentués.
    var rules = {
        a: "àáâãäå",
        e: "èéêë",
        i: "ìíîï",
        o: "òóôõöø",
        u: "ùúûü",
        y: "ÿ",
        c: "ç",
        n: "ñ"
    };
    var regstring = "";
    for (acc in rules) {
        regstring += rules[acc];
    }

    var reg = new RegExp("[" + regstring + "]", "g");
    str = str.replace(reg, function(t) {
        for (acc in rules) {
            if (rules[acc].indexOf(t) > -1) {
                return acc;
            }
        }
    });
    //On remplace les autres caractères spéciaux par un tiret.
    str = $.trim(str);
    str = str.replace(/([^a-z0-9_]+)/g, "-");
    str = str.replace(/-/g, "-");
    str = str.replace(/---/g, "-");
    str = str.replace(/--/g, "-");
    str = $.trim(str);
    return str;
}



/**
 * Permet de reformater les nombres avec des espaces.
 */
function formatNb(nStr) {
    nStr += '';
    var x = nStr.split('.');
    var x1 = x[0];
    var x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + ' ' + '$2');
    }

	var niceNb = x1 + x2;
    niceNb = (lg == 'en') ? niceNb : niceNb.replace('.',',');
    return niceNb;
}


/**
 * On arrondi à la dizaine, centaine, millier, etc supérieure.
 * @param {Object} n
 */
function roundSup(n) {

    n = Math.ceil(n);
    var countc = n.toString().length;
    var multiple = 1;
    for (i = 1; i < countc; i++) {
        multiple = multiple * 10;
    }

    n = n / multiple;
    n = Math.ceil(n);
    n = n * multiple;
    return n;
}
