binder = function(callback) {

    /**
     * Chemin vers la base de donnée SQLite
     * @type String
     */
    var sqliteDb = 'database.sqlite';

    /**
     * Chemin vers le script PHP à interroger
     * @type String
     */
    var php = 'query.php';

    /**
     * Liste des requêtes SQL
     * Rempli uniquement en mode "nodejs" (node-webkit)
     */
    var sql = {};

    /**
     * Type de connexion à utiliser
     * @type php|nodejs
     */
    var type = '';


    /**
     * Si on a une fonction "require" c'est qu'on est dans node-webkit
     * Sinon on est sur le web en PHP
     */
    if (typeof require === 'undefined') {
        type = 'php';
    } else {
        type = 'nodejs';
    }




    /**
     * Retourne toutes les traductions pour la population
     *
     * @param int id
     * @param {type} callback
     */
    this.getPopTrads = function(callback) {
		query('getPopTrads', {}, callback);
    };

    /**
     * Retourne la liste de la table Pays
     * @param {type} callback
     */
    /*this.getPays = function(callback) {
        query('getPays', {}, callback);
    };*/
    this.getPays = function(lg, callback) {
        if(lg == "en"){
            query('getPays_en', {}, callback);
        }else{
            query('getPays_fr', {}, callback);
        }
    };

    /**
     * Retourne la liste des zones geograpiques
     * @param {type} callback
     */
    this.getZones = function(callback) {
        query('getZones', {}, callback);
    };


    /**
     * Retourne la liste des pays par zones geograpiques
     * @param {type} callback
     */
    this.getPaysZone = function(idZone, lg, callback) {
        if(lg == "en"){
            query('getPaysZone_en', {"id":idZone}, callback);
        }else{
            query('getPaysZone_fr', {"id":idZone}, callback);
        }
    };

    /**
     * Retourne les données pour le monde pour une année donnée
     *
     * @param int annee
     * @param {type} callback
     */
    this.getDataForYear = function(annee, callback) {
		query('getDataForYear', {"annee": annee}, callback);
    };


    /**
     * Retourne les données pour une zone => Pour place.
     *
     * @param int id
     * @param {type} callback
     */
    this.getDataForZonePlace = function(id, callback) {
		query('getDataForZonePlace', {"id": id}, callback);
    };

    /**
     * Retourne les données de t_population pour une zone.
     *
     * @param int id
     * @param {type} callback
     */
    this.getDataForZone = function(id, callback) {
		query('getDataForZone', {"id": id}, callback);
    };

    /**
     * Retourne les données de t_donnee pour une zone.
     *
     * @param int id
     * @param {type} callback
     */
    this.getDataForZone2 = function(id, callback) {
		query('getDataForZone2', {"id": id}, callback);
    };

    /**
     * Retourne les données de "survie" pour une zone et un age donné.
     *
     * @param int id
     * @param int age
     * @param {type} callback
     */
    this.getDataForSurvie = function(id, callback) {
		query('getDataForSurvie', {"id": id}, callback);
    };

    /**
     * Fonction d'abstraction de requête
     * Va dispatcher et retourner le résultat en fonction de l'environnement
     *
     */
    var query = function(query, params, callback) {

        /**
         * Si on est en PHP
         */
        if (type === 'php') {
            /**
             * On charge directement le JSON de résutlat depuis le serveur
             * Avec les paramètres encodés en JSON
             */
            $.getJSON(php + '?query=' + query + '&params=' +
                    JSON.stringify(params), callback);

        } else {
            /**
             * Sinon on récupère la requête dans le tableau
             * @type @arr;sql
             */
            var q = sql[query];
            var params2 = {};

            /**
             * On préfixe les paramètres pour que sqlite
             * retrouve ses placeholders
             * Par défaut PHP n'en a pas besoin et utilise ":" comme préfixe
             */
            for (p in params) {
                params2[':' + p] = params[p];
            }

            /**
             * On charge tout le résultat et on le retourne au callback
             */
            db.all(q, params2, function(tx, results) {
                if (tx) {
                    /**
                     * Sauf s'il y a une erreur ...
                     * on l'affiche par défaut ...
                     */
                    alert('SQL error : ' + tx);
                    return false;
                }
                callback(results);
            });
        }
    };


    /**
     * Si on est en node-webkit on doit préparer la connexion
     */
    if (type === 'nodejs') {
        /**
         * On récupère la liste des requêtes SQL
         */
        var self = this;
        $.getJSON("sql.json", function(data) {
            sql = data;
            if(callback) callback(self);
        });

        /**
         * On instancie notre objet sqlite3
         *
         * @todo verbose() peut être enlevé une fois en prod
         *
         * @type @call;require@call;verbose
         */
        var sqlite3 = require('sqlite3');


        /**
         * Et on charge la base de donnée
         * @type binder.sqlite3.Database
         */
        var db = new sqlite3.Database(sqliteDb,
                sqlite3.OPEN_READONLY, function(e) {
            if (e) {
                /**
                 * Si e n'est pas null c'est qu'on a eu un problème
                 * de connexion à la BDD
                 *
                 * Par défaut on affiche à l'utilisateur
                 *
                 * @param {type} callback
                 * @returns {undefined}
                 */
                alert(e);
            }
        });

    }else{

    	var self = this;
    	setTimeout(function(){
			if(callback) callback(self);
		}, 1000);


    }


     /**
     * Retourne le classement des pays pour un indice donné.
     *
     * @param indice string
     * @param {type} callback
     */
    this.getClassement = function(index, callback) {
        if(index == 0){
            query('getClassementPopulation', {}, callback);
        }else if (index == 1){
            query('getClassementDensite', {}, callback);
        }else if (index == 2){
            query('getClassementEnfantFemme', {}, callback);
        }else if (index == 3){
            query('getClassementNaissanceAnnuelle', {}, callback);
        }else if (index == 4){
            query('getClassementTauxNatalite', {}, callback);
        }else if (index == 5){
            query('getClassementTauxMortalite', {}, callback);
        }else if (index == 6){
            query('getClassementTauxCroissance', {}, callback);
        }else if (index == 7){
            query('getClassementMortaliteInfant', {}, callback);
        }else if (index == 8){
            query('getClassementEsperance', {}, callback);
        }else if (index == 9){
            query('getClassement65', {}, callback);
        }
    };


};
