var currentDate = new Date();
var currentYear = currentDate.getFullYear();

// Ajout pour le genSliders et classement
var startYear = currentYear;
var endYear = currentYear;


var popbirdyear = 0;
var popcurrentyear = 0;

var dataZone = {};
var dataZones = {};
var dataZoneGen = {};

var pyr = {};

var dataSurvie = {};
var dataTrads = {};

var lg = getParam("lang") ? getParam("lang") : "fr";
var activeAjaxCount = 0;


/**
 * utilisé pour classement start
 */
var dataPays = null; // liste des pays
var totalPays = 0;// nombre total de pays
var classementData = 0;// données de classement
var classementMax = 0;// valeur maximal pour un classement
var sliderYear = 0;// année en cours dans le slider
/**
 * utilisé pour classement end
 */


//var q = new binder(function() {q.getZones(parseDataForZones);});


$(document).ajaxStart(function () {
    activeAjaxCount++;
    $("#loading").show();
});

$(document).ajaxStop(function () {
    setTimeout(function () {
        activeAjaxCount--;
        $("#loading").fadeOut(100);
    }, 200);
});

$(document).ready(function () {

    var q = new binder(function (b) {
        FastClick.attach(document.body);

        //On commence par récupérer toutes les trads associés à la population
        //et on les stoques dans un tableau.
        q.getPopTrads(function (data) {

            //console.log(data);
            dataTrads["fr"] = {};
            dataTrads["en"] = {};
            dataTrads["es"] = {};
            for (p in data) {

                //Version lg => identifiant => trad.
                dataTrads["fr"][data[p].trad_id] = data[p].trad_fr;
                dataTrads["en"][data[p].trad_id] = data[p].trad_en;
                dataTrads["es"][data[p].trad_id] = data[p].trad_es;
            }
            //console.log(dataTrads);

            //Mise à jour des années de début et de fin du module.
            startYear = parseInt(dataTrads[lg]["population_start_date"]);
            endYear = parseInt(dataTrads[lg]["population_end_date"]);


            //Avant toute chose, on load le template avec les trads adaptées à la langue.
            $("#script_template_container").loadTemplate("#template", dataTrads[lg]);
            genSliders(); //Les sliders.
            pyr = new pyramid('#graphique_tableau');
            genTabs(); //Les onglets.


            //Affichage des zones.
            b.getZones(parseDataForZones);
        });


        // Requète de pays et initialisation de la partie classement
        q.getPays(lg, function (data) {

            dataPays = data; // enregistrement de la liste des pays
            totalPays = dataPays.length; // nombre total de pays
            classementInit(); // initialisation du classements
        });

    });

    //Au redimensionnement de la fenêtre.
    $(window).resize(function () {
        var tabSelected = $("#tabs_population ul li.ui-state-active");
        TweenMax.to("#tabs_cursor", 0, {opacity: 1, "left": getCursorPos(tabSelected)});
    });


    /*********************************************************************/
    //On déclare tous les sliders dont on a besoin.
    /*********************************************************************/

    //Les sliders.
    function genSliders() {
        genCustomSlider("#slider_pyramide_annee", currentYear, startYear, endYear, "", ".slider_annee", "updateStats", 1, "pyramide");
        genCustomSlider("#slider_evolution_annee", currentYear, startYear, endYear, "", ".slider_annee", "updateStats", 1, "evolution");
        genCustomSlider("#slider_indice_annee", currentYear, startYear, endYear, "", ".slider_annee", "updateStats", 1, "indice");
        genCustomSlider("#slider_classement_annee", currentYear, startYear, endYear, "", ".slider_annee", "updateStats", 1, "classement");
    }


    /*********************************************************************/
    //Gestion des pages (catégories).
    /*********************************************************************/

    function genTabs() {

        //On commence par récupérer la liste des pages.
        $("#contenu").prepend('<div id="tabs_population"><ul id="tabs_population_content"></ul><div id="tabs_cursor"></div></div>');
        $("#contenu .categorie h2").each(function (index) {
            var tabTitre = $(this).html();
            var tabId = $(this).parent('section').attr("id");
            var tabCat = $(this).parent('section').attr("data-categorie");
            $("#tabs_population_content").append('<li><a href="#' + tabId + '" data-categorie="' + tabCat + '"><span>' + tabTitre + '</span></a></li>');
            $(this).hide(); //On cache tous les titres h2 du contenu qui apparaissent dans les onglets.
        });

        //Création des onglets.
        $("#contenu").tabs({
            create: function (event, ui) {
                var tabSelected = $("#tabs_population ul li.ui-state-active");
                TweenMax.to("#tabs_cursor", 0, {opacity: 1, "left": getCursorPos(tabSelected)});
                TweenMax.to(tabSelected, 1, {backgroundColor: "#1FBDC3"});
            },
            activate: function (event, ui) {
                var tabSelected = $(ui.newTab.context).parent('li');
                TweenMax.to("#tabs_cursor", 0.5, {opacity: 1, "left": getCursorPos(tabSelected)});
                TweenMax.to("#tabs_population li", 0.6, {backgroundColor: "#222E3B"});
                TweenMax.to(tabSelected, 1, {backgroundColor: "#1FBDC3"});

                //On met à jour les stats sur toutes les pages.
                updatePyramid();
                getIndices();
                getCourbes();

                // mise à jour du classement si le tab est celui du classement
                // et qu'il n'y a pas de données de classement
                classementUpdate($(ui.newTab.context).attr('href') == "#classement" && !classementData);
            }

        });
    }

    function getCursorPos(tabSelected) {
        var tabSelected = (tabSelected) ? tabSelected : $("#tabs_population ul li.ui-state-active");

        var tabPosX = $(tabSelected).position().left;
        var tabWidth = $(tabSelected).width();
        return tabPosX + (tabWidth / 2) - 20;
    }


    /*********************************************************************/
    //Gestion de l'introduction.
    /*********************************************************************/

    //On ajoute une petite astuce pour les écrans tactiles afin de gérer le grow sur les boutons.
    $(document).on('touchstart touchend', '.hvr-grow', function (e) {
        //e.preventDefault();
        //$(this).toggleClass('hvr-grow-hover');

        if (e.type == 'touchend') {
            $(this).css({'-webkit-transform': 'scale(1)', 'transform': 'scale(1)'});
        } else {
            $(this).css({'-webkit-transform': 'scale(1.1)', 'transform': 'scale(1.1)'});
        }
    });

    $(document).on("click", ".btn_intro", function (e) {
        var tlIntro = new TimelineMax();

        //On récupère le type de bouton cliqué.
        var btn_type = $(this).attr('id');

        //On masque l'introduction et on affiche le module.
        tlIntro.to('#simulateur_introduction', 0.3, {opacity: 0, display: "none"});
        tlIntro.to('#simulateur_module', 0, {opacity: 0, display: "block"});
        tlIntro.to('#simulateur_module', 0.5, {opacity: 1});
        // tlIntro.to("#tabs_cursor", 0, {"left": getCursorPos()});

        //On sélectionne le bon onglet.
        tlIntro.addCallback(function () {
            TweenMax.to("#tabs_cursor", 0, {"left": getCursorPos()});
        });
    });


    /*********************************************************************/
    //Gestion des zones.
    /*********************************************************************/

    /**
     * On réaffiche les boutons dans la liste des continents
     * à partir de la base de données.
     */
    //q.getZones(parseDataForZones);
    function parseDataForZones(data) {

        var elementsNames = "select.select_liste_continents, select.select_liste_continents2";

        $(elementsNames).html(""); //On vide la liste des continents sur chaque page.
        for (p in data) {

            var pays_id = data[p].pays_id;
            var pays_titre = data[p]['pays_nom_' + lg];
            var pays_titre_nice = niceName(pays_titre);
            var pays_titre_zone = niceName(data[p].pays_nom_fr);
            var pressed = (p == 0) ? true : false;

            //On rempli le(s) select(s) des régions (zones).
            $(elementsNames).append('<option role="option" aria-selected="' + pressed + '" data-zone="' + pays_titre_zone + '" value="' + pays_id + '">' + pays_titre.toUpperCase() + '</option>');
        }

        //Après avoir attribué les différentes valeurs aux zones,
        //on affiche les infos du monde par défaut.
        setTimeout(function () {
            updateZoneList(900);
            updateZoneList(900, 2); //Pour la zone 2 des courbes.
            updateOptionSelectedAria($(elementsNames), elementsNames);

            //On déclare les class de select à customiser.
            $('.select_style').customSelect();
        }, 100);
    }


    /*********************************************************************/
    //Gestion de la region.
    /*********************************************************************/

    $("body").on("change", "select.select_liste_continents, select.select_liste_continents2", function (e) {
        var selectZoneNum = $(this).data('zonenum');
        var classSelect = (parseInt(selectZoneNum) && selectZoneNum != 1) ? 'select.select_liste_continents' + selectZoneNum : 'select.select_liste_continents';
        var valueSelected = $(this).val();

        updateZoneList(valueSelected, selectZoneNum);

        //updateOptionSelectedAria(this, "select.select_liste_continents");
        updateOptionSelectedAria(this, classSelect);
    });
    $("body").on("change", "select.select_liste_pays, select.select_liste_pays2", function (e) {
        var selectZoneNum = $(this).data('zonenum');
        var classSelect = (parseInt(selectZoneNum) && selectZoneNum != 1) ? 'select.select_liste_pays' + selectZoneNum : 'select.select_liste_pays';

        //updateOptionSelectedAria(this, "select.select_liste_pays");
        updateOptionSelectedAria(this, classSelect);
    });


    /**
     * On met à jour les infos du select (aria et autres).
     */
    function updateOptionSelectedAria(object, element) {
        var selectType = (element.indexOf("continents") != -1) ? 'zone' : 'pays';

        var optionSelected = $(object).find('option:selected');
        var optionSelectedValue = optionSelected.attr('value');
        var optionSelectedName = optionSelected.html();

        $(element).find('option').attr('aria-selected', false).removeAttr("selected");

        //$(optionSelected).attr('aria-selected', true);
        $(element).find('option[value=' + optionSelectedValue + ']').attr('aria-selected', true).attr('selected', 'selected');
        $(element).next('span.customSelect').children('span.customSelectInner').html(optionSelectedName);


        //Seulement pour la liste des pays, on affiche la nouvelle pyramide.
        //if ($(object).attr("class") == "select_liste_pays") {
        var selectZoneNum = $(object).data('zonenum');
        //var idPays = $(object).find('option:selected').val();
        //var idZone = $(object).find('option:selected').val();

        var formId = $(object).parent('div').parent('form').attr('id');
        var optionZone = $('#' + formId + ' select:eq(0)').find('option:selected');
        var optionPays = $('#' + formId + ' select:eq(1)').find('option:selected');

        var idZone = optionZone.val();
        var idPays = (selectType == 'zone') ? 0 : $(optionPays).val();

        //On met à jour le titre de la zone sélectionnée sauf pour le formulaire de liste 2.
        if (element.indexOf("2") == -1) {
            var zoneSelectedName = (selectType == 'pays' && idPays && idPays != 0) ? $(optionPays).html() : $(optionZone).html();
            $('.monde_zone_titre').html(zoneSelectedName);
        }

        //On récupère les infos correspondantes.
        getDataAndUpdate(idPays, idZone, selectZoneNum);
        //}
    }


    /**
     * En fonction de la zone, on met à jour le formulaire.
     */
    function updateZoneList(idZone, zoneNum) {

        if (idZone == 900) {
            //q.getPays(updatePaysList);
            //console.log(lg);
            q.getPays(lg, function (data) {
                updatePaysList(data, zoneNum);
            });
        } else {
            //q.getPaysZone(idZone, updatePaysList);
            q.getPaysZone(idZone, lg, function (data) {
                updatePaysList(data, zoneNum);
            });
        }
    }


    /**
     * Mise à jour de la liste des pays en fonction d'une zone.
     */
    function updatePaysList(data, zoneNum) {

        //On récupère les classes sélectionnées en fonction de la liste sélectionnée.
        var classSelect = (parseInt(zoneNum) && zoneNum != 1) ? 'select.select_liste_pays' + zoneNum : 'select.select_liste_pays';
        var classChoix = (parseInt(zoneNum) && zoneNum != 1) ? '.choix_pays' + zoneNum : '.choix_pays';

        $(classChoix).find('span.customSelectInner').html('-----');
        $(classSelect).html('<option role="option" aria-selected="true" data-pays="null" value="0">-----</option>');
        for (p in data) {

            var pays_id = data[p].pays_id;
            var pays_titre = data[p]['pays_nom_' + lg];
            var pays_titre_nice = niceName(pays_titre);
            var pays_titre_zone = niceName(data[p].pays_nom_fr);
            //var pressed = (p == 0) ? true : false;
            var pressed = false;

            //On rempli le select des pays.
            $(classSelect).append('<option role="option" aria-selected="' + pressed + '" data-pays="' + pays_titre_zone + '" value="' + pays_id + '">' + pays_titre + '</option>');
        }

        //getDataAndUpdate();
    }


    /*********************************************************************/
    //Gestion de la pyramide.
    /*********************************************************************/

    /**
     * V2. Permet de mettre à jour la pyramide en fonction du lieu
     * sans effectuer de requête à chaque fois.
     */
    var sliderAnnee = false;

    function updatePyramid() {
        if (!sliderAnnee) {
            sliderAnnee = $('#slider_pyramide_annee a.ui-slider-handle');
        }

        //On récupère l'année sélectionnée.
        var selectedYear = sliderAnnee.attr('aria-valuenow');

        //On affiche la nouvelle pyramide.
        pyr.gen(dataZone[selectedYear]["Male"], dataZone[selectedYear]["Female"], function () {
            getPopulation(dataZone[selectedYear]["popu_total"]);
        });
    }


    /**
     * Permet de récupérer les données et de mettre la pyramide à jour.
     */
    function getDataAndUpdate(idPays, idZone, zoneNum) {
        setTimeout(function () {
            //var idPays = $("select.select_liste_pays").find('option:selected').val();
            //var idZone = $("select.select_liste_continents").find('option:selected').val();

            var id = (idPays != 0) ? idPays : idZone;
            getDataZoneInfos(id, true, zoneNum, function () {

                var maxt = dataZone['max_total'];
                var maxr = dataZone['max_round'];
                var maxm = Math.round(maxr / 2);

                $("#graphique_legende .val_homme_max")[0].innerHTML = (maxr);
                $("#graphique_legende .val_homme_medium")[0].innerHTML = (maxm);
                $("#graphique_legende .val_femme_medium")[0].innerHTML = (maxm);
                $("#graphique_legende .val_femme_max")[0].innerHTML = (maxr);

                updateStats();
                getCourbes();
            });

        }, 100);
    }


    /**
     * Récupération de toutes les infos concernant une ou
     * plusieurs zones sous forme de tableau.
     */
    function getDataZoneInfos(id, various, zoneNum, callback) {
        var popu_total_max = 0;
        var zoneNum = (parseInt(zoneNum)) ? zoneNum : 1;
        var dataZoneLoc;

        var last_dataZone = dataZone;

        q.getDataForZone(id, function (data) {
            //console.log(data);
            dataZoneLoc = {};

            var esperance_max = 0;
            var enfant_femme_max = 0;
            var tx_croissance_max = 0;
            var tx_natalite_max = 0;
            var densite_max = 0;
            var naissance_annuelle_max = 0;
            var tx_mortalite_max = 0;
            var mortalite_infant_max = 0;
            var pop65_max = 0;

            var esperance_min = 0;
            var enfant_femme_min = 0;
            var tx_croissance_min = 0;
            var tx_natalite_min = 0;
            var densite_min = 0;
            var naissance_annuelle_min = 0;
            var tx_mortalite_min = 0;
            var mortalite_infant_min = 0;
            var pop65_min = 0;

            for (p in data) {

                if (!dataZoneLoc[data[p].popu_annee]) {
                    dataZoneLoc[data[p].popu_annee] = {};
                }

                var sexe = data[p].popu_sexe;
                if (sexe != 'Both') {
                    dataZoneLoc[data[p].popu_annee][sexe] = data[p];

                    //On essaye de récupérer la valeur maximum de la population
                    //sur toutes les années dont on possède les données.
                    var max = 0;
                    for (var i = 99; i >= 0; i--) {
                        max = Math.max(data[p]['popu_age' + i], max);
                    }

                    if (popu_total_max < max) {
                        popu_total_max = max;
                    }

                } else {
                    dataZoneLoc[data[p].popu_annee]['popu_total'] = data[p].popu_total;

                    esperance_max = Math.max(esperance_max, data[p].donnee_esperance);
                    enfant_femme_max = Math.max(enfant_femme_max, data[p].donnee_enfant_femme);
                    tx_croissance_max = Math.max(tx_croissance_max, data[p].donnee_tx_croissance);
                    tx_natalite_max = Math.max(tx_natalite_max, data[p].donnee_tx_natalite);
                    densite_max = Math.max(densite_max, data[p].donnee_densite);
                    naissance_annuelle_max = Math.max(naissance_annuelle_max, data[p].donnee_naissance_annuelle);
                    tx_mortalite_max = Math.max(tx_mortalite_max, data[p].donnee_tx_mortalite);
                    mortalite_infant_max = Math.max(mortalite_infant_max, data[p].donnee_mortalite_infant);
                    pop65_max = Math.max(pop65_max, data[p].donnee_65);

                    esperance_min = Math.min(esperance_min, data[p].donnee_esperance);
                    enfant_femme_min = Math.min(enfant_femme_min, data[p].donnee_enfant_femme);
                    tx_croissance_min = Math.min(tx_croissance_min, data[p].donnee_tx_croissance);
                    tx_natalite_min = Math.min(tx_natalite_min, data[p].donnee_tx_natalite);
                    densite_min = Math.min(densite_min, data[p].donnee_densite);
                    naissance_annuelle_min = Math.min(naissance_annuelle_min, data[p].donnee_naissance_annuelle);
                    tx_mortalite_min = Math.min(tx_mortalite_min, data[p].donnee_tx_mortalite);
                    mortalite_infant_min = Math.min(mortalite_infant_min, data[p].donnee_mortalite_infant);
                    pop65_min = Math.min(pop65_min, data[p].donnee_65);
                }

                //console.log(data[p]);
                //dataZoneLoc[data[p].popu_annee]['popu_total'] = data[p].popu_annee;
            }


            //On stoque tout ça dans le dataZoneLoc.
            dataZoneLoc['fk_pays_id'] = id;
            dataZoneLoc['esperance_max'] = esperance_max;
            dataZoneLoc['enfant_femme_max'] = enfant_femme_max;
            dataZoneLoc['tx_croissance_max'] = tx_croissance_max;
            dataZoneLoc['tx_natalite_max'] = tx_natalite_max;
            dataZoneLoc['densite_max'] = densite_max;
            dataZoneLoc['naissance_annuelle_max'] = naissance_annuelle_max;
            dataZoneLoc['tx_mortalite_max'] = tx_mortalite_max;
            dataZoneLoc['mortalite_infant_max'] = mortalite_infant_max;
            dataZoneLoc['pop65_max'] = pop65_max;

            dataZoneLoc['esperance_min'] = esperance_min;
            dataZoneLoc['enfant_femme_min'] = enfant_femme_min;
            dataZoneLoc['tx_croissance_min'] = tx_croissance_min;
            dataZoneLoc['tx_natalite_min'] = tx_natalite_min;
            dataZoneLoc['densite_min'] = densite_min;
            dataZoneLoc['naissance_annuelle_min'] = naissance_annuelle_min;
            dataZoneLoc['tx_mortalite_min'] = tx_mortalite_min;
            dataZoneLoc['mortalite_infant_min'] = mortalite_infant_min;
            dataZoneLoc['pop65_min'] = pop65_min;

            dataZoneLoc['max_total'] = popu_total_max;
            dataZoneLoc['max_round'] = roundSup(popu_total_max);
            //var maxm = Math.round(maxr / 2);


            //Si on a plusieurs zones, on stoque dans une nouvelle variable
            //et on réattribu les bonnes valeurs à la zone générale.
            if (various) {
                dataZones['zone' + zoneNum] = dataZoneLoc;
                //dataZoneLoc = (last_dataZoneLoc) ? last_dataZoneLoc : dataZoneLoc;
            }

            if (zoneNum == 1) {
                dataZone = dataZoneLoc;
            }

            if (callback) {
                callback();
            }

            //console.log(dataZoneLoc);
            //console.log(dataZoneLocs);
            return dataZoneLoc;
        });

    }


    /**
     * Fonction jouée à chaque changement de paramètres.
     */
    function updateStats() {
        updatePyramid();
        getIndices();
        //getCourbes();

        classementUpdateView();
        classementUpdatePays();
    }


    function getPopulation(total) {
        $(".categorie_infos #population_totale").html(formatNb(total * 1000));
    }


    /*********************************************************************/
    //Gestion des indices démographiques.
    /*********************************************************************/

    $('.jauge_aide .jauge_aide_infos').hide();
    $("body").on("click", ".jauge_aide_picto", function (e) {
        e.preventDefault();
        $('.jauge_aide .jauge_aide_infos').not($(this).next('.jauge_aide_infos')).fadeOut(100);
        $(this).next('.jauge_aide_infos').fadeToggle(100);
        return false;
    });


    /**
     * On récupère et on affiche les indices.
     */
    function getIndices() {

        var sliderAnnee = $("#slider_pyramide_annee");
        var selectedYear = sliderAnnee.slider('value');

        var tabDonnees = {
            'esperance': dataZone[selectedYear]['Male']['donnee_esperance'],
            'enfant_femme': dataZone[selectedYear]['Male']['donnee_enfant_femme'],
            'tx_croissance': dataZone[selectedYear]['Male']['donnee_tx_croissance'],
            'tx_natalite': dataZone[selectedYear]['Male']['donnee_tx_natalite'],
            'densite': dataZone[selectedYear]['Male']['donnee_densite'],
            //'naissance_annuelle' : dataZone[selectedYear]['Male']['donnee_naissance_annuelle'],
            'tx_mortalite': dataZone[selectedYear]['Male']['donnee_tx_mortalite'],
            'mortalite_infant': dataZone[selectedYear]['Male']['donnee_mortalite_infant'],
            'pop65': dataZone[selectedYear]['Male']['donnee_65']
        }

        for (key in tabDonnees) {
            //console.log(key+' => '+tabDonnees[key]);

            var purcent_max = dataZone[key + '_max'] + (dataZone[key + '_min'] * -1);
            var purcent = ((tabDonnees[key] + (dataZone[key + '_min'] * -1)) * 100) / purcent_max;
            $(".indice_jauge #indice_" + key + "_defaut").html((formatNb(dataZone[key + '_min'], 2)));

            if (key == 'enfant_femme') {
                $(".indice_jauge #indice_" + key + "_chiffre").html(formatNb(tabDonnees[key], 2));
            } else {
                $(".indice_jauge #indice_" + key + "_chiffre").html(formatNb(tabDonnees[key], 1));
            }
            $(".indice_jauge #indice_" + key + "_jauge").css({width: purcent + '%'});
        }

    }


    /*********************************************************************/
    //Gestion de la courbe d'évolution.
    /*********************************************************************/

    $("body").on("click", "#stats_pictos .statpicto", function (e) {
        e.preventDefault();

        TweenMax.to('#stats_pictos .statpicto', 0.3, {backgroundColor: "#edeeef", color: "#222222"});
        TweenMax.to($(this), 0.3, {
            backgroundColor: "#2d3844", color: "#ffffff", onComplete: function (e) {

                $('#stats_pictos .statpicto').removeClass('selected');
                $(this.target).addClass('selected');
                getCourbes();
            }
        });

        return false;
    });


    /**
     * On récupère les infos et on affiche la courbe.
     */
    function getCourbes() {


        //On commence par récupérer toutes les données des deux zones à comparer.
        /************************************************************************************/

        var tabDonneesZones = {};
        //console.log(dataZones);

        for (keyZone in dataZones) {
            //console.log(dataZones[keyZone]);

            var tabDonnees = {};
            tabDonneesZones[keyZone] = [];
            tabDonneesZones[keyZone]['fk_pays_id'] = {};
            tabDonneesZones[keyZone]['values'] = {};

            if (keyZone == "zone1") {
                tabDonneesZones['labels'] = [];
            }

            for (var a = startYear; a <= 2100; a++) {

                if (keyZone == "zone1") {
                    tabDonneesZones['labels'].push(a);
                }

                if (a == startYear) {
                    tabDonneesZones[keyZone]['fk_pays_id'] = dataZones[keyZone][a]['Male']['fk_pays_id'];
                }

                tabDonnees[a] = {
                    //'population' : dataZones[keyZone][a]['Male']['popu_total'],
                    'population': dataZones[keyZone][a]['popu_total'],
                    'densite': dataZones[keyZone][a]['Male']['donnee_densite'],
                    'enfant_femme': dataZones[keyZone][a]['Male']['donnee_enfant_femme'],
                    'naissance_annuelle': dataZones[keyZone][a]['Male']['donnee_naissance_annuelle'],
                    'tx_natalite': dataZones[keyZone][a]['Male']['donnee_tx_natalite'],
                    'tx_mortalite': dataZones[keyZone][a]['Male']['donnee_tx_mortalite'],
                    'tx_croissance': dataZones[keyZone][a]['Male']['donnee_tx_croissance'],
                    'mortalite_infant': dataZones[keyZone][a]['Male']['donnee_mortalite_infant'],
                    'esperance': dataZones[keyZone][a]['Male']['donnee_esperance'],
                    'pop65': dataZones[keyZone][a]['Male']['donnee_65']
                }

            }
            tabDonneesZones[keyZone]['values'] = tabDonnees;

        }
        //console.log(tabDonneesZones);


        //On récupérer ensuite les données du type spécifique.
        /************************************************************************************/

        var labels = tabDonneesZones['labels'];
        var zones = {};

        var courbeType = $('#stats_pictos .statpicto.selected').data('type');
        var type = (courbeType) ? courbeType : 'population';
        getLegendeCourbe(type);


        for (key in tabDonneesZones) {

            if (key != 'labels') {

                var zone = tabDonneesZones[key]['values'];
                var zoneId = key;
                zones[zoneId] = [];

                //Pour chaque zone, on parcours tout le tableau.*
                zones["zero"] = [];
                for (key in zone) {
                    if (key > 0) {
                        var val = zone[key][type]; //(zone[key][type] > 0) ? zone[key][type] : 0;
                        zones[zoneId].push(val);
                        zones['zero'].push(0);
                        //zones[zoneId].push(zone[key][type]);
                    }
                }
            }

        }
        //console.log(zones['zone1']);
        //console.log(zones['zone2']);


        //Création du graphique.
        /************************************************************************************/

        //Calcul de la valeur maximale de chaque courbes.
        var maxZone1 = Math.max.apply(Math, zones["zone1"]);
        var maxZone2 = Math.max.apply(Math, zones["zone2"]);
        var maxZones = Math.max.apply(Math, [maxZone1, maxZone2]);
        maxZones = roundSup(maxZones);


        //Idem pour les valeurs min chaque courbes.
        var minZone1 = Math.min.apply(Math, zones["zone1"]);
        var minZone2 = Math.min.apply(Math, zones["zone2"]);
        var minZones = Math.min.apply(Math, [minZone1, minZone2]);

        //console.log(zones["zone1"]);

        var lineChartData = {
            labels: labels,
            datasets: []
        };

        //On ajoute les datasets en fonction des zones sélectionnées.
        if (zones["zone1"] != null) {

            var idZone = tabDonneesZones['zone1']['fk_pays_id'];
            var labelZone = $('#form_choix_zone select').find('option[value="' + idZone + '"]').html();
            //console.log('labelZone');
            //console.log(labelZone);

            var zone1 = {
                //label: "My First dataset",
                label: labelZone,
                //fillColor: "rgba(220,220,220,0.2)",
                //strokeColor: "rgba(220,220,220,1)",
                //pointColor: "rgba(220,220,220,1)",
                fillColor: "rgba(34,46,59,0.1)",
                strokeColor: "rgba(34,46,59,1)",
                pointColor: "rgba(34,46,59,1)",
                pointStrokeColor: "#fff",
                pointHighlightFill: "#fff",
                pointHighlightStroke: "rgba(220,220,220,1)",
                data: zones["zone1"]
                //data: [65, 59, 80, 81, 56, 55, 40]
            };
            lineChartData['datasets'].push(zone1);
        }

        if (zones["zone2"] != null) {

            var idZone = tabDonneesZones['zone2']['fk_pays_id'];
            var labelZone = $('#form_choix_zone2 select').find('option[value="' + idZone + '"]').html();
            //console.log(labelZone);

            var zone2 = {
                //label: "My Second dataset",
                label: labelZone,
                //fillColor: "rgba(151,187,205,0.2)",
                //strokeColor: "rgba(151,187,205,1)",
                //pointColor: "rgba(151,187,205,1)",
                fillColor: "rgba(229,56,47,0.1)",
                strokeColor: "rgba(229,56,47,1)",
                pointColor: "rgba(229,56,47,1)",
                pointStrokeColor: "#fff",
                pointHighlightFill: "#fff",
                pointHighlightStroke: "rgba(151,187,205,1)",
                data: zones["zone2"]
                //data: [65, 59, 80, 81, 56, 55, 40]
            };
            lineChartData['datasets'].push(zone2);
        }
        //console.log(lineChartData);


        var zoneZero = {

            label: "zero",
            //fillColor: "rgba(151,187,205,0.2)",
            //strokeColor: "rgba(151,187,205,1)",
            //pointColor: "rgba(151,187,205,1)",
            fillColor: "rgba(255,0,1,0)",
            strokeColor: "rgba(100,100,100,.5)",
            pointColor: "rgba(255,0,1,0)",
            pointStrokeColor: "#fff",
            pointHighlightFill: "#fff",
            pointHighlightStroke: "rgba(151,187,205,0)",
            data: zones["zero"]
            //data: [65, 59, 80, 81, 56, 55, 40]
        };

        //On recréer le canvas dynamiquement au cas ou...
        var newCanvas = $('<canvas/>', {'class': 'cnvsClass'}, {'id': 'lineCanvas'}).width(600).height(400);
        $("section#evolution #wrapperCanvas").html(newCanvas);


        var ctx = newCanvas[0].getContext('2d');
        ctx.canvas.width = 600;
        ctx.canvas.height = 380;
        scaleSteps = 2;

        //On défini le step et la valeur de départ en fonction de la valeur minimum récupérée.
        if (minZones < 0) {
            var scaleStepWidthValue = Math.ceil((maxZones - minZones) / 2);
            var scaleStartValue = minZones;
        } else {
            var scaleStepWidthValue = Math.ceil(maxZones / 2);
            var scaleStartValue = 0;
        }

        /**
         * @TODO Rendre ça plus "souple" pour que le zero ne soit pas forcément au milieu de l'écran ...
         */
        if (scaleStartValue < 0) {
            scaleStepWidthValue = Math.ceil((Math.max(maxZones, Math.abs(minZones))));
            scaleStartValue = -maxZones;

            scaleStepWidthValue = Math.abs(Math.floor(minZones));
            scaleStartValue = Math.floor(minZones);
            scaleSteps = Math.ceil(maxZones / Math.abs(Math.floor(minZones))) + 1;

            lineChartData['datasets'].unshift(zoneZero);
            lineChartData['datasets'][1].fillColor = 'rgba(0,0,0,0)';
            if (lineChartData['datasets'][2]) {
                lineChartData['datasets'][2].fillColor = 'rgba(0,0,0,0)';
            }
        }

        // console.log(maxZones);
        // console.log(minZones);
        // console.log('scaleSteps : '+scaleSteps);
        // console.log('scaleStepWidth : '+scaleStepWidthValue);

        //Si le nombre de zones est inférieur ou égal au nombre de pas, on décide d'en afficher seulement 2.
        if (maxZones <= scaleSteps) {
            scaleSteps = 2;
            scaleStepWidthValue = Math.ceil(maxZones / 2);
        }


        //var ctx = document.getElementById("lineCanvas").getContext("2d");
        var myLineChart = new Chart(ctx).Line(lineChartData, {
            responsive: true,
            //tooltipXPadding: 60,
            animation: false,
            pointDot: false,
            pointHitDetectionRadius: 0,
            showXLabels: 6,
            datasetStrokeWidth: 2,

            showTooltips: false,

            //scaleLabel: "<%=value%>",
            scaleLabel: function (e) {
                return ' ' + formatNb(e.value);
            },

            // Boolean - If we want to override with a hard coded scale
            scaleOverride: true,

            // ** Required if scaleOverride is true **
            // Number - The number of steps in a hard coded scale
            scaleSteps: scaleSteps,
            // Number - The value jump in the hard coded scale
            scaleStepWidth: scaleStepWidthValue,
            // Number - The scale starting value
            scaleStartValue: scaleStartValue

        });


        //On récupère les données du point de l'année actuelle.
        var getSubItem = function (subItems, id) {
            if (subItems) {
                for (var i = 0; i < subItems.length; i++) {
                    if (subItems[i].label == id) {
                        return subItems[i];
                    }
                    var found = getSubItem(subItems[i].items, id);
                    if (found) return found;
                }
            }
        };

        var allPoints = myLineChart.datasets[0]['points'];
        var currentYearPoint = getSubItem(allPoints, currentYear);

        //On positionne par défaut les lignes sur l'année courante.
        $('#yearLine').css({'left': currentYearPoint['x'] + 'px'}).hide();
        $('#yearLineCurrent').css({'left': currentYearPoint['x'] + 'px'});


        //On ajuste la largeur de la div '#wrapperInfosCanvas' à la taille du graphique.
        var xPointMin = allPoints.reduce(function (min, arr) {
            return Math.min(min, arr['x']);
        }, +Infinity);

        var xPointMax = allPoints.reduce(function (max, arr) {
            return Math.max(max, arr['x']);
        }, -Infinity);

        var widthCharArea = parseInt(xPointMax) - parseInt(xPointMin);
        var widthDiff = newCanvas.width() - widthCharArea;
        //console.log(widthDiff);

        $('#wrapperInfosCanvas').css({
            'width': (newCanvas.width() - widthDiff) + 'px',
            'padding-left': widthDiff + 'px'
        });
        $('#wrapperDeadZoneCanvas').css({'width': widthDiff + 'px', 'height': newCanvas.height() + 'px'});


        //Evenements liés au graphique.
        /************************************************************************************/

        /**
         * On affiche/masque le block infos au passage de la souris.
         */
        $('#infosCanvas').hide();
        //$('#yearLineZone').on( "mouseenter", function(e){
        newCanvas.on("mouseenter", function (e) {
            $('#infosCanvas, #yearLine').show();

        }).on("mouseleave", function (e) {

            var relatedTarget = $(e.relatedTarget).attr('id');
            if (relatedTarget == 'yearLine' || relatedTarget == 'wrapperInfosCanvas' || relatedTarget == 'infosCanvas')
                return false;

            $('#infosCanvas, #yearLine').hide();
        });


        /**
         * On affiche des informations au passage de la souris sur le graphique.
         */
        //$('#yearLineZone').on('mousemove touchmove', function(evt){
        //newCanvas.on('mousemove touchmove', function(evt){
        $(newCanvas).add('#wrapperInfosCanvas').on('mousemove touchmove', function (evt) {

            var activePoints = myLineChart.getPointsAtEvent(evt);
            activePoints = arrayUnique(activePoints, 'datasetLabel');


            //Si on a pas de points, on ne vas pas plus loin.
            var totalPoints = activePoints.length;
            if (totalPoints < 1)
                return false;


            //Récupérations des infos des points sélectionnés.
            var points = {};
            for (key in activePoints) {
                //console.log('point');
                //console.log(activePoints[key]);

                points[key] = {};
                points[key]['label'] = activePoints[key]['label'];
                points[key]['datasetLabel'] = activePoints[key]['datasetLabel'];
                points[key]['value'] = activePoints[key]['value'];
            }

            //var courbeTradId = $('#stats_pictos .statpicto.selected').find('span').data('content');
            var courbeTrad = $('#stats_pictos .statpicto.selected').find('span').html();
            //console.log(courbeTrad);


            //Cas particuliers pour les décilmales à afficher.
            if (type == 'population') {
                var decimales = 0;

            } else if (type == 'pop65') {
                var decimales = 0;

            } else if (type == 'enfant_femme') {
                var decimales = 2;

            } else {
                var decimales = 1;
            }


            if (points[0]['datasetLabel'] == "zero") {
                /**
                 * Si on a une valeur pour la ligne du zero on la dégage
                 */
                points[0] = points[1];
                points[1] = points[2];
            }
            //On intégre les infos correspondantes.
            if (points[0] != null) {
                $('#infosCanvas #info_annee span#population_indicateur').html(courbeTrad);
                $('#infosCanvas #info_annee span#annee_valeur').html(points[0]['label']);
                $('#infosCanvas #info_zone1 span#zone1_titre').html(points[0]['datasetLabel']);
                $('#infosCanvas #info_zone1 span#zone1_valeur').html(formatNb(points[0]['value'], decimales));
            }

            if (points[1] != null) {
                $('#infosCanvas #info_zone2').show();
                $('#infosCanvas #info_zone2 span#zone2_titre').html(points[1]['datasetLabel']);
                $('#infosCanvas #info_zone2 span#zone2_valeur').html(formatNb(points[1]['value'], decimales));
            } else {
                $('#infosCanvas #info_zone2').hide();
            }


            //On postionne la ligne au bon endroit.
            $('#yearLine').css({'left': activePoints[0]['x'] + 'px'});

        });
    }


    /**
     * On récupère la traduction de la légende
     * en fonction du type de bouton sélectionné.
     */
    function getLegendeCourbe(type) {

        var infoTrad = "";
        switch (type) {
            case 'population':
                infoTrad = dataTrads[lg]["population_indicecourbe_population_info"];
                break;

            case 'densite':
                infoTrad = dataTrads[lg]["population_indicecourbe_densite_info"];
                break;

            case 'enfant_femme':
                infoTrad = dataTrads[lg]["population_indicecourbe_nombre_enfant_femme_info"];
                break;

            case 'naissance_annuelle':
                infoTrad = dataTrads[lg]["population_indicecourbe_nombre_naissance_info"];
                break;

            case 'tx_natalite':
                infoTrad = dataTrads[lg]["population_indicecourbe_taux_natalite_info"];
                break;

            case 'tx_mortalite':
                infoTrad = dataTrads[lg]["population_indicecourbe_taux_mortalite_info"];
                break;

            case 'tx_croissance':
                infoTrad = dataTrads[lg]["population_indicecourbe_taux_croissance_info"];
                break;

            case 'mortalite_infant':
                infoTrad = dataTrads[lg]["population_indicecourbe_mortalite_infantile_info"];
                break;

            case 'esperance':
                infoTrad = dataTrads[lg]["population_indicecourbe_duree_vie_moyenne_info"];
                break;

            case 'pop65':
                infoTrad = dataTrads[lg]["population_indicecourbe_population_65_plus_info"];
                break;
        }

        if (infoTrad != "") $('#stats_courbes #courbe_legende').html(infoTrad);

    }


    /*********************************************************************/
    //Gestion de la pyramide.
    /*********************************************************************/

    /**
     * Construction de la pyramide.
     */
    pyramid = function (obj) {
        var conteneur = $(obj);


        //On récupère la limite de l'age recherché.
        var selectedAge = $("#slider_place .sliderValue").html();
        var selectedYear = $("#slider_pyramide_annee .sliderValue").html();
        var limitAge = parseInt(selectedYear) - parseInt(currentYear) + parseInt(selectedAge);

        //On construit le tableau de 100 valeurs.
        var table = ['<table class="pyramid" width="100%" cellspacing="0" cellpadding="0"><caption></caption>'];
        var tabObj = {};
        var ageTexte = '';
        for (var p = 99; p >= 0; p--) {
            ageTexte = p + ' ' + dataTrads[lg]["population_titre_ans"];
            table.push('<tr data-age="' + p + '">');
            table.push('<td><span id="sh' + p + '" class="sh" style="width:100%;"></span></td>');
            table.push('<th>' + p + '</th>');
            table.push('<td><span id="sf' + p + '" class="sf" style="width:100%;"></span><span id="cf' + p + '" class="cf">' + ageTexte + '</span></td></tr>');
        }

        table.push('</table>');
        conteneur.html(table.join(''));
        for (var p = 99; p >= 0; p--) {
            tabObj['sh' + p] = document.getElementById('sh' + p);
            tabObj['sf' + p] = document.getElementById('sf' + p);
        }

        var tableDiv = conteneur.find('>table');

        var sliderPlace = $("#slider_place");
        var sliderAnnee = $("#slider_pyramide_annee");
        var previousYear = false;


        //On insert les valeurs correspondantes aux hommes et aux femmes.
        this.gen = function (homme, femme, callback) {

            /**
             * On récupère les valeurs actuelles.
             */
            var selectedAge = sliderPlace.slider('value');
            var selectedYear = sliderAnnee.slider('value');


            //Récupération de la population max sur l'ensemble des années.
            var max = dataZone['max_round'];
            //console.log(max);

            /**
             * Test pour ne pas refaire tout le tableau si on juste changé
             * d'age et pas d'année
             */
            //if (previousYear !== selectedYear) {

            for (var p = 99; p >= 0; p--) {

                tabObj['sh' + p].style.width = (homme['popu_age' + p] / max * 100) + '%';
                tabObj['sf' + p].style.width = (femme['popu_age' + p] / max * 100) + '%';

                /*
                 * Bizarrement : Plus lent en temps de calcul mais
                 * plus fluide à l'affichage (sur ipad au moins) !
                 * Mais moins bon support global ....
                 *
                 tabObj['sh' + p].style.webkitTransform =
                 tabObj['sh' + p].style.mozTransform =
                 tabObj['sh' + p].style.webkitTransform =
                 tabObj['sh' + p].style.transform =
                 'scaleX(' + (homme['popu_age' + p] / max) + ')';
                 tabObj['sf' + p].style.webkitTransform = '
                 scaleX(' + (femme['popu_age' + p] / max) + ')';
                 */
                /* tabObj['sh' + p].style.backgroundColor = couleurCode;
                 tabObj['sf' + p].style.backgroundColor = couleurCode;*/

            }
            //}
            previousYear = selectedYear;


            if (callback) {
                callback();
            }
        };
    };


    /*********************************************************************/
    //Gestion des sliders.
    /*********************************************************************/

    /**
     * Génère un jquery-ui slider avec les attributs d'accessibilité "aria".
     */
    function genCustomSlider(element, defaultValue, minValue, maxValue, txtSuffix, sliderClass, slideFunction, slideFunctionInterval, categorie, vertical) {

        var categorie = (categorie) ? categorie : '';
        var txtSuffix = (txtSuffix) ? txtSuffix : '';
        var slideFunction = (slideFunction) ? slideFunction : '';
        var slideOrientation = (vertical) ? "vertical" : 'horizontal';
        var sliderElement = (sliderClass) ? sliderClass : element;
        var trimelement = element.replace("#", "").replace(".", "");
        var count = 0;

        sliderYear = defaultValue;


        //Création du slider.
        /********************************************************************/
        $(element).empty().slider({
            orientation: slideOrientation,
            range: "min",
            animate: true,
            value: defaultValue,
            min: minValue,
            max: maxValue,
            slide: function (event, ui) {

                //console.log('slide');
                var slideHandle = $(ui.handle);
                var vlu = slideHandle.find('.sliderValue')[0];
                if (vlu.innerHTML === ui.value) {
                    return;
                }
                vlu.innerHTML = ui.value;
                slideHandle.attr("aria-valuenow", ui.value).attr("aria-valuetext", ui.value + txtSuffix);
                sliderYear = ui.value;
                updateSliders(ui.value, sliderElement, element);
                var currentCat = $("#tabs_population ul li.ui-state-active a").attr("data-categorie");

                if (slideFunction && categorie === currentCat /*&& slideFunctionInterval && count == slideFunctionInterval*/) {
                    eval(slideFunction + "()");
                }
            },
            change: function (event, ui) {

                //console.log('change');
                var slideHandle = $(ui.handle);
                var vlu = slideHandle.find('.sliderValue')[0];
                if (vlu.innerHTML === ui.value) {
                    return;
                }
                vlu.innerHTML = ui.value;
                slideHandle.attr("aria-valuenow", ui.value).attr("aria-valuetext", ui.value + txtSuffix);
                sliderYear = ui.value;
                var currentCat = $("#tabs_population ul li.ui-state-active a").attr("data-categorie");

                if (slideFunction && categorie == currentCat) {
                    eval(slideFunction + "()");
                }
                //;
            }

        });


        //Au chargement du slider.
        /********************************************************************/
        setTimeout(function () {

            //On affiche les valeurs par défaut.
            var slideHandle = $(element + " .ui-slider-handle");
            slideHandle.html('<span class="sliderPointer"></span><span class="sliderValue">' + defaultValue + '</span>' + txtSuffix);
            slideHandle.attr("role", "slider");
            slideHandle.attr("aria-valuenow", defaultValue).attr("aria-valuemin", minValue).attr("aria-valuemax", maxValue);
            slideHandle.attr("aria-valuetext", defaultValue + txtSuffix);

            //On ajoute un wrapper autour du slider.
            $(element).wrap('<div id="' + trimelement + '_wrapper" class="slider_' + slideOrientation + ' slider_wrapper ' + sliderElement.replace(".", "") + '_wrapper"></div>');

            //On ajoute les boutons "+" et "-".
            var prependBtn = (slideOrientation == 'vertical') ? 'more' : 'less';
            $(element + "_wrapper").prepend('<span class="sbutton sbutton_' + prependBtn + '" role="button"></a>');
            var appendBtn = (slideOrientation == 'vertical') ? 'less' : 'more';
            $(element + "_wrapper").append('<span class="sbutton sbutton_' + appendBtn + '" role="button"></a>');

            //On ajoute également dynamiquement les valeurs min et max sous le slider.
            $(element + "_wrapper ").append('<div class="sdefault_values"><div class="sdefault_min">' + minValue + '</div><div class="sdefault_max">' + maxValue + txtSuffix + '</div></div>');

        }, 100);


        //Ajout des actions.
        /********************************************************************/
        $("body").on("click", element + "_wrapper .sbutton_more", function () {
            var valuenow = $(element).slider("value");
            updateSliders(valuenow + 1, sliderElement);
        });

        $("body").on("click", element + "_wrapper .sbutton_less", function () {
            var valuenow = $(element).slider("value");
            updateSliders(valuenow - 1, sliderElement);
        });
    }


    /**
     * On met à jour tous les sliders associés.
     */
    function updateSliders(value, groupElement, currentElement) {
        $(groupElement).not(currentElement).each(function (index) {
            $(this).slider("value", value);
        });
    }


    /*********************************************************************/
    //Gestion du Classement.
    /*********************************************************************/

    //Initialisation du classement
    function classementInit() {
        // Mise en place des boutons d'indice
        $("#classement_indices button").on('click', function (e) {
            e.preventDefault();
            // Au click sur un bouton indice, on demande l'initialisation
            // de la mise à jour des données
            classementUpdateInit($(this).index() - 1);
            //classementUpdateStart( $(this).index() );
        });

        // Ajout ou suppression d'entrée dans la liste de classement
        // en fonction du nombre de pays
        classementAddEntry(dataPays.length, $('#classement .categorie_infos .indice_jauge').length);

        // Ajout d'identifiant pour chacune des jauges
        $("#classementCategorie .indice_jauge").each(function (i) {
            $(this).attr('id', 'classement' + i);
        });

        // Ajout du scroll sur la liste de classement
        $("#classementCategorie").mCustomScrollbar({
            theme: "rounded-dark"
        });
    };


    // Ajout ou suppression d'entrée dans la liste de classement
    // en fonction du nombre de pays
    function classementAddEntry(total1, total2) {
        var i = 0;
        var content = "";
        var total = total1 - total2;
        var totalAbs = Math.abs(total);

        if (total > 0) {
            // Si il a plus de pays que d'entrées
            for (i = 0; i < totalAbs; i = i + 1) {
                content += '                                <div class="indice_jauge">\
                                    <span data-content=""></span>\
\
                                    <div class="jauge_content">\
                                        <div class="jauge_wrapper">\
                                            <span class="jauge_valeur"></span>\
                                            <div class="jauge">\
                                            </div>\
                                        </div>\
                                    </div>\
                                </div>';
            }
            $('#classement .categorie_infos').append(content);

        } else if (total < 0) {
            // Si il y a moins de pays que d'entrées
            for (i = 0; i < totalAbs; i = i + 1) {
                $('#classement .categorie_infos .indice_jauge').eq(0).remove();
            }
        }
    }


    // Mise à jour des classement
    function classementUpdate(firstUpdate) {
        if (firstUpdate) {
            // Si c'est la première fois que l'on vient sur les classements
            classementUpdateInit(0);
        } else {
            // Sinon mise à jour de l'affichage des données
            classementUpdateView();
        }
    }


    // Initialisation du chargement de données de classement
    function classementUpdateInit(index) {

        // Affichage du loading
        //$("#loading").show();

        // Démarrage du chargement de la mise à jours
        classementUpdateStart(index);
    }


    // Démarrage du chargement de la mise à jours
    function classementUpdateStart(index) {
        // Changement de l'affichage de l'indice sélectionné
        // et de ses informations complémentaires
        classementUpdateViewInfo(index);

        // Lancement du chargement de la requète
        q.getClassement(index, classementUpdateData);
    }


    // Changement de l'affichage de l'indice sélectionné
    // et de ses informations complémentaires
    function classementUpdateViewInfo(index) {
        // Changement de l'affichage de l'indice sélectionné
        $("#classement_indices").find('.selected').removeClass('selected');
        $("#classement_indices button").eq(index).addClass('selected');

        // Changement de l'affichage des informations complémentaires
        classementUpdateIndiceInfo(index);
    }


    // Changement de l'affichage des informations complémentaires
    function classementUpdateIndiceInfo(index) {
        $infoTrad = "";
        if (index === 0) {
            $infoTrad = dataTrads[lg]["population_indice_population_info"];
        } else if (index === 1) {
            $infoTrad = dataTrads[lg]["population_indice_densite_info"];
        } else if (index === 2) {
            $infoTrad = dataTrads[lg]["population_indice_nombre_enfant_femme_info"];
        } else if (index === 3) {
            $infoTrad = dataTrads[lg]["population_indice_nombre_naissance_info"];
        } else if (index === 4) {
            $infoTrad = dataTrads[lg]["population_indice_taux_natalite_info"];
        } else if (index === 5) {
            $infoTrad = dataTrads[lg]["population_indice_taux_mortalite_info"];
        } else if (index === 6) {
            $infoTrad = dataTrads[lg]["population_indice_taux_croissance_info"];
        } else if (index === 7) {
            $infoTrad = dataTrads[lg]["population_indice_mortalite_infantile_info"];
        } else if (index === 8) {
            $infoTrad = dataTrads[lg]["population_indice_duree_vie_moyenne_info"];
        } else if (index === 9) {
            $infoTrad = dataTrads[lg]["population_indice_population_65_plus_info"];
        }
        if ($infoTrad != "") $('#classement_indice_info').html($infoTrad);
    }


    // Récupération de informations de requète et mise à jour de la vue
    // des classements
    function classementUpdateData(data) {
        // mise à jour des données
        classementData = data;

        //console.log(classementData);

        // valeur maximale pour ce classement
        classementMax = 0;

        var cT = classementData.length;

        for (i = 0; i < cT; i = i + 1) {
            // recherche de la valeur maximale
            if (classementData[i].CONTENT >= classementMax) classementMax = parseFloat(classementData[i].CONTENT);
        }

        // Mise à jour de la vue des données
        classementUpdateView();

        // Mise à jour du scroll
        $("#classementCategorie").mCustomScrollbar("update");

        // Mise à jour du pays sélectionné
        classementUpdatePays();
    }


    // Mise à jour de la vue des données
    function classementUpdateView() {
        // S'il y a un objet de données pour le classement
        if (classementData) {
            var i = 0;
            var j = 0;
            var content = "";
            // Démarrage de la liste d'affichage en fonction de la date
            // sélectionnée dans le slider


            var listStart = (sliderYear - startYear) * totalPays;
            var categorie = document.getElementById("classementCategorie");
            var list = categorie.getElementsByClassName("indice_jauge");


            //Je récupère mon type.
            var courbeType = $('#classement_indices .statpicto.selected').data('type');
            var type = (courbeType) ? courbeType : 'population';


            //Cas particuliers pour les décilmales à afficher.
            if (type == 'population') {
                var decimales = 0;

            } else if (type == 'pop65') {
                var decimales = 0;

            } else if (type == 'enfant_femme') {
                var decimales = 2;

            } else {
                var decimales = 1;
            }


            // mise à jour des jauges
            for (i = 0; i < totalPays; i = i + 1) {
                // Récupération de l'objet pays
                var obj = classementGetPays(classementData[listStart + i].pays)[0];
                var value = parseFloat(classementData[listStart + i].CONTENT);
                // mise à jour de l'id du pays concerné par cette jauge
                list[i].setAttribute("data-id", obj.pays_id);
                // mise à jour visuelle
                //list[i].getElementsByTagName('span')[0].innerHTML = (i + 1) + ": " + obj.pays_nom_fr;
                list[i].getElementsByTagName('span')[0].innerHTML = (i + 1) + ": " + obj['pays_nom_' + lg];
                list[i].getElementsByClassName('jauge')[0].style.width = (value * 100 / classementMax) + "%";
                list[i].getElementsByClassName('jauge_valeur')[0].innerHTML = formatNb(value, decimales);
            }
        }
    }

    // Récupération de l'objet contenant les données du pays
    function classementGetPays(paysId) {
        return $.grep(dataPays, function (e) {
            return e.pays_id == paysId;
        });
    }


    // Mise à jour du pays sélectionné dans la liste des classements
    function classementUpdatePays() {
        // Identifiant du pays sélectionné dans le menu déroulant
        // des pays des classement
        var id = $('#classement_select_liste_pays option:selected').attr('value');

        // Suppression du mode sélectionné en cours dans la liste des classements
        $('#classementCategorie .indice_jauge .selected').removeClass('selected');

        // Si la valeur de l'identifiant sélectionné n'est pas 0
        if (id != 0) {
            // Récupération de la jauge portant l'identifiant à sélectionner
            var jauge = $('#classementCategorie .indice_jauge[data-id="' + id + '"]');
            // Ajout du mode sélectionné à la jauge
            jauge.find('span').first().addClass('selected');
            // Récupération de l'index de cette jauge
            var scrollIndex = jauge.index();
            // Mise à jour du scroll pour aller sur cette jauge
            $("#classementCategorie").mCustomScrollbar("scrollTo", "#classement" + (scrollIndex - 2));
        }
    }


});


$(window).load(function () {

});


/*********************************************************************/
//Autres fonctions.
/*********************************************************************/

/**
 * Recupere la valeur d'un parametre defini dans l'url.
 */
function getParam(param) {

    //On separe la chaine des parametres en fonction du &.
    var spath = window.location.search.split("&"), i;

    //Bouclage des parametres.
    for (i = 0; i < spath.length; ++i) {

        hash = spath[i].split("=");
        hash_param = hash[0].replace("?", "");
        hash_val = hash[1];

        //On recupere le parametre de l'url si il existe.
        if (hash_param == param) {
            return hash_val;
        }
    }
}


/**
 * Permet de supprimer les doublons d'un tableau.
 * On peut également définir un élément spécifique du tableau sur lequel on effectuera le test.
 */
function arrayUnique(array, element) {

    var a = array.concat();
    for (var i = 0; i < a.length; ++i) {
        for (var j = i + 1; j < a.length; ++j) {

            if (element && a[i][element] === a[j][element]) {
                a.splice(j--, 1);

            } else if (a[i] === a[j]) {
                a.splice(j--, 1);
            }
        }
    }

    return a;
};


/**
 * Transforme un nom de fichier pour qu'il soit propre.
 */
function niceName(str) {
    str = str.toLowerCase();

    //On remplace les caractères accentués.
    var rules = {
        a: "àáâãäå",
        e: "èéêë",
        i: "ìíîï",
        o: "òóôõöø",
        u: "ùúûü",
        y: "ÿ",
        c: "ç",
        n: "ñ"
    };

    var regstring = "";
    for (acc in rules) {
        regstring += rules[acc];
    }

    var reg = new RegExp("[" + regstring + "]", "g");
    str = str.replace(reg, function (t) {
        for (acc in rules) {
            if (rules[acc].indexOf(t) > -1) {
                return acc;
            }
        }
    });

    //On remplace les autres caractères spéciaux par un tiret.
    str = $.trim(str);
    str = str.replace(/([^a-z0-9_]+)/g, "-");
    str = str.replace(/-/g, "-");
    str = str.replace(/---/g, "-");
    str = str.replace(/--/g, "-");
    str = $.trim(str);
    return str;
}


/**
 * Retourne le nombre avec un point ou une virgule en fonction de la langue.
 * Permet de reformater les nombres avec des espaces.
 */
function formatNb(nbr, digit) {
    var digit = (digit) ? digit : 0;
    var niceNb = Number(nbr).toFixed(digit);

    niceNb = (lg == 'en') ? niceNb : niceNb.toString().replace('.', ',');

    var x = niceNb.split('.');
    var x1 = x[0];
    var x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + ' ' + '$2');
    }

    niceNb = x1 + x2;
    niceNb = niceNb.replace('.00', '');
    niceNb = niceNb.replace(',00', '');
    return niceNb;
}


/**
 * On arrondi à la dizaine, centaine, millier, etc supérieure.
 * @param {Object} n
 */
function roundSup(n) {

    n = Math.ceil(n);
    var countc = n.toString().length;
    var multiple = 1;
    for (i = 1; i < countc; i++) {
        multiple = multiple * 10;
    }

    n = n / multiple;
    n = Math.ceil(n);
    n = n * multiple;
    return n;
}

/**
 * Pour un arrondi spécifique.
 * @param {Object} n
 */
function myToFixed(n, digits) {
    digits = digits || 0;
    return n.toFixed(digits).replace(new RegExp("\\.0{" + digits + "}"), "");
}
