


interface jvectormapOptions {
        
    map  :   string;//  Name of the map in the format territory_proj_lang where territory is a unique code or name of the territory which the map represents (ISO 3166 alpha 2 standard is used where possible), proj is a name of projection used to generate representation of the map on the plane (projections are named according to the conventions of proj4 utility) and lang is a code of the language, used for the names of regions.
backgroundColor? :    string;//  Background color of the map in CSS format.
zoomOnScroll? :   boolean;//     When set to true map could be zoomed using mouse scroll. Default value is true.
zoomMax?   :  number;//  Indicates the maximum zoom ratio which could be reached zooming the map. Default value is 8.
zoomMin?   :  number;//  Indicates the minimum zoom ratio which could be reached zooming the map. Default value is 1.
zoomStep?   : number;//  Indicates the multiplier used to zoom map with +/- buttons. Default value is 1.6.
regionsSelectable?  : boolean;//     When set to true regions of the map could be selected. Default value is false.
regionsSelectableOne?   : boolean;//     Allow only one region to be selected at the moment. Default value is false.
markersSelectable?  : boolean;//     When set to true markers on the map could be selected. Default value is false.
markersSelectableOne?  :  boolean;//     Allow only one marker to be selected at the moment. Default value is false.
regionStyle?   :  {};//  Set the styles for the map's regions. Each region or marker has four states: initial (default state), hover (when the mouse cursor is over the region or marker), selected (when region or marker is selected), selectedHover (when the mouse cursor is over the region or marker and it's selected simultaneously). Styles could be set for each of this states. Default value for that parameter is:
/*
{
  initial: {
    fill: 'white',
    "fill-opacity": 1,
    stroke: 'none',
    "stroke-width": 0,
    "stroke-opacity": 1
  },
  hover: {
    "fill-opacity": 0.8
  },
  selected: {
    fill: 'yellow'
  },
  selectedHover: {
  }
}
*/
markerStyle?  :  {};//   Object  Set the styles for the map's markers. Any parameter suitable for regionStyle could be used as well as numeric parameter r to set the marker's radius. Default value for that parameter is:
/*
{
  initial: {
    fill: 'grey',
    stroke: '#505050',
    "fill-opacity": 1,
    "stroke-width": 1,
    "stroke-opacity": 1,
    r: 5
  },
  hover: {
    stroke: 'black',
    "stroke-width": 2
  },
  selected: {
    fill: 'blue'
  },
  selectedHover: {
  }
}
*/
markers?  :any;//   Object | Array  Set of markers to add to the map during initialization. In case of array is provided, codes of markers will be set as string representations of array indexes. Each marker is represented by latLng (array of two numeric values), name (string which will be show on marker's label) and any marker styles.
series?  :{};//Object  Object with two keys: markers and regions. Each of which is an array of series configs to be applied to the respective map elements. See DataSeries description for a list of parameters available.
/*
    
  values    Array   The data set to visualize.
attribute   String  Numberic or color attribute to use for data visualization. This could be: fill, stroke, fill-opacity, stroke-opacity for markers and regions and r (radius) for markers only.
scale   Array   Values used to map a dimension of data to a visual representation. The first value sets visualization for minimum value from the data set and the last value sets visualization for the maximum value. There also could be intermidiate values. Default value is ['#C8EEFF', '#0071A4']
normalizeFunction   Function | String   The function used to map input values to the provided scale. This parameter could be provided as function or one of the strings: 'linear' or 'polynomial', while 'linear' is used by default. The function provided takes value from the data set as an input and returns corresponding value from the scale.
min     Number  Minimum value of the data set. Could be calculated automatically if not provided.
max     Number  Maximum value of the data set. Could be calculated automatically if not provided.  
    
*/    
    
    
    
focusOn?   :any;//  Object | String     This parameter sets the initial position and scale of the map viewport. It could be expressed as a string representing region which should be in focus or an object representing coordinates and scale to set. For example to focus on the center of the map at the double scale you can provide the following value:
/*
{
  x: 0.5,
  y: 0.5,
  scale: 2
}
*/

selectedRegions?   :any;//  Array | Object | String     Set initially selected regions.
selectedMarkers?   :any;//  Array | Object | String     Set initially selected markers.
onRegionLabelShow?  :(e:Event, label:JQuery,  code:string)=>any;// Function    (Event e, Object label, String code) Will be called right before the region label is going to be shown.
onRegionOver?    :(e:Event,  code:string)=>any;//Function    (Event e, String code) Will be called on region mouse over event.
onRegionOut?     :(e:Event,  code:string)=>any;//Function    (Event e, String code) Will be called on region mouse out event.
onRegionClick?   :(e:Event,  code:string)=>any;//Function    (Event e, String code) Will be called on region click event.
onRegionSelected?   :(e:Event,  code : string, isSelected : boolean , selectedRegions : string[] )=>any;// Function    (Event e, String code, Boolean isSelected, Array selectedRegions) Will be called when region is (de)selected. isSelected parameter of the callback indicates whether region is selected or not. selectedRegions contains codes of all currently selected regions.
onMarkerLabelShow?  :(e:Event, label:JQuery,  code:string)=>any;// Function    (Event e, Object label, String code) Will be called right before the marker label is going to be shown.
onMarkerOver?   :(e:Event,  code:string)=>any;// Function    (Event e, String code) Will be called on marker mouse over event.
onMarkerOut?     :(e:Event,   code:string)=>any;//Function    (Event e, String code) Will be called on marker mouse out event.
onMarkerClick?   :(e:Event,   code:string)=>any;//Function    (Event e, String code) Will be called on marker click event.
onMarkerSelected?    :(e:Event,  code : string, isSelected : boolean , selectedMarkers : string[])=>any;//Function    (Event e, String code, Boolean isSelected, Array selectedMarkers) Will be called when marker is (de)selected. isSelected parameter of the callback indicates whether marker is selected or not. selectedMarkers contains codes of all currently selected markers.
onViewportChange?    :(e:Event, scale : number)=>any;//Function    (Event e, Number scale) Triggered when the map's viewport is changed (map was panned or zoomed).
}


interface JQuery
{
    
   
    vectorMap(option:jvectormapOptions): JQuery;
    vectorMap(cmd:string,param:string): WorldMap;
}

interface WorldMap  {
    constructor(any);
    
    params;
mapData;
markers;
regions;
regionsColors;
regionsData;
container;
defaultWidth;
defaultHeight;
onResize();
canvas;
transX;
transY;
scale;
baseTransX;
baseTransY;
baseScale;
width;
height;
setBackgroundColor(backgroundColor : string);
resize();
setSize();
reset();
applyTransform();
bindContainerEvents();
bindContainerTouchEvents();
bindElementEvents();
labelWidth;
labelHeight;
bindZoomButtons();
createLabel();
label;
//setScale(Number, any, any, any);
setFocus(scale:number, centerX:number, centerY:number);
setFocus(regionCode:string, centerX:number, centerY:number);
setFocus(regionCodes:string[], centerX:number, centerY:number);
//getSelected(any);
getSelectedRegions();
getSelectedMarkers();
//setSelected(any, Array);
setSelectedRegions(keys : string );
setSelectedRegions(keys : string[]);
setSelectedRegions(keys : {});
setSelectedMarkers(keys : string );
setSelectedMarkers(keys : string[] );
setSelectedMarkers(keys : {});
//clearSelected(any);
clearSelectedRegions();
clearSelectedMarkers();
getMapObject();
getRegionName(any);
createRegions();
createMarkers(Object);
markersGroup;
repositionMarkers();
//getMarkerPosition(any);
addMarker(key : string, marker : {}, seriesData : any[]);
addMarkers(markers : {}, seriesData : any[]);
addMarkers(markers :  any[], seriesData : any[]);
removeMarkers(any);
removeAllMarkers();
latLngToPoint(lat : number, lng : number);
pointToLatLng(x : number, y : number);
//getInsetForPoint(any, any);
createSeries();
series;
remove();
    setScale(scale : number,x?:number,y?:number);
}


