declare var require;

/********************************************** file : binder.ts ***********************************************/
class binder {
   

    /**
    * Chemin vers la base de donnée SQLite
    * @type String
    * protected
    */
    sqliteDb = 'database.sqlite';

    /**
     * Chemin vers le script PHP à interroger 'query.php';
     * @type String
     * protected
     */
    php = '';

    /**
     * Liste des requêtes SQL
     * Rempli uniquement en mode "nodejs" (node-webkit)
     * protected
     */
    sql : any = false;

    /**
     * Type de connexion à utiliser
     * @type php|nodejs
     * protected
     */
    type = '';

    /**
     * 
     * connection en mode node-webkit
     * protected
     */
    db:any;
    /**
     * Si on a une fonction "require" c'est qu'on est dans node-webkit
     * Sinon on est sur le web en PHP
     */


    constructor(callback: (b: binder) => any) {

        if (typeof require === 'undefined') {
            this.type = 'php';
        } else {
            this.type = 'nodejs';
        }

        this.connect(callback);

    }

    private connect( callback: (b: binder) => any) {
        /**
     * Si on est en node-webkit on doit préparer la connexion
     */
        if (this.type === 'nodejs') {
            /**
             * On récupère la liste des requêtes SQL
             */
            var self = this;
            
            $.getJSON("sql.json", function(data) {
               self.sql = data;

                if (callback)
                    callback(self);

            });

            /**
             * On instancie notre objet sqlite3
             *
             * @todo verbose() peut être enlevé une fois en prod
             *
             * @type @call;require@call;verbose
             */
            var sqlite3 = require('sqlite3');


            /**
             * Et on charge la base de donnée
             * @type binder.sqlite3.Database
             */
            this.db = new sqlite3.Database(this.sqliteDb,
                sqlite3.OPEN_READONLY, function(e) {
                    if (e) {
                        /**
                         * Si e n'est pas null c'est qu'on a eu un problème
                         * de connexion à la BDD
                         *
                         * Par défaut on affiche à l'utilisateur
                         *
                         * @param {type} callback
                         * @returns {undefined}
                         */
                        alert(e);
                    }
                });

        } else {

            var self = this;
            setTimeout(function() {
                if (callback) callback(self);
            }, 1000);


        }
    }
    
    query(query: string, params: any, callback: (data: any)=> any) {
        /**
         * Si on est en PHP
         */
        if (this.type === 'php') {
            /**
             * On charge directement le JSON de résutlat depuis le serveur
             * Avec les paramètres encodés en JSON
             */
            $.getJSON(this.php + '?query=' + query + '&params=' +
                    JSON.stringify(params), callback);
                  
        } else {
            /**
             * Sinon on récupère la requête dans le tableau
             * @type @arr;sql
             */
            var q = this.sql[query];
            var params2 = {};

            /**
             * On préfixe les paramètres pour que sqlite
             * retrouve ses placeholders
             * Par défaut PHP n'en a pas besoin et utilise ":" comme préfixe
             */
            for (var p in params) {
                params2[':' + p] = params[p];
            }

            /**
             * On charge tout le résultat et on le retourne au callback
             */
            this.db.all(q, params2, function (tx, results,test) {

                if (tx) {
                    /**
                    * Sauf s'il y a une erreur ...
                    * on l'affiche par défaut ...
                    */
                    alert('SQL error : ' + tx+" \n On : "+query);
                    
                   
                    return false;
                }
                callback(results);
            });
        }
    }




}
