/// <reference path="libs/jquery.d.ts" />
/// <reference path="libs/jquery.mCustomScrollbar.d.ts" />
/// <reference path="libs/jquery.customselect.d.ts" />
/// <reference path="libs/jquery.loadTemplate.d.ts" />
/// <reference path="libs/FastClick.d.ts" />
/// <reference path="binder.ts"/>
/// <reference path="RequestBinder.ts" />
/********************************************** file : app.ts ***********************************************/

declare var jvm;
// je ne souhaite pas d'interpolation de scale-color sur les fonctions d'evaluation pas seuil
jvm.NumericScale.prototype.getValue= function(value) {
    var lengthes = [],
        fullLength = 0,
        l,
        i = 0,
        c;

    if (typeof this.normalize === 'function') {
      value = this.normalize(value);
        
      return this.vectorToNum(this.scale[value])
    }
    for (i = 0; i < this.scale.length-1; i++) {
      l = this.vectorLength(this.vectorSubtract(this.scale[i+1], this.scale[i]));
      lengthes.push(l);
      fullLength += l;
    }

    c = (this.maxValue - this.minValue) / fullLength;
    for (i=0; i<lengthes.length; i++) {
      lengthes[i] *= c;
    }

    i = 0;
    value -= this.minValue;
    while (value - lengthes[i] >= 0) {
      value -= lengthes[i];
      i++;
    }

    if (i == this.scale.length - 1) {
      value = this.vectorToNum(this.scale[i])
    } else {
      value = (
        this.vectorToNum(
          this.vectorAdd(this.scale[i],
            this.vectorMult(
              this.vectorSubtract(this.scale[i+1], this.scale[i]),
              (value) / (lengthes[i])
            )
          )
        )
      );
    }

    return value;
  };

  


var currentDate = new Date(2015,01,01);
var currentYear = currentDate.getFullYear();

// tableau de donnée stat
var rang: string; // nom de la colonne de trie par rang
//var maxValue: number;
//var minValue: number;
// min max par column
var minMax: Array<{ min: number; max: number; color: string }> = [];

var tableData: any[];

var dataTrads = {};
/**
{
            pays_id : number,
            name : string,
            pays_lat : number,
            pays_lng : number
latLng : []
        };
    */
var dataMapNames = {};

var activeAjaxCount = 0;
var lg = getParam("lang") ? getParam("lang") : "fr";
var requestBinder: RequestBinder;
$("#script_template_container").hide();
$(document).ajaxStart(function() {
    activeAjaxCount++;
    $("#loading").show();

});
$(document).ajaxStop(function() {
    setTimeout(function() {
        activeAjaxCount--;
        $("#loading").fadeOut(100);
        $("#script_template_container").fadeIn(100).resize();

        var tabSelected = $("#tabs_migration ul li.ui-state-active");
        TweenMax.to("#tabs_cursor", 0, { opacity: 1, "left": getCursorPos(tabSelected) });
    }, 200);


});






$(document).ready(function() {
    console.log("lang :  ", lg);

    $('img').on('dragstart', function(event) { event.preventDefault(); });



    requestBinder = new RequestBinder(function(b) {



        //On commence par récupérer toutes les trads associés à la population
        //et on les stoques dans un tableau.
        requestBinder.getPopTrads(onPropTrad);

    });

});


function onPropTrad(data) {

    dataTrads["fr"] = {};
    dataTrads["en"] = {};
    dataTrads["es"] = {};
    for (var p in data) {
        //Version lg => identifiant => trad.
        dataTrads["fr"][data[p].trad_id] = data[p].trad_fr;
        dataTrads["en"][data[p].trad_id] = data[p].trad_en;
        dataTrads["es"][data[p].trad_id] = data[p].trad_es;
    }
    //Avant toute chose, on load le template avec les trads adaptées à la langue.
    $("#script_template_container").loadTemplate("#template", dataTrads[lg]);
    console.log(dataTrads[lg]);

    
    //Affichage des zones.
    requestBinder.getPaysMonde(lg, parseData_getPaysMonde);

    updateJqTools();

}
function updateJqTools() {


    var b_pays = $('#').customSelect({
        customClass: "listSelect", // Specify a different class name (default is 'customSelect')
    });
    var b_classement = $('#b_classement').customSelect({
        customClass: "listSelect", // Specify a different class name (default is 'customSelect')
    });

    $("#scrollTab").mCustomScrollbar({ theme: "rounded-dark" });
    FastClick.attach(document.body);
    $(".tableau_pays").hide();

    $("#b_fiche").on("click", function() {

        if ($("#b_fiche").hasClass("selected")) {
            $(".tableau_pays").hide();
            $("#b_fiche").removeClass("selected");
        } else {
            $(".tableau_pays").show();
            $("#b_fiche").addClass("selected");
        }
    });


    $("#fermer_detail").on("click", function() {
        $(".tableau_pays").hide();
        $("#b_fiche").removeClass("selected");
    });

    $(".contenu_savoirplus").hide();
    $("#b_savoirPlus").on("click", function() {

        if ($("#b_savoirPlus").hasClass("selected")) {
            $(".contenu_savoirplus").hide();
            $("#b_savoirPlus").removeClass("selected");
        } else {
            //$(".contenu_savoirplus").show();
            $("#b_savoirPlus").addClass("selected");
            $(".contenu_savoirplus").show();
            $(".contenu_savoirplus").scrollTop();
            $('html, body').animate({
                scrollTop: $("#b_savoirPlus").offset().top
            }, 2000);
        }

    });


    $("#fermer_plus").on("click", function() {
        $(".contenu_savoirplus").hide();
        $("#b_savoirPlus").removeClass("selected");
    });


    $("#b_pays").on("change", function() {
        var valueSelected = $(this).val();
        //updateZoneList(valueSelected);

        updateSelectedCountry();
    });
    
    $("#b_classement").on("change", function() {
        updateSelectedClassement();

    });

    $(".map_button").on("click", function(e) {
        var clickedindic = $(this);
        var zone = clickedindic.attr('data-zone');
        updateSelectedindicateur(zone);
    });
    $(".map_button").hover(function() {
        var $elt = $(this); // cibler l'élément
        var $ma_bulle = $elt.find('.infobulle'); // cibler la div .ma-bulle
        $ma_bulle.fadeIn(); // un fade pour faire apparaître la div .ma-bulle
    },function(){
        var $elt = $(this);
        var $ma_bulle = $elt.find('.infobulle');
        $ma_bulle.css("display","none");
    });
    
    
    genTabs();

    //Au redimensionnement de la fenêtre.
    $(window).resize(function() {
        var tabSelected = $("#tabs_migration ul li.ui-state-active");
        TweenMax.to("#tabs_cursor", 0, { opacity: 1, "left": getCursorPos(tabSelected) });
    });

    $("#zoom_plus").on("click", function() {
        worldMap.setScale(worldMap.scale * worldMap.params.zoomStep, worldMap.width / 2, worldMap.height / 2);

    });
    $("#zoom_moins").on("click", function() {
        worldMap.setScale(worldMap.scale / worldMap.params.zoomStep, worldMap.width / 2, worldMap.height / 2);
    });
    $("#zoom_reset").on("click", function() {
        worldMap.setScale(worldMap.baseScale, worldMap.baseTransX, worldMap.baseTransY);
        // worldMap.reset();
    });
}

function updateSelectedindicateur(zone) {
    resetMap()
        //On sélectionne le bouton associé à la zone et on change son style.
        $('.map_button').attr('aria-pressed', 'false');
    $('.map_button[data-zone="' + zone + '"]').attr('aria-pressed', 'true');

    TweenMax.to('.map_button', 0.5, { backgroundColor: "#FFFFFF", color: "#222E3B", fontWeight: "normal" });
    TweenMax.to('.map_button[data-zone="' + zone + '"]', 0.5, { backgroundColor: "#222E3B", color: "#FFFFFF", fontWeight: "bold" });


    switch (zone) {
        case 'stocks_immigrants_effectif':
            requestBinder.get_stocks_immigrants_effectif(currentYear, (data: any) => {
                parseData_get_stats(data,
                    {
                        series:
                        {

                            markers: [
                                {
                                    attribute: 'r',
                                    column: 'immigration_nombre',
                                    suffix:'m',
                                    scale: [5, 100],
                                    normalizeFunction: 'linear',
                                    titre: 'migration_indice2_i_1Addon',
                                    color : '#006674',
                                    unit: "migration_milliers",
                                    min: 0,
                                    //max : 1400000
                                }
                            ]
                        },
                        legendeValues : [200,900,4000],
                        legendeTitre : ['migration_indice2_i_1Addon'],
                        rang: 'immigration_nombre',
                        markers_initial_fill: '#006674',
                    }
                    )
            });
            break;
        case 'stocks_immigrants_proportion':
            requestBinder.get_stocks_immigrants_proportion(currentYear, (data: any) => {
                parseData_get_stats(data,
                    {
                        series:
                        {

                            regions: [
                                {
                                    attribute: 'fill',
                                   // scale: ['#F1F9FE', '#C8DBF2', '#A8C8EA', '#99AAD7', '#9C88BF', '#9A61A4', '#861773'],
                                    scale: ['#EBF7C9', '#DDF240', '#A9DE74', '#7BCDA2', '#57B198', '#39978C', '#006674'],
                                    column: 'immigration_proportion',
                                    normalizeFunction: (val:number)=>{ return mapNormaliseSeuil([1,2,5,10,20,50],val)},
                                    titre: 'stocks_immigrants_proportion',
                                    color : '#006674',
                                    unit: "migration_milliers",
                                    min:0,
                                    max:100
                                }
                            ]
                        },
                        legendeValues : [0.9,1.9,4.9,9.9,19.9,49.9,50.1],
                        legendeTitre : ['stocks_immigrants_proportion'],
                        rang: 'immigration_proportion',
                    }
                    )
            });
            break;
        case 'stocks_immigrants_effectifAndPopulation':
            requestBinder.get_stocks_immigrants_effectifAndPopulation(currentYear, (data: any) => {
                parseData_get_stats(data,
                    {
                        series:
                        {
                            markers: [
                               
                                {
                                    attribute: 'r',
                                    column: 'immigration_nombre',
                                    scale: [5, 100],
                                    normalizeFunction: 'linear',
                                    titre: 'migration_indice2_i_1Addon',
                                    color : '#E2A338',
                                    unit: "migration_milliers",
                                    min: 0,
                                    max : 1400000,
                                    suffix : 'mig'
                                },
                                 {
                                    attribute: 'r',
                                    column: 'carte_population_total',
                                    scale: [5, 100],
                                    normalizeFunction: 'linear',
                                    titre: 'migration_indice2_i_2Addon',
                                    color : '#006674',
                                    unit: "migration_milliers",
                                    min: 0,
                                    max : 1400000,
                                    suffix :'pop'

                                },
                            ]
                        },
                        legendeValues : [6000,20000,130000],
                        legendeTitre : ['migration_indice2_i_1Addon','migration_indice2_i_2Addon'],
                        rang: 'carte_population_total',
                        markers_initial_fill: '#006674',
                    }
                    )
            });
            break;
        case 'flux_migratoryGrowth_effectif': //migration_indice16_c_2Addon
            requestBinder.get_flux_migratoryGrowth_effectif(currentYear, (data: any) => {
                parseData_get_stats(data,
                    {
                        series:
                        {

                            markers: [
                                {
                                    attribute: 'r',
                                    scale: [4, 50],

                                    column: 'carte_population_migrants_abs',
                                    normalizeFunction: 'linear',
                                    suffix:'m',
                                    
                                   
                                },
                                {
                                    attribute: 'fill',
                                    scale: [ '#FF7731','#5F6496'],
                                    column: 'carte_population_migrants',
                                    normalizeFunction: (val:number)=>{ return mapNormaliseSeuil([0],val)},
                                    titre: ['migration_indice16_c_2Addon'],
                                    unit: "migration_milliers",
                                    color : '#5F6496',
                                    suffix:'m',
                                   
                                },
                               
                            ]
                        },
                        legendeValues : [-100,-10,10,100],
                        legendeTitre : ['migration_indice16_c_2Addon'],
                        rang: 'carte_population_migrants',
                    }
                    )
            });
            break;
        case 'flux_migratoryGrowth_taux':
            requestBinder.get_flux_migratoryGrowth_taux(currentYear, (data: any) => {
                parseData_get_stats(data,
                    {
                        series:
                        {

                            regions: [
                                {
                                    attribute: 'fill',
//                                    scale: ['#d3584a','#f89f75','#ffdfa4','#f6f6f6','#d4daef','#9a9dce','#6a509a'],
                                    scale: ['#E9362D','#E2A338','#DDF240','#f6f6f6','#99C1C6','#287480','#1F3D4F'],
                                    column: 'carte_population_migration_rate',
                                    normalizeFunction: (val:number)=>{ return mapNormaliseSeuil([-4,-1,0,1,2,4],val)},
                                    titre: 'migration_indice17_c_2Addon',
                                    unit: "migration_milliers",
                                   color : '#1F3D4F',
                                }
                            ]
                        },
                        legendeValues : [-4.1,-1.1,-0.1,0.9,1.9,3.9,4.1],
                        legendeTitre : ['migration_indice17_c_2Addon'],
                        rang: 'carte_population_migration_rate',
                        
                    }
                    )
            });
            break;
        case 'flux_totalIncrease_effectif': 
            requestBinder.get_flux_totalIncrease_effectif(currentYear, (data: any) => {
                parseData_get_stats(data,
                    {
                        series:
                        {

                             markers: [
                              {
                                    attribute: 'r',
                                    scale: [4, 25],

                                    column: 'carte_population_change_abs',
                                    normalizeFunction: 'linear',
                                    suffix:'p',
                                    
                                   
                                },
                                {
                                    attribute: 'fill',
//                                    scale: [ '#CC00FF','#336666'],
                                    scale: [ '#FF7731','#5F6496'],
                                    column: 'carte_population_change',
                                    normalizeFunction: (val:number)=>{ return mapNormaliseSeuil([0],val)},
                                    titre: 'migration_indice16_c_1Addon',
                                    unit: "migration_milliers",
                                     color : '#FF7731',
                                    min:0,
                                    suffix:'p',
                                   
                                },
                                {
                                    attribute: 'r',
                                    scale: [4, 25],

                                    column: 'carte_population_migrants_abs',
                                    normalizeFunction: 'linear',
                                    suffix:'m',
                                    
                                   
                                },
                                {
                                    attribute: 'fill',
                                    scale:  [ '#FF7731','#5F6496'],
                                    column: 'carte_population_migrants',
                                    normalizeFunction: (val:number)=>{ return mapNormaliseSeuil([0],val)},
                                    titre: 'migration_indice16_c_2Addon',
                                      color : '#336666',
                                    unit: "migration_milliers",
                                    min:0,
                                    suffix:'m',
                                   
                                },
                               
                            ]
                        },
                        legendeValues : [-2000,-100,100,2000],
                        legendeTitre : ['migration_indice16_c_1Addon','migration_indice16_c_2Addon'],
                        rang: 'carte_population_change',
                    }
                    )
            });
            break;
        case 'flux_totalIncrease_taux':
            requestBinder.get_flux_totalIncrease_taux(currentYear, (data: any) => {
                parseData_get_stats(data,
                    {
                        series:
                        {
                            regions: [
                                {
                                    attribute: 'fill',
                                    column: 'carte_population_change_rate',
                                    scale: ['#E2A338','#DDF240','#F6F6F6','#3C8993','#287480','#0D5866','#1F3D4F'],
                                    normalizeFunction: (val:number)=>{ return mapNormaliseSeuil([0,5,10,15,20,25],val)},
                                     color : '#006674',
                                    titre: 'migration_indice17_c_1Addon',
                                    unit: "duree_titre_en_pourcent",
                                   
                                },
                                {
                                    attribute: 'none',
                                    scale: [0,10],
                                    column: 'carte_population_migration_rate',
                                     color : '#E2A338',
                                    normalizeFunction: (val:number)=>{ return 0},
                                    titre: 'migration_indice17_c_2Addon',
                                    unit: "migration_milliers",
                                   
                                }
                             
                            ],
                          

                        },
                        legendeValues : [-0.1,4.9,9.9,14.9,19.9,24.9,25.1],
                        legendeTitre : ['migration_indice17_c_1Addon'],
                        rang: 'carte_population_change_rate',
                    }
                    )
            });
            break;
        case 'population_effectif':
            requestBinder.get_population_effectif(currentYear, (data: any) => {
                parseData_get_stats(data,
                    {
                        series:
                        {

                            markers: [
                                {
                                    attribute: 'r',
                                    column: 'carte_population_total',
                                    suffix:'m',
                                    scale: [5, 100],
                                    normalizeFunction: 'linear',
                                    titre: 'migration_indice2_i_2Addon',
                                    color : '#006674',
                                    unit: "migration_milliers",
                                    min: 0,
                                    //max : 1400000
                                }
                            ]
                        },
                        legendeValues : [6000,30000,160000],
                        legendeTitre : ['migration_indice2_i_2Addon'],
                        rang: 'carte_population_total',
                         markers_initial_fill: '#006674',
                    }
                  
                    )
            });

            break;

        default:
            genVide();
    }
}
function updateSelectedCountry() {


    updateOptionSelectedAria($("#b_pays"));
    var optionSelected = $("#b_pays").find('option:selected');

    $('.place_selected_country').html(optionSelected.html());

    requestBinder.getPaysFile(currentYear, optionSelected.val(), parseData_getPaysFile);
    if (optionSelected.attr("data-zone") == "") {
        worldMap.clearSelectedRegions();
    } else {
        worldMap.clearSelectedRegions();
        try {
            worldMap.setSelectedRegions(optionSelected.attr("data-zone"));
        } catch (e) {
            console.log("setSelectedRegions not in map code :" + optionSelected.attr("data-zone"));
        }
        //worldMap.setFocus(optionSelected.attr("data-zone"),0.5,0.5);
    }
    $('#scrollTab tr').attr('aria-pressed', 'false');
    $('#scrollTab tr').removeClass("tabselect");
    $('#id_' + optionSelected.val()).attr('aria-pressed', 'true');
    $("#scrollTab").mCustomScrollbar("scrollTo", "#id_" + optionSelected.val());
    $('#id_' + optionSelected.val()).addClass("tabselect");
}

function updateSelectedClassement() {
    updateOptionSelectedAria($("#b_classement"));

    updateTableSort();
}


function updateOptionSelectedAria(element) {
    $(element).find('option').attr('aria-selected', "false");
    var optionSelected = $(element).find('option:selected');
    $(optionSelected).attr('aria-selected', "true");
}



/**
 * 
 * data :
carte_population_change: 81334.548
carte_population_change_rate: 11.23
carte_population_migrants: 212.918
carte_population_migration_rate: 0.03
carte_population_natural_increase: 11.2
carte_population_total: 7243784.121
carte_population_total_natural_change: 81121.63
fk_pays_id: 900
immigration_nombre: 231522215
immigration_proportion: 3.2
 */
function parseData_getPaysFile(data) {
    for (var p in data) {

        var carte_population_change: number = data[p].carte_population_change;
        var carte_population_change_rate: number = data[p].carte_population_change_rate;
        var carte_population_migrants: number = data[p].carte_population_migrants;
        var carte_population_migration_rate: number = data[p].carte_population_migration_rate;
        var carte_population_natural_increase: number = data[p].carte_population_natural_increase;
        var carte_population_total: number = data[p].carte_population_total;
        var carte_population_total_natural_change: number = data[p].carte_population_total_natural_change;
        var fk_pays_id: number = data[p].fk_pays_id;
        var immigration_nombre: number = data[p].immigration_nombre / 1000;
        var immigration_proportion: number = data[p].immigration_proportion;

        $("#carte_population_change").html(formatNb(carte_population_change.toFixed(1)));
        $("#carte_population_change_rate").html(formatNb(carte_population_change_rate.toFixed(1)));
        $("#carte_population_migrants").html(formatNb(carte_population_migrants.toFixed(1)));
        $("#carte_population_migration_rate").html(formatNb(carte_population_migration_rate.toFixed(1)));
        $("#carte_population_natural_increase").html(formatNb(carte_population_natural_increase.toFixed(1)));
        $("#carte_population_total").html(formatNb(carte_population_total.toFixed(1)));
        $("#carte_population_total_natural_change").html(formatNb(carte_population_total_natural_change.toFixed(1)));
        $("#immigration_nombre").html(formatNb(immigration_nombre.toFixed(1)));
        $("#immigration_proportion").html(formatNb(immigration_proportion.toFixed(1)));

    }

}

function parseData_getPaysMonde(data) {
    $("select#b_pays").html(""); //On vide la liste des pays.
    for (var p in data) {

        var pays_id = data[p].pays_id;
        var pays_titre = data[p]['pays_nom_' + lg];
        var pays_titre_nice = niceName(pays_titre);
        var pays_titre_zone = niceName(data[p].pays_nom_fr);
        var pressed = (p == 0) ? true : false;
        //On rempli le select des pays (zones).
        $("select#b_pays").append('<option role="option" aria-selected="' + pressed + '" data-zone="' + data[p].pays_iso2 + '" value="' + pays_id + '">' + pays_titre.toUpperCase() + '</option>');
        dataMapNames[data[p].pays_iso2] = {
            pays_id: pays_id,
            name: pays_titre,
            pays_lat: data[p].pays_lat,
            pays_lng: data[p].pays_lng,
            latLng: [data[p].pays_lat, data[p].pays_lng]
        };
    }
    genVide();

    worldMap.resize();
    var b_pays = $('#b_pays').customSelect({
        customClass: "listSelect", // Specify a different class name (default is 'customSelect')
    });
    $("#b_pays").val("900").select();
    updateSelectedCountry();
    updateSelectedindicateur('stocks_immigrants_effectif');


}


/**********************************************************************/
// Gestion de la carte
/**********************************************************************/

var worldMap: WorldMap;

var regionStyle = {
    initial: {
        fill: '#FFFFFF',
        "fill-opacity": 1,
        stroke: '#222e3b',
        "stroke-width": 1,
        "stroke-opacity": 1
    },
    hover: {
        "fill-opacity": 0.8
    },
    selected: {
        stroke: 'red',
        "stroke-width": 2,
        "fill-opacity": 1
    },
    selectedHover: {
    }

};
var markerStyle = {
    initial: {
        r:'10',
        fill: '#64B0D2',
        "fill-opacity": 0.6,
        stroke: 'lightgrey',
        "stroke-width": 1,
        "stroke-opacity": 1
    },
    hover: {
        "fill-opacity": 0.8,
        "stroke-opacity": 0.8,
    },
};
function resetMap() {
    /*  gestion des selecteurs
        $('header button.active').removeClass('active');
        $(obj).addClass('active');
      */
    var map = $('#world-map');
    map.html('');

}

function genVide() {
    //gdpData = window.datas;
    //  resetMap();
    $('#world-map').vectorMap({
        map: 'world_mill_en',
        regionsSelectable: false,
        regionsSelectableOne: false,
        backgroundColor: '#ffffff',
        regionStyle: regionStyle,

        onRegionClick: function(e: Event, code: string) {
            var mapName = dataMapNames[code];

            if (mapName) {

                $("#b_pays").val(mapName.pays_id).select();
                $('#b_pays').trigger('change');

            } else {
                e.preventDefault();
                return false;
            }
        },
        onRegionLabelShow: function(e, el, code) {
            var mapName = dataMapNames[code];
            if (mapName) {
                el.html(' <div class="nom_pays">' + mapName.name + '</div>');

                // el.parent().show();
            } else {
                e.preventDefault();
                return false;
            }
        },
    });

    worldMap = $('#world-map').vectorMap('get', 'mapObject');
    updateSelectedCountry();
    updateTabView()
}


function mapNormaliseSeuil(seuils:number[],val:number):number{
     if (typeof val === 'undefined') return val;
   var i = 0;
    for (i=0;i<seuils.length;i++) {
        if ( val < seuils[i] ) {
            console.log('mapNormaliseSeuil '+val+'->'+i);
            return i;
        }
    }
    console.log('mapNormaliseSeuil '+val+'->'+i);
    return i;
}


function mapNormaliseAbsolute(val:number):number{
     if (typeof val === 'undefined') return val;
         console.log('mapNormaliseAbsolute '+val+'->'+Math.abs(val));
     return Math.abs(val);
 
}



function parseData_get_stats(data, dataDef) {
// reinit default
     regionStyle = {
    initial: {
        fill: '#FFFFFF',
        "fill-opacity": 1,
        stroke: '#222e3b',
        "stroke-width": 0.5,
        "stroke-opacity": 1
    },
    hover: {
        "fill-opacity": 0.8
    },
    selected: {
        stroke: 'red',
        "stroke-width": 2,
        "fill-opacity": 1
    },
    selectedHover: {
    }

};
  markerStyle = {
    initial: {
        r:'10',
        fill: '#64B0D2',
        "fill-opacity": 0.6,
        stroke: '#222e3b00',
        "stroke-width": 1,
        "stroke-opacity": 1
    },
    hover: {
        "fill-opacity": 0.8,
        "stroke-opacity": 0.8,
    },
};
    
    
    
    var series = dataDef.series;
    rang = dataDef.rang;
    if (series.regions) {
        for (var ir in series.regions) {
            series.regions[ir].values = []
        }
    }
    if (series.markers) {
        for (var im in series.markers) {
            series.markers[im].values = []
        }
        
    }
    if (dataDef.markers_initial_fill) {
                markerStyle.initial.fill = dataDef.markers_initial_fill;
                markerStyle.initial.stroke = dataDef.markers_initial_fill;
    }
   
    //var serieData = [];
    var markerData: Array<{
        latLng: number[];
        name: string;
        code: string;
        values: number[];
        id: number
    }> = [];

    var markers;
    if (series.markers) {
        markers = {};
    }


    var codeToId = [];
    //var regionData = [];
    // var txtlabel = "population_effectif";
    for (var p in data) {
        
        var values = [];
        codeToId[data[p].pays_iso2] = p;
        if (series.regions) {
            for (var ir in series.regions) {
                series.regions[ir].values[data[p].pays_iso2] = data[p][series.regions[ir].column];
                values[series.regions[ir].column] = data[p][series.regions[ir].column];
            }
        }

        if (series.markers) {
            for (var im in series.markers) {
                
                series.markers[im].values[data[p].pays_iso2+'_'+series.markers[im].suffix] = data[p][series.markers[im].column];
                values[series.markers[im].column] = data[p][series.markers[im].column];
                codeToId[data[p].pays_iso2+'_'+series.markers[im].suffix] = p;
                markers[data[p].pays_iso2+'_'+series.markers[im].suffix] = {
                    latLng: dataMapNames[data[p].pays_iso2].latLng,
                    name: dataMapNames[data[p].pays_iso2].name,
                    code: data[p].pays_iso2,
                    id: data[p].pays_id,
                }
            }
        }


        markerData.push({
            latLng: dataMapNames[data[p].pays_iso2].latLng,
            name: dataMapNames[data[p].pays_iso2].name,
            code: data[p].pays_iso2,
            values: values,
            id: data[p].pays_id,
        });
    }

    // generation de la map
    $('#world-map').vectorMap({

        map: 'world_mill_en',
        regionsSelectable: true,
        regionsSelectableOne: true,
        backgroundColor: '#ffffff',
        regionStyle: regionStyle,
        markerStyle: markerStyle,
        onRegionClick: function(e: Event, code: string) {
            var mapName = dataMapNames[code];
            if (mapName) {

                $("#b_pays").val(mapName.pays_id).select();
                $('#b_pays').trigger('change');

            } else {
                e.preventDefault();
                return false;
            }
        },
        onRegionLabelShow: function(e, el, code) {
            var index = codeToId[code];
            var mapName = dataMapNames[code];
            if (mapName) {
                el.html(' <div class="nom_pays">' + mapName.name + '</div>');
                var txt: string = ' <div class="nom_pays">' + markerData[index].name + '</div>';
                if (series.regions) {
                    for (var ir in series.regions) {
                        txt += '<div class="zone_titre">' + dataTrads[lg][series.regions[ir].titre] + '</div>';
                        txt += '<div class="valeur ">' + formatNb(markerData[index].values[series.regions[ir].column].toFixed(1)) + '</div>';
                    }
                }

                if (series.markers) {
                    for (var im in series.markers) {
                        //             series.markers[im].scale.maxValue
                        if (typeof series.markers[im].titre !== 'undefined') { 
                        txt += '<div class="zone_titre">' + dataTrads[lg][series.markers[im].titre] + '</div>';
                        txt += '<div class="valeurDefaultColor">' + formatNb(markerData[index].values[series.markers[im].column].toFixed(1)) + '</div>';
                        }

                    }
                }

                el.html(txt);
            } else {
                e.preventDefault();
                return false;
            }
        },
        onMarkerLabelShow: function(event, label, code) {
            var index = codeToId[code];
            var txt: string = ' <div class="nom_pays">' + markerData[index].name + '</div>';
            
            if (series.regions) {
                for (var ir in series.regions) {
                    txt += '<div class="zone_titre">' + dataTrads[lg][series.regions[ir].titre] + '</div>';
                    txt += '<div class="valeurDefaultColor"  >' + formatNb(markerData[index].values[series.regions[ir].column].toFixed(1)) + '</div>';
                }
            }

            if (series.markers) {
                for (var im in series.markers) {
                    if (typeof series.markers[im].titre !== 'undefined') { 
                    txt += '<div class="zone_titre">' + dataTrads[lg][series.markers[im].titre] + '</div>';
                    var color = 'blue';
                    if (series.markers[im].attribute == 'r') {
                        color = markerStyle.initial.fill;
                    } else {
                        color = markerStyle.initial.stroke;
                    }
                    
                    txt += '<div style="color:' + color + '">' + formatNb(markerData[index].values[series.markers[im].column].toFixed(1)) + '</div>';
                    }
                }
            }

            label.html(txt);

        },
        onMarkerClick: function(e, index) {
            var _index = index.split("_")[0];
            var code = _index//markerData[_index].code;
            var mapName = dataMapNames[code];
            if (mapName) {

                $("#b_pays").val(mapName.pays_id).select();
                $('#b_pays').trigger('change');

            } else {
                e.preventDefault();
                return false;
            }


        },
        series: series,



        markers: markers,
    });
    
     $('#world-map circle').sort(function (a, b) {

      var contentA =parseInt( $(a).attr('r'));
      var contentB =parseInt( $(b).attr('r'));
      return (contentA > contentB) ? -1 : (contentA < contentB) ? 1 : 0;
   }).appendTo($('#world-map g')[1]);
    worldMap = $('#world-map').vectorMap('get', 'mapObject');

    // update legende / titre de map et tableau


    $('.monde_legende').html('');

    
    var titre_global: string = "";
    var svg_type : string;
    var svg_scale;
   
    //titre_global += "<div>" + dataTrads[lg][dataDef.legendetitre] + "</div>";
    for (var iTitre in dataDef.legendeTitre) {
        titre_global +="<div>" + dataTrads[lg][dataDef.legendeTitre[iTitre]] + "</div>";
    }
   
    $('.monde_legende').append(addLegend(dataDef.legendeValues,titre_global/*"<div>" + dataTrads[lg][dataDef.legendeTitre[0]] + "</div>"*/,worldMap.series));
    
    
    titre_global += "<div>" + currentYear + "</div>";
    $('.place_titre').html(titre_global);
    
    // update table data
    //var color;
     titre_global = "";
     minMax = [];
    if (series.regions) {
        for (var ir in series.regions) {
            if (series.regions[ir].titre) {
        //        color = worldMap.series.regions[ir].scale.getValue(worldMap.series.regions[ir].scale.maxValue);
                minMax[series.regions[ir].column] = { min: worldMap.series.regions[ir].params.min, max: worldMap.series.regions[ir].params.max, color: worldMap.series.regions[ir].params.color };
                titre_global += "<div style='color:"+ minMax[series.regions[ir].column].color+"'>" + dataTrads[lg][series.regions[ir].titre] + "</div>";//+" ("+dataTrads[lg][series.regions[ir].unit]+")</div>";
            }
        }
    }

    if (series.markers) {

        for (var im in series.markers) {
            if (series.markers[im].titre) {
            /*
                if (series.markers[im].attribute == 'r') {
                    color = markerStyle.initial.fill;
                } else {
                    color = markerStyle.initial.stroke;
                }*/
                minMax[series.markers[im].column] = { min: worldMap.series.markers[im].params.min, max: worldMap.series.markers[im].params.max, color: worldMap.series.markers[im].params.color };
                titre_global += "<div style='color:"+ minMax[series.markers[im].column].color+"'>" + dataTrads[lg][series.markers[im].titre] + "</div>";//+" ("+dataTrads[lg][series.markers[im].unit]+")</div>";
            }
        }
    }
    
    titre_global += "<div>" + currentYear + "</div>";
    $('.place_titre_table').html(titre_global);
   
    tableData = markerData.concat();
    tableData = tableData.sort((n1, n2) => {
        if (n1.values[rang] < n2.values[rang]) {
            return 1;
        }

        if (n1.values[rang] > n2.values[rang]) {
            return -1;
        }

        return 0;
    });
    var i = 1;

    for (var p in tableData) {
        tableData[p].rang = i;
        i++;
    }

    updateTableSort();
    updateTabView()
    

}
function addLegend(legendeValues : number[],titre : string,series : any): HTMLDivElement {
     var svg_type : string;
     var svg_scale ; 
     var shape: any;
    
     var legendDom = document.createElement("div");
     legendDom.setAttribute("class", "type_legende");
     legendDom.innerHTML = '<div class="legende_titre"><span >' + titre + '</span></div>';
     
     var prevVal : number = NaN;
     for ( var leg_val in legendeValues) {
        var val : number = legendeValues[leg_val];
        if (series.regions.length>0) {
            svg_type = "rect";
            shape = createRectShape(regionStyle.initial);
            for (var ir in series.regions) {
                svg_scale = worldMap.series.regions[ir].scale.getValue(val);
                shape.setAttribute(worldMap.series.regions[ir].params.attribute, svg_scale);
                console.log("svg_scale "+worldMap.series.regions[ir].params.attribute+":"+svg_scale);
            }
        }
        if (series.markers.length>0) {
            svg_type = "circle";
            shape = createCircleShape(markerStyle.initial);
            for (var ir in series.markers) {
            
                if (worldMap.series.markers[ir].params.column.lastIndexOf("_abs")>0) {
                    svg_scale = worldMap.series.markers[ir].scale.getValue(Math.abs(val));
                } else {
                    svg_scale = worldMap.series.markers[ir].scale.getValue(val);
                }
                console.log("svg_scale "+worldMap.series.markers[ir].params.attribute+":"+svg_scale);
                shape.setAttribute(worldMap.series.markers[ir].params.attribute, svg_scale);
            }
        }
        
        var itemLegend = document.createElement("div");
        itemLegend.setAttribute("class", "liste_legende");

        var itemIco = document.createElement("div");
        itemIco.setAttribute("class", "legende_ico");


        var svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
        svg.setAttributeNS(null, "width", "50");
        svg.setAttributeNS(null, "height", "50");
        svg.appendChild(shape);
        itemIco.appendChild(svg);

        var itemRef = document.createElement("div");
        itemRef.setAttribute("class", "legende_reference");
        var valRound =  Math.round(val);
        if (valRound>val) {
            if (isNaN(prevVal)) {
                itemRef.innerHTML = dataTrads[lg]['migration_lessThan']+" "+formatNb(valRound);
            } else {
                itemRef.innerHTML = formatNb(prevVal)+" "+dataTrads[lg]['migration_a']+" "+formatNb(valRound);
            }
        } else if  (valRound<val) {
            itemRef.innerHTML = formatNb(valRound) +" "+dataTrads[lg]['migration_orMore'];
        } else {
            itemRef.innerHTML = formatNb(valRound);
        }
        

        itemLegend.appendChild(itemIco);
        itemLegend.appendChild(itemRef);

        legendDom.appendChild(itemLegend);
        prevVal = valRound;
        
    }
    
    return legendDom;
}

function createRectShape (style_initial : any){
 var shape : any = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            shape.x.baseVal.value = 12;
            shape.y.baseVal.value = 12;
            shape.width.baseVal.value = 25;
            shape.height.baseVal.value = 25;
            shape.rx.baseVal.value = 5;
            shape.ry.baseVal.value = 5;
    for (var e in style_initial) {
                shape.setAttribute(e, style_initial[e]);
    }
    return shape;
}

function createCircleShape (style_initial : any){
 var shape : any = document.createElementNS("http://www.w3.org/2000/svg", "circle");
            shape.cx.baseVal.value = 25;
            shape.cy.baseVal.value = 25;
            shape.r.baseVal.value = 10;
    for (var e in style_initial) {
                shape.setAttribute(e, style_initial[e]);
    }
    return shape;
}

function addLegendFor(txtlabel, marker, style, type: string = 'circle'): HTMLDivElement {
    var legendDom = document.createElement("div");
    //target.append(legendDom);
    legendDom.setAttribute("class", "type_legende");
    // legender une serie
    marker.scale.minValue;
    marker.scale.maxValue;
    
    var steps = Math.max(2,marker.scale.scale.length-1);
    var step = (marker.scale.maxValue - marker.scale.minValue) / steps;
    //roundSup(step);
    legendDom.innerHTML = '<div class="legende_titre"><span >' + txtlabel + '</span></div>';
    for (var i = 0; i <= steps; i++) {

        var val = marker.scale.minValue + step * i;
        var color = marker.scale.getValue(val);

        var shape: any;
        if (type == 'circle') {
            shape = document.createElementNS("http://www.w3.org/2000/svg", "circle");
            shape.cx.baseVal.value = 25;
            shape.cy.baseVal.value = 25;
            shape.r.baseVal.value = 10;
            //shape.setAttribute("fill", "green");
            for (var e in style.initial) {
                shape.setAttribute(e, style.initial[e]);
            }
            shape.setAttribute(marker.params.attribute, color);
        } else {
            shape = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            shape.x.baseVal.value = 12;
            shape.y.baseVal.value = 12;
            shape.width.baseVal.value = 25;
            shape.height.baseVal.value = 25;
            shape.rx.baseVal.value = 5;
            shape.ry.baseVal.value = 5;
            //shape.setAttribute("fill", "green");
            for (var e in style.initial) {
                shape.setAttribute(e, style.initial[e]);
            }
            shape.setAttribute(marker.params.attribute, color);
        }

        var itemLegend = document.createElement("div");
        itemLegend.setAttribute("class", "liste_legende");

        var itemIco = document.createElement("div");
        itemIco.setAttribute("class", "legende_ico");


        var svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
        svg.setAttributeNS(null, "width", "50");
        svg.setAttributeNS(null, "height", "50");
        svg.appendChild(shape);
        itemIco.appendChild(svg);

        var itemRef = document.createElement("div");
        itemRef.setAttribute("class", "legende_reference");
        itemRef.innerHTML = formatNb(val.toFixed(0));

        itemLegend.appendChild(itemIco);
        itemLegend.appendChild(itemRef);

        legendDom.appendChild(itemLegend);
        /*
         $('.monde_legende').append('<div style="background-color:' + color + ';"><svg id="svglegend_'+i+'" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="50" height="50"></svg>' + val + ' - ' + color + '</div>');
         var el = document.getElementById("svglegend_"+i);
         el.appendChild(shape);
         */

    }
    return legendDom;
}

function updateTableSort() {
    $("#scrollTab .mCSB_container").html("");
    var optionSelected = $("#b_classement").find('option:selected');
    var val = optionSelected.val();
    switch (val) {
        case 'rang':
            _updateTableSortRang();
            break;
        case 'name':
            _updateTableSortName();
            break;
    }

    $("#scrollTab").mCustomScrollbar("update");
    updateSelectedCountry();
}

function buildTableRow(row: any): string {
    var max = 0;
    var min = 0;
    for (var icol in minMax) {
        if (min > minMax[icol].min) {
            min = minMax[icol].min;
        }
        if (max < minMax[icol].max) {
            max = minMax[icol].max;
        }
    }

    var str = "";
    str += '<tr id="id_' + row.id + '" > ';
    str += '<td class="trang">' + row.rang + '</td>';
    str += '<td class="tpays">' + row.name + '</td>';

    var arr_rows = [];


    for (var col in minMax) {
        str = "";
        str += '<td class="tgraph">';
        var left=0;
        var pc: number = row.values[col] * 100 / max;//minMax[col].max;
        if (min<0) {
            pc = pc/2;
            if (pc>=0) {
                left=50;
                pc = Math.min(pc,50);
            } else {
                left =Math.max( 50+pc,0);
                pc = Math.min(-pc,50);
                
            }
        }
        var addClass ='';
        if ( minMax[col].min >= 0) {
            addClass = ' class="leftRound"';
        }
        str += '<div style="left: '+left+'%;width:' + pc + '%; background-color:' + minMax[col].color + '" '+addClass+'></div>';
        str += '</td>';

        str += '<td class="tvaleur" style="color :' + minMax[col].color + ' ">';
        var val = formatNb(row.values[col].toFixed(1));
        str += '<div >' + val + '</div>';
        str += '</td>';
        arr_rows.push(str);
    }

    str = "";
    for (var i in arr_rows) {
        str += '<tr id="id_' + row.id + '" > ';
        if (i == 0) {
            str += '<td class="trang" rowspan="' + arr_rows.length + '">' + row.rang + '</td>';
            str += '<td class="tpays" rowspan="' + arr_rows.length + '">' + row.name + '</td>';
        }
        str += arr_rows[i];
        str += '</tr>';
    }
    str+="<tr class='void'></tr>";
    return str;
}


function _updateTableSortRang() {
    tableData = tableData.sort((n1, n2) => {
        if (n1.rang > n2.rang) {
            return 1;
        }

        if (n1.rang < n2.rang) {
            return -1;
        }

        return 0;
    });
    for (var p in tableData) {
        var id = tableData[p].id;
        var target = $("#scrollTab .mCSB_container").append(buildTableRow(tableData[p]));
        $("#id_" + id).on("click", tableData[p], (event) => onClickTableMonde(event));

    }

}


function _updateTableSortName() {
    tableData = tableData.sort((n1, n2) => {
        if (n1.name > n2.name) {
            return 1;
        }

        if (n1.name < n2.name) {
            return -1;
        }

        return 0;
    });
    for (var p in tableData) {
        var id = tableData[p].id;
        var target = $("#scrollTab .mCSB_container").append(buildTableRow(tableData[p]));
        $("#id_" + id).on("click", tableData[p], (event) => onClickTableMonde(event));
    }

}



function onClickTableMonde(e: JQueryEventObject) {

    $("#b_pays").val(e.data.id).select();
    $('#b_pays').trigger('change');
}





/*********************************************************************/
//Autres fonctions.
/*********************************************************************/
function genTabs() {

    //On commence par récupérer la liste des pages.
    $("#tabs_migration").append('<div id="tabs_cursor"></div>');

    $("#tabs_migration li").on("click", function() {
        $("#tabs_migration li").attr('aria-selected', "false");
        $("#tabs_migration li").removeClass('ui-state-active')
             $(this).attr('aria-selected', "true");
        $(this).addClass('ui-state-active');


        TweenMax.to("#tabs_cursor", 0.5, { opacity: 1, "left": getCursorPos(this) });
        updateTabView();

    });

    $("#tabs_migration ul li.ui-state-active").on("create", function() {
        TweenMax.to("#tabs_cursor", 0.5, { opacity: 1, "left": getCursorPos(this) });
    });
    //TweenMax.to("#tabs_cursor", 0.5, {opacity: 1, "left": getCursorPos( $("#tabs_migration li .ui-state-active"))});
    var tabSelected = $("#tabs_migration ul li.ui-state-active").get()[0];
    TweenMax.to("#tabs_cursor", 0, { opacity: 1, "left": getCursorPos(tabSelected) });
    updateTabView()
        //Création des onglets.
       /*
        $("#contenu").tabs({
            create: function(event, ui) {
        //        var tabSelected = $("#tabs_migration ul li.ui-state-active");
       //         TweenMax.to("#tabs_cursor", 0, {opacity: 1, "left": getCursorPos(tabSelected)});
       //         TweenMax.to(tabSelected, 1, {backgroundColor: "#1FBDC3"});
            },
            activate: function(event, ui) {
       //         var tabSelected = $(ui.newTab.context).parent('li');
      //          TweenMax.to("#tabs_cursor", 0.5, {opacity: 1, "left": getCursorPos(tabSelected)});
      //          TweenMax.to("#tabs_migration li", 0.6, {backgroundColor: "#222E3B"});
     //           TweenMax.to(tabSelected, 1, {backgroundColor: "#1FBDC3"});
                //On met à jour les stats sur toutes les pages.
    //           setPopulationStats();
    //           setGenerationStats();
    //           updatePyramid();
            }

        });
    */

    }

function updateTabView() {
    var vue = $("#tabs_migration ul li.ui-state-active").attr("aria-controls");
    if (vue == "carte") {
        $('.carte_monde').show().resize();
        $('.tableau_monde').hide();
        $('.tableau_select').hide();
        

    } else {
        $('.tableau_monde').show();
         $('.tableau_select').show();
        $('.carte_monde').hide();
    }
}

function getCursorPos(tabSelected) {
    var tabPosX = $(tabSelected).position().left;
    var tabWidth = $(tabSelected).width();
    return tabPosX + (tabWidth / 2) - 5;
}

console = <any>{ log: function() { } };
if (typeof console == "undefined" || typeof console.log == "undefined")
    console = <any>{ log: function() { } };

function getParam(param: string): string {

    //On separe la chaine des parametres en fonction du &.   
    var spath = window.location.search.split("&"), i;

    //Bouclage des parametres.
    for (i = 0; i < spath.length; ++i) {

        var hash = spath[i].split("=");
        var hash_param = hash[0].replace("?", "");
        var hash_val = hash[1];

        //On recupere le parametre de l'url si il existe.  
        if (hash_param == param) {
            return hash_val.toLowerCase();
        }
    }
}


/**
 * Transforme un nom de fichier pour qu'il soit propre.
 */
function niceName(str: string) {
    str = str.toLowerCase();
    //On remplace les caractères accentués.
    var rules = {
        a: "àáâãäå",
        e: "èéêë",
        i: "ìíîï",
        o: "òóôõöø",
        u: "ùúûü",
        y: "ÿ",
        c: "ç",
        n: "ñ"
    };
    var regstring = "";
    for (var acc in rules) {
        regstring += rules[acc];
    }

    var reg = new RegExp("[" + regstring + "]", "g");
    str = str.replace(reg, function(t) {
        for (var acc in rules) {
            if (rules[acc].indexOf(t) > -1) {
                return acc;
            }
        }
    });
    //On remplace les autres caractères spéciaux par un tiret.
    str = $.trim(str);
    str = str.replace(/([^a-z0-9_]+)/g, "-");
    str = str.replace(/-/g, "-");
    str = str.replace(/---/g, "-");
    str = str.replace(/--/g, "-");
    str = $.trim(str);
    return str;
}



/**
 * Permet de reformater les nombres avec des espaces.
 */
function formatNb(nStr: any) {
    
    nStr += '';
    var x = nStr.split('.');
    var x1 = x[0];
    var x2; 
    if (x.length > 1) {
        if (lg == "fr") {
            x2=',' + x[1];
         } else {
             x2='.' + x[1];
         }
    } else {
        x2="";
    }
    
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        if (lg == "fr") {
            x1 = x1.replace(rgx, '$1' + ' ' + '$2');
         } else {
           x1 = x1.replace(rgx, '$1' + ',' + '$2');
         }
    }
    return x1 + x2;
}


/**
 * On arrondi à la dizaine, centaine, millier, etc supérieure.
 * @param {Object} n
 */
function roundSup(n: number) {

    n = Math.ceil(n);
    var countc = n.toString().length;
    var multiple = 1;
    for (var i = 1; i < countc; i++) {
        multiple = multiple * 10;
    }

    n = n / multiple;
    n = Math.ceil(n);
    n = n * multiple;
    return n;
}