<?php

header('Content-Type: text/javascript; charset=UTF-8');

/**
 * Paramètres
 */
if (empty($_GET['query']) || empty($_GET['params'])) {
    die(json_encode('query & params nécessaires'));
}

/**
 * Connexion à la base
 */
$db = new SQLite3('database.sqlite');
if (!$db) {
    die(json_encode('Connexion BDD failed ...'));
}

/**
 * On récupère la liste des requêtes
 */
$sqls = json_decode(file_get_contents('sql.json'), true);


/**
 * On cherche la query
 */
if (empty($sqls[$_GET['query']])) {
    die(json_encode('Query inexistante : ' . $_GET['query']));
}

/**
 * On prépare la requete et les paramètres
 */
$req = $db->prepare($sqls[$_GET['query']]);

$params = json_decode($_GET['params']);

/**
 * On lie les paramètres à la requête
 */
foreach ($params as $k => $v) {
    $req->bindValue($k, $v);
}

/**
 * On met tout la requête dans un tableau
 */
$jsonRes = array();
$res = $req->execute();

while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
	
    $jsonRes[] = $row;
}

/**
 * Et on renvoi en json ... 
 */
echo json_encode($jsonRes);
