function getPaysById(id) {
    return window._pays[id];
}

function getPaysByIso(iso) {
    return window._paysIso[iso];
}


function getCurrentIndic() {
    return $('#select_liste_indic').val();
}

function getCurrentPays() {
    return $('#select_liste_pays').val();
}

function getCurrentAnnee() {
    return $("#cartes_annee").slider('value');
}

function getCurrentProportion() {
    return $("#choix_proportion").slider('value');
}

function getCurrentEcran() {
    return $('#ecran').val();
}

function getCurrentTypePays() {
    return $('input[name=type_pays]:checked').val();
}

function getCurrentDistance() {
    return $("#cartes_distance").slider('value');
}

/**
 * Retour l'indicateur correspondant 
 * @var id Identifiant numérique dans la BDD 
 * */
function getIndicateurById(id) {
    return window._indicateurs[id];
}


function parseDataDistances(data) {
    window._distancesPays = {};
    var d;
    for (var p in data) {
        d = data[p];
        if (!window._distancesPays[d.P]) {
            window._distancesPays[d.P] = [];
        }
        window._distancesPays[d.P].push(d);
    }
}

function parseDataContiguite(data) {

    window._contiguite = {};
    for (var p in data) {
        d = data[p];
        if (!window._contiguite[d.P]) {
            window._contiguite[d.P] = [];
        }
        window._contiguite[d.P].push(d.Q);
    }
    console.log(window._contiguite);
}


function parseDataForIndicateurs(data) {
    window._indicateurs = {};
    console.log(window._indicateurs);
    var h = [];
    var selected = window.hashParameters['select_liste_indic'] ? window.hashParameters['select_liste_indic'] : 5;

    for (var p in data) {

        var id = data[p].indicateur_id;
        data[p].indicateur_values_colors_db = data[p].indicateur_values_colors.split(';');
        data[p].indicateur_values_colors = ['d9efed', '99dee3', '5dced2', '20bdc4', '2499a2', '29767e', '2f515b'];
        data[p].indicateur_values = data[p].indicateur_values.split(';');
        data[p].indicateur_values_colors_extended = data[p].indicateur_values_colors_extended.split(';');
        var titre = data[p]['indicateur_title_' + lg];
        var pressed = (id == selected) ? 'selected' : '';

        //On rempli le select des régions (zones).
        h.push('<option aria-selected="' + pressed + '" ' + (pressed ? 'selected' : '') + ' value="' + id + '">' + titre.toUpperCase() + '</option>');

        window._indicateurs[id] = data[p];
    }

    $("select#select_liste_indic").html(h.join(''));
}

/**
 * Récupère et construit la liste des pays
 * */
function parseDataForPays(data) {
    /**
     * Variable globale pour retrouver les pays
     * */
    window._pays = window._paysIso = {};
    var h = [];
    var selectedPays = window.hashParameters['select_liste_pays'] ? window.hashParameters['select_liste_pays'] : ['WW'];
    h.push('<option ' + (selectedPays.indexOf('WW') >= 0 ? 'selected' : '') + ' value="WW">' + t('monde') + '</option>');

    for (var p in data) {
        var id = data[p].pays_id;
        var titre = data[p]['pays_nom_' + lg];
        window._pays[id] = data[p];
        window._paysIso[data[p].pays_iso2] = data[p];
        var sel = selectedPays.indexOf(data[p].pays_iso2) >= 0 ? 'selected' : '';

        //On rempli le select des régions (zones).
        h.push('<option ' + sel + ' value="' + data[p].pays_iso2 + '">' + titre.toUpperCase() + '</option>');
    }
    $("select#select_liste_pays").html(h.join(''));
}

function selectSingleCountryVoisins(obj) {

    window.ignoreSumoCountryEvent = true;
    unselectAllCountries();
    window.ignoreSumoCountryEvent = false;
    selectedCountries[obj.id] = obj;
    obj.isSelected = true;
    window.ignoreSumoCountryEvent = true;
    selectCountryInSelect(obj.id);
    window.ignoreSumoCountryEvent = false;
    updateMap();
    setTimeout(function() {
        updateChart();
        updateLocationHash();
    }, 10);
}


function selectSingleCountryAlautre(obj) {
    countriesInOrder = [];
     window.ignoreSumoCountryEvent = true;
    unselectAllCountries();
    window.ignoreSumoCountryEvent = false;
    selectedCountries[obj.id] = obj;
    obj.isSelected = true;
    window.ignoreSumoCountryEvent = true;
    selectCountryInSelect(obj.id);
    window.ignoreSumoCountryEvent = false;
    updateMap();
    setTimeout(function() {
        updateChart();
        updateLocationHash();
    }, 10);
}

function unselectAllCountries() {
    countryColors = clone(initCountryColors);
    currentCountriesColors = {};
    unSelectAllCountriesInSelect();
    selectedCountries = [];
}


function unSelectAllCountriesInSelect() {
    $('#select_liste_pays')[0].sumo.unSelectAll();
}

function selectSingleCountry(obj) {

    console.trace();
    if (countryColors.length == 0) {
        unSelectCountryInSelect(obj.id);
        console.log('TROP DE PAYS');
        /**
         * Déjà trop de pays sélectionnés
         * On en fait rien
         * @todo mettre un message d'info ?
         * */
        return;
    }

    /**
     * On force sa couleur ... sinon la librairie la change ...
     * */
    obj.color = obj.colorReal;

    /**
     * Liste des pays sélectionnés
     * */
    selectedCountries[obj.id] = obj;

    /**
     * On récupère une nouvelle couleur à utiliser
     * */
    obj.insetColor = countryColors.shift();

    /**
     * On garde pour remettre
     * */
    currentCountriesColors[obj.id] = obj.insetColor;

    /**
     * Et on lui applique le filtre SVG correspondant à cette couleur
     * */
    applyFilterToSelectedCountry(obj)

    /**
     * On garde en mémoire qu'on est sélectionné
     * */
    obj.isSelected = true;

    /**
     * On force sa mise à jour graphique
     * */
    obj.validate();

    /**
     * On met à jour le select
     * */
    selectCountryInSelect(obj.id);

    /**
     * On met à jour le graph
     * */
    setTimeout(updateChart, 10);

    updateLegende();
}


/**
 * Désélection d'un pays
 * @var obj MapObject
 * */
function unSelectSingleCountry(obj) {

    /**
     * On le supprime de la liste
     * */
    delete selectedCountries[obj.id];
    delete currentCountriesColors[obj.id];

    /**
     * On récupère sa couleur et on la remet dans la liste
     * */
    countryColors.unshift(obj.insetColor);

    /**
     * Plus sélectionné ...
     * */
    obj.isSelected = false;

    /**
     * On supprime sa couleur
     * */
    $(obj.displayObject.node).attr('filter', '');

    /**
     * On force sa mise à jour graphique
     * */
    obj.validate();

    /**
     * On met à jour le select
     * */
    unSelectCountryInSelect(obj.id);

    /**
     * On met à jour le graph
     * */
    setTimeout(updateChart, 10);

    updateLegende();
}




/**
 * On force la sélection d'un pays dans le menu déroulant
 * suite à un clic sur le pays
 * */
function selectCountryInSelect(cc) {
    $('#select_liste_pays')[0].sumo.selectItem(cc);
    $('.sumo_select_liste_pays li[data-value=' + cc + '] i').css('background-color', '#' + currentCountriesColors[cc]);
}



/**
 * On force la dé-sélection d'un pays dans le menu déroulant
 * suite à un clic sur le pays
 * */
function unSelectCountryInSelect(cc) {
    $('#select_liste_pays')[0].sumo.unSelectItem(cc);
    $('.sumo_select_liste_pays li[data-value=' + cc + '] i').css('background-color', '');
}


function applyFilterToSelectedCountry(obj) {
    if (obj.displayObject) {
        $(obj.displayObject.node).attr('filter', 'url(#inset_' + obj.insetColor + ')');
    }
}




/**
 * On resélectionne avec leur couleur tous les pays sélectionnés
 * Notament après une reconstruction de la carte
 * (changement d'indicateur ...)
 * */
function reselectSelectedCountries() {
    var obj;

    if (getCurrentTypePays() != "tous" || getCurrentEcran() != 'monde') {
        if (getCurrentEcran() != 'monde') {
            if (getCurrentPays()[0] == 'WW') {
                unSelectSingleCountry(window.currentMap.getObjectById('WW'));
                console.log(getCurrentPays());
                if (getCurrentPays() == null) {
                    selectCountryInSelect(('FR'))
                }
            }
        }
        return;
    }
    if (selectedCountries.length == 0) {
        var cPs = getCurrentPays();
        for (var p in cPs) {
            selectedCountries[cPs[p]] = window.currentMap.getObjectById(cPs[p]);
        }
    }
    for (var p in selectedCountries) {
        obj = window.currentMap.getObjectById(p);
        if (!obj) {
            continue;
        }
        console.log('RESELECT ' + p + " : " + currentCountriesColors[p]);
        if (!currentCountriesColors[p]) {
            currentCountriesColors[p] = countryColors.shift();
        }
        obj.insetColor = currentCountriesColors[p];
        obj.isSelected = true;
        applyFilterToSelectedCountry(obj);
    }
}


function handleProportionChange() {
    updateMap();
    updateLocationHash();
}

function updateLocationHash() {

    var x = {};

    x.select_liste_pays = $('#select_liste_pays').val();
    x.select_liste_indic = $('#select_liste_indic').val();
    x.cartes_annee = $('#cartes_annee').slider('value');
    x.type_pays = $('input[name=type_pays]:checked').val();
    x.ecran = $('#ecran').val();
    x.prop = $('#choix_proportion').slider('value');
    window.location.hash = '#' + JSON.stringify(x);

}


function showMessage(txt) {
    alert(txt);
}
