/**
 * Récupère les données d'un indicateur pour tous les pays
 * et les stock prêt à être utilisé dans le tableau "currentChartData"
 * */
function parseDataChart(indic, result) {

    var data = {};
    var res = [];
    var nom = '';
    /***
     * Les indicateurs "cercles" sont en milliers donc à multiplier par 1000
     * */
    var multiplyByMille = shouldIMultiplyByMille();
    var curMax = 0;
    var curMin = 0;

    for (var p in result) {
        res = result[p];
        if (!res.P) {
            /**
             * Toujours le monde qui nous enquiquine ...
             * N'a pas de code ISO donc on triche
             * */
            res.P = 'WW';
            nom = t('monde');
        }
        else {
            /**
             * Sinon tout va bien
             * */
            nom = getPaysByIso(res.P)['pays_nom_' + lg]
        }

        /**
         * Tableau par défaut
         * */
        if (!data[res.P]) {

            data[res.P] = {
                x: [],
                y: [],
                text: [],
                mode: 'lines',
                line: {
                    shape: 'spline'
                },
                type: 'scatter',
                name: nom,
                paysMin: 0,
                paysMax: 0,
                hoverinfo: 'text'
            }
            data[res.P + "_Proj"] = {
                x: [],
                y: [],
                text: [],
                mode: 'lines',
                line: {
                    shape: 'spline',
                    dash: 'dot',
                },
                type: 'scatter',
                name: nom,
                hoverinfo: 'text'
            }
        }
        /**
         * Données des cercles
         * Toujours en "Milliers" donc on multiplie par 1000 ...
         * */
        if (multiplyByMille) {
            res.V = res.V * 1000;
        }


        data[res.P].paysMax = Math.max(data[res.P].paysMax, res.V);
        data[res.P].paysMin = Math.min(data[res.P].paysMin, res.V);


        /***
         * On sépare les relevés des projections
         * */
        if (res.Y <= (Number(dataYear))) {
            data[res.P].x.push(res.Y);
            data[res.P].y.push(res.V);
            data[res.P].text.push(formatNb(res.V));
        }
        if (res.Y >= (Number(dataYear))) {
            data[res.P + "_Proj"].x.push(res.Y);
            data[res.P + "_Proj"].y.push(res.V);
            data[res.P + "_Proj"].text.push(formatNb(res.V));
        }
    }


    /**
     * Tableau à stocker en attendant de l'utiliser vraiment
     * */
    currentChartData = data;

    /**
     * On balance tout ça au tableau
     * */
    updateChart(indic);

}

function shouldIMultiplyByMille(indic) {
    indic = indic ? indic : getCurrentIndic();
    return getIndicateurById(indic).indicateur_type == 1 ? true : false
}

function handleChartUnit() {
    var zone = $('.yaxislayer .ytick:last-child text');
    var txt = zone.text();
    var unit = txt.substr(-1).toUpperCase();
    if (["K", "M", "B"].indexOf(unit) > -1) {
        zone.html(txt.substring(0, txt.length - 1));
        $('#chart_top_unit').html(t('unite_' + unit));
        console.log(unit);
    }
    else {
        $('#chart_top_unit').html("");
        console.log('NO UNIT ' + txt + " : " + unit);
    }

}


/**
 * On met à jour le graphique avec les infos qu'on a déjà reçues
 * */
function updateChart(indic) {


    /**
     * A l'initialisation on a  pas encore les données mais on affiche un
     * pays .. un peu bizarre à voir
     *
     * @todo Vérifier ce cas
     * */
    if (currentChartData.length == 0) {
        console.log('PAS DATA');
        return;
    }


    /**
     * Si on a pas d'indicateur en parametre on utilise l'indic courant
     * */
    indic = indic ? indic : getCurrentIndic();

    var type = getCurrentTypePays();
    var ecran = getCurrentEcran();

    if (ecran == 'monde') {
        if (type == 'tous') {
            drawChartLines(indic);
        }
        else {
            drawChartProportions(indic);
        }
    }
    else if (ecran == 'voisins') {
        drawChartVoisins();
    }
    else if (ecran == 'paysalautre') {
        drawChartPaysALAutre();
    }


}


function drawChartProportions() {
    $('#zone_chart_spline').removeClass('active');
    $('#zone_chart_proportion').addClass('active');
}


/**
 * Histogram d'un pays à lautre
 * */
function drawChartPaysALAutre() {

    /**
     * Le bon div
     * */
    $('#zone_chart_spline').addClass('active');
    $('#zone_chart_proportion').removeClass('active');

    var multiplyByMille = shouldIMultiplyByMille();

    // Pays dans le bon ordre de sélection
    var pays = countriesInOrder;
    var iso;
    var y = [];
    var t = [];
    var colors = [];
    var v;
    var curMin = 0;
    var curMax = -Infinity;
    /**
     * On construit le tableau des valeurs des pays
     * */
    for (var p in pays) {
        iso = pays[p];
        if (!iso) {
            continue;
        }
        console.log(iso);
        // valeur
        v = window._paysValue[iso];
        v = multiplyByMille ? v * 1000 : v;
        y.push(v);
        // infobulle, nom du pays + valeur
        t.push(window._paysIso[iso]['pays_nom_' + lg] + ' : ' + formatNb(v));
        // Couleur différente pour le premier 
        colors.push(p == 0 ? '#1FBDC3' : '#52F0F6');
        curMax = Math.max(v, curMax);
        curMin = Math.min(v, curMin);
    }


    /**
     * En X les pays et en Y leur valeur
     * */
    var data = [{
        x: pays,
        y: y,
        text: t,
        type: 'bar',
        colorbar: {
            thickness: 0
        },
        marker: {
            color: colors
        },
        hoverinfo: 'text',
        name: ''
    }];

    /**
     * Et la ligne ...
     * */
    data.push({
        type: 'scatter',
        x: pays,
        y: y,
        mode: 'lines+markers',
        marker: {
            symbol: 'star',
            color: '#222E3B',
            size: 10,
            showlegend: false
        },
        line: {
            color: '#222E3B',
            width: 2,
            shape: 'linear',
            dash: 'solid',
            showlegend: false
        },
        showlegend: false,
        hoverinfo: 'skip',
        text: ''
    });

    Plotly.newPlot('chart', data, getBasicChartLayout(curMin, curMax), {
        displayModeBar: false,
        scrollZoom: false
    });

}

/**
 * Un pays et ses voisins
 * */
function drawChartVoisins() {


    /**
     * Le bon div
     * */
    $('#zone_chart_spline').addClass('active');
    $('#zone_chart_proportion').removeClass('active');

    /**
     * Pays principal activé
     * */
    var pays = getCurrentPays();
    if (!pays) {
        console.log('PAS PAYS');
        return;
    }
    if (pays.constructor === Array) {
        pays = pays[0];
    }
    if (!currentChartData[pays]) {
        console.log('PAS DATA PAYS', pays);
        return;
    }

    var paysRow = getPaysByIso(pays);
    /**
     * La ligne du pays est déjà prête
     * */
    var linePays = {
        x: currentChartData[pays].x,
        y: currentChartData[pays].y,
        'mode': 'lines',
        name: paysRow['pays_nom_' + lg],
        line: {
            shape: 'spline',
            color: '#222E3B'
        },
        hoverinfo: 'text',
        text: currentChartData[pays + "_Proj"].text,
    };

    /**
     * La même en pointillé pour le futur ...
     * */
    var linePaysProj = {
        x: currentChartData[pays + "_Proj"].x,
        y: currentChartData[pays + "_Proj"].y,
        'mode': 'lines',
        name: paysRow['pays_nom_' + lg],
        line: {
            shape: 'spline',
            dash: 'dot',
            color: '#222E3B'
        },
        hoverinfo: 'text',
        text: currentChartData[pays + "_Proj"].text
    };

    /**
     * Les lignes max
     * */
    var lineMax = {
        x: currentChartData[pays].x,
        y: [],
        'mode': 'lines',
        name: 'Max',
        line: {
            shape: 'spline',
            color: '#1FBDC3'
        },
        hoverinfo: 'text',
        text: []
    };
    var lineMaxProj = {
        x: currentChartData[pays + "_Proj"].x,
        y: [],
        'mode': 'lines',
        name: 'Max',
        line: {
            shape: 'spline',
            dash: 'dot',
            color: '#1FBDC3'
        },
        hoverinfo: 'text',
        text: []

    };

    /**
     * Et minimum
     * */
    var lineMin = {
        x: currentChartData[pays].x,
        y: [],
        'mode': 'lines',
        name: 'Min',
        line: {
            shape: 'spline',
            color: '#d2f2f3'
        },
        fill: 'tonexty',
        hoverinfo: 'text',
        text: []
    };
    var lineMinProj = {
        x: currentChartData[pays + "_Proj"].x,
        y: [],
        'mode': 'lines',
        name: 'Min',
        line: {
            shape: 'spline',
            dash: 'dot',
            color: '#d2f2f3'
        },
        fill: 'tonexty',
        hoverinfo: 'text',
        text: [],
    };

    /**
     * Valeurs par défaut
     * */
    var loopPays, curMax, curMin;
    var index = 0,
        absMin = Infinity,
        absMax = -Infinity,
        curY = 0;

    /**
     * On parcourt les années
     * */
    for (var y in currentChartData[pays].x) {
        curMax = -Infinity;
        curMin = Infinity;
        /**
         * Et à l'intérieur les pays sélectionnés
         * Pour déterminer le min et le max par année
         * */
        for (var p in window.voisinsPays) {
            loopPays = window.voisinsPays[p];
            curY = currentChartData[loopPays].y[y];
            curMax = Math.max(curMax, curY);
            curMin = Math.min(curMin, curY);
        }
        /**
         * Push ..;
         * */
        lineMin.y.push(curMin);
        lineMin.text.push(formatNb(curMin));
        lineMax.y.push(curMax);
        lineMax.text.push(formatNb(curMax));

        absMax = Math.max(absMax, curMax);
        absMin = Math.min(absMin, curMin);
    }

    /***
     * Et on recommande avec les Projections
     * */
    for (var y in currentChartData[pays + "_Proj"].x) {
        curMax = -Infinity;
        curMin = Infinity;
        for (var p in window.voisinsPays) {
            loopPays = window.voisinsPays[p];
            curY = currentChartData[loopPays + "_Proj"].y[y];
            curMax = Math.max(curMax, curY);
            curMin = Math.min(curMin, curY);
        }
        lineMinProj.y.push(curMin);
        lineMinProj.text.push(formatNb(curMin));
        lineMaxProj.y.push(curMax);
        lineMaxProj.text.push(formatNb(curMax));
        absMax = Math.max(absMax, curMax);
        absMin = Math.min(absMin, curMin);
    }

    /**
     * Layout par défaut de la courbe
     * avec les lignes verticales etc ...
     * */
    var layout = getChartLayout(absMin, absMax);

    /**
     * Attention l'ordre est important
     * C'est ce qui permet de construire le remplissage de couleur
     * */
    var d = [lineMax, lineMin, lineMaxProj, lineMinProj, linePays, linePaysProj];

    /***
     * Go go
     * */
    Plotly.newPlot('chart', d, layout, {
        displayModeBar: false,
        scrollZoom: false
    });
}

function drawChartLines(indic) {

    $('#zone_chart_spline').addClass('active');
    $('#zone_chart_proportion').removeClass('active');

    var d = [];
    var dp, dpProj;
    var curMin = 0,
        curMax = 0;
    for (var pays in selectedCountries) {
        dp = currentChartData[pays];
        dp.line.color = '#' + currentCountriesColors[pays];
        d.push(dp);
        dpProj = currentChartData[pays + "_Proj"];
        dpProj.line.color = '#' + currentCountriesColors[pays];
        d.push(dpProj);

        curMin = Math.min(curMin, dp.paysMin);
        curMax = Math.max(curMax, dp.paysMax);
    }

    var layout = getChartLayout(curMin, curMax);

    window.p = Plotly.newPlot('chart', d, layout, {
        displayModeBar: false,
        scrollZoom: false
    });


}

function getBasicChartLayout(curMin, curMax) {

    /***
     * On augmente un peu le max en hauteur
     * Afin de pas taper tout en haut
     * */
        //curMax += ((curMax) / 10);
        //curMin -= Math.abs((curMax - curMin) / 10);
    var layout = {
            font: {
                size: 11
            },
            margin: {
                l: 40,
                b: 30,
                t: 10,
                r: 20
            },
            showlegend: false,
            xaxis: {
                fixedrange: true,
                showgrid: false,
                showline: true,
                linecolor: '#4D4D4D',
                linewidth: 2
            },
            yaxis: {
                /*  fixedrange: true,*/
                showgrid: false,
                showline: true,
                linecolor: '#4D4D4D',
                linewidth: 2,
                fixedrange: true,

                showticksuffix: 'last'
                /*   hoverformat: '.2'*/
                /*    range: [curMin, curMax]*/
            },

            hovermode: 'closest'
        };


    if (lg == 'fr') {
        layout.separators = ',.';
    }

    return layout;
}

/***
 * Layout par défaut de la courbe
 * Avec les lignes, années en cours etc ...
 **/
function getChartLayout(curMin, curMax) {


    var layout = getBasicChartLayout(curMin, curMax);

    /***
     * Barre verticale de l'année des données
     * */
    layout.shapes = [{
        type: 'line',
        xref: 'x',
        x0: dataYear,
        x1: dataYear,
        yref: 'paper',
        y0: 0.06,
        y1: 1,
        line: {
            color: '#E9362F',
            width: 1,
            dash: 'dot'
        }
    }];

    /**
     * Année des données
     * */
    layout.annotations = [{
        xref: 'x',
        x: dataYear,
        text: '<b>' + dataYear + '</b>',
        y: -0.01,
        showarrow: false,
        yanchor: 'bottom',
        yref: 'paper',
        font: {
            size: 16,
            color: '#E9362F'
        }
    }, {
        xref: 'x',
        x: Math.round(dataYear) - 15,
        text: t('cartes_observations'),
        y: 0,
        xanchor: 'right',
        showarrow: false,
        yanchor: 'bottom',
        yref: 'paper',
        font: {
            size: 11,
            color: '#E9362F'
        }
    }, {
        xref: 'x',
        x: Math.round(dataYear) + 15,
        text: t('cartes_projections'),
        y: 0,
        xanchor: 'left',
        showarrow: false,
        yanchor: 'bottom',
        yref: 'paper',
        font: {
            size: 11,
            color: '#E9362F'
        }
    }];


    var annee = getCurrentAnnee();
    /**
     * Si l'année en cours est différente de l'année des dernières données
     * de l'onu on ajoute une barre et le numéro de l'année
     * Sinon on fait pas c'est reoondant graphiquement
     * */
    if (annee != dataYear) {
        layout.annotations.push({
            xref: 'x',
            x: annee,
            text: '<b>' + annee + '</b>',
            y: 1,
            showarrow: false,
            yanchor: 'top',
            yref: 'paper',
            font: {
                size: 16,
                color: '#1FBDC3'
            }
        });

        layout.shapes.push({
            type: 'line',
            xref: 'x',
            x0: annee,
            x1: annee,
            yref: 'paper',
            y0: 0.06,
            y1: 0.94,
            line: {
                color: '#1FBDC3',
                width: 1,
                dash: 'dash'
            }
        })
    }

    return layout;
}


function updateChartPopulationProportion(percent) {
    $('#choix_proppop .ui-slider-range').css('height', percent + '%');
    $('#choix_proppop .ui-slider-handle').css('bottom', percent + '%').find('.sliderValue').html(Math.round(percent));
}
