binder = function (callback) {

    /**
     * Chemin vers la base de donnée SQLite
     * @type String
     */
    var sqliteDb = 'database.sqlite';

    /**
     * Chemin vers le script PHP à interroger
     * @type String
     */
    var php = 'query.php';

    /**
     * Liste des requêtes SQL
     * Rempli uniquement en mode "nodejs" (node-webkit)
     */
    var sql = {};

    /**
     * Type de connexion à utiliser
     * @type php|nodejs
     */
    var type = '';


    /**
     * Si on a une fonction "require" c'est qu'on est dans node-webkit
     * Sinon on est sur le web en PHP
     */
    if (typeof require === 'undefined') {
        type = 'php';
    } else {
        type = 'nodejs';
    }


    /**
     * Retourne toutes les traductions pour la population
     *
     * @param int id
     * @param {type} callback
     */
    this.getTrads = function (callback) {
        return query('getTrads', {}, callback);
    };

    /**
     * Retourne la liste de la table Indicateurs
     * @param {type} callback
     */
    this.getIndicateurs = function (callback) {
        return query('getIndicateurs', {}, callback);
    };

    /**
     * Retourne la liste de la table Pays
     * @param {type} callback
     */
    this.getPaysEn = function (callback) {
        return query('getPaysEn', {}, callback);
    };

    /**
     * Retourne la liste de la table Pays
     * @param {type} callback
     */
    this.getPaysFr = function (callback) {
        return query('getPaysFr', {}, callback);
    };


    this.getDistances = function (callback) {
        return query('getDistances', {}, callback);
    }

    this.getContiguite = function (callback) {
        return query('getContiguite', {}, callback);
    }


    /**
     * Retourne la valeur d'un indicateur pour tous les pays par groupe de
     * 5 ans
     * */
    this.getIndicateurEveryFiveYears = function (indicateur_field, annee1, annee2, callback) {
        return query('getIndicateurEveryFiveYears', {
            "[indicateur_field]": indicateur_field,
            '[annee1]': annee1,
            '[annee2]': annee2,
            'annee1': annee1,
            'annee2': annee2

        }, callback);
    }

    /**
     * Retourne un indicateur pour une année donnée et tous les pays
     * */
    this.getIndicateurByYear = function (indicateur_field, annee, callback) {
        return query('getIndicateurByYear', {
            "[indicateur_field]": indicateur_field,
            "annee": annee
        }, callback);
    }

    // Simple typeof comparison
    var isFunction = function (object) {
        return typeof (object) == 'function';
    }


    /**
     * Fonction d'abstraction de requête
     * Va dispatcher et retourner le résultat en fonction de l'environnement
     *
     */
    var query = function (query, params, callback) {

        var def = $.Deferred();
        console.log('[bind] > init ' + query);

        /**
         * Si on est en PHP
         */
        if (type === 'php') {
            /**
             * On charge directement le JSON de résutlat depuis le serveur
             * Avec les paramètres encodés en JSON
             */
            $.getJSON(php + '?query=' + query + '&params=' +
                JSON.stringify(params),
                function (results) {
                    console.log('[bind] < resolve ' + query);

                    if (isFunction(callback)) {
                        callback(results);
                    }
                    def.resolve(results);
                });

        } else {
            /**
             * Sinon on récupère la requête dans le tableau
             * @type @arr;sql
             */
            var q = sql[query];
            var params2 = {};

            /**
             * On préfixe les paramètres pour que sqlite
             * retrouve ses placeholders
             * Par défaut PHP n'en a pas besoin et utilise ":" comme préfixe
             */
            for (p in params) {
                if (p.indexOf('[') === 0) {
                    q = q.split(p).join(params[p]);
                } else {
                    params2[':' + p] = params[p];
                }
            }

            /**
             * On charge tout le résultat et on le retourne au callback
             */
            db.all(q, params2, function (tx, results) {
                if (tx) {
                    /**
                     * Sauf s'il y a une erreur ...
                     * on l'affiche par défaut ...
                     */
                    alert('SQL error : ' + tx);
                    return false;
                }
                console.log('[bind] < resolve ' + query);

                callback(results);
                def.resolve(results);
            });
        }
        return def;
    };


    /**
     * Si on est en node-webkit on doit préparer la connexion
     */
    if (type === 'nodejs') {
        /**
         * On récupère la liste des requêtes SQL
         */
        var self = this;
        $.getJSON("sql.json", function (data) {
            sql = data;
            if (callback) callback(self);
        });

        /**
         * On instancie notre objet sqlite3
         *
         * @todo verbose() peut être enlevé une fois en prod
         *
         * @type @call;require@call;verbose
         */
        var sqlite3 = require('sqlite3');


        /**
         * Et on charge la base de donnée
         * @type binder.sqlite3.Database
         */
        var db = new sqlite3.Database(sqliteDb,
            sqlite3.OPEN_READONLY,
            function (e) {
                if (e) {
                    /**
                     * Si e n'est pas null c'est qu'on a eu un problème
                     * de connexion à la BDD
                     *
                     * Par défaut on affiche à l'utilisateur
                     *
                     * @param {type} callback
                     * @returns {undefined}
                     */
                    alert(e);
                }
            });

    } else {

        var self = this;
        setTimeout(function () {
            if (callback) callback(self);
        }, 1000);


    }

};
