<?php

class genFlashData {

    public $params;
    public $site;
    private $first_time;

    public function genFlashData($site, $params='') {

        // Pour Canada et Etats unis
        $this->regionsWithCountries = array(905);


        $this->site = &$site;
        $this->params = $params;
        $this->splitParams();
        $this->first_time = 0;
        $this->cur_annee = date('Y');
        $this->connect();
    }

    public function gen() {

        $xml = '<' . '?x' . 'ml version="1.0" encoding="utf-8"?><root>';

        if ($_GET['game']) {
            switch ($_GET['game']) {

                case 'population':
                    if ($_GET['pays']) {
                        $xml .= $this->getDataPopulation();
                    } else {
                        $xml .= $this->initDataPopulation();
                    }
                    break;

                case 'famille':
                    $xml .= $this->initDataFamille();
                    break;

                case 'simulateur':
                    if ($_GET['pays']) {
                        $xml .= $this->getDataSimulateur();
                    } else {
                        $xml .= $this->initDataSimulateur();
                    }
                    break;

                case 'duree':
                    $xml .= $this->initDataDuree();
                    break;

                case 'naissance':
                    $xml .= $this->initDataNaissance();
                    break;

                case 'atlas':
                    if ($_GET['pays']) {
                        $xml .= $this->getDataAtlas();     // VOIR POUR DENSITE DE POP. ET POP. DE PLUS DE 65 ANS
                    } elseif ($_GET['classement']) {
                        $xml .= $this->getClassement();
                    } else {
                        $xml .= $this->initDataAtlas();
                    }
                    break;
            }
            //$this->disconnect();
        }

        $xml .= '</root>';
        //print $xml;

        while (@ob_end_clean());

        $this->site->doExport(($xml), 'application/xml', 'utf-8', 'data', false, '', true); //, 'Content-Encoding: gzip'."\n",false);
    }

    private function getClassement() {
        $data = '';

        $temps = getmicrotime();
        $yearLimit = isset($_GET['year']) ? "and p.popu_annee = ".$_GET['year']." " : "";

        if ($_GET['classement'] == 'population') {
            $sql = 'select popu_total as population, popu_annee as annee, p.fk_pays_id
                   from t_population p, t_pays px1, t_pays px2
                   where popu_sexe = "Both"
                   and p.fk_pays_id=px1.pays_id
                   and px1.fk_pays_id=px2.pays_id
                   and ( ( px1.pays_id IS NOT NULL
                   and px2.fk_pays_id IS NOT NULL )  OR px1.fk_pays_id IN (' . implode(",", $this->regionsWithCountries) . ') )
                   and p.fk_pays_id!=934
                   and p.fk_pays_id!=941
                   '.$yearLimit.'
                   order by annee, population desc';
        } elseif ($_GET['classement'] == 'donnee_mortalite_infant') {
            //$sql = 'select ((donnee_mortalite_infant/donnee_naissance_annuelle)*1000) AS DIVID, d.donnee_annee as annee, d.fk_pays_id
            $sql = 'select donnee_mortalite_infant AS DIVID, d.donnee_annee as annee, d.fk_pays_id
            from t_donnee d, t_pays p1, t_pays p2
            where d.fk_pays_id=p1.pays_id
            and p1.fk_pays_id=p2.pays_id
            and ( ( p1.pays_id IS NOT NULL
            and p2.fk_pays_id IS NOT NULL )
             OR p1.fk_pays_id IN (' . implode(",", $this->regionsWithCountries) . ')
            )
            and d.fk_pays_id!=934
            and d.fk_pays_id!=941
            '.$yearLimit.'
            order by annee, DIVID desc';
        } else {
            $sql = 'select ' . $_GET['classement'] . ', d.donnee_annee as annee, d.fk_pays_id
            from t_donnee d, t_pays p1, t_pays p2
            where d.fk_pays_id=p1.pays_id
            and p1.fk_pays_id=p2.pays_id
            and ( ( p1.pays_id IS NOT NULL
            and p2.fk_pays_id IS NOT NULL )
             OR p1.fk_pays_id IN (' . implode(",", $this->regionsWithCountries) . ')
            )
            and d.fk_pays_id!=934
            and d.fk_pays_id!=941
            '.$yearLimit.'
            order by annee, ' . $_GET['classement'] . ' desc';
        }

        //$data .= '<pouet>' .$sql .'</pouet>';

        $res = GetAllBdd($sql);

        //$data .= '<pouet>' .$res[0]['population'] .'</pouet>';

        $temp = '';
        $themax = 0;
        foreach ($res as $k => $v) {
            $val = $v[$_GET['classement']];
            if ($_GET['classement'] == 'donnee_mortalite_infant')
                $val = str_replace(',', '.', round($v['DIVID'], 2));
            if ($temp == '')
                $themax = max($themax, $val);
            $temp .= '<item _code="' . $v['fk_pays_id'] . '">' . $val . '</item>';


            if ($v['annee'] != $res[$k + 1]['annee']) {
                $data .= '<y_' . $v['annee'] . ' _title="' . $v['annee'] . '">' . $temp . '</y_' . $v['annee'] . '>';
                $temp = '';
            }
        }
        $data .= '<maxcount>' . $themax . '</maxcount>';
        $data .= '<temps>' . (getmicrotime() - $temps) . '</temps>';
        return $data;
    }

    private function getDataAtlas() {
        $data = '<population>';

        $sql = 'select p.*, d.*
               from t_population p, t_donnee d
               where p.fk_pays_id=d.fk_pays_id
               and p.popu_annee=d.donnee_annee
               and p.fk_pays_id=' . $_GET['pays'] . '
               order by p.popu_annee, p.popu_sexe';

        $res = GetAllBdd($sql);
        $temp = '';

        $population_max = 0;
        $h_max = 0;
        $f_max = 0;
        $duree_vie_max = 0;
        $nbr_enfant_max = 0;
        $tx_croissance_max = 0;
        $tx_natalite_max = 0;
        $densite_pop_max = 0;
        $naissance_max = 0;
        $tx_mortalite_max = 0;
        $mortalite_infant_max = 0;
        $pop65_max = 0;

        $population_min = 100000000;
        $duree_vie_min = 100000000;
        $nbr_enfant_min = 100000000;
        $tx_croissance_min = 100000000;
        $tx_natalite_min = 100000000;
        $densite_pop_min = 100000000;
        $naissance_min = 100000000;
        $tx_mortalite_min = 100000000;
        $mortalite_infant_min = 100000000;
        $pop65_min = 100000000;

        foreach ($res as $k => $v) {
            $sexe = ($v['popu_sexe'] == 'Female') ? 'F' : 'H';
            $mort_infant = $v['donnee_mortalite_infant'];

            if ($v['popu_sexe'] != 'Both') {

                if ($sexe == 'F') {
                    $tmpVal = $v['donnee_65'] . '';
                    $tmpVal = $this->removeExposant($tmpVal);


                    $duree_vie_max = max($duree_vie_max, $v['donnee_esperance']);
                    $nbr_enfant_max = max($nbr_enfant_max, $v['donnee_enfant_femme']);
                    $tx_croissance_max = max($tx_croissance_max, $v['donnee_tx_croissance']);
                    $tx_natalite_max = max($tx_natalite_max, $v['donnee_tx_natalite']);
                    $densite_pop_max = max($densite_pop_max, $v['donnee_densite']);
                    $naissance_max = max($naissance_max, $v['donnee_naissance_annuelle']);
                    $tx_mortalite_max = max($tx_mortalite_max, $v['donnee_tx_mortalite']);
                    $mortalite_infant_max = max($mortalite_infant_max, $mort_infant);
                    $pop65_max = max($pop65_max, $v['donnee_65']);


                    $duree_vie_min = min($duree_vie_min, $v['donnee_esperance']);
                    $nbr_enfant_min = min($nbr_enfant_min, $v['donnee_enfant_femme']);
                    $tx_croissance_min = min($tx_croissance_min, $v['donnee_tx_croissance']);
                    $tx_natalite_min = min($tx_natalite_min, $v['donnee_tx_natalite']);
                    $densite_pop_min = min($densite_pop_min, $v['donnee_densite']);
                    $naissance_min = min($naissance_min, $v['donnee_naissance_annuelle']);
                    $tx_mortalite_min = min($tx_mortalite_min, $v['donnee_tx_mortalite']);
                    $mortalite_infant_min = min($mortalite_infant_min, $mort_infant);
                    $pop65_min = min($pop65_min, $v['donnee_65']);

                    $data .= '<item _title="' . $v['popu_annee'] . '" _population="' . $this->removeExposant($pop_totale) . '" _duree_vie_moy="' . $v['donnee_esperance'] . '" _nbr_enf_fem="' . $v['donnee_enfant_femme'] . '" _taux_crois="' . $v['donnee_tx_croissance'] . '" _taux_natalite="' . $v['donnee_tx_natalite'] . '" _densite_pop="' . $v['donnee_densite'] . '" _naissances="' . $v['donnee_naissance_annuelle'] . '" _taux_mortalite="' . $v['donnee_tx_mortalite'] . '" _mortalite_inf="' . str_replace(',', '.', round($mort_infant, 2)) . '" _pop_65="' . $this->removeExposant($tmpVal) . '">';
                }
                $data .= '<subitem _title="' . $sexe . '">';

                for ($i = 0; $i <= 100; $i++) {
                    $data .= $v['popu_age' . $i] . ', ';

                    if ($sexe == 'H')
                        $h_max = ($v['popu_age' . $i] > $h_max) ? $v['popu_age' . $i] : $h_max;
                    if ($sexe == 'F')
                        $f_max = ($v['popu_age' . $i] > $f_max) ? $v['popu_age' . $i] : $f_max;
                }

                $data = substr($data, 0, -2);
                $data .= '</subitem>';

                if ($sexe == 'H') {
                    $data .= '</item>';
                }
            } else {
                $population_max = max($population_max, $v['popu_total']);
                $population_min = min($population_min, $v['popu_total']);
                $pop_totale = $v['popu_total'];
            }
        }
        $maxHF = ($h_max > $f_max) ? $h_max : $f_max;
        $data .= '</population>';
        $data .= '<maxcount _hf="' . $this->removeExposant($maxHF) . '" _population="' . $this->removeExposant($population_max) . '" _duree_vie_moy="' . $duree_vie_max . '"  _nbr_enf_fem="' . $nbr_enfant_max . '" _taux_crois="' . $tx_croissance_max . '" _taux_natalite="' . $tx_natalite_max . '" _densite_pop="' . $densite_pop_max . '" _naissances="' . $naissance_max . '" _taux_mortalite="' . $tx_mortalite_max . '" _mortalite_inf="' . str_replace(',', '.', round($mortalite_infant_max, 2)) . '" _pop_65="' . $this->removeExposant($pop65_max) . '"></maxcount>';
        $data .= '<mincount _population="' . $this->removeExposant($population_min) . '" _duree_vie_moy="' . $duree_vie_min . '"  _nbr_enf_fem="' . $nbr_enfant_min . '" _taux_crois="' . $tx_croissance_min . '" _taux_natalite="' . $tx_natalite_min . '" _densite_pop="' . $densite_pop_min . '" _naissances="' . $naissance_min . '" _taux_mortalite="' . $tx_mortalite_min . '" _mortalite_inf="' . str_replace(',', '.', round($mortalite_infant_min, 2)) . '" _pop_65="' . $this->removeExposant($pop65_min) . '"></mincount>';
        return $data;
    }

    private function removeExposant($val) {
        return number_format($val,5,'.','');
        if (strpos($val, 'e') != false) {
            $val = str_replace('e+06', '', $val);
            $val = $val * 1000000;
        }

        return $val;
    }

    private function initDataAtlas() {
        $data = '<continents>';
        $data .= $this->getContinentsList();
        $data .= $this->getPaysList();
        $data .= '</continents>';

        $data .= '
        <rubriques>
        <item><![CDATA[' . $this->getFlashTradRub('atlas_rubrique_0') . ']]></item>
        <item><![CDATA[' . $this->getFlashTradRub('atlas_rubrique_1') . ']]></item>
        <item><![CDATA[' . $this->getFlashTradRub('atlas_rubrique_2') . ']]></item>
        <item><![CDATA[' . $this->getFlashTradRub('atlas_rubrique_3') . ']]></item>
        </rubriques>';

        $data .= '<trads>';
        $data .= $this->getFlashTrad('atlas');
        $data .= '<item _title="_startYear">1950</item>';
        $data .= '<item _title="_endYear">2100</item>';
        $data .= '</trads>';

        return $data;
    }

    private function getDataSimulateur() {
        $data = '<population>';

        $sql = 'select p.*, d.donnee_esperance, d.donnee_enfant_femme
               from t_population p, t_donnee d
               where p.fk_pays_id=d.fk_pays_id
               and p.popu_annee=d.donnee_annee
               and p.fk_pays_id=' . $_GET['pays'] . '
               order by p.popu_annee, p.popu_sexe';

        $res = GetAllBdd($sql);
        $temp = '';

        foreach ($res as $k => $v) {
            $sexe = ($v['popu_sexe'] == 'Female') ? 'F' : 'H';


            if ($v['popu_sexe'] != 'Both') {
                if ($sexe == 'F') {
                    $v['donnee_esperance'] = ($v['donnee_esperance'] == 0) ? $res[$k - 2]['donnee_esperance'] : $v['donnee_esperance'];
                    $v['donnee_enfant_femme'] = ($v['donnee_enfant_femme'] == 0) ? $res[$k - 2]['donnee_enfant_femme'] : $v['donnee_enfant_femme'];

                    $data .= '<item _title="' . $v['popu_annee'] . '" _population="' . $this->removeExposant($pop_totale) . '" _esperance="' . $v['donnee_esperance'] . '" _fecondite="' . $v['donnee_enfant_femme'] . '">';
                }

                $data .= '<subitem _title="' . $sexe . '">';

                for ($i = 0; $i <= 100; $i++)
                    $data .= $v['popu_age' . $i] . ', ';

                $data = substr($data, 0, -2);
                $data .= '</subitem>';

                if ($sexe == 'H')
                    $data .= '</item>';
            }else {
                $pop_totale = $v['popu_total'];
            }
        }


        $data .= '</population>';
        return $data;
    }

    private function initDataSimulateur() {
        $data = '<continents>';
        $data .= $this->getContinentsList();
        $data .= $this->getPaysList();
        $data .= '</continents>';

        $data .= '
        <rubriques>
        <item><![CDATA[' . $this->getFlashTradRub('simulateur_rubrique_0') . ']]></item>
        <item><![CDATA[' . $this->getFlashTradRub('simulateur_rubrique_1') . ']]></item>
        </rubriques>';

        $data .= '<trads>';
        $data .= $this->getFlashTrad('simulateur');
        $data .= '<item _title="_startYear">1950</item>';
        $data .= '<item _title="_endYear">2100</item>';
        $data .= '</trads>';

        $data .= '
        <fecondite>
        <item _title="0">0.0000</item>
        <item _title="1">0.0625</item>
        <item _title="2">0.1259</item>
        <item _title="3">0.1927</item>
        <item _title="4">0.2642</item>
        <item _title="5">0.3407</item>
        <item _title="6">0.4221</item>
        <item _title="7">0.5083</item>
        <item _title="8">0.5990</item>
        <item _title="9">0.6941</item>
        <item _title="10">0.7934</item>
        <item _title="11">0.8967</item>
        <item _title="12">1.0039</item>
        <item _title="13">1.1148</item>
        <item _title="14">1.2291</item>
        <item _title="15">1.3468</item>
        <item _title="16">1.4676</item>
        <item _title="17">1.5915</item>
        <item _title="18">1.7183</item>
        <item _title="19">1.8479</item>
        <item _title="20">1.9802</item>
        <item _title="21">2.1151</item>
        <item _title="22">2.2524</item>
        <item _title="23">2.3921</item>
        <item _title="24">2.5340</item>
        <item _title="25">2.6782</item>
        <item _title="26">2.8245</item>
        <item _title="27">2.9729</item>
        <item _title="28">3.1232</item>
        <item _title="29">3.2755</item>
        <item _title="30">3.4296</item>
        <item _title="35">4.3300</item>
        <item _title="40">5.1900</item>
        <item _title="45">6.0800</item>
        <item _title="50">7.0000</item>
        <item _title="55">7.9500</item>
        <item _title="60">8.9200</item>
        <item _title="65">9.9200</item>
        <item _title="70">10.9300</item>
        <item _title="75">11.9700</item>
        <item _title="80">13.0200</item>
        <item _title="85">14.0900</item>
        <item _title="90">15.1700</item>

    </fecondite>


    <esperance>
        <item _title="10">4.98</item>
        <item _title="15">9.64</item>
        <item _title="20">14.97</item>
        <item _title="25">20.79</item>
        <item _title="30">26.91</item>

        <item _title="35">33.13</item>
        <item _title="40">39.29</item>
        <item _title="45">45.24</item>
        <item _title="50">50.87</item>
        <item _title="55">56.10</item>
        <item _title="60">60.90</item>

        <item _title="65">65.23</item>
        <item _title="70">69.12</item>
        <item _title="75">72.60</item>
        <item _title="80">75.74</item>
        <item _title="85">78.63</item>
        <item _title="90">81.42</item>

        <item _title="95">84.45</item>
        <item _title="96">85.16</item>
        <item _title="97">85.95</item>
        <item _title="98">86.87</item>
        <item _title="99">88.08</item>
        <item _title="99.5">88.95</item>
        <item _title="99.8">88.78</item>
        <item _title="99.9">90.24</item>
        <item _title="110">91</item>
    </esperance>

    <param_a0>
        <item _title="0">-2.16583</item>
        <item _title="1">-5.51465</item>
        <item _title="2">-5.51465</item>
        <item _title="3">-5.51465</item>

        <item _title="4">-5.51465</item>
        <item _title="5">-4.39268</item>
        <item _title="6">-4.39268</item>
        <item _title="7">-4.39268</item>
        <item _title="8">-4.39268</item>
        <item _title="9">-4.39268</item>

        <item _title="10">-3.69225</item>
        <item _title="11">-3.69225</item>
        <item _title="12">-3.69225</item>
        <item _title="13">-3.69225</item>
        <item _title="14">-3.69225</item>
        <item _title="15">-2.94252</item>

        <item _title="16">-2.94252</item>
        <item _title="17">-2.94252</item>
        <item _title="18">-2.94252</item>
        <item _title="19">-2.94252</item>
        <item _title="20">-2.74829</item>
        <item _title="21">-2.74829</item>

        <item _title="22">-2.74829</item>
        <item _title="23">-2.74829</item>
        <item _title="24">-2.67206</item>
        <item _title="25">-2.67206</item>
        <item _title="26">-2.67206</item>
        <item _title="27">-2.67206</item>

        <item _title="28">-2.67206</item>
        <item _title="29">-2.51872</item>
        <item _title="30">-2.51872</item>
        <item _title="31">-2.51872</item>
        <item _title="32">-2.51872</item>
        <item _title="33">-2.51872</item>

        <item _title="34">-2.18575</item>
        <item _title="35">-2.18575</item>
        <item _title="36">-2.18575</item>
        <item _title="37">-2.18575</item>
        <item _title="38">-2.18575</item>
        <item _title="39">-2.67206</item>

        <item _title="40">-1.64691</item>
        <item _title="41">-1.64691</item>
        <item _title="42">-1.64691</item>
        <item _title="43">-1.64691</item>
        <item _title="44">-1.64691</item>
        <item _title="45">-0.93877</item>

        <item _title="46">-0.93877</item>
        <item _title="47">-0.93877</item>
        <item _title="48">-0.93877</item>
        <item _title="49">-0.93877</item>
        <item _title="50">-0.38269</item>
        <item _title="51">-0.38269</item>

        <item _title="52">-0.38269</item>
        <item _title="53">-0.38269</item>
        <item _title="54">-0.38269</item>
        <item _title="55">0.04832</item>
        <item _title="56">0.04832</item>
        <item _title="57">0.04832</item>

        <item _title="58">0.04832</item>
        <item _title="59">0.04832</item>
        <item _title="60">0.48768</item>
        <item _title="61">0.48768</item>
        <item _title="62">0.48768</item>
        <item _title="63">0.48768</item>

        <item _title="64">0.48768</item>
        <item _title="65">0.93302</item>
        <item _title="66">0.93302</item>
        <item _title="67">0.93302</item>
        <item _title="68">0.93302</item>
        <item _title="69">0.93302</item>

        <item _title="70">1.32649</item>
        <item _title="71">1.32649</item>
        <item _title="72">1.32649</item>
        <item _title="73">1.32649</item>
        <item _title="74">1.32649</item>
        <item _title="75">1.82189</item>

        <item _title="76">1.82189</item>
        <item _title="77">1.82189</item>
        <item _title="78">1.82189</item>
        <item _title="79">1.82189</item>
        <item _title="80">2.29</item>
        <item _title="81">2.29</item>

        <item _title="82">2.29</item>
        <item _title="83">2.29</item>
        <item _title="84">2.29</item>
        <item _title="85">2.29</item>
        <item _title="86">2.29</item>
        <item _title="87">2.29</item>

        <item _title="88">2.29</item>
        <item _title="89">2.29</item>
        <item _title="90">2.29</item>
        <item _title="91">2.29</item>
        <item _title="92">2.29</item>
        <item _title="93">2.29</item>

        <item _title="94">2.29</item>
        <item _title="95">2.29</item>
        <item _title="96">2.29</item>
        <item _title="97">2.29</item>
        <item _title="98">2.29</item>
        <item _title="99">2.29</item>

        <item _title="100">2.29</item>
        <item _title="101">2.29</item>
        <item _title="102">2.29</item>
        <item _title="103">2.29</item>
        <item _title="104">2.29</item>
        <item _title="105">2.29</item>

        <item _title="106">2.29</item>
        <item _title="107">2.29</item>
        <item _title="108">2.29</item>
        <item _title="109">2.29</item>
        <item _title="110">2.29</item>
    </param_a0>


    <param_a1>
        <item _title="0">2.4914</item>
        <item _title="1">4.30613</item>
        <item _title="2">4.30613</item>
        <item _title="3">4.30613</item>
        <item _title="4">4.30613</item>

        <item _title="5">3.34845</item>
        <item _title="6">3.34845</item>
        <item _title="7">3.34845</item>
        <item _title="8">3.34845</item>
        <item _title="9">3.34845</item>
        <item _title="10">2.83824</item>

        <item _title="11">2.83824</item>
        <item _title="12">2.83824</item>
        <item _title="13">2.83824</item>
        <item _title="14">2.83824</item>
        <item _title="15">2.51152</item>
        <item _title="16">2.51152</item>

        <item _title="17">2.51152</item>
        <item _title="18">2.51152</item>
        <item _title="19">2.51152</item>
        <item _title="20">2.47996</item>
        <item _title="21">2.47996</item>
        <item _title="22">2.47996</item>

        <item _title="23">2.47996</item>
        <item _title="24">2.47996</item>
        <item _title="25">2.45176</item>
        <item _title="26">2.45176</item>
        <item _title="27">2.45176</item>
        <item _title="28">2.45176</item>

        <item _title="29">2.45176</item>
        <item _title="30">2.38134</item>
        <item _title="31">2.38134</item>
        <item _title="32">2.38134</item>
        <item _title="33">2.38134</item>
        <item _title="34">2.38134</item>

        <item _title="35">2.21784</item>
        <item _title="36">2.21784</item>
        <item _title="37">2.21784</item>
        <item _title="38">2.21784</item>
        <item _title="39">2.21784</item>
        <item _title="40">1.94409</item>

        <item _title="41">1.94409</item>
        <item _title="42">1.94409</item>
        <item _title="43">1.94409</item>
        <item _title="44">1.94409</item>
        <item _title="45">1.58125</item>
        <item _title="46">1.58125</item>

        <item _title="47">1.58125</item>
        <item _title="48">1.58125</item>
        <item _title="49">1.58125</item>
        <item _title="50">1.32476</item>
        <item _title="51">1.32476</item>
        <item _title="52">1.32476</item>

        <item _title="53">1.32476</item>
        <item _title="54">1.32476</item>
        <item _title="55">1.15017</item>
        <item _title="56">1.15017</item>
        <item _title="57">1.15017</item>
        <item _title="58">1.15017</item>

        <item _title="59">1.15017</item>
        <item _title="60">0.98232</item>
        <item _title="61">0.98232</item>
        <item _title="62">0.98232</item>
        <item _title="63">0.98232</item>
        <item _title="64">0.98232</item>

        <item _title="65">0.81446</item>
        <item _title="66">0.81446</item>
        <item _title="67">0.81446</item>
        <item _title="68">0.81446</item>
        <item _title="69">0.81446</item>
        <item _title="70">0.67993</item>

        <item _title="71">0.67993</item>
        <item _title="72">0.67993</item>
        <item _title="73">0.67993</item>
        <item _title="74">0.67993</item>
        <item _title="75">0.47414</item>
        <item _title="76">0.47414</item>

        <item _title="77">0.47414</item>
        <item _title="78">0.47414</item>
        <item _title="79">0.47414</item>
        <item _title="80">0.2735</item>
        <item _title="81">0.2735</item>
        <item _title="82">0.2735</item>

        <item _title="83">0.2735</item>
        <item _title="84">0.2735</item>
        <item _title="85">0.2735</item>
        <item _title="86">0.2735</item>
        <item _title="87">0.2735</item>
        <item _title="88">0.2735</item>

        <item _title="89">0.2735</item>
        <item _title="90">0.2735</item>
        <item _title="91">0.2735</item>
        <item _title="92">0.2735</item>
        <item _title="93">0.2735</item>
        <item _title="94">0.2735</item>

        <item _title="95">0.2735</item>
        <item _title="96">0.2735</item>
        <item _title="97">0.2735</item>
        <item _title="98">0.2735</item>
        <item _title="99">0.2735</item>
        <item _title="100">0.2735</item>

        <item _title="101">0.2735</item>
        <item _title="102">0.2735</item>
        <item _title="103">0.2735</item>
        <item _title="104">0.2735</item>
        <item _title="105">0.2735</item>
        <item _title="106">0.2735</item>

        <item _title="107">0.2735</item>
        <item _title="108">0.2735</item>
        <item _title="109">0.2735</item>
        <item _title="110">0.2735</item>
    </param_a1>

    <param_k>
        <item _title="0">0</item>

        <item _title="1">0</item>
        <item _title="2">0</item>
        <item _title="3">0</item>
        <item _title="4">0</item>
        <item _title="5">0</item>
        <item _title="6">0</item>

        <item _title="7">0</item>
        <item _title="8">0</item>
        <item _title="9">0</item>
        <item _title="10">0</item>
        <item _title="11">0</item>
        <item _title="12">0</item>

        <item _title="13">0</item>
        <item _title="14">0</item>
        <item _title="15">0.1</item>
        <item _title="16">0.3</item>
        <item _title="17">0.5</item>
        <item _title="18">0.6</item>

        <item _title="19">0.7</item>
        <item _title="20">0.8</item>
        <item _title="21">0.9</item>
        <item _title="22">1</item>
        <item _title="23">1</item>
        <item _title="24">1</item>

        <item _title="25">1</item>
        <item _title="26">1</item>
        <item _title="27">1</item>
        <item _title="28">1</item>
        <item _title="29">1</item>
        <item _title="30">0.93</item>

        <item _title="31">0.93</item>
        <item _title="32">0.85</item>
        <item _title="33">0.85</item>
        <item _title="34">0.85</item>
        <item _title="35">0.68</item>
        <item _title="36">0.68</item>

        <item _title="37">0.68</item>
        <item _title="38">0.68</item>
        <item _title="39">0.68</item>
        <item _title="40">0.35</item>
        <item _title="41">0.35</item>
        <item _title="42">0.35</item>

        <item _title="43">0.35</item>
        <item _title="44">0.35</item>
        <item _title="45">0.05</item>
        <item _title="46">0.05</item>
        <item _title="47">0.05</item>
        <item _title="48">0.05</item>

        <item _title="49">0.05</item>
        <item _title="50">0</item>
        <item _title="51">0</item>
        <item _title="52">0</item>
        <item _title="53">0</item>
        <item _title="54">0</item>

        <item _title="55">0</item>
        <item _title="56">0</item>
        <item _title="57">0</item>
        <item _title="58">0</item>
        <item _title="59">0</item>
        <item _title="60">0</item>

        <item _title="61">0</item>
        <item _title="62">0</item>
        <item _title="63">0</item>
        <item _title="64">0</item>
        <item _title="65">0</item>
        <item _title="66">0</item>

        <item _title="67">0</item>
        <item _title="68">0</item>
        <item _title="69">0</item>
        <item _title="70">0</item>
        <item _title="71">0</item>
        <item _title="72">0</item>

        <item _title="73">0</item>
        <item _title="74">0</item>
        <item _title="75">0</item>
        <item _title="76">0</item>
        <item _title="77">0</item>
        <item _title="78">0</item>

        <item _title="79">0</item>
        <item _title="80">0</item>
        <item _title="81">0</item>
        <item _title="82">0</item>
        <item _title="83">0</item>
        <item _title="84">0</item>

        <item _title="85">0</item>
        <item _title="86">0</item>
        <item _title="87">0</item>
        <item _title="88">0</item>
        <item _title="89">0</item>
        <item _title="90">0</item>

        <item _title="91">0</item>
        <item _title="92">0</item>
        <item _title="93">0</item>
        <item _title="94">0</item>
        <item _title="95">0</item>
        <item _title="96">0</item>

        <item _title="97">0</item>
        <item _title="98">0</item>
        <item _title="99">0</item>
        <item _title="100">0</item>
        <item _title="101">0</item>
        <item _title="102">0</item>

        <item _title="103">0</item>
        <item _title="104">0</item>
        <item _title="105">0</item>
        <item _title="106">0</item>
        <item _title="107">0</item>
        <item _title="108">0</item>

        <item _title="109">0</item>
        <item _title="110">0</item>
    </param_k>';

        return $data;
    }

    private function initDataDuree() {

        $data = '';

        $data .= '<trads>';
        $data .= $this->getFlashTrad('duree');
        $data .= '</trads>';



        return $data;
    }

    private function initDataNaissance() {

        $data = '';

        $data .= '<trads>';
        $data .= $this->getFlashTrad('naissance');
        $data .= '</trads>';



        return $data;
    }

    private function getPaysList() {
        global $lg;
        $data = '';

        $sql = 'select DISTINCT(p1.pays_id) , p1.*
               from t_pays p1, t_pays p2
               where  ( p1.fk_pays_id=p2.pays_id
               and p1.pays_id IS NOT NULL
               and p2.fk_pays_id IS NOT NULL ) OR p1.fk_pays_id IN (' . implode(",", $this->regionsWithCountries) . ')  order by p1.pays_nom_' . $lg;

        $list = GetAllBdd($sql);
        $data .= '<item _url="" _type="1" _tc="0" _empty="true"><![CDATA[' . strtoupper(removeaccents(t('flash_pays_aucun'))) . ']]></item>' . "\n";
        foreach ($list as $k => $v) {

            /* $temp = explode('(', $this->site->getLgValue('pays_nom', $v));
              $nom_pays = $temp[0]; */

            // LES EXPRESSIONS REGULIERES CA PUENT DU SLIP !!!!!!!!
            /* $pattern = "(([)])([[:punct:]]|[[:alnum:]]|[[:print:]])*([)]))";
              $nom_pays = eregi_replace($pattern, "", $this->site->getLgValue('pays_nom', $v)) ; */

            $data .= '<item _url="http://' . $_SERVER['SERVER_NAME'] . $this->site->g_url->buildUrlFromId(getParam('rub_flashdata_id')) . 'bdd/game/' . $_GET['game'] . '/pays/' . $v['pays_id'] . '" _code="' . $v['pays_id'] . '" _type="1"><![CDATA[' . $this->site->getLgValue('pays_nom', $v) . ']]></item>' . "\n";
        }

        return $data;
    }

    private function initDataFamille() {
        $data = '<trads>';
        $data .= $this->getFlashTrad('famille');
        $data .= '<item _title="_startYear">1950</item>';
        $data .= '<item _title="_endYear">2100</item>';
        $data .= '</trads>';

        $data .= '
        <contraceptions>
            <item _title="contraception3" _value="' . $this->getFlashTradRub('famille_contraception3_value') . '" _type="0"><![CDATA[' . $this->getFlashTradRub('famille_contraception3') . ']]></item>
            <item _title="contraception0" _value="' . $this->getFlashTradRub('famille_contraception0_value') . '" _type="0"><![CDATA[' . $this->getFlashTradRub('famille_contraception0') . ']]></item>
            <item _title="contraception1" _value="' . $this->getFlashTradRub('famille_contraception1_value') . '" _type="0"><![CDATA[' . $this->getFlashTradRub('famille_contraception1') . ']]></item>
            <item _title="contraception2" _value="' . $this->getFlashTradRub('famille_contraception2_value') . '" _type="0"><![CDATA[' . $this->getFlashTradRub('famille_contraception2') . ']]></item>
            <item _title="contraception4" _value="' . $this->getFlashTradRub('famille_contraception4_value') . '" _type="0"><![CDATA[' . $this->getFlashTradRub('famille_contraception4') . ']]></item>
            <item _title="contraception5" _value="' . $this->getFlashTradRub('famille_contraception5_value') . '" _type="0"><![CDATA[' . $this->getFlashTradRub('famille_contraception5') . ']]></item>
            <item _title="contraception6" _value="' . $this->getFlashTradRub('famille_contraception6_value') . '" _type="0"><![CDATA[' . $this->getFlashTradRub('famille_contraception6') . ']]></item>
        </contraceptions>';

        return $data;
    }

    private function getDataPopulation() {
        $data = '';
        $population = '';
        $generation = '';

        // RATIO pour lisser le passage de 1949 à 1950 pour le pourcentage vivants / morts
        $tab_ratio = array(900 => 0.84, //MONDE
            903 => 0.81, //AFRIQUE
            904 => 0.87, //AMERIQUE LATINE ET CARAIBES
            905 => 0.67, //AMERIQUE SEPTENTRIONALE
            908 => 0.65, //EUROPE
            909 => 0.70, //OCEANIE
            935 => 0.91); //ASIE


        $ANN = date('Y');

        $sql = 'select p.*, donnee_naissance_annuelle, donnee_tx_mortalite, donnee_tx_natalite, donnee_txsurvie
               from t_population p, t_donnee d
               where p.fk_pays_id=d.fk_pays_id
               and popu_annee=donnee_annee
               and p.fk_pays_id=' . $_GET['pays'] . '
               and popu_sexe="both"
               and popu_annee <= ' . $ANN . '
               order by popu_annee
               ';



        $res = GetAllBdd($sql);
        $r_cpt = $ANN - $res[0]['popu_annee'];
        $cpt = $ANN - $res[0]['popu_annee'];

        $sql = 'select * from t_quot_survie where fk_pays_id=' . $_GET['pays'];
        $list_quot = GetAllBdd($sql);

        foreach ($res as $k => $v) {

            $tmpVal = $v['popu_total'] . '';
            if (strpos($tmpVal, 'e') != false) {
                $tmpVal = str_replace('e+06', '', $tmpVal);
                $tmpVal = $tmpVal * 1000000;
            }

            if($v['donnee_txsurvie'] == 0) {
                $v['donnee_txsurvie'] = str_replace(',','.',round($lastTaux * $rapport,5));
            }
            
            $rapport = $v['donnee_txsurvie'] / $lastTaux;
            $lastTaux = $v['donnee_txsurvie'];

            $population .= '<item _title="' . $v['popu_annee'] . '"><![CDATA[' . $tmpVal . ']]></item>' . "\n";

            if ($v['popu_annee'] >= 1950) {
                /* $nb_vivant = $v['popu_age0']*1000;

                  $nb_vivant -= ($nb_vivant * $res[$i]['donnee_tx_mortalite']) /1000;


                  $prct_vivant = round($nb_vivant*100/($v['popu_age0']*1000), 2);
                  $prct_dead = 100 - $prct_vivant;
                  //$nb_dead = $v['popu_age0']*1000 - $nb_vivant;

                  $generation .= '<item _title="' .$r_cpt .'"  _alive="' .str_replace(',','.',$prct_vivant) .'" _died="' .str_replace(',','.',$prct_dead) .'"><![CDATA[' .$v['donnee_naissance_annuelle'] .']]></item>' ."\n";
                  $r_cpt--; */
                $nb_vivant = ($v['donnee_naissance_annuelle'] * 1000) * ($v['donnee_txsurvie']);



                if ($ANN > 2005 && $v['popu_annee'] < 2005) {
                    for ($l = 0; $l <= $ANN - 2005; $l++) {
                        $temp = $r_cpt - $l;
                        $nb_vivant = $nb_vivant * (1 - ($list_quot[$temp]['quot_survie_valeur']));
                    }
                }

                $nb_dead = $v['donnee_naissance_annuelle'] * 1000 - $nb_vivant;
                $nb_naissance = ($v['donnee_tx_natalite'] * $v['popu_total']) / 1000;

                $prct_vivant = ($nb_vivant * 100 / ($v['donnee_naissance_annuelle'] * 1000)); // * $tab_ratio[$v['fk_pays_id']];
                $prct_dead = 100 - $prct_vivant;

                $temp = 1 - ($list_quot[$temp]['valeur']);

                $generation .= '<item
                        _nb_vivant="' . $v['donnee_naissance_annuelle'] . '" 
                        _tx_survie="' . $v['donnee_txsurvie'] . '"
                        _title="' . $r_cpt . '"
                        _alive="' . str_replace(',', '.', round($prct_vivant, 2)) . '"
                        _died="' . str_replace(',', '.', round($prct_dead, 2)) . '"><![CDATA[' . $v['donnee_naissance_annuelle'] . ']]></item>' . "\n";
                $r_cpt--;
            } else {
                $nb_vivant = ($v['donnee_naissance_annuelle'] * 1000) * ($v['donnee_tx_mortalite']);

                if ($ANN > 2005) {
                    for ($l = 0; $l <= $ANN - 2005; $l++) {
                        $temp = $r_cpt - $l;
                        $nb_vivant = $nb_vivant * (1 - ($list_quot[$temp]['quot_survie_valeur']));
                    }
                }

                $nb_dead = $v['donnee_naissance_annuelle'] * 1000 - $nb_vivant;
                $nb_naissance = ($v['donnee_tx_natalite'] * $v['popu_total']) / 1000;

                $prct_vivant = ($nb_vivant * 100 / ($v['donnee_naissance_annuelle'] * 1000)); // * $tab_ratio[$v['fk_pays_id']];
                $prct_dead = 100 - $prct_vivant;

                $temp = 1 - ($list_quot[$temp]['valeur']);

                $generation .= '<item  _title="' . $r_cpt . '"  _alive="' . str_replace(',', '.', round($prct_vivant, 2)) . '" _died="' . str_replace(',', '.', round($prct_dead, 2)) . '"><![CDATA[' . $v['donnee_naissance_annuelle'] . ']]></item>' . "\n";
                $r_cpt--;
            }
        }

        $data = '<population>';
        $data .= $population;
        $data .= '</population>';
        $data .= '<generation>';
        $data .= $generation;
        $data .= '</generation>';

        $sql = 'select *
               from t_population
               where fk_pays_id=' . $_GET['pays'] . '
               and popu_sexe!="both"
               order by popu_annee, popu_sexe';

        $res = GetAllBdd($sql);


        $dataHF_header = '';
        $dataHF_data = '';
        $dataHF_footer = '';
        //$data .= '<place>';
        $h_max = 0;
        $f_max = 0;
        foreach ($res as $k => $v) {
            $sexe = ($v['popu_sexe'] == 'Female') ? 'F' : 'H';
            $dataHF_data .= '<item _title="' . $v['popu_annee'] . $sexe . '">' . "\n";

            for ($i = 0; $i <= 100; $i++) {
                $dataHF_data .= $v['popu_age' . $i] . ', ';
                if ($sexe == 'H')
                    $h_max = ($v['popu_age' . $i] > $h_max) ? $v['popu_age' . $i] : $h_max;
                if ($sexe == 'F')
                    $f_max = ($v['popu_age' . $i] > $f_max) ? $v['popu_age' . $i] : $f_max;
            }

            $dataHF_data = substr($dataHF_data, 0, -2);

            $dataHF_data .= '</item>' . "\n";
        }

        $maxHF = ($h_max > $f_max) ? $h_max : $f_max;

        $dataHF_header = '<place _max="' . $maxHF . '">';

        $dataHF_footer .= '</place>';

        $data .= $dataHF_header . $dataHF_data . $dataHF_footer;

        return $data;
    }

    private function initDataPopulation() {
        $data = '<continents>';
        $data .= $this->getContinentsList();
        $data .= $this->getPaysList();
        $data .= '</continents>';

        $data .= '
        <rubriques>
        <item><![CDATA[' . $this->getFlashTradRub('population_rubrique_0') . ']]></item>
        <item><![CDATA[' . $this->getFlashTradRub('population_rubrique_1') . ']]></item>
        <item><![CDATA[' . $this->getFlashTradRub('population_rubrique_2') . ']]></item>
        </rubriques>';

        $data .= '<trads>';
        $data .= $this->getFlashTrad('population');
        $data .= '<item _title="_startYear">1880</item>';
        $data .= '<item _title="_endYear">2100</item>';
        $data .= '</trads>';

        return $data;
    }

    private function getFlashTrad($game) {
        $data = '';
        $game = '"%' . $game . '%"';
        $sql = 'select * from t_trad_flash where trad_flash_param like ' . $game;
        $trads = GetAll($sql);

        foreach ($trads as $k => $v) {
            $tr = str_replace(array("\r\n"), array("\n"), getLgValue('trad_flash', $v, false));
            $data .= "<item _title=\"" . $v['trad_flash_id'] . "\"><![CDATA[" . $tr . "]]></item>\n";
        }

        return $data;
    }

    private function getFlashTradRub($tradRub) {
        $data = '';
        $rub = '"' . $tradRub . '"';
        $sql = 'select * from t_trad_flash where trad_flash_id like ' . $rub;
        $trads = GetAll($sql);

        foreach ($trads as $k => $v) {
            $data = $this->site->getLgValue('trad_flash', $v);
        }

        return $data;
    }

    private function getContinentsList($fk_id = '') {
        global $lg;
        if ($fk_id == '900')
            return;
        if ($fk_id == '')
            $sql = 'select * from t_pays where fk_pays_id IS NULL ';
        else
            $sql = 'select * from t_pays where fk_pays_id=' . $fk_id . ' order by pays_nom_' . $lg;

        $list = GetAllBdd($sql);

        if ($this->first_time == 0)
            $data .= '<item _url="" _type="0" _empty="true"><![CDATA[' . strtoupper(removeaccents(t('flash_continent_aucun'))) . ']]></item>' . "\n";


        foreach ($list as $k => $v) {

            if ($v['fk_pays_id'] == 0) {
                $data .= '<item _url="http://' . $_SERVER['SERVER_NAME'] . $this->site->g_url->buildUrlFromId(getParam('rub_flashdata_id')) . 'bdd/game/' . $_GET['game'] . '/pays/' . $v['pays_id'] . '" _code="' . $v['pays_id'] . '" _type="0" _tc="1"><![CDATA[' . strtoupper(removeaccents($this->site->getLgValue('pays_nom', $v))) . ']]></item>' . "\n";
                $this->first_time = 1;
                $data .= $this->getContinentsList($v['pays_id']);
            } else {

                $data .= '<item _url="http://' . $_SERVER['SERVER_NAME'] . $this->site->g_url->buildUrlFromId(getParam('rub_flashdata_id')) . 'bdd/game/' . $_GET['game'] . '/pays/' . $v['pays_id'] . '" _code="' . $v['pays_id'] . '" _type="0" _tc="0"><![CDATA[   ' . $this->site->getLgValue('pays_nom', $v) . ']]></item>' . "\n";
            }
        }
        return $data;
    }

    private function splitParams() {
        if (strlen($this->params)) {

            $params = explode('&', $this->params);
            $this->params = array();
            foreach ($params as $param) {

                $p = explode('=', $param);

                $this->params[$p[0]] = $p[1];
            }
        }
    }

    public function connect() {
        global $co_bdd, $_Gconfig;

        $bddName = 'bdd_popM';

        $co_bdd = NewADOConnection($_Gconfig[$bddName]['bdd_type']);

        $co_bdd->NConnect(
                $_Gconfig[$bddName]['bdd_host'], $_Gconfig[$bddName]['bdd_user'], $_Gconfig[$bddName]['bdd_pwd'], $_Gconfig[$bddName]['bdd_bdd']
        );


        $co_bdd->Execute('SET collation_connection = utf8');
        $co_bdd->Execute('SET character_set_client = utf8');
        $co_bdd->Execute('SET character_set_connection = utf8');

        // THIS ONE !
        $co_bdd->Execute('SET character_set_results = utf8');
    }

    public function disconnect() {
        global $co_bdd;

        $co_bdd->disconnect();
    }

}

?>
