﻿// (c) ammap.com | SVG (in JSON format) map of Svalbard and Jan Mayen - High
// areas: {id:"SJ-JN"},{id:"SJ-SV"}
AmCharts.maps.svalbardJanMayenHigh={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"-9.077734",
				"topLatitude":"80.759032",
				"rightLongitude":"36.811330",
				"bottomLatitude":"70.832842"
			}
		},
		"g":{
			"path":[
				{
					"id":"SJ-JN",
					"title":"Jan Mayen",
					"d":"M9.468,785.72h-0.5l-0.695,-0.085l-0.278,0.17l-0.304,0.255l-0.418,0.171l-0.473,0.171l-0.572,0.057l-0.13,0.348l-0.222,0.255l-0.597,0.383l-0.681,1.231l-0.5,0.679l-0.319,0.128l-0.257,0.826l-0.5,0.084H2.688l-0.396,0.657l-0.493,0.697L1.16,792l-0.604,-0.19l0.014,-0.55l-0.542,-0.805l0.028,-0.381l0.243,-0.19h0.694l0.257,-0.912l0.604,-0.7l0.833,-0.765l0.806,-0.255l0.639,-0.255l1.139,-0.511l0.25,-0.426l0.472,-0.256l0.59,-0.49l0.465,-0.532l0.908,-0.053l0.017,-0.438l0.194,-0.598l0.167,-0.513l0.431,-0.47l0.014,-0.728l0.521,-0.706l0.34,-0.493l0.708,-0.386l0.202,-0.665l0.306,-0.257l0.854,-0.365l-0.625,-0.859l-0.027,-0.302l0.632,-0.021l0.167,-0.603l0.639,-0.258l0.723,0.086l0.222,-0.345l0.327,0.194l0.285,0.409l0.604,0.623l0.285,0.323l0.271,0.451v0.815l-0.25,0.687l-0.215,-0.064l-0.243,0.279l0.181,0.214l-0.319,0.729l-0.056,0.899l0.208,0.384l0.167,0.685l-0.167,0.555l-0.799,0.704l-1.639,0.427l-0.945,0.085l-0.778,0.512H9.468z"
				},
				{
					"id":"SJ-SV",
					"title":"Svalbard",
					"d":"M395.273,229.047l0.132,0.216l0.306,-0.173l0.334,0.346l0.409,0.043l-0.354,0.129v0.519l-0.416,0.172l-0.195,0.518l-0.576,-0.216l0.098,-0.432l-0.153,-0.518l0.271,-0.735L395.273,229.047zM399.483,235.077l-0.209,0.086l-0.284,0.986l-0.521,-0.558l0.153,-0.601l-0.319,-0.429l0.125,-0.43l-0.16,-1.075l-0.439,-0.011l0.134,0.527h-0.278l-0.277,-0.516l-0.361,0.172l-0.111,0.344l-0.417,-0.172l0.216,-0.301l-0.431,-0.602l-0.035,-0.302v-0.345l-0.465,-0.474l0.076,-0.216l0.583,-0.172l0.084,-0.691l0.111,0.345l0.354,0.216l0.035,0.647h0.389h0.528l0.111,0.172l-0.049,0.301l0.431,0.603l0.389,0.86l0.091,-0.043l0.25,-0.344l0.333,-0.517l0.195,0.172l0.333,-0.172l0.111,-0.344l0.417,0.172l0.139,0.86l0.277,0.172l0.306,-0.172l0.111,0.172l-0.139,0.516h-0.278l-0.277,-0.172l-0.278,-0.516h-0.306l-0.354,0.646l0.486,0.515l-0.688,0.386L399.483,235.077zM404.971,233.704l0.354,0.558l0.438,0.043l-0.271,0.301l-0.285,0.3l-0.208,0.171l0.132,0.214h0.389l0.223,0.343l0.083,0.857l-0.222,0.171l-1.223,0.171l-0.167,-0.171h-0.5l-0.056,0.171h-0.528l0.167,0.514l-0.528,0.171l-0.222,-0.685h-0.389l-0.133,-0.214l0.104,-0.471l-0.354,-0.215l-0.063,-1.329l0.223,-0.172h0.861l0.473,-0.172h0.75l0.167,0.344h0.277l0.194,-1.031L404.971,233.704zM396.322,239.228l-0.944,-0.17l-0.611,-1.026h-0.223l-0.223,-0.342l-0.055,-0.513l0.917,0.342l0.055,-0.685h0.361l0.445,-0.171h0.75l0.222,0.685h0.445l0.111,-0.342h0.639l0.167,0.342h0.222l0.278,0.854h-0.278l-0.166,-0.342h-0.306l0.132,0.555l-0.111,0.428l-0.604,0.213l0.021,0.469l0.063,0.554l0.056,0.17l0.41,0.042l-0.076,0.298l-0.201,0.128l-0.216,0.554l-0.521,-0.895l-0.369,-0.298l0.049,-0.299l-0.354,-0.213L396.322,239.228zM387.854,247.336l0.597,1.097l0.035,0.295l0.41,0.38l0.111,0.758l-0.188,0.547l-0.306,0.336l-0.445,0.336l0.021,0.463l-0.188,0.042l-0.528,0.503h-0.444h-0.334l-0.167,-0.335l-0.5,-0.168l-0.201,-1.051l-0.069,-0.758l0.056,-0.673l0.743,0.295l0.389,-0.168l-0.056,-0.337h0.528l-0.167,-0.675l-0.243,-0.042v-0.591l0.243,-0.211h0.5L387.854,247.336zM380.019,268.991l0.188,0.534l0.639,0.984l0.854,1.188l0.313,0.777l0.528,0.327l0.778,0.164h0.583l0.278,-0.327h0.444v0.327l0.306,-0.164l-0.083,-0.817h-0.39l-0.556,-0.327l0.021,-0.287l-0.291,-0.41l0.041,-0.738l0.202,-0.533l0.166,-0.492l0.834,-0.494l0.326,-0.534l-0.048,-0.453l-0.223,-0.329l-0.5,-0.165l-0.188,-0.535l0.132,-0.454l0.257,-0.289l0.431,-0.33l-1.16,-0.701l-0.076,-0.455l0.188,-0.537h0.333l0.445,-0.332l0.277,-0.166h0.334l0.465,-0.124l-0.271,-0.372h-0.306l-0.444,0.166l-0.167,-0.331h-0.278l-0.166,0.497l-0.299,-0.125l0.111,-0.331l0.132,-0.373l0.188,-0.041l0.034,-0.622h0.806h0.528l0.056,-0.332l-0.223,-0.333h-0.222l-0.111,-0.332h0.333l0.278,-0.332h0.611l0.09,-0.125l0.021,-0.208l-0.194,-0.332l-0.278,0.166l-0.611,-0.333l-0.111,0.333l-0.389,0.166h-0.278l-0.632,-0.706l-0.535,-0.291h-0.389l-0.223,0.166l-0.556,0.167l-0.833,0.166l-0.778,-0.166l-0.354,-1.041l0.153,-0.583l-0.432,-1.083l0.209,-1.169l-0.209,-0.92l0.306,-1.34l0.716,-0.377l0.16,0.294l0.09,0.544l0.278,0.503l0.368,0.293l0.465,0.711h0.557l0.076,0.459l-0.104,0.71l0.111,0.333l0.778,0.333l0.222,0.667l0.299,-0.042l-0.583,-2.254l-0.376,-0.25l-0.146,-0.46l-0.223,-0.334l-0.222,-0.334l-0.41,-0.88l-0.056,-0.42l0.209,-0.167l-0.265,-0.587l0.056,-1.261l0.264,-0.757l-0.097,-0.253l0.326,-0.042l0.167,0.337l0.5,0.168l0.111,0.504l0.333,0.504l0.577,0.546l-0.382,0.798h0.583l0.194,-0.168l0.271,0.377l-0.125,0.42l0.299,0.712h0.444l0.027,-0.503h1.001l0.444,-0.838h0.444l0.223,0.335l-0.076,0.964l-0.424,0.209l-0.077,0.293l0.792,2.006l-0.11,0.25l0.201,0.292l0.382,0.375l-0.132,0.458l-0.354,0.125l0.319,0.416l0.368,0.625l0.501,-0.167l0.277,-1.333l0.723,-0.167h0.778l0.306,-0.167h0.444l-0.049,0.292l0.243,0.375l0.389,0.167l0.39,0.167l0.146,0.792l0.292,0.416l0.111,0.665l0.083,0.664l0.091,0.623v0.333l0.75,0.331l0.465,0.704l-0.215,0.621l0.132,0.537l-0.167,0.579l-0.514,0.413l-0.167,0.578l0.466,-0.124l0.604,0.701l0.277,0.66l0.084,0.659l-0.077,0.453l0.695,0.165l0.694,-0.494l0.223,-0.658l0.556,-0.66l0.444,-0.33l0.556,0.165l-0.167,0.33l0.195,0.33l-0.021,0.371l0.028,0.823l0.041,0.412l-0.291,0.822l0.271,1.518l-0.271,0.779l0.458,0.899l-0.056,0.654l0.174,1.103l0.25,0.164h0.778l0.056,-0.654h0.277l0.473,0.164l0.285,-0.694l0.132,-0.449l0.465,0.041l0.008,0.776l0.916,0.49h0.501l0.59,-0.368l0.077,-0.286l0.5,-0.49l0.277,-0.327l0.445,-0.327l0.09,-0.287l0.326,-0.368l0.133,0.041l0.313,0.287l0.326,0.286l-0.743,0.205l-0.076,0.286l0.235,0.164l-0.139,0.817l-0.208,0.163l0.132,0.205h0.583l0.473,-0.327l0.035,-0.612l-0.028,-0.245l0.104,-0.777l0.354,-0.532l-0.209,-0.411l0.459,-0.737l-0.181,-0.41l0.188,-0.533l0.806,0.328l0.389,0.656l0.118,0.451l0.348,0.246l0.201,0.287l0.084,0.492l0.361,0.327l0.389,0.327l0.361,0.164l0.382,-0.614l-0.083,-0.655l-0.167,-0.491l-0.264,-0.984l-0.084,-0.657l0.188,-0.205l0.278,0.329l0.223,0.164l0.11,-0.493v-0.165l0.667,-0.164l0.063,0.452l0.354,0.206l0.466,1.025l0.027,0.902l-0.027,0.41l-0.028,0.573l-0.166,0.491l-0.181,0.49l0.235,0.571l0.174,0.286l0.077,0.449l-0.104,0.204l-0.25,-0.163l-0.327,0.367l-0.09,0.448l0.007,0.203l0.021,0.448l-0.688,0.041l-0.402,0.733l-0.348,0.975l0.319,0.812l-0.299,0.041l-0.465,0.284l0.132,0.203l0.667,-0.162h0.944l0.611,-0.325h0.278l-0.077,0.446l0.236,0.081l0.702,1.094l0.027,0.647h1.223l0.056,-0.162l0.39,-0.162h0.277l-0.326,0.607l0.291,0.404l-0.069,0.727l0.216,0.363l0.306,0.484l0.271,0.444l0.063,0.523l-0.222,0.322l0.007,0.443l0.382,0.362l0.229,0.121l0.208,0.241l-0.139,0.321l-0.076,0.282l-0.695,-0.482l-0.104,0.121l0.521,0.844h0.361l0.104,0.201l-0.431,0.401l0.354,0.841l0.494,0.2l0.117,0.441l0.494,0.52l-0.209,0.24l-0.174,0.52l0.584,0.16l0.583,-0.16l0.299,-0.28l-0.049,-0.2l-0.159,-0.44l0.264,-0.24l0.111,-0.32l-0.326,-0.602l-0.216,-0.04l0.271,-0.762l0.528,0.161l-0.083,0.481l0.473,0.16l0.527,0.642l0.556,0.16h0.278l0.271,-0.681l-1.049,-1.243h-0.361l-0.104,-0.201l0.32,-0.482l-0.125,-0.563l0.271,-0.684l0.139,-0.322h0.64l0.243,-0.201l-0.216,-0.443l-0.527,-0.322l-0.417,0.161l-0.132,-0.283l0.159,-0.362l0.584,0.161l0.243,-0.282l-0.327,-0.202l-0.25,-0.484l-0.944,-0.162l-0.299,-0.283l0.16,-0.363l0.415,0.321l0.446,0.002l0.243,-0.202l-0.077,-0.445l-0.055,-0.647l-0.383,-0.526l-0.056,-0.729l-0.166,-1.217l-0.056,-1.219l0.159,-0.366l0.258,-0.286l0.389,-0.977l0.41,-0.204l0.215,-0.529l-0.431,-0.98l0.216,-0.613l0.354,-0.858l-0.188,-0.45L420.691,271l-0.159,-0.532l-0.042,-0.902v-0.739l-0.125,-0.576l0.41,-0.205l0.194,-0.494l1.278,-0.329l0.104,-0.206l-0.077,-0.453l-0.118,-0.454l-0.215,-0.371h-0.528l-0.861,-0.33l-0.361,-0.661l-0.604,-0.372l-0.583,-1.489l-0.028,-0.828l-0.222,-1.161l0.181,-0.498l-0.069,-1.58l0.076,-0.208h0.527l0.557,-1.5l0.472,-0.333l1.111,-0.333h0.807l0.25,0.5h0.222l0.104,0.292l-0.208,0.167l0.264,0.916l-0.125,0.417l0.152,0.833l-0.132,0.374l-0.146,0.706l-0.236,0.748l0.348,0.249l-0.181,0.497l-0.195,0.58l0.16,0.538l0.361,0.331l0.399,0.02l0.435,0.807l0.416,0.661h0.445l-0.056,-0.496l-0.417,-0.992l-0.799,-0.703l0.403,-0.662l-0.07,-0.747l0.459,-1.079l0.229,-0.291l0.694,-0.831l0.438,-1.54l-0.277,-1l0.007,-0.46l0.188,-0.042l0.027,-0.584l-0.236,-0.167l0.028,-0.417l0.125,-0.418l-0.653,-1.256l-0.027,-0.419l-0.223,-1.09l0.208,-0.589l-0.326,-0.546l-0.104,-0.463l0.383,-0.715l0.306,0.842l0.174,0.21l0.048,0.462l0.354,0.21l0.201,-0.042l0.133,0.042l-0.042,0.253l0.292,0.419l-0.125,0.42l0.458,0.419l0.341,0.629h0.277l0.076,-0.209l-0.159,-0.629l-0.688,-0.545l0.298,-0.126l0.528,0.335l0.473,0.671l0.527,0.168l0.195,0.67h0.889l-0.021,0.294l0.41,0.711l0.527,-0.167l0.5,-0.167l0.306,0.502l0.216,0.376l-0.181,0.501l0.104,0.292h0.444l0.306,-0.501l0.159,0.543l-0.326,0.459l-0.473,0.334l0.167,0.167h0.528l-0.035,0.292l-0.354,0.042l-0.09,0.625l-0.354,0.042l-0.25,0.666l-0.424,0.625l-0.486,0.748l0.216,0.457h0.389l0.382,0.373l-0.159,0.457l-0.493,0.373l0.188,0.953h0.611l0.166,0.166l0.202,0.538l0.125,0.58l0.007,0.372l-0.361,0.33l0.194,0.661l0.139,0.33l-0.36,0.33l0.063,0.454l0.375,0.576l-0.16,0.453l-0.215,0.535l0.041,0.74l-0.083,0.657l-0.521,0.041l-0.306,0.164h-0.75l-0.361,0.492l-0.389,0.164L428.333,271l0.132,0.942l-0.152,0.818l-0.137,1.057l-0.086,0.657l0.181,0.408l-0.326,0.367l-0.389,-0.163l-0.271,0.204l0.403,0.163l-0.236,2.359l0.521,0.853l0.466,0.203l-0.027,0.486l-0.16,0.607l0.611,-0.162l-0.028,0.324l-0.11,0.162l0.027,0.485h0.278l0.11,-0.323l0.528,0.162l-0.188,0.202l0.027,0.405l0.327,0.363l0.354,-0.525l0.056,-0.485l-0.292,-0.486l0.125,-0.38l-0.515,-1.078l-0.284,-0.447l-0.194,-0.325l-0.299,-0.528l0.243,-0.284l0.527,0.163l0.361,0.649h0.695l0.333,0.649l0.444,0.487l0.194,0.324l0.299,-0.041l-0.604,-1.095l-0.416,-0.649l-0.243,-0.365l0.291,-0.407l-0.354,-0.692h0.277l0.556,0.489l0.341,0.285l0.215,0.366l0.118,0.447l0.25,1.785l0.633,0.526l0.215,-0.202l-0.069,-1.541l-0.035,-0.527l-0.048,-0.447l0.181,-0.487l-0.195,-0.325l-0.409,-0.692l-0.695,-0.814v-0.163l-0.333,-0.815h0.277l0.557,0.653l0.083,0.489h0.611l0.132,-0.448l-0.16,-0.367h0.445l0.632,0.53l-0.027,0.57l-0.292,0.244l-0.028,0.57l0.056,0.651l0.438,1.015l0.584,0.325v0.649l0.083,0.486l-0.493,0.365l-0.007,0.607l0.361,0.324h0.75l0.084,-0.647l0.556,-0.162l0.299,-0.688l-0.403,-0.974l0.111,-0.731l0.41,-0.203l0.277,-1.139l0.466,0.041l0.007,0.611h0.583l0.41,-0.203l0.194,-0.489l-0.159,-0.937l-0.493,-0.204l-0.098,-1.054l-0.348,-0.252l-0.125,-1.389l-0.291,-0.409l0.326,-0.45l0.167,0.164l0.563,0.041l0.132,0.287h0.417l0.159,-0.368l-0.104,-0.288l-0.195,-0.327l-0.277,-0.164l-0.417,-0.164l-0.465,0.123l-0.056,-0.738l0.291,-0.246l0.028,-0.575l-0.181,-0.329l0.243,-1.356h0.25l0.473,0.494l0.299,0.534l0.208,1.232l0.382,0.369l0.188,-0.205l-0.097,-0.575l0.243,-0.369l0.416,0.493h0.39l1.028,0.82l0.277,-0.82l-0.361,-0.329l-0.166,0.165l-0.528,-0.165l-0.382,-0.37l0.104,-0.288l0.41,-0.205l-0.598,-1.316l0.14,-0.412l0.298,-0.536l0.354,0.536l0.424,0.453l0.194,0.658l0.618,0.781l0.91,1.191l0.084,0.492l0.444,0.492l0.584,-0.328l0.132,-0.369l-0.111,-0.575l-0.431,-0.41l-0.007,-0.288l-0.445,-0.822l-0.034,-0.535l-0.021,-0.782l0.583,0.165h0.5l0.306,0.33l0.25,0.494l0.556,0.329l-0.048,0.288l0.243,0.206l0.465,-0.699l-0.348,-0.329l0.126,-0.412l-0.216,-0.371l-0.473,-0.166l-0.139,-0.33h-0.389l-0.077,-0.784l0.466,-0.041l0.132,0.289l0.063,0.371h0.417h0.333l0.528,0.495l0.132,-0.124l-0.292,-0.412l0.028,-0.604l-0.396,-0.014l-0.556,-0.496h-0.722l-0.306,-0.331l-1.057,-0.33l-0.527,-0.332l-0.361,-0.331l0.139,-0.497l0.028,-0.497h0.527l0.334,-0.829l0.222,-0.167h1.111l1.528,0.333l0.14,0.331h0.389l0.361,-0.331h0.25l0.049,0.456l0.007,0.207l0.215,0.373l-0.125,0.414l0.417,0.993l0.41,0.702h0.333l0.132,0.207l-0.632,0.784l-0.59,0.289l-0.292,0.331l-0.091,0.371h-0.277l-0.194,0.494l-0.41,0.206l0.104,0.288l0.277,-0.165l0.104,0.206l-0.486,0.822l0.056,0.74l0.347,0.246l0.063,0.779h0.278l0.194,-0.492l0.118,-0.287l0.292,-0.246l0.257,-0.123l0.694,-0.165l-0.021,-0.781l0.493,-1.192l0.466,0.041l-0.104,0.453h0.945l0.222,-0.165l0.299,-0.699l-0.042,-1.072l0.181,-0.413l-0.027,-0.413l0.201,-0.372l0.049,-0.621l-0.188,-0.372l-0.243,-0.041l-0.091,-1.118l-0.472,-0.166l-0.133,-0.29l0.438,-0.207h0.944l-0.083,0.331l-0.183,0.032l-0.005,0.424l0.958,0.414l0.195,0.662l0.027,0.331l-0.181,0.827l0.181,0.413l-0.348,0.825l0.084,0.989l-0.028,0.823l0.348,0.329l-0.16,0.37l-0.215,0.041l-0.146,0.781l0.306,0.984l0.216,0.041l0.007,0.451h-0.333L452.313,271l1.167,-0.164l0.278,-0.328l1.25,-0.164l0.063,-0.615l0.375,-0.41l-0.181,-0.329l0.104,-0.288l0.556,0.494l0.139,0.328h0.278l0.111,-0.328l0.417,-0.165l0.139,-0.329l0.778,-0.657l0.194,0.493h1.167l-0.083,0.329l-0.466,0.78l0.382,0.041l0.139,0.328l0.473,0.164l-0.083,0.328h-0.25l-0.584,-0.492h-0.277l-0.473,0.492l-0.25,-0.82l-0.417,-0.164l-0.604,0.369l0.104,0.287l0.639,0.164l0.14,0.328l0.215,0.041l-0.264,0.656l0.111,0.491l0.271,0.123l0.611,0.164l0.076,-0.287l-0.514,-0.655l0.104,-0.205l0.639,-0.328l0.271,0.041l-0.347,0.491l0.188,0.451h0.277l0.361,0.164l-0.049,0.286l0.271,0.205l0.277,0.164l0.584,0.163l0.973,-0.327l0.778,0.49l-0.084,0.327l-0.417,-0.163l-0.104,0.204l0.382,0.449l0.438,-0.368l0.146,-0.613h0.277h0.5l0.194,-0.49h0.278l0.271,0.531l-0.347,0.49l0.104,0.286l1.084,-0.163l0.139,0.327h0.861l0.216,0.368l-0.382,0.123l-0.368,0.041l-0.327,0.123l-0.215,0.041l0.027,0.408l0.466,0.204l0.361,0.652l-0.334,0.163l-0.139,0.326h-0.25l-0.333,-0.326l-0.188,0.204l0.104,0.286l1.028,0.65l0.188,-0.285l-0.319,-0.244l0.076,-0.286l0.694,0.164l0.14,0.325l0.396,0.122l0.354,-0.122h0.333l0.104,-0.203l-0.382,-0.122l0.083,-0.326h0.417l0.139,0.163h0.528l0.277,-0.326h0.278l0.306,0.326h0.723h0.694l0.778,0.164h0.611l0.667,0.163l1.139,0.325l1.445,0.325l0.444,0.163l0.417,0.162l0.723,0.487h1l0.417,1.136l0.444,0.162l0.501,0.972l0.409,0.688l0.341,0.93l0.521,1.009l-0.291,0.323l0.104,0.282l1.528,-0.484l0.917,0.162l0.917,0.484l0.382,2.053l-0.298,0.683h-0.361l-0.361,0.803l-0.118,0.281l-0.223,0.802l-0.243,0.521l-0.034,0.76l-0.14,0.64l0.111,0.719l-0.125,0.399l0.348,1.275l-0.223,0.478l-0.736,1.511l0.264,0.477l-0.041,1.191l0.771,1.465l0.633,0.515l-0.015,1.501l-0.055,0.395l-0.084,0.553l0.319,0.631l-0.055,0.472l-0.223,0.472l-0.16,0.354l-0.389,0.158l-0.361,0.786l-0.444,0.628l-0.063,0.432l-0.348,0.392l-0.174,0.118l-0.299,0.196l0.077,0.588l-0.306,0.156l-0.25,-0.47h-0.251l-0.271,0.196l0.076,0.587l-0.472,0.313l-0.39,-0.313h-0.417l-0.361,0.469l-0.118,0.274l-0.326,0.352l-0.222,-0.313h-0.584l-0.444,0.313l-0.16,0.352l-0.174,0.43l-0.354,0.351l-0.069,0.858l-0.264,0.546l0.181,0.701l-0.216,1.127h-0.611l-0.194,0.777l-0.833,0.466l-0.723,0.155l-0.111,0.62l-0.549,0.504l-0.285,0.271l-0.243,0.193l-0.146,0.735l-0.639,0.31l-0.229,0.58l-0.104,0.193l-0.277,0.31l-0.556,0.154l-0.334,0.463l-0.694,0.309l-0.473,0.154l-0.194,0.462l-0.75,0.308l-0.278,0.617h-0.25l-0.389,-0.308l-0.611,0.308l-0.111,0.308l-1.001,0.154l-0.416,0.615l-0.89,0.614l-0.549,0.5l-0.201,0.882l-0.285,0.269l-0.181,0.383l0.265,0.766l-0.098,0.995l0.299,0.497l0.167,0.305l0.75,0.458l0.271,0.496l0.111,2.209l-0.625,0.684l-0.056,0.228l-0.139,0.228l-0.32,1.139l-0.159,0.341l-0.361,0.455l-0.771,0.341l-0.194,0.454l-0.229,0.568l-0.611,0.302l-0.583,1.057l-1.195,1.659h-0.444l-0.639,0.603l-0.556,0.452l-1.167,0.602l-1.64,-0.301h-1.557l-0.723,0.301l-0.527,0.15l-0.473,0.45l-0.694,-0.15l-0.445,0.3l-0.166,0.45l-0.667,0.15l-0.861,0.601l-0.806,0.15l-0.056,0.45h-0.751h-1.056l-0.5,0.149l-0.528,0.599l-0.389,0.149l-0.473,0.449l-0.667,0.897l-0.527,0.149l-0.778,0.448l-0.528,0.597l-0.215,1.23l0.014,0.67l-0.688,1.672l-0.444,0.742h-1.473h-1.64l-1.528,-0.148h-0.584l-0.361,-0.148l-0.611,-0.296l-0.556,0.148l-0.361,-0.445l-1.556,-0.297l-0.139,-0.297l-0.278,-0.446l-1,-0.596l-0.139,-0.149l-1.362,-0.149h-0.889l-0.667,-0.148l-0.5,-0.596h-0.501l-0.242,-0.187l-0.174,-0.261l-0.132,-0.485l0.014,-0.522l-0.403,-0.373l-0.417,-0.896l-0.014,-0.823l0.139,-0.674l0.348,-1.275l0.326,-0.488l0.223,-0.15l0.667,-0.15l0.354,-0.563l-0.431,-0.375l-0.229,-0.565l-1.334,-0.301l-0.111,-0.301l-0.139,-0.15h-1.14l-0.11,0.301l-0.361,0.15l-0.361,-0.15h-0.334l-0.472,0.15l-0.5,-0.904h-0.723l-0.361,0.603l-0.528,0.151h-0.528l-0.166,-0.301h-0.39l-0.076,0.264l-0.257,0.188l-0.174,0.038h-0.444l-0.076,0.264h-0.25l-0.251,-0.301l-0.36,0.15l-0.251,0.151l-0.306,0.15h-0.444l-0.389,-0.15l-0.223,0.15l-0.389,0.602h-0.444l-0.251,0.301h-0.611l-0.722,0.3l-0.111,0.3l-0.306,0.451l-0.299,-0.338l-0.396,-0.113l-0.39,-0.45l-0.694,0.15l-0.695,-0.902l-0.666,-0.301l-1.001,-0.452h-1.084l-0.556,-0.15l-0.583,-0.301l-0.667,0.301l-1.223,0.301l-0.667,0.301l-1.056,0.452l-0.806,0.15l-0.417,0.301h-0.834l-0.861,-0.451h-0.556l-0.611,-0.15l-0.417,-0.151l-0.354,-0.338l-0.055,-0.376l0.389,-1.055l0.299,-0.038l0.354,-0.491l-0.195,-0.831l-0.215,-0.038l-0.584,-0.453l-0.5,-0.302l-0.611,-0.757l-0.694,-0.151h-0.5h-0.917l-0.5,-0.605l-1.307,-0.303l-0.694,-0.455h-0.5l-0.167,-0.303l-0.278,-0.456h-0.361l-0.576,-0.266l-0.229,0.114l-0.416,0.152l-0.557,-0.152l-0.409,-0.645l-0.056,-0.38l-0.118,-0.342l-0.16,-0.495l-0.034,-0.724l-0.41,-0.647l-0.396,-0.572l-0.39,-0.152l-0.778,-0.458l-0.639,-0.764l-0.667,-0.765l0.076,-0.421l-0.271,-0.651l-0.417,0.153l-0.444,-0.459v-0.153l0.25,-0.307l0.09,-0.191l0.07,-0.384l-0.431,-0.384l0.097,-0.385l-0.438,-0.345l-0.216,-0.346l0.14,-0.538l0.493,-0.963l1.64,-0.308l0.944,-0.462l0.646,-0.039l0.521,-0.27l0.64,0.154l1.528,0.154l0.666,0.308l0.501,0.309l0.521,0.809l-0.236,0.308l0.16,0.577h0.833l0.063,0.884l0.66,0.499l0.278,0.46l0.861,0.153h0.389l0.111,-0.307h0.223l0.277,0.153v0.307l0.417,0.153h0.361l0.361,-0.307l0.473,-0.153l0.25,-0.767l0.326,-0.039l0.451,0.039l0.133,0.038l0.257,0.729h0.25l0.076,-0.192l-0.16,-0.422l0.473,-0.153l0.229,-0.116l0.243,-0.038l0.549,0.346l-0.181,0.154l0.104,0.269l0.34,0.651l0.16,0.575l0.361,-0.306l0.271,0.038l0.167,0.843l-0.271,0.497h0.64l0.417,0.459h0.5l0.389,0.153l0.723,0.458h0.417l0.424,-1.185l0.271,-0.344l0.549,-0.651l-0.215,-0.421l-0.445,-0.46h-0.25l-0.111,0.153l-0.75,0.153l-0.056,0.307h-0.527l-0.501,-0.153l-0.382,-0.345l-0.118,-0.422l-0.277,-0.768l-0.194,-0.154l-0.723,-0.768l-0.75,-0.461l-0.723,0.154l-1.111,-0.308l-0.306,-0.308l-0.251,-0.154l-0.722,-0.154l-0.271,-0.347l-0.368,-0.578L395.343,317l-0.167,-0.464l-0.792,-1.159l-0.063,-0.426l-0.326,-0.271l0.299,-0.348h0.444l0.14,-0.311l1.027,-0.31l1.195,-0.31l0.5,-0.155h0.473l0.583,-0.311l0.667,-0.155l0.528,0.466h0.389l0.368,-0.582l0.438,-0.35h0.584h0.75l0.64,-0.311l1.25,0.155l0.89,0.155l0.25,0.155h0.25l0.216,-0.533l0.423,-0.088h0.473l0.271,0.194l0.118,0.738l1.056,-0.311l0.417,0.466l0.417,0.155l0.417,0.155l0.723,-0.155h0.361l0.833,0.155l0.778,-0.311l0.417,-0.311l0.215,-0.504l0.118,-1.206l0.584,-0.311l0.159,-0.35l-0.159,-0.584l-0.611,-0.468l-0.633,-0.195l-0.173,-0.273l-0.25,-0.468l-0.834,-0.156l-0.667,0.312l-0.41,-0.663l0.056,-0.626l-0.027,-0.391l0.243,-0.195l0.889,0.156l-0.056,-0.469h-0.667l-0.5,-0.47l-0.111,0.313l-0.389,0.157l-0.167,0.469l-0.166,0.469l-0.299,-0.039l0.604,-2.467h0.472h0.445l0.243,-0.196l-0.104,-0.274l-0.827,-0.51l-0.507,-0.432l-0.361,-0.157h-0.194l-0.583,0.157l-0.584,0.157l-0.167,-0.314h-0.889l-0.111,0.314l-0.584,0.314h-0.472l-0.807,0.471l-0.215,-0.275l0.354,-0.039v-0.157l-0.528,-0.314h-0.417l-0.243,0.196l0.188,0.432l-1.333,0.628h-0.89l-0.277,0.157h-0.417l-0.14,-0.471l0.133,-0.118l-0.354,-0.196l-0.528,0.942l-0.694,0.157l-0.778,-0.157l-0.361,-0.314h-0.667l-0.166,-0.314h-0.39l-0.723,1.568l-0.11,0.313h-0.611l-0.084,0.156l-0.361,-0.156l0.188,-0.196l-0.159,-0.587h-0.473l-0.167,0.157l-0.556,-0.157l-0.299,0.353l0.077,0.274l-0.834,0.157l-1.361,0.313l-0.111,0.313l-0.5,0.313l-0.39,0.157l-0.166,-0.313l-0.341,-0.195l-0.056,-0.392l-0.271,-0.352v-0.313h-0.417l-0.243,1.213l-0.146,0.352l-0.306,0.469l-0.89,0.313l-0.723,0.312l-0.389,0.156h-0.834h-0.667l-0.583,0.156l-1.445,0.156l-0.667,0.624l-0.188,0.506l0.098,0.234l-0.493,0.972l-0.25,-0.778l-0.223,-0.312l-0.632,-0.194l0.215,-0.273h0.473l0.076,-0.663l0.125,-0.858l-0.201,-0.195l-0.417,-0.469l-1.973,0.156l-0.723,-0.156l-0.333,-0.156h-0.473l-0.556,-0.157h-0.223h-0.806h-0.917l-0.917,0.157l-0.306,0.469l-0.361,0.156l-0.166,0.468l-0.473,0.156l-0.25,-0.468l-0.091,-0.586l-0.354,-0.508h-0.361l-0.583,-0.157l0.132,-0.586l-0.493,-0.196l-0.201,-0.039l-0.327,0.039l0.077,0.274l-0.216,0.196l-0.361,-0.157l-0.277,-0.47l-0.223,-0.313h-0.194l-0.091,0.118l-0.215,0.195l-0.694,0.157h-0.39l-0.159,-0.274l0.264,-0.235l-0.028,-0.549l-0.188,-0.51l-0.361,-0.313l-0.271,0.118l-0.174,-1.217l-0.527,-0.157l-0.361,0.314h-0.194l-0.223,-0.157l-0.299,-1.141l-0.035,-0.591l-0.063,-0.749l-0.319,-0.474l-0.167,-0.394l0.042,-0.711l-0.222,-0.791l-0.41,-0.831l-0.473,-0.158l-0.049,-0.594l0.236,-0.237l0.223,-0.635l0.194,-0.635l0.229,-0.755l0.549,-0.198l0.063,-0.756h0.277l-0.076,0.438l0.299,0.198h1.028l-0.14,-0.318l-0.11,-0.478l-0.417,0.159l-0.194,-0.796h-0.361l-0.278,0.159l-1.139,0.159l-0.64,0.956l-0.299,-0.597l0.327,-0.518l0.333,-0.478l0.417,-0.319h0.306l0.639,-0.479l0.778,-0.479l0.194,-0.639l0.035,-0.52l0.159,-0.6l0.167,0.16h1.667l0.271,0.2l-0.82,0.16l0.077,0.44l0.166,0.319l0.077,0.28l-0.438,0.359l0.077,0.279l-0.299,0.359h-0.25l-0.278,-0.479l-0.132,0.04l-0.118,0.279l-0.41,-0.12l-0.034,0.279l0.465,0.358l0.091,0.598l0.167,0.478h0.527l1.001,-0.159l0.444,-0.16l0.473,-0.159l0.159,-0.598l0.208,0.116l0.16,0.322l-0.056,0.159l0.584,0.159l0.061,-0.309l-0.339,-0.168l-0.215,-0.438l0.576,-0.04l0.167,0.16l0.167,-0.479l0.09,-0.199l0.049,-0.758l0.639,0.319l-0.027,0.479l0.778,0.16l0.222,0.638l0.528,0.16l0.056,-0.319h-0.194l-0.243,-0.359l0.235,-0.319l0.368,0.04h0.417l-0.146,-0.598l-1.133,-0.679v-0.16l0.549,-0.2l-0.243,-0.12v-0.32l-0.583,0.16l-0.243,-0.44l0.938,-0.04l0.361,-0.48l0.417,0.32h0.417l0.826,-1.563l-0.604,0.441h-0.277l-0.194,-0.32l-0.077,-0.361l0.104,-0.441l0.389,-0.161l-0.076,-0.281l0.271,-0.361l0.556,0.963l0.493,-0.2l0.306,-0.482l-0.382,-0.442v-0.321l0.076,-0.282l-0.243,-0.362l-0.75,0.161l-0.41,-0.362l-0.201,-0.282l-0.216,-0.362l0.326,-0.605l0.584,-0.322v-0.162l-0.334,-0.484l-0.194,0.323h-0.277l-1.307,-0.807h-0.25l-0.111,0.323h-0.444l-0.215,-0.444l0.271,-0.525l-0.667,-0.486h-0.417l0.223,0.324l-0.223,0.162l-0.438,-0.122l0.021,0.606l0.389,0.484l0.243,0.363l-0.021,0.766l0.277,0.162l0.25,-0.162l0.278,0.162l0.132,0.282l-0.243,0.04l-0.306,0.161l-0.417,0.805l-0.694,0.161l-0.354,0.041l-0.056,0.724l0.375,0.241l0.368,0.281l0.077,0.361l-0.383,0.762l-0.354,-0.361l-0.146,-0.441l-0.167,-0.321h-0.361l-0.639,0.321h-1.945l-0.083,0.321l-0.64,0.642l-0.243,-0.361l0.042,-0.723l-0.299,-0.361l-0.139,-0.482l-0.694,-0.161l-0.028,0.321l0.167,0.804h-0.584l-0.132,-0.201l-0.167,-0.482l0.07,-0.402l-0.792,-2.012l-0.015,-1.049l-0.514,-0.888l-0.451,-1.902l-0.306,0.162l-0.445,-0.162l-0.076,0.202l0.515,0.971v0.486l0.034,0.444l-0.382,-0.202l0.042,-0.243l-0.403,-0.728l0.098,-0.405l-0.32,-0.404l-0.174,-0.77h-0.583h-0.333l-1.112,0.972l-0.438,-0.04l-0.063,-0.284l0.056,-0.324l0.528,-0.162l-0.077,-0.284l0.327,-0.528l0.277,0.163l0.243,-0.203l-0.159,-1.096l0.417,-0.325h0.611h0.333l0.611,-0.325l0.076,-0.774l-0.402,-0.732l0.076,-0.286h0.277l0.39,1.141l0.389,0.326l0.167,-0.164l0.396,-0.203l0.209,-0.163l0.166,-0.082h0.181l0.327,-0.529l0.222,0.489h0.39l0.389,0.326v0.326h0.444l0.528,-0.164l0.694,-0.163l0.278,-0.326l0.354,-0.041l-0.077,-0.448l-0.243,-0.041l0.16,-0.611l0.243,0.204l0.146,0.448l0.278,0.489l0.354,-0.204l-0.077,-0.774l0.473,0.652h0.556l0.445,-0.326l0.36,0.326l0.417,1.14l0.584,0.325l-0.188,0.285l0.243,0.365l0.25,-0.162l0.639,0.325l0.216,-0.203l0.014,-1.546l0.243,-0.203h0.473l0.132,-0.366l-0.243,-0.449l-0.278,0.163l-0.5,-0.489l-0.076,-0.449l0.243,-0.368l0.333,0.327l0.806,0.164l0.557,0.652l0.5,0.163l0.166,0.326l0.417,-0.163l0.111,0.326h-0.306l-0.243,0.285l0.188,0.53h0.223l0.215,0.366l-0.181,1.219l0.41,0.203l0.25,-0.163l0.201,0.284l0.486,0.893l0.611,0.648l0.598,1.214l0.243,0.364l0.278,-0.162l0.361,0.323l-0.188,0.283l0.277,0.565l0.132,0.282l0.64,0.323l0.166,-0.646l0.39,0.646h0.417h0.333l0.639,-0.484l0.133,-0.363l-0.354,-0.283v-0.323l0.021,-0.364v-0.485L379.407,280l0.465,-0.364l0.14,-0.648l-0.167,-0.162l-0.194,0.162l-0.243,-0.365l-0.285,-0.447l-0.111,-0.325l0.473,-0.162l0.277,0.487h0.557h0.306l0.444,0.487l0.583,0.162h0.445l0.271,-0.447l-0.604,-0.365v-0.325l-0.583,-0.65l-0.778,-0.163l-0.417,-0.163l-0.389,-0.325l-1.084,0.163l-0.382,-0.366l-0.056,-0.408l0.159,-0.203l-0.527,-0.326l-0.444,0.163l-0.223,-0.326l-0.354,-1.019l0.021,-0.449l-0.216,-0.368l-0.042,-1.063l-0.458,-0.409l-0.341,-1.926l-0.493,-1.026l-0.034,-0.453l0.063,-0.699l0.208,-0.741l-0.611,-2.144l-0.319,-0.909l0.097,-0.911l-0.188,-0.372l0.195,-0.166l0.444,0.332l0.132,-0.042l-0.076,-0.29l1.056,0.166l0.389,0.662h0.89l0.277,0.165l0.056,0.331h-0.277l0.166,0.662l0.557,0.496l0.5,0.825l0.451,0.454l0.299,0.701l0.09,0.617L380.019,268.991zM443.762,255.068l0.604,0.376l0.493,0.877l-0.181,0.501l0.111,0.584l0.243,0.042l0.278,0.833l0.576,0.375l0.028,0.417l-0.292,0.249l0.097,0.582l-0.715,0.54l-1.14,-0.333h-0.222h-0.611l-0.167,-0.665l-0.493,-0.208l0.215,-0.625l0.216,-0.042l-0.181,-0.333l0.027,-0.583l0.515,-1.585l-0.042,-0.752l0.382,-0.042l-0.056,-0.334L443.762,255.068zM363.124,267.264l-0.091,-0.206l-0.111,0.329h-0.444l-0.076,-0.37l0.208,-0.165l-0.104,-0.289l0.223,-0.165l0.278,0.165l0.11,-0.33l0.188,-0.041l-0.216,-0.619l-0.41,-0.041l0.265,-0.825l-0.098,-0.248l0.604,0.124l0.223,-0.661h0.166l0.327,-0.538l-0.077,-0.786h0.167l0.306,-0.497h0.333v-0.166l-0.409,-0.041l0.076,-0.29h0.333l0.077,-0.208l-0.188,-0.457h0.277l0.167,0.332h0.223l0.277,0.498h0.389v0.332l0.834,0.166v0.332h0.389l0.056,0.166l0.278,-0.166v0.331l0.667,0.166l0.167,0.331l0.277,-0.165l0.299,0.703l-0.049,0.455l0.223,0.33l0.299,-0.124l0.056,0.413l-0.188,0.042l0.021,0.454l-0.264,0.247l0.132,0.289h0.944v-0.495h0.444l0.133,0.206v0.578l-0.188,0.041l-0.222,0.659l-0.584,-0.165l-0.688,0.535l0.326,1.604h-0.166l-0.167,0.493l-0.444,0.328l-0.417,-0.164l-0.444,0.82l-0.445,-0.82h-0.277l-0.216,0.205l0.077,0.287l-0.188,0.041l0.077,0.287l-0.5,0.164l0.076,-0.943l-0.243,-0.369h-0.223v-0.329h-0.222l-0.695,-0.822l-0.806,-0.165l-0.25,-0.658l-0.389,-0.165l0.083,0.329h-0.444L363.124,267.264zM546.457,284.964l-0.64,0.322l-0.777,0.161l-0.501,0.321l-0.222,0.322l-0.64,0.161h-0.583l-1.39,-1.287l-0.889,-1.933l-0.452,-0.283l-0.188,-0.524l0.174,-0.524l0.027,-0.729l0.41,-1.335l0.535,-1.582l0.549,-1.015l0.417,-0.488l0.806,-1.466l1.334,-0.978l1.278,-0.817l0.833,-0.654l0.861,-0.654l0.834,-0.655l0.806,-0.82l0.806,-1.477l0.5,-0.329l0.945,-0.822l0.527,-0.329l1.945,-0.823l0.751,-0.165l1.861,-0.99l0.861,-0.33l1,-0.33h1.418h0.666l1.445,0.66l1.195,0.825l0.194,0.494l0.139,0.329l0.743,0.535l0.417,0.986l0.118,1.109l0.473,0.328l0.861,0.492h0.5l0.889,0.164l-0.048,0.287l0.326,0.369h0.333l0.16,0.368l-0.104,0.287l-0.854,0.858l-0.027,0.409l0.292,0.245v0.898l-0.111,0.489l-0.604,1.018l-0.799,1.667l0.41,0.771h-0.445l-0.111,-0.325h-0.5l-0.5,-0.162l-0.139,0.324l-0.417,0.163l-0.917,-0.163l-0.778,0.487l-0.139,0.324l-1,0.324l-1.167,0.324l-0.667,0.162h-0.64h-0.75h-0.639l-0.528,0.324l-1.056,0.81l-1.39,0.485h-1.084l-0.889,-0.162l-0.778,0.162l-1.194,0.323l-0.917,1.13l-1.168,0.967l-1,0.644L546.457,284.964zM611.014,277.324l0.792,0.406l0.194,0.569l-0.382,0.365h-0.278l0.056,-0.325l-0.611,0.163l-0.299,-0.365l-0.007,-0.609h0.223l0.166,-0.325L611.014,277.324zM493.112,282.83l-0.028,-0.404l-0.166,-0.888l0.041,-0.567l-0.458,-0.323l0.16,-0.364l0.146,-0.283l0.16,-0.364h0.361l0.055,-0.486l0.306,-0.324h0.445l0.104,0.284l-0.152,0.324l0.188,0.364l0.444,0.162l-0.027,0.324l0.361,0.162l0.11,-0.324l0.361,-0.162l0.354,0.364l-0.236,0.485l0.188,0.445l0.445,0.162l0.639,0.323l0.25,0.162l0.584,0.484l0.104,0.605l-0.354,0.041l-0.104,0.201l-0.014,1.048l-0.473,0.644l-0.375,0.402l-0.452,0.282l-0.639,0.482l-0.417,-0.161l-0.473,-0.322l-0.5,-0.644l-0.333,-0.322l-0.354,-1.006L493.112,282.83zM267.084,316.962l0.361,-0.309l0.063,0.27l0.521,0.193l0.25,0.309L268.55,317l-0.542,-0.231l0.132,-0.425l0.473,0.154l0.5,0.31l-0.021,0.733l0.354,0.347l0.882,-0.501l0.729,0.038l0.611,-0.154l0.479,0.347l0.625,-0.154l0.361,0.463l0.201,0.424l0.417,0.154l0.417,-0.309l0.278,-0.154l0.354,0.116l0.306,-0.849l-1.903,-1.159l-0.069,-0.541h-0.598l-0.118,0.271l-0.778,-1.083l-0.243,-0.503l-0.333,-0.621l-0.236,-0.465l0.479,-0.116h0.417l0.306,0.155l0.048,-0.893l-0.215,-0.194h-1.111l-0.299,-0.194l-0.444,-1.012h0.458l0.785,0.583l0.243,-0.272l-0.792,-0.544l-0.125,-0.39l-0.569,-0.155l-0.195,-0.624l0.167,-0.78l0.243,-0.195l0.507,0.429l0.431,-0.078l0.222,0.546l-0.069,0.468h0.458l0.028,-0.234l-0.278,-0.857l-0.125,-0.234l0.264,-0.625l-0.695,-0.469l-0.688,-0.195l-0.021,-0.9l0.271,-0.195l0.889,0.313l0.111,0.313l0.493,0.039l0.125,0.392l0.382,-0.118l-0.299,-0.352l0.215,-0.744l0.535,0.9l0.25,0.313l0.382,0.195l0.09,0.586l0.236,0.313l0.868,0.351l0.188,-1.054l-0.264,-0.078l-0.09,-0.587l0.271,-0.431l-0.458,-0.704l0.208,-0.313l-0.056,-0.549l-0.292,-0.078l-0.083,-0.393h0.458l0.257,0.275l0.278,0.157l0.354,-0.039l-0.125,-0.236l0.375,-1.02l0.042,-1.022l0.32,-0.078l0.118,-0.276l1.417,0.157l0.007,-0.433l0.514,-0.315l0.5,0.629l-0.056,0.394l-0.083,0.314l0.035,0.196l0.326,0.354l0.223,0.55l-0.223,0.313l-0.25,0.471l-0.827,0.196l0.063,0.431l0.223,0.47l0.431,0.078l0.264,-0.47l0.771,0.587l0.223,-0.313l0.493,0.822l-0.028,0.235l-0.347,0.078l-0.167,0.157l-0.201,0.274l-0.049,0.195l0.188,0.273l0.473,-0.156l0.076,0.118l-0.083,1.092l-0.354,-0.273l-0.41,0.195l0.153,0.858l-0.653,0.078l-0.056,0.39l0.549,0.039l0.194,-0.156l0.723,0.156l0.417,0.312l0.243,0.583l-0.473,-0.078h-0.153l-0.264,0.544l-0.354,0.039l-0.327,0.35l0.083,0.389h0.306l0.854,0.194l-0.604,-0.66l0.604,-0.117l0.202,-0.039l0.569,0.078l-0.375,0.544l0.208,0.466l0.167,0.542l-0.028,0.233l-0.431,0.621l0.521,0.348l0.118,0.271l0.25,0.232l0.604,0.116l0.271,-0.502l-0.097,-0.388l0.319,-0.775l-0.299,-0.504l0.077,-0.737l-0.236,-0.311l0.132,-0.194l0.354,0.039l0.479,0.583l0.118,1.203l0.542,0.232l0.042,0.698l0.243,0.503l0.667,0.155l0.354,-0.813l-0.083,-1.939l-0.403,-1.632l-0.368,-1.051l-0.09,-0.585l-0.986,-0.39l0.028,-0.234l0.299,0.117l0.046,-0.182l-0.317,-0.716l-0.056,-0.469l-0.278,-0.86l0.042,-0.392l-0.486,-0.626l0.104,-0.196l0.146,-0.196l0.264,-0.471l-0.069,-0.55l0.299,-0.196l0.035,0.275l0.306,-0.079l0.069,-1.1l-0.236,-0.235l-0.028,-0.708l0.521,0.275l0.306,-0.157l0.333,0.157l-0.16,0.276l0.66,0.511l0.243,-0.433l-0.236,-0.315h0.931l0.306,0.787l-0.181,0.236l0.875,0.942l-0.708,0.392l-0.125,0.549l-0.348,0.235l-0.028,0.235l0.271,-0.118l0.25,-0.157l0.333,0.47l0.132,-0.509l-0.125,-0.235l0.298,-0.196l0.16,0.196l0.055,0.47l0.083,0.313l-0.097,0.705l0.271,-0.117l0.417,0.156l0.132,0.352l-0.208,0.313l-0.174,0.273l-0.271,0.43l0.083,0.313l0.215,0.039l0.118,-0.273l0.347,-0.078l0.479,-0.273l0.257,-0.273l0.521,-0.352l0.313,-0.587h0.292l0.174,0.431l0.472,-0.157l0.473,0.313l0.577,-0.352l0.674,-0.587l0.007,-0.431l0.66,-0.196l0.396,-1.059l0.806,-0.785l0.778,-0.628l0.854,0.275l0.778,-0.157l1.438,-1.141l0.514,-0.866l0.744,-0.197l0.583,0.158l0.604,-0.197l0.479,-0.434l1.528,-0.315l0.445,-0.474l0.694,-0.315l0.466,-0.355l0.007,-0.435l0.306,0.158l0.173,0.276l0.542,0.237l0.535,0.908l-0.077,0.591l0.32,0.551l0.278,0.787l-0.014,0.866l0.327,0.354l0.25,0.314l0.216,0.589l-0.167,0.628l-0.57,0.47l0.056,0.47l0.25,0.313l-0.007,0.195l-0.354,0.508l-0.229,0.431l-0.007,0.586l-0.403,0.39l-0.083,0.391l0.431,0.078l0.083,0.39l-0.194,0.156l-0.5,0.78l-0.764,0.544l-0.583,0.467l0.181,0.544l-0.91,0.661l0.063,0.427h0.292l-0.25,0.465l-0.271,0.039l-0.361,-0.466l-0.361,0.311l-0.417,-0.466l-0.583,0.155l-1.389,-0.155l-1,-0.466l-0.611,0.155l-0.194,-0.466l-0.611,-0.311l-0.354,0.039l-0.417,0.467l-0.097,0.389l-0.271,0.194h-0.945h-0.361h-0.723l-0.577,0.814l0.299,0.582l-0.035,0.427l-0.278,0.464l-0.167,0.155l-0.542,0.231l-0.417,0.464l-0.479,1.044l-0.722,0.617l-0.167,-0.154l-0.5,0.154l-0.035,0.733l-0.542,0.385l-0.417,0.463l-0.313,0.115l-0.215,0.192l1.132,0.27l-0.174,0.192l-0.41,-0.039l-0.382,0.192l-0.042,0.23l-0.486,0.077l-0.201,0.423h-0.278l-0.667,-0.615l-0.833,0.615h-0.473l-0.868,-0.73l-0.438,-0.039l-0.09,0.423l-0.514,0.308l0.854,0.192l0.257,0.423l0.194,0.46l0.688,0.039l0.16,0.191l-0.208,0.384l0.028,0.613l-0.118,0.038l-0.938,0.498h0.597l0.528,0.46l-0.299,0.268l0.16,0.421l-0.486,0.153l-0.229,-0.115l-0.16,0.573l0.375,0.229l0.063,0.268l0.778,0.153l0.167,-0.306l0.118,-0.267l0.41,0.114l0.778,-0.152l0.25,0.152l0.285,-0.42l0.104,-0.191l-0.048,-0.727l0.208,-0.229l0.34,-0.268l0.243,-0.422l-0.736,0.077l-0.055,-0.537l0.91,-0.191l0.521,-0.038l0.25,-0.46l-0.236,-0.384l0.354,-0.5l0.521,0.038l-0.028,0.845l-0.208,0.229l0.028,0.69l0.938,0.191l0.646,-1.188l1.056,-0.614l0.299,-0.653l0.722,-0.153l0.361,-0.308h0.472h0.389l0.695,0.154l0.354,-0.116l0.368,0.116l0.417,0.307h0.639l0.417,0.154l0.194,-0.307l0.09,-0.116l0.653,-0.154l0.056,0.539l-0.236,0.307l0.632,0.346l0.361,0.46l0.076,0.575l-1.07,1.302l-0.153,0.689l-0.688,0.955l0.104,0.268l-0.521,0.191l-0.472,-0.306l-0.66,0.726l0.083,0.305l0.403,0.076l0.167,0.686l-0.32,0.685l0.028,0.609l-0.389,0.38l0.195,0.456l0.354,0.19l0.09,-0.874l0.604,-0.19l-0.202,0.418l-0.069,1.063l0.632,0.342l0.354,-0.114l0.306,0.607l-0.153,0.228l0.208,0.909l0.174,0.492l0.215,-0.189l-0.097,-0.82l0.549,0.101l0.076,-0.265l-0.139,-1.366l-0.431,-0.683l-0.083,-0.38l0.083,-0.304l0.055,-0.304h0.292l0.674,0.267l0.417,0.152l-0.021,0.418l0.382,0.645l0.111,0.152l0.299,-0.341h0.153l0.681,0.835l0.264,0.38l0.5,1.061l0.549,0.643l-0.035,0.266h-0.431l0.528,1.662l0.188,0.188l0.222,-0.151l0.299,0.038l0.25,0.151l0.778,0.68l-0.431,0.603l0.708,0.753l-0.604,0.188l-0.132,0.415l0.139,0.601l0.223,0.976l-0.111,1.126l0.194,0.973l-0.229,0.861l-0.063,0.411h-0.292l0.056,0.448l0.333,0.448l0.438,-0.262l0.473,0.149l0.424,-0.56l0.819,-0.224l0.334,-0.823l0.333,-0.673l-0.069,-0.375l0.764,-1.274l0.028,-0.826l-0.361,-1.655l-0.382,-0.64l-0.341,-0.716l-0.854,-0.642l-0.076,-0.415l0.361,-0.302l0.097,-0.453l-0.569,-0.756l0.375,-0.833l0.25,-0.455l0.028,-0.228l-0.41,-0.493l-0.229,-1.177l-1.319,-1.444l0.326,-0.115l0.271,-0.571l-0.111,-0.762l-0.66,-0.801l0.035,-0.42l-0.097,-0.917l-0.264,-0.153l0.111,-0.459l0.111,-0.46l0.299,-0.038l0.077,-0.191l0.056,-0.383l-0.208,-0.307l0.25,-0.46l0.542,-0.23l0.833,-0.921l0.348,-0.846l0.111,-0.461l0.223,-0.308l0.222,-0.308l0.66,0.27h0.361l-0.076,-0.27l0.243,-0.193l0.701,0.654l0.236,-0.23l0.027,-0.848l-0.36,-0.462l-0.57,-0.077l-0.527,-1.003l0.382,-0.348l0.118,-0.425l0.556,-0.464l0.438,0.116l-0.201,-0.426l-0.265,-0.077l0.375,-1.007l-0.208,-0.465l0.64,-0.62l0.444,-1.243l0.458,-0.544l-0.069,-0.389l0.611,-0.623l0.382,-0.039l0.188,0.272l-0.291,0.623l0.326,0.35l0.063,-0.739l0.278,-0.467l0.652,-0.077l-0.465,-0.584l-1.028,0.467l-0.049,-0.506l0.223,-1.014l0.083,-0.295l0.139,-0.642l0.111,-0.469l0.598,-0.391l0.25,-0.548l-0.014,-1.097l0.604,-0.196l0.056,-0.314h0.36l0.334,0.471h0.611h0.361l1.229,0.196l0.299,-0.039l0.243,0.353l-0.014,0.157l0.18,0.47l0.223,0.313l0.194,0.469l0.042,0.548l0.736,0.702l0.194,0.468l0.319,0.702l0.417,0.78l0.348,0.467l-0.264,0.389l0.055,0.389l0.584,0.777l0.438,-0.117l0.021,0.738l-0.235,0.31l0.056,0.465l0.286,0.533l0.484,0.9l0.16,0.193l0.139,0.619l-0.083,0.309l-0.042,0.387l0.264,0.618l0.341,0.347l0.479,1.35l1.125,0.308l-0.473,1.23l0.195,1.076l-0.195,0.767l-0.235,0.307l0.215,0.651l0.361,0.459l0.076,0.421l-0.375,0.229l-0.333,0.841l0.326,0.19l0.076,0.573l-0.458,0.61l0.215,0.19h0.417l0.827,-0.115l0.319,0.686l0.139,0.609l0.361,0.913l0.493,0.19l-0.576,0.722l0.215,0.189l0.361,-0.303l0.188,0.114l-0.417,0.835l-0.125,0.683l0.375,0.741l-0.208,0.244l0.027,0.53l0.14,0.605l0.222,0.302l0.084,0.226l-0.167,0.604l-0.028,1.283v0.602l0.188,0.188l0.146,0.866l0.598,0.977v0.676l-0.32,0.075l-0.055,0.226v0.6l0.298,0.337l1.084,-0.15l-0.243,0.562l0.604,0.337l-0.354,0.412l0.14,0.599l0.027,0.373l0.25,0.821l0.243,0.187l0.271,-0.485l-0.097,-0.224l0.465,-0.187l-0.409,1.157l0.354,0.187l0.11,0.596l0.479,0.707l0.334,0.447l0.431,0.521l-0.278,1.115l-0.236,0.297l0.354,0.185l0.076,0.408l-0.632,0.186l-0.299,0.482l0.098,0.814l-0.473,0.592l-0.25,0.444l-0.486,1.329l-0.139,0.958l0.319,0.442l-0.264,0.442l-0.223,0.368l0.299,0.331l0.778,0.441l0.306,-0.294l0.409,-0.037l-0.014,-0.515l0.139,-0.589l0.25,-0.885l0.41,-0.479l0.146,-0.554l0.494,-0.479l0.229,0.701l0.723,0.59l0.243,-0.111l0.132,0.249l-0.208,0.305l0.181,0.884l0.375,0.883l0.639,0.882l0.466,0.33l-0.271,1.578l0.681,0.659l-0.015,0.659l0.195,0.878l0.181,0.365l-0.028,0.657l-1.042,0.146l0.576,0.328l0.494,-0.11l-0.015,0.657l0.493,0.182l0.216,0.328v0.655l-0.236,0.291l0.514,0.728l-0.409,0.036l-0.076,0.254l0.354,0.182l0.743,0.472l-0.055,0.218h-0.265l0.361,0.725l0.959,0.652l-0.069,0.362l0.194,0.29l0.271,-0.108l0.049,0.542l-0.208,0.29l0.416,1.012l0.354,0.036l0.584,0.577l0.354,-0.036l0.84,-0.108l0.417,-0.289l0.188,-1.265l-0.792,-0.723l0.57,-1.014l-0.682,-0.072l-0.117,-0.979l-0.494,0.036l0.042,0.363h-0.292l-0.194,-0.363l0.153,-1.162l-0.167,-0.437l-0.41,-0.327l0.188,-0.328l0.084,-0.364l-0.028,-0.437l-0.465,0.109l-0.035,-0.328l-0.042,-0.949l0.265,-0.438l-0.417,-0.584l0.063,-0.768l0.021,-0.548l-0.409,-0.476l-0.035,-0.549l-0.111,-1.174l-0.194,-0.44l-0.056,-0.22l-0.027,-0.515l-1.001,-1.177l-0.215,0.11l-0.299,-0.184l0.056,-0.369l0.361,-0.147l0.097,-0.442l-0.681,-2.732l-0.056,-0.962l-0.111,-1.705l-0.235,-1.412l-0.334,-0.893l-0.333,-1.043l-0.584,-1.045l-0.5,-0.896l-0.431,-1.197l0.319,-0.599l-0.139,-1.2l-0.403,-2.254l0.236,-0.903l-0.625,-0.979l0.056,-0.831l0.049,-0.34l0.271,-0.793v-1.135l-0.542,-0.682l-0.027,-1.138l0.236,-0.304l-0.348,-1.52l0.319,-0.609l-0.111,-0.761l-0.438,-0.343l-0.299,-0.191l-0.007,-0.419l0.035,-0.268l0.375,-0.229l-0.375,-1.452l0.694,-0.229l0.716,0.497h0.473l0.305,-0.153l1.945,0.765l0.104,-0.268l-0.223,-0.306l-0.416,-0.153l-0.417,-0.153l-2.077,-0.497l-0.063,-0.575l-0.986,-0.307l-0.125,-1.842l-0.216,-0.192l-0.326,-0.577l0.264,-0.461l-0.514,-0.924l0.166,-0.617l0.14,-0.462l0.299,-0.193l0.416,0.154l0.077,-0.116l-0.466,-0.347l0.049,-0.425l-0.361,-0.309l-0.938,0.271l-0.049,-0.58l0.382,-0.348l0.104,-0.426l-0.056,-0.31l-0.139,-0.619l-0.521,-1.279l0.056,-1.398l-0.361,-1.556l-0.007,-0.741l-0.028,-0.468l-0.291,-0.625v-0.625l-0.056,-0.938l0.159,-0.195l-0.09,-0.744l-0.41,-0.509l-0.049,-0.588l0.265,-0.392l-0.098,-0.864l-0.056,-0.235v-0.708l0.054,-0.774l0.433,-0.406l-0.292,-1.341l0.133,-0.197l0.117,-0.119l0.417,-0.315l0.243,-0.197l1.14,0.158l0.368,-0.593l0.271,-0.039l-0.021,0.277l0.549,0.671l0.306,-0.158l0.778,0.158l0.813,0.276l0.771,0.355l0.743,-0.198l0.056,-0.158l-0.375,-0.316l-0.39,-0.315l-0.083,-0.396l0.431,-0.474l-0.056,-0.316l-0.75,-0.079l-0.327,0.197l-0.215,-0.514l0.069,-0.396l-1.015,-1.347l-0.194,-0.556l0.153,-1.032l0.083,-0.397v-0.637l-0.069,-0.796l0.111,-0.478l0.409,-0.837h0.306l0.271,-0.359l-0.264,-0.241l0.541,-0.719l-0.514,-0.56l0.569,-0.88l-0.041,-0.401l0.354,-0.2l0.368,-0.12l0.598,-0.401l0.306,-0.481l0.111,-1.045l0.479,-0.201l0.527,-0.804l0.216,0.04l-0.042,0.242l0.521,0.201l0.333,-0.161l0.466,0.362l-0.098,0.402l0.521,0.04h0.694l0.5,0.482l0.223,-0.161l0.528,-0.161l0.382,1.084l-0.028,0.641l0.084,1.442l-0.403,0.24l0.153,0.56l-0.306,-0.081l-0.375,-0.239l-0.341,0.04l-0.326,0.599l0.75,0.16l0.348,0.48l-0.493,0.04l-0.243,0.279l0.465,0.359l0.368,0.12l0.319,0.398l-0.083,0.398l-0.41,0.04l-0.277,-0.319h-0.334l-0.166,0.16l0.063,0.757l0.632,-0.12l0.063,0.438l0.576,0.517l0.917,-0.477l0.327,0.199l0.139,0.716l-0.083,0.318l-0.223,0.159l-0.014,1.27l0.799,0.832l0.034,0.594l0.14,0.633l0.354,0.039l0.299,0.355l-0.069,0.869l0.493,0.355l0.834,-0.158l0.723,0.158l0.306,-0.315l-0.104,-0.75l0.292,-0.395l-0.028,-0.554l-0.375,-0.237l-0.201,-0.277l-0.229,-1.069l-0.375,-0.317l0.083,-0.317l0.403,-0.238l0.319,-1.669l0.326,-0.04l0.723,-0.637h0.834l0.194,0.159l1.077,0.04l0.639,0.478l0.348,0.557l1.271,0.834l0.632,0.675l-0.069,0.873l0.444,0.633l0.354,0.198l1.028,0.317h0.777l0.424,0.909l0.89,1.263l0.431,0.631l0.167,0.394l0.5,1.023l-0.271,0.669l-0.5,-0.157l-0.611,0.157l-0.493,-0.196l-0.389,0.314l0.549,0.511h0.527l0.479,0.589l0.438,0.353l0.979,0.118l0.375,0.706l0.265,0.235l0.333,0.47l0.375,0.235l-0.125,1.487l0.334,0.468l0.848,0.702l0.139,1.637l-0.208,0.156l0.027,0.467l0.438,0.35l-0.299,0.661l0.181,0.389l-0.903,-0.078l-0.313,0.582l-0.007,0.427l-0.653,0.077l-0.201,0.271l-0.222,0.155l0.313,0.582l0.236,0.077l0.027,0.542l-0.348,0.077l-0.639,1.083l0.152,0.542l-0.11,0.309l-0.736,0.385l0.188,0.27l0.215,-0.038l0.069,-0.232h0.292l-0.139,0.54l-0.306,0.462l-0.542,0.231l-0.153,0.54l-0.194,0.154l-0.652,0.077l0.083,0.846l0.236,0.077l-0.084,0.385l-0.36,0.615l-0.32,0.076l-0.25,0.307l0.111,0.23l0.111,0.613h0.458l-0.361,0.613l-0.319,0.076l-0.139,0.459l-0.25,0.842l0.799,0.038l0.223,-0.153l0.409,0.344l-0.264,0.458l0.403,1.069l0.472,0.458l-0.027,0.229l-0.021,0.343l0.133,0.647l0.027,0.533l-0.027,0.608l-0.354,0.949l0.007,0.722l0.208,0.303l-0.194,0.606l-0.319,0.53l-0.223,0.757l-0.431,0.302h-0.431l-0.125,0.982l-0.486,0.528l-0.083,0.302l-0.028,0.679l0.473,0.452l0.528,0.752h0.444l0.466,0.188l0.715,-0.64l0.153,-0.527l0.271,-0.188h0.528l0.313,-0.489l0.41,-0.415l0.063,-1.17l0.306,-0.454l0.361,-0.757l0.298,-0.492l0.229,-0.719l0.604,-0.493l0.216,-1.101l-0.042,-1.901v-0.38v-1.601l0.139,-1.375l0.056,-1.225l0.278,-0.919l0.521,-0.191l0.104,-0.882l-0.348,-0.23l-0.056,-0.384l0.716,-0.346l0.132,-0.423l-0.236,-0.154l0.25,-0.308h0.445l0.326,-0.192l0.035,-0.424l0.298,-0.192l0.25,0.154l0.521,0.5l-0.042,0.231l0.765,0.384l0.451,0.423l0.508,0.576l0.882,0.192l0.09,0.576l0.709,0.537l0.341,0.269l0.25,0.613l0.729,0.881l0.514,0.229l-0.139,0.994l-0.292,0.458l0.348,0.763l-0.542,0.229l-0.098,0.838l0.146,0.343l0.75,-0.152l0.417,0.457l0.611,-0.153l0.326,0.495l-0.111,0.38l-0.333,0.608l-0.209,0.076l-0.083,0.38l0.056,0.304l0.431,0.379l0.027,0.531l-0.208,0.151l0.223,0.303l0.291,-0.076l0.194,0.379l-0.125,0.454l0.153,0.908v0.831l-0.098,0.378l0.223,0.679l0.098,0.679l-0.14,0.452l-0.236,0.226l0.376,0.678l-0.251,0.225l-0.465,-0.188l-0.271,0.188l-0.139,0.526l0.486,0.225l0.361,0.75l0.111,0.676l-0.194,0.15l-0.383,0.337l-0.549,0.187l0.188,0.262l0.333,-0.149l0.326,0.486l-0.111,0.375l-0.375,0.224l-0.139,0.524l0.542,0.15l-0.694,1.194l-1.07,0.522l-0.889,0.97l0.027,0.446l0.125,0.447l-0.125,0.447l0.966,0.483l0.777,-0.149l0.473,0.446l0.368,-0.557l0.354,-0.037l0.896,0.78h0.125l0.284,0.409l-0.451,1.594l-0.348,0.518l0.056,0.37l0.466,0.037l0.188,0.259l-0.354,0.333l0.049,-0.407h-0.431l-0.194,1.109l0.326,0.185l0.076,0.406l-0.306,0.443l-0.409,-0.111l-0.063,0.701l-0.236,0.294l0.743,-0.11l0.194,-0.295l0.326,0.037l-0.041,0.664l0.965,0.919l-0.021,0.258l1.16,0.184l0.528,-0.294h0.527l0.383,-0.184l0.277,-0.441l0.695,-1.178l0.139,-0.517l-0.181,-0.295l0.083,-0.295l0.167,-0.886l0.139,-0.444l0.799,-0.48l0.591,0.407h0.125l-0.042,-0.37l0.375,0.148l0.015,0.519l0.291,0.369l-0.236,0.37l0.188,0.185l0.472,-0.148l0.306,0.443l0.299,0.479l-0.042,0.222l0.501,0.737l1.188,0.332l0.444,-0.294l0.64,0.441l0.306,0.442l0.159,0.552l-0.056,0.588l-0.18,0.147l-0.056,0.587l0.431,0.44l-0.195,0.586l-0.326,0.037l-0.243,0.33l-0.368,0.257l-0.382,0.695l0.466,0.183l0.034,-0.403h0.403l0.208,0.805l0.569,0.365l0.167,0.439l-0.931,1.095l0.486,0.218l0.042,0.365l0.25,0.146l0.438,-0.11l0.382,0.183l0.027,0.364l0.056,0.655v0.509l-0.688,0.037l-0.132,0.254v0.437l0.25,0.581l0.194,0.291l0.403,0.362l-0.181,0.653l0.326,0.182l0.104,-0.182l0.069,-1.524l0.278,0.073l0.235,-0.364l-0.235,-0.072l-0.008,-0.255l0.195,-0.291l0.243,0.037l0.152,0.509l0.236,0.146l-0.132,0.181l-0.118,0.109l-0.25,0.291l-0.459,0.072l0.14,0.508l0.271,0.036l0.333,-0.29l0.167,-0.145l0.257,-0.109l0.299,-0.036l0.361,-0.436l0.313,0.254l0.515,0.072l0.542,0.653l0.549,0.036l0.159,-0.544l-0.458,-0.218l0.056,-0.654l0.333,-1.019l0.243,-0.036l0.285,0.691l0.25,0.582l0.777,0.291l0.223,0.581l0.569,0.362l0.861,0.435l0.473,0.291l0.507,0.543l0.021,0.543l-0.466,0.036l-0.215,0.253l0.222,1.879l0.167,0.289l0.473,0.722l0.409,0.324l0.258,0.684l0.75,0.288l0.271,-0.108l0.521,0.611l0.208,0.792l0.792,0.144l0.667,-0.288l0.424,-0.108l0.584,-0.144h0.861l0.306,0.575h0.416l0.751,-0.144l0.306,0.287l0.09,0.395l0.438,0.323l0.341,-0.539l0.243,-0.036l-0.076,0.395l0.521,0.323l0.41,0.609l-0.098,0.359l0.167,0.286l1.271,0.179l0.521,0.823l-0.111,0.286l-0.493,0.179l-0.271,0.322l-0.056,0.214l0.334,0.286l0.347,0.5l0.25,0.856l-0.076,0.535l0.132,0.534l-0.25,0.711l-0.402,0.711l0.277,0.426l0.431,-0.071l0.167,0.781l-0.167,0.426l-0.25,0.284l-0.549,0.177l-0.25,-0.142l-0.299,0.673l0.278,0.425l0.993,0.318l0.194,-0.283l0.382,0.177l-0.194,0.638l-1.049,-0.531h-0.306l-0.361,0.424h-0.473l-0.833,-0.424l-0.195,-0.283l-0.242,0.248l0.485,0.495l-0.055,0.637l-0.306,0.424l-0.521,0.035l-0.354,-0.317l-0.041,-0.354l-0.854,-0.602l0.034,-0.672l1.042,-0.142l-0.736,-0.708l-0.069,-0.567l-0.326,-0.177l-1.133,0.319l-0.708,-0.425l-1.021,-0.035l-0.479,0.674l-0.743,0.318l-0.382,-0.318l-0.32,-0.781l-0.458,-0.213l-0.181,-0.355l-1.188,-0.461l0.048,0.533l-0.25,0.284l-0.444,0.426l-0.41,0.177l-0.722,-0.142l-0.306,0.284l-0.417,-0.284l-0.257,-0.106l-0.376,-0.142l0.125,0.425l-0.125,0.071h-0.291l-0.306,0.426l-0.278,0.85l-0.333,0.566l-0.515,0.212l-0.444,0.848l-0.027,0.212l0.222,0.141l0.403,-0.071l-0.223,0.776l-0.854,0.176l-0.201,-0.529l-0.243,-0.035l-0.229,1.517l-0.382,-0.528l-0.229,0.247l-0.438,0.176l0.104,-0.458l0.027,-0.495l-0.854,-0.317l0.091,0.529l-0.084,1.057l0.125,0.493l-0.25,0.282l-0.521,0.175l-1.028,-0.422l-0.035,0.387l-0.576,0.175l-0.083,-0.281l-0.41,0.316l-0.153,0.493v0.421l-0.25,0.281l-1.604,0.877h-0.556l-0.632,-0.035l-0.042,-0.351l-0.375,-0.07l-0.056,-0.352l0.299,-0.175l-0.188,-0.527h0.264l0.424,0.246l0.146,0.246l0.473,0.281l0.216,0.035l0.243,-0.246l-0.14,-0.351h0.153l0.41,0.175l0.188,-0.316l-0.195,-0.352l-0.333,-0.21l-0.083,-0.212l-0.327,-0.035l-0.5,-0.422l-0.528,0.563l-0.833,-0.141l-1.133,0.739l0.39,0.632l0.326,0.035l0.576,0.456l0.195,0.28v0.492l-0.271,0.175l-0.465,-0.035l-0.174,-0.245l-0.278,-0.421l-0.188,0.526l0.306,0.28l0.181,0.28l-0.438,0.175l-0.5,-0.14l-0.334,-0.28l0.021,-0.667l0.618,0.246l0.215,-0.667l-0.549,-0.316h-0.306l-0.306,-0.281l-0.284,0.386l-0.515,0.21l-0.083,0.772l0.069,0.561l0.167,0.35l0.194,0.7l-0.389,1.189l-0.716,-0.105l-0.194,0.14l-0.723,-0.279l-0.556,-0.559l-0.25,-0.28l-0.584,0.141l-0.549,0.314l-0.917,1.955l0.243,0.523l0.007,-0.383l0.292,-0.14l0.181,0.488l0.403,0.348l-0.32,0.557l0.056,0.348l0.236,0.557l-0.598,0.557l0.883,0.59h0.527l0.077,0.729l0.194,1.109l0.069,0.762l0.576,0.173l0.91,1.555v0.415l-0.069,0.759l0.181,1.033l0.028,0.275l-0.292,0.138l0.027,0.344l0.383,-0.103l0.215,0.309l-0.299,0.104l-0.063,0.653l-0.764,0.205l-0.431,0.481l-0.604,-0.103l-0.556,0.549l-0.883,-0.034l0.466,0.582l0.229,-0.239l0.597,-0.138l-0.347,1.097l0.139,0.479l0.625,0.479l0.069,1.162l0.278,0.41l0.889,1.5l0.236,-0.068l0.194,0.682l-0.291,0.545l0.125,0.476l-0.348,0.681l-0.535,0.577l-0.639,-0.137h-0.723l-0.076,0.238l0.375,0.407l-0.299,0.169l-0.299,0.102l0.139,0.407l0.431,0.203l0.417,0.813l0.556,1.286l0.417,1.147l0.278,0.81l0.056,0.741l-0.361,0.673l-0.611,1.479l-0.806,1.208l-0.361,0.269l-0.688,0.301l-0.527,-0.134l-0.202,0.503l-0.326,0.033l-0.889,-0.67l-0.258,-0.638l-0.354,0.101l-0.556,-0.402l-0.216,-0.302l0.069,-0.336l-0.188,-0.033l-0.104,0.234l-0.09,0.303l-0.917,0.536l-0.306,0.135l-0.771,0.436l-0.527,0.402l-0.084,0.268l-0.083,0.335l0.403,0.736l0.416,1.202l0.313,0.635l0.076,0.367l-0.028,0.533l-0.048,0.566l0.188,0.232l-0.611,1.065l-0.626,0.332l-0.056,0.199l-0.034,0.299l0.159,0.432l-0.25,0.465l-0.333,0.266l-0.688,0.165l-0.14,-0.133l-0.188,0.166l0.542,0.795l-0.069,0.332l0.875,0.463l0.417,0.793l-0.292,0.529l-0.257,0.099h-0.417l-0.333,0.265l-0.41,0.495l0.375,0.329l-0.208,0.33l0.111,0.132l0.771,0.297l0.334,-0.132l0.049,-0.231l-0.14,-0.396l-0.431,-0.264l0.278,-0.396l0.41,0.23l0.188,0.692l-0.07,0.33l0.403,0.725l0.111,0.526l0.223,1.315l-0.056,0.656l-0.084,0.328l-0.083,0.196l-0.069,0.328l0.056,0.263l0.152,0.263l0.056,0.654l-0.444,1.047l-0.167,0.522l-0.292,0.457l-0.014,0.457l-0.299,0.163l-0.833,-0.13l-0.243,0.162l-0.25,0.393l-0.084,0.325l0.848,0.652l-0.326,0.292l-0.049,0.423l0.125,0.456l-0.403,0.455v0.455l0.188,0.162l0.528,-0.13l0.604,0.747l-0.25,0.389l-0.319,0.583l-0.25,0.843l-0.084,0.582l-0.139,0.518l-0.007,0.872l-0.243,0.355l0.139,0.773l0.208,0.064l0.056,0.258l-0.235,0.838l0.347,0.515l-0.486,1.093l-0.292,0.964l-0.854,0.032l-0.14,-0.257h-1l-0.049,-0.225l0.292,-0.129l-0.188,-0.16l-0.993,0.354l-0.848,-0.707l-0.577,-0.161l-0.777,0.257l-0.591,-0.096l-0.459,-0.064l-0.083,-0.579l0.966,-0.031l0.313,-0.354l0.792,-0.063l0.083,-0.322l-1.104,-0.935l-0.715,0.161l0.208,0.193l-0.326,0.419l-0.223,-0.129l-1.104,0.097l-0.083,-1.096l1.069,-0.064l-0.486,-0.516l0.069,-0.323l-0.493,0.098l-1.361,-0.905l-0.354,0.42l0.028,0.453l0.354,0.29l0.216,0.741l-0.549,0.161l-0.104,0.354l0.743,0.806l0.118,0.61l0.375,-0.064l0.563,0.226l0.132,0.996l-0.681,0.962l0.326,0.481l0.104,0.609l0.027,0.384l-0.167,0.512l-0.188,-0.096h-0.222l-0.091,0.096l-0.708,0.576l-0.069,0.702l-0.153,0.064l0.056,0.319l0.375,-0.064l0.056,0.319l-0.083,0.639l-0.82,0.19l-0.041,0.574l-1.126,-0.064l-0.5,0.382l0.139,0.446l0.584,0.636l1.014,0.318l0.223,0.571l0.056,0.254l-0.389,0.889l-0.216,0.285l-0.229,0.35l-0.319,0.189l-0.25,0.887l0.208,0.569l-0.569,0.568l-0.236,0.443l-0.708,0.693l-0.973,1.514l0.444,0.692l0.611,0.503l0.382,-0.598l0.035,0.472l0.402,0.692l-0.694,1.067l-0.236,-0.063l-0.222,0.377l0.055,0.313l0.542,0.188l0.361,0.877l-0.236,0.375l-0.069,0.688l-0.222,0.375l-0.848,0.313l-0.473,0.749l0.25,0.438l0.931,0.25l-0.583,2.365l0.007,0.652l0.076,0.715l-0.431,0.186L351.522,488l-0.438,0.402l-0.201,-0.341l-0.633,-0.154l-0.417,-0.372l-0.389,0.124l-1.361,-0.124l-0.202,0.589l-0.264,0.062l-0.25,0.496l0.576,0.465l0.834,0.124l0.952,1.02l0.027,0.434h0.236l-0.014,-0.434h0.125l0.347,0.557l0.306,0.247l0.209,0.494l0.146,0.154l0.493,0.154v0.925l-0.139,0.8l-0.375,0.862l-0.64,0.491l-0.36,0.859l-0.563,0.706l-0.09,0.705l-0.736,0.429v0.856l-0.125,0.795l-0.306,0.245l-0.473,0.366l-0.465,0.152l-0.41,-0.092l-0.646,0.336L346,500.455l-0.417,-0.366l-0.334,0.244l-0.333,0.366l-0.132,0.457l-0.084,0.731l-0.083,0.67l-0.083,0.305l0.597,0.851l0.667,-0.242l-0.014,-0.792l0.265,-0.121l0.222,0.486l0.028,0.365l0.125,0.547l0.402,0.183l-0.027,0.546l-0.299,0.03l-0.611,0.485l-0.021,0.213l0.215,0.03l0.341,-0.334l0.354,-0.151l0.771,0.455l0.125,-0.425h0.486l0.667,0.606l-0.153,0.182l0.278,0.728l0.167,0.241l0.299,0.03l0.159,0.454l0.139,0.303l0.056,0.303l-0.222,0.362v0.362l-0.084,0.725l-0.271,0.15l-0.194,-0.12l-0.382,0.392l0.069,0.543l-0.015,0.964l-0.173,0.15l0.048,0.691l-0.194,0.602l-0.556,0.72l-0.431,-0.18l-0.014,1.26l-0.521,-0.09l-0.326,0.149l-0.236,0.779l-1.486,1.017l-0.069,0.3l-1.3,0.388l-0.423,-0.328l-0.771,-0.03l-0.549,-0.628v-0.539l-0.027,-0.658l0.208,-0.899l-0.25,-0.36l-0.438,0.091l-0.091,-0.33l-0.215,-0.03l-0.243,0.45l-0.14,0.06l-0.097,0.78l-0.354,0.149l-0.313,0.09l-0.444,-0.659l-0.25,-0.36l-0.431,-0.06l0.083,-0.78l0.083,-0.36l0.354,-0.15l0.146,0.211l0.653,0.119l0.083,-0.24l-0.743,-0.33l-0.382,0.09l-0.09,-0.451l-0.035,-0.571l-0.319,-0.421l0.194,-0.302l0.417,-0.241h0.236l0.368,-0.03l-0.146,-0.813l-0.382,-0.15l0.076,-0.937l-0.777,-0.241h-0.834l-1.069,-0.423l-0.542,-0.786l-0.445,-0.122l-0.736,-0.302l-0.235,-0.546l-0.918,-1.092l-0.958,-0.91l-0.334,-0.485l-0.402,-0.427l-0.459,-0.061l-0.417,-0.729l-0.152,-0.915l-0.444,-0.609l-0.431,-0.122l-0.452,-0.396l0.049,-0.458l-0.389,-0.366l-1.015,-0.184l-0.5,-0.855l0.473,-1.409l0.639,-0.613l0.834,-0.307l0.444,-0.307l0.493,-0.031l0.007,-0.46l0.354,-0.153l0.257,-0.339l0.167,-0.122l0.243,0.338l0.326,-0.153l0.056,-0.308l-0.292,-0.246l0.354,-0.277l1.028,0.615l0.216,-0.276l0.055,-0.309l-0.041,-0.246l0.799,-0.399h0.389l0.389,0.246l0.702,-0.4l0.549,0.031l0.41,-0.093l0.264,0.555l0.403,0.184l-0.042,0.678l0.097,0.491l-0.375,0.062l-0.174,0.338l-0.409,-0.093l0.167,0.431l0.826,0.398l-0.216,-0.46l0.292,-0.185h0.125l0.327,0.031l-0.049,0.338l0.277,0.368l0.41,0.153l0.313,-0.153l0.466,0.03l0.076,-0.338l-0.25,-0.368l-0.375,-0.307l-0.444,-1.106l-0.278,-0.801l0.799,-0.399l0.007,0.215l0.521,0.154l0.194,-0.123l-0.076,-0.216l0.11,-0.369l0.466,-0.031l0.66,0.832l-0.264,-0.801l0.354,-0.154l0.383,0.154l0.208,0.185l0.306,0.246l0.417,-0.185l0.271,0.093l0.243,-0.216l-0.264,-0.37l0.611,-0.37l-0.278,-0.37h0.486l0.084,0.186l0.146,0.277l0.216,-0.277l-0.084,-0.556l-0.465,-0.154l-0.528,-0.124h-0.25l-0.41,0.093l-0.042,-0.37l-0.166,-0.804l-0.493,-0.278l-0.89,0.123l-0.104,-0.154l0.098,-0.929l-0.653,-0.186l-0.166,-0.311l0.382,-0.65l0.438,0.278l0.069,0.311l0.223,0.124l0.514,-0.187l-0.027,-0.372l-0.403,-0.186l-0.181,-0.807l-0.326,-0.155l-0.694,-0.125l-0.334,0.373l-0.243,0.838l0.292,1.054l0.118,0.341l-0.035,0.341l-0.215,0.03l-0.202,-0.34l-0.36,-0.124l-0.348,0.062l-0.174,-0.217l-0.354,0.279l-0.056,0.31l0.236,-0.063l0.25,0.371l-0.277,0.989l-0.028,0.186l0.14,0.371l-0.104,0.154l-0.118,0.216l-0.375,-0.37l0.069,-0.31l-0.528,-0.803l-1.41,-0.093l-0.188,-0.278l-0.25,-1.858l0.209,-0.807l-0.223,-0.621l-0.883,-0.776l-1.243,0.031l0.417,0.808l0.431,0.125l0.194,1.116l-0.41,0.403l-0.382,-0.218l-0.903,-1.737l-0.549,-0.155l-0.556,-0.249l-0.188,0.218l0.194,0.622l0.417,1.24l0.542,-0.248l-0.348,-0.559l0.432,-0.248l0.139,0.868l0.723,0.992l-0.195,0.31l-0.076,0.155l0.438,0.835l-0.222,0.371l-0.827,0.031l-0.194,-0.248l-0.528,0.124l-0.257,0.34l0.028,0.371l-0.66,0.401l-0.466,-0.278l-0.152,-0.433l-0.306,-0.247l-0.327,-0.154l-0.424,0.711l-0.389,0.494l-1.938,0.03l-1.528,-0.741l-0.882,-0.525l-0.507,-0.34l-0.493,-0.712l0.097,-0.371l-0.236,-0.496l-0.416,-0.682l0.792,-0.807l-0.334,-0.621l-0.417,-0.373h-0.486l0.25,-0.497l0.431,-0.249l-0.242,-0.28l-0.251,-0.498l-0.313,0.592l-0.319,-0.125l0.028,-0.188l0.222,-0.373l0.625,-0.997l-0.569,-0.188l0.042,-0.687l-0.431,-0.25l0.382,-0.031l0.549,0.281l0.098,0.624l0.458,-0.375l-0.444,-0.749l-0.549,-0.156l-0.25,0.125l-0.368,-0.719l-0.354,-0.031l-0.076,0.844l-0.167,0.063l-0.229,-0.406l-0.473,-0.125h-0.527l0.021,0.344l-0.382,0.281l-0.604,-0.844l0.278,-0.501l0.416,-0.25l0.771,-0.031l0.104,-0.406l-0.236,-0.063l-0.563,-0.156l-0.646,0.47l-0.708,-0.125l-0.07,-0.251l0.167,-0.188l-0.806,-0.878l-0.299,-0.157h-0.611l-0.528,0.126l-0.118,-0.22l-0.444,-0.754l-0.382,-0.407h-0.25l0.049,0.345l-0.348,0.377l0.326,0.157l0.111,-0.126l0.41,0.597l-0.438,0.031l-0.223,0.251l-0.611,-0.502l0.076,0.471h-0.375l0.278,0.376l0.111,0.125l0.819,0.063l0.167,0.439l-0.354,0.156l-0.521,-0.22l0.167,0.438h0.236l-0.466,0.532l-0.063,-0.47l-0.402,-0.313l-0.508,-0.345l-0.271,-0.532l-0.361,-0.628l0.069,-0.816l-0.347,-0.564l0.083,-0.44l-0.118,-0.409l-0.466,-0.157l0.265,-0.692l0.236,-0.379l-0.125,-0.63l-0.195,-0.252l-0.659,-0.158l-0.667,-0.252l-0.695,-0.379l-0.159,-0.601l0.083,-0.822l0.014,-1.203l-0.194,-0.761l-0.292,-0.189l-0.416,-0.382l0.083,-0.444l0.236,0.063l0.083,-0.444l-0.514,-0.317l0.069,-0.445l-0.82,-0.7l-0.333,-0.255l-0.264,-0.573l-0.348,-0.127l-0.056,-0.766l0.41,-0.159l0.076,-0.287l-0.152,-0.959h0.486l0.284,0.352l0.507,-0.352l-0.319,-1.407l-0.389,-0.513l-0.41,0.097l-0.667,-0.256l-0.41,-0.61l0.458,-1.347l-0.236,-0.579l0.25,-0.515l0.639,-0.515l0.521,-0.161l0.118,-0.354l0.334,-0.387l0.472,-0.387l0.89,-0.387l0.576,-0.032l1.258,-0.613l0.716,-0.032l0.944,0.646l0.444,-0.258l0.243,0.032l0.209,0.322l0.139,0.387l0.215,0.161l0.744,1.063l-0.265,0.708l0.042,0.257l0.042,0.836l-0.167,1.348h0.486l0.042,-0.193l0.549,-0.288l0.034,0.609l0.326,0.032l0.306,0.385l0.174,0.416l0.076,0.225l0.785,-0.609l0.327,0.225l-0.063,-0.353l-0.486,-0.448l0.083,-0.449l0.292,-0.064l0.083,-0.385l-0.208,-1.156l0.264,-0.579l-0.069,-0.772l1.132,0.097l0.417,-0.258l0.479,-0.226l0.827,-0.806l0.465,0.29l0.424,0.226l0.633,0.677l0.069,0.322l1.216,-0.097l1.361,0.515l0.639,-0.129l0.556,0.387l0.89,0.643l1.139,-0.129l0.751,-0.386l1.146,-0.225l0.299,0.097l0.118,0.354l0.466,0.032l0.25,-0.129l0.632,0.16l0.236,0.708l0.382,0.288l0.633,0.61l0.785,0.802l0.146,0.608l0.639,0.896l0.556,0.768l0.876,0.447l0.583,0.638l0.265,1.467l-0.146,0.159l-0.326,-0.351l0.222,1.083h0.265l0.319,-0.255l0.167,0.382l0.521,0.286l-0.118,-0.478l-0.319,-0.255l0.292,-0.572l-0.098,-0.573l0.223,-1.276l0.236,-0.319l0.083,-0.831l-0.208,-0.128l0.139,-0.512l0.292,-0.063l0.083,-0.832l-0.326,-0.032l-0.417,-0.385l-0.417,0.257l-1.111,-0.257l-0.604,-0.673l-0.333,-0.642l-0.646,-0.611l-0.535,-0.867l-0.854,-0.934l0.216,-0.419l-0.194,-0.322l-1.577,-0.677l-0.591,-0.354l-1.111,-0.259l-0.299,-0.161l-0.563,0.097l-0.16,0.032l-1.027,-0.388h-0.834l-0.479,-0.484l-1.049,-0.421l-1.25,0.13l-0.118,-0.355l-0.299,-0.162l-0.5,-0.129l-0.973,0.129l-0.285,0.098l-1.216,0.032l-0.409,-0.162l-0.265,-0.583l-0.409,-0.291l-0.16,0.032l-0.146,0.745l-0.438,-0.422l-0.152,-1.102l-0.5,-0.519l-1.049,-0.292l-0.049,-0.487l0.66,-0.162l-0.021,0.228h0.375l0.292,-0.585l0.743,-0.032l0.383,-0.358l0.257,-0.423l0.25,-0.13l0.417,-0.13l0.465,-0.163l0.702,-0.488l0.313,-0.358l0.243,-0.163l0.354,-0.162l0.646,-0.49l0.396,-0.489l0.277,-0.131l0.466,-0.032l0.527,0.261h0.361l0.556,-0.13l0.216,-0.229l-0.319,-0.262l0.743,-0.555l1.306,0.261l0.417,-0.393l0.667,0.132l0.215,-0.229l-0.306,-0.327l0.258,-0.229h0.556l0.527,0.522l0.479,0.36l0.403,-0.131l0.534,0.033l0.299,-0.229l-0.306,-0.393l-0.354,-0.032l-0.021,-0.491l0.854,-0.426l0.25,0.262l0.479,-0.754l0.604,-0.032l0.056,0.394l-0.326,0.36l0.604,0.032l0.361,-0.262l-0.048,-0.36l0.548,-0.295l0.361,0.263h0.39l1.473,-0.263l0.639,-0.131l0.799,-0.951l0.223,-0.395l0.201,-0.888l0.841,0.493l0.584,0.264l0.771,0.032l0.535,-0.493l1.049,-0.164l1.111,-0.132l0.75,-0.395l0.64,0.132l0.723,0.526l0.723,0.395l1.201,1.018l0.354,-0.361l0.424,0.361l0.465,0.032l0.077,-0.623l-0.236,0.065l-0.486,-0.723l-0.278,-0.395l-1.848,-0.854l-0.236,-0.594l-0.458,-0.197l-0.403,-1.385l-0.514,-1.454l0.111,-0.396l0.271,-0.165l0.229,0.363l0.465,0.166l0.827,-0.563l-0.431,-0.265l0.319,-0.332l-0.361,-1.061l-0.354,-0.431l-0.382,0.299l0.292,1.259l-0.299,-0.1l-0.132,-0.231l-0.153,-0.397l-0.347,0.265l-0.202,0.232l-0.556,0.132l-0.424,1.026l-0.159,0.43l0.021,0.496l-0.639,0.396l-0.66,0.165l-2.278,0.528l-0.493,-0.165l-0.431,-0.462h-0.515l-1.042,0.462l-0.354,-0.1l-1.139,0.265l-0.688,0.56l-0.674,-0.164l-1.758,0.89l-0.66,-0.362l-0.834,0.132l-0.833,-0.264l-0.618,-0.891l-0.682,-0.329l-0.84,-0.231l-0.25,-0.529l-0.285,-0.091l-0.966,-0.173l-0.694,0.132l-0.473,-0.132l-0.104,0.231l0.104,0.562l-0.139,0.132l-0.41,-0.099l-0.598,1.253l-0.333,0.264l-0.326,0.297l-0.229,0.362l-0.194,0.264l-0.271,0.427l-0.611,0.132l-0.173,0.493l-0.334,0.263l-1.049,0.165l-1.39,0.525l-0.194,-0.132l-1.028,0.132l-0.034,-0.23l-0.438,-0.164l0.077,0.624l-0.493,0.164l-0.396,0.754l-0.438,0.296h-0.25l-0.479,-0.886l-0.632,-0.558l-0.646,0.492l-0.152,0.655l0.159,0.296l0.41,-0.033l-0.104,-0.36l0.41,0.163l0.285,0.754l-1.612,-0.131l-0.063,0.229l-0.354,0.163h-0.667l-0.146,-0.229l-0.799,-0.295l-1.028,0.131l-0.527,-0.786l-0.528,-0.132l-0.889,0.132l-0.771,0.294l-0.403,0.591l0.111,0.654l-0.493,0.033l-0.104,0.163l-0.125,1.111l-0.354,-0.098l-0.139,0.262l-0.271,-0.164l-0.139,-0.522l-0.292,-0.589l-0.243,-0.163h-0.833l-0.049,-0.491l0.299,-0.819l0.271,-1.147l-0.32,-0.263l0.167,-1.117l-0.195,-0.395l-0.056,-0.329l-0.368,-0.428l-0.694,-0.527l0.132,-0.759l-0.111,-0.659l-0.167,-0.396l-0.521,-0.43l0.285,-0.231l0.41,-0.033l0.048,-0.231l-0.569,-0.396l0.125,-0.53l-0.32,-0.265l-0.278,-0.463l-0.056,-0.398l-0.014,-1.128l-0.375,-0.664l-0.056,-0.931l0.194,-0.8l0.083,-0.933l-0.056,-1.401l0.097,-1.673l-0.292,-0.334l-0.333,-1.006l0.194,-0.806l0.82,-0.066l-0.042,-0.471l0.694,-0.672l0.243,0.102l0.188,-0.223l-0.097,-0.148l0.382,-0.168l0.167,0.135l0.354,-0.303l0.069,-0.336l0.966,-0.304h0.694l0.612,0.27l0.777,1.211l0.341,1.041l0.236,0.067l0.194,0.806l-0.153,0.201l1.16,2.175l0.285,1.303l0.486,0.066l-0.111,0.468l-0.264,0.066l0.167,0.467l0.389,0.533l0.466,0.166l0.659,-0.433l-0.541,-2.135l0.027,-0.201l0.215,0.101l0.229,-0.234l-0.444,-0.937l0.319,-0.268l-0.361,-0.669l-0.771,-0.436l-0.188,-0.437l0.097,-0.604l-0.264,-0.47l-0.223,-0.739l0.194,-0.27l-0.034,-0.168l-0.299,-0.571l0.056,-0.337l0.438,-0.303h0.25l0.223,0.269l0.5,-0.134l0.5,-0.135l0.139,-0.135l1.14,0.403l0.223,0.27l1.243,-0.572l1.758,-0.506l0.222,-0.27h0.611l1.167,-0.404l1.091,1.314l1.077,0.168l0.41,-0.303l0.25,-0.472l-0.542,-1.417l0.139,-1.149l0.271,-0.304l0.584,0.135l0.188,-0.236l-0.375,-0.067l0.056,-0.204l0.667,-0.541l0.438,0.372l0.104,-0.372l-0.431,-0.407l0.36,-0.406l0.195,-0.136l0.333,-0.271l0.688,-0.034l0.077,-0.373l-0.348,-0.067l0.167,-0.748l0.333,-0.271l0.584,-0.067l0.235,0.136l0.015,-1.156l0.5,-0.818l0.667,-0.545l0.438,-0.307l0.25,0.272l1.306,0.137l-0.021,0.784l-0.111,0.408l0.167,0.408l0.389,0.137l0.028,-0.137l0.326,-0.374l0.334,0.272l0.972,0.408l0.466,-0.034l0.361,-0.408l0.083,-0.341l-0.166,-0.409l-0.584,-0.817l-0.639,-0.682l-0.626,-0.615l-0.236,-0.751l-0.409,-0.308l-0.049,-0.514l0.375,-0.411l0.229,-0.308l0.09,-0.377l0.556,-0.549l0.445,-0.068l0.215,-0.103l0.091,-0.515l0.194,-0.275l1.444,-1.236l0.243,-0.034l0.361,0.274l1.112,-0.138l2.306,-0.963l0.604,0.447l0.431,0.619l0.632,0.034l0.834,-0.274l0.299,0.171l0.056,0.345l-0.153,0.137l0.438,0.31l0.722,0.274l0.611,-0.138h0.417l0.223,-0.274l-0.056,-0.274l0.382,0.034l0.528,0.549l0.257,-0.034l0.667,0.138l0.611,-0.412l1.361,0.138l0.521,-0.241l0.319,0.894l0.25,0.138l0.667,0.549l0.625,0.137l0.027,-0.206l-0.659,-0.309l-0.834,-0.961l0.007,-0.653l0.25,-0.412l0.986,-0.481l0.229,-0.379l0.361,-0.276l0.41,-0.447l0.014,-0.482l1.271,-0.863l0.034,0.242l0.216,0.034l0.382,-0.311l0.194,-0.139l0.181,-0.621l0.695,-0.554l0.333,-0.138l0.292,-0.069l-0.139,-0.485l-0.39,-0.554l-0.167,-0.346l-0.083,-0.209l-0.791,-0.141l-0.842,0.522l-0.527,0.415l-0.271,0.45l-0.639,0.277l-0.868,0.242l-0.306,0.139l-0.479,1.07l-0.271,0.173l-0.465,-0.104l-0.069,0.76l-0.243,0.034l-3.05,-1.969l0.083,-0.346h0.792l-0.333,-0.277l-0.486,-0.069l0.097,-0.484l-0.799,-0.45l-0.417,-0.139l-0.583,0.277l-0.667,-0.139l-0.083,0.416l-0.674,-0.798l-0.82,-0.555l0.223,-0.277l0.326,0.104l0.438,-0.312l0.306,-0.556l0.015,-0.626l0.597,-0.626l0.278,-0.975l-0.069,-1.744l0.958,-0.908l0.278,-0.98l-0.208,-0.771l0.194,-0.701l1.403,-0.912l0.041,-1.195l0.473,-0.703l0.556,-1.41l0.521,-0.317h0.5l1.028,0.565h0.417l-0.16,-0.318l0.16,-0.106l0.305,0.283l0.188,-0.67l-0.195,-0.283h-0.541l0.083,-0.282l0.271,-0.035l0.104,-0.389l-0.194,-0.283l-0.883,-0.176l-0.389,-0.284h-1.39h-0.416l-0.118,0.39l-0.438,0.177l-0.451,-1.097l-0.438,0.106l-0.223,0.424l-0.271,-0.176l0.152,-0.566l-0.11,-0.212l-0.494,0.106l-0.201,-0.673l-0.382,0.106l0.132,0.39l-0.111,0.85l-0.264,-0.071l-0.083,0.283l0.014,1.061l-0.438,0.317l-0.445,-0.141l-0.194,0.141l0.271,0.458l-0.069,0.353l-0.195,0.635l0.431,1.479l-0.166,0.563l-0.459,0.632l-0.083,0.327l-0.375,0.866l-0.028,0.561l-0.222,0.84l-0.417,0.42l-1.077,0.455l-0.382,0.314l-0.459,0.629l-0.5,0.279l-0.514,-0.14l-0.368,-0.524l-0.243,0.175l0.181,0.279l-0.181,0.349l0.299,0.174l0.188,0.523l-0.222,0.831l-1.001,1.12l-0.577,0.034l-0.889,0.417h-1.306l-1.779,1.111l-0.889,0.139h-0.834l-0.659,-0.173l-0.584,-0.973l-0.152,-0.626l-0.987,-0.904l-0.181,-1.046l-0.409,-0.873l0.104,-1.083l-0.11,-0.7l-0.292,-0.91l0.042,-0.771l-0.598,-0.421l0.723,-0.562l0.097,-0.421l-0.215,-0.175l-0.584,0.281l-0.132,-0.246l0.632,-0.457l0.417,0.14l0.89,-0.281l0.277,0.141l0.306,-0.282l0.257,-0.809l0.41,-0.176l0.361,-0.563l0.063,-1.799l0.056,-0.283l0.167,-0.566l0.166,-0.707l-0.222,-0.708l0.319,-0.709l-0.264,-0.567l0.333,-0.71l0.208,-0.781v-0.641l-0.055,-0.285l-0.653,-0.641l-0.285,-0.963l-0.354,-0.535l0.383,-0.321l0.132,-0.464l-0.153,-0.501l0.32,-1.216L327.042,375l-0.438,-0.466l-0.299,0.036l0.292,0.502l-0.299,0.036l-0.167,0.286l-0.243,-0.322l0.104,-0.251h-0.695l-0.667,0.143l-0.382,0.967l0.125,0.572l-0.166,0.572l-0.251,1l-0.652,0.856l0.125,1.14l-0.236,0.427l-0.083,0.854l0.652,0.71l-0.056,0.284l-0.326,0.177l-0.132,0.532l0.514,0.709l-0.083,0.779l-0.236,0.495l0.542,0.495l0.306,1.06l-0.493,0.035l-0.25,-0.282h-0.751l-0.909,0.741l0.208,0.282l-0.027,0.212l-0.32,0.141l-0.201,0.317l-0.5,0.141l-0.438,0.669l0.139,0.563l0.459,0.352l-0.084,0.352l-0.473,0.703l-0.438,-0.105l-0.146,-0.387l-0.632,-0.597l-0.438,-0.598l-0.729,-0.951l-0.465,-1.022l0.027,-0.212l0.709,-0.564l0.528,-0.424l-0.167,-1.556l-0.111,-1.276l-0.076,-0.745l-0.063,-0.39l-0.271,-0.319l-0.361,0.284l-0.306,-0.71l-0.889,0.426l-0.118,-0.391l-0.083,-0.285l-0.383,-0.036l-0.188,0.178v1.208l0.319,0.284l-0.375,0.354l0.042,0.497l-0.931,0.212l-0.459,0.779l-0.688,-0.106l-0.215,0.318l0.431,0.425l-0.181,0.354l0.027,0.424l0.854,0.883l0.049,0.529l-0.236,0.423l0.292,1.127l-0.084,0.282l-0.347,0.844l0.347,0.843l-0.181,0.842l0.932,1.821l-0.077,0.175l-0.284,0.105l-0.243,0.175l-1.417,-0.7l-0.723,0.14l-0.25,-0.14l-0.313,-0.105l-0.327,-0.175l-0.188,0.105l0.021,0.315l-0.077,0.455l0.084,0.35l0.188,1.013l0.479,0.803l0.354,-0.105l0.16,0.244l-0.083,0.279l-0.306,0.14l-0.216,-0.105l-0.826,0.313l-0.195,0.279l0.056,0.349l0.799,-0.104l0.368,0.521l0.327,0.313l0.146,0.521l1.243,0.451l0.778,0.278l0.452,0.521l0.486,0.208l0.389,0.764l0.223,1.177l0.235,0.899l0.966,1.416l0.049,0.518l-0.306,-0.483l-0.243,-0.034l-1.084,0.689h-0.667l-0.257,-0.518l-1.633,-0.587l-0.465,0.726l0.097,0.207l-0.159,0.31l-0.778,-0.827l-0.868,-1.209l-0.938,-0.587l-0.528,0.138l-0.535,-0.935l-0.465,-0.034l-0.258,1.35l-0.208,0.276l0.306,0.552l0.771,-0.104l-0.104,-0.518l0.292,-0.139l0.25,0.208l-0.181,0.275l0.431,0.415l-0.25,0.414l-0.515,-0.069l-0.25,0.483l0.327,0.172l0.25,-0.138l0.438,0.792l-0.604,0.311l-0.424,-0.104h-0.792l-0.223,0.345l0.195,0.413l-0.424,0.172l-0.104,0.24l0.188,0.172l1.611,-0.412l0.084,0.274l0.257,0.241l0.216,0.171l0.326,-0.171l-0.069,-0.345l0.271,-0.171l0.271,0.171l-0.098,0.481l-0.181,0.138l0.208,0.962l0.57,0.343l0.056,0.343l-0.028,0.686l-0.583,0.685l-0.917,0.411l-0.41,0.034l-0.576,0.717l0.014,0.479l-0.056,0.82l-0.278,0.545h-0.264l-0.042,-0.478l-0.208,-0.204l0.042,-1.435l-0.056,-0.273l-0.153,-0.342l-0.611,-0.411l-0.313,-0.24l-0.465,-0.444l-0.174,-0.515l-0.257,0.515l-0.577,0.171l-0.243,0.514l0.854,0.308l0.063,0.377l0.542,0.479l-0.139,0.614l-0.319,0.274l0.083,0.818l0.292,0.341l-0.056,0.886l-0.194,0.272l-0.347,-0.272l-0.07,-0.341l-0.403,-0.477l-0.181,-0.478l-0.389,-0.683l-0.486,-0.204l0.069,-0.343l-0.994,-0.307l-0.257,0.376l-0.042,0.273l0.236,0.137l0.264,0.682h0.403l0.598,0.954l0.333,0.273l0.208,0.272l-0.382,0.17h-0.389l-0.201,-0.238l-0.153,0.136l0.048,0.511l0.035,0.374l0.521,0.034l0.229,-0.374l0.264,0.068l0.139,0.544l-0.639,0.407l-1.521,0.441l-0.945,-0.271l-0.778,0.136l-1.417,-0.68l-0.806,-0.136l-0.389,0.136l-1.362,-0.407l-0.361,-0.137l-0.917,-0.816l-0.444,-0.136l-0.646,0.374l-0.333,0.816l-0.327,-0.102l-0.493,0.169l0.292,0.477l-0.299,0.17l-0.243,-0.103l-0.445,-1.02l0.125,-0.749l-0.431,-0.341l-0.278,-0.545l0.111,-0.614l0.111,-1.093l0.486,-1.572v-0.754l-0.389,-0.686l-0.465,-0.172l-0.16,-0.583l-0.194,-0.962l0.271,-0.104l0.528,-0.55l0.215,-0.31l0.278,-0.758l-0.41,-0.448h-0.528l-0.216,0.241l-0.194,-0.482l-0.118,-0.448l0.021,-0.38l-0.215,-0.173l-0.188,0.242l-0.32,0.138l0.389,0.621l-0.222,0.482l-0.243,0.172l-0.611,0.276l-0.882,-0.035l-0.542,-0.758l-0.361,-0.828l-0.576,-0.311l-0.354,-0.448l-0.472,-0.968l-0.479,-0.936l-1.466,-3.714l0.667,-0.557l0.382,-0.035l-0.132,0.244l0.542,0.626l0.069,0.487l0.708,0.347l-0.056,0.348l-0.799,0.035l-0.076,0.243l0.243,0.173l0.639,-0.139l0.528,0.416l-0.215,-0.937l0.167,-0.14l0.604,-0.313l0.577,0.104l0.313,-0.243l-0.076,-0.243l0.548,-0.174l0.369,-0.175l1.132,0.313l0.222,0.278l0.757,-0.104l0.382,-0.174h0.583l0.556,0.14l0.285,-0.522l0.41,-0.174l0.007,0.243l0.333,0.279l1.049,0.451l0.104,-0.104l-0.32,-0.347l-0.139,-0.627h0.264l0.202,0.243l0.215,-0.174l-0.097,-0.209l0.319,-0.278l0.333,-0.139l0.431,1.184l0.521,0.034l0.549,-0.522l-0.139,-0.557l-0.959,-0.627l-0.403,-0.209l-0.486,-0.209l-0.257,-0.524l-0.104,-0.384l0.799,-0.035l0.222,0.279l0.778,0.14l0.188,-0.523l-0.083,-0.28l-0.764,-0.209l0.278,-1.33l0.632,-0.315l0.063,-0.245l-0.452,-0.876h-0.25l-0.41,-0.316l-0.285,-0.526l-0.91,-1.018l0.111,-1.197l0.375,0.141h0.139l-0.306,-0.563l-0.382,-0.035l-0.354,-0.388l-0.424,0.106l-0.215,0.317l0.097,0.774l-0.292,0.704l1.216,1.019l0.174,0.386l0.222,0.21l0.181,0.352l-0.153,0.14l-0.681,-0.772l-0.41,-0.315l-0.361,-0.281l-0.16,0.387l0.236,0.07l-0.028,0.211l-0.521,0.175l-0.25,-0.141l-0.299,-0.175l0.042,-0.351l-0.986,-0.492l-0.458,-0.633l-0.653,-0.141v0.774l0.333,0.421l0.736,0.351l0.347,1.053l0.486,0.21l-0.014,0.21l0.048,0.315l0.021,1.225l-0.417,0.559l-0.375,-0.14l-0.097,-0.91l-0.854,-0.175l-0.146,-0.385l-0.327,-0.175l-0.611,0.28l-0.132,0.385l0.403,0.629l-0.042,0.35l0.514,0.069l0.34,0.664l-1.077,-0.454l-0.195,-0.35l-0.146,-0.314l-0.25,-0.28l-0.306,0.28h-0.583l-0.361,0.28l-0.528,-0.28h-0.611l-0.528,0.28l-1.612,-0.14l-0.271,-0.314v-0.771h0.82l-0.438,0.245l0.167,0.28l0.834,-0.14l0.104,-0.175l-0.465,-0.525l-0.021,-1.087l0.208,-0.421l-0.167,-0.562l-0.348,-0.21h-0.153l-0.271,0.175l-0.417,0.141h-0.417l-0.528,-0.141l-1.354,0.105l-0.202,-0.105l-1.41,-1.019l-0.313,-0.388l-0.229,-0.528l-0.319,0.282l0.208,0.352l-0.486,-0.282l-0.223,-0.281l0.042,-0.353l-0.91,-0.739l-0.104,-0.389l-0.056,-0.353l-0.069,-0.494l-0.299,-0.317l-0.306,-0.565l-0.223,-0.425l0.139,-0.283l0.257,0.389h0.264l0.194,-0.283l0.223,-0.425l0.125,-0.637l-0.306,-0.496l-0.195,-0.497l0.181,-0.284l-0.188,-0.178l-0.167,0.284l-0.299,-0.177l0.014,-0.213l-0.243,-0.035l-0.361,0.567l-0.667,-0.284l-0.313,-0.106l-1.098,-0.781l-0.361,-0.426l0.153,-1.565l0.583,-0.712l-0.028,-0.571l0.264,-0.642l0.695,0.143l0.069,-0.428l-0.188,-0.179l-0.417,0.143l-0.104,-0.679l0.083,-0.429l0.688,-0.608l0.09,-0.394l0.458,-0.143l0.486,0.43l0.458,-0.071l0.229,0.179l1.556,-0.143l0.521,-0.251l-0.194,-0.43l-0.466,-0.179l-0.215,0.036l0.208,0.502l-0.66,-0.107l-0.223,-0.287l0.021,-0.395l-0.736,-0.501l-0.319,-0.646l-0.278,-0.144l-0.604,-0.036l-0.771,-0.036l-0.591,-0.539l-1.139,-0.863l-1.091,-1.982l-0.556,-0.866l-0.708,-0.65l-0.924,-1.122l-0.049,-0.615l-0.167,-1.378l0.715,-0.326l0.25,0.29h0.473l0.611,-0.436l0.889,-0.145l0.674,0.689l0.799,0.036l2.008,1.27l0.632,0.036l0.09,0.615l0.056,0.506l0.327,0.181h0.833l0.229,0.688l0.66,0.18l0.118,-0.325l0.82,0.072l0.201,0.253l-0.021,0.397l0.771,0.325l0.361,0.289l0.604,-0.108l0.125,0.938l0.466,0.036l0.667,-0.289l0.285,0.397l0.298,0.036l0.89,-0.433l0.556,-0.288l0.632,-0.469l0.25,-0.433l-1.327,-0.397l0.188,-0.325l-0.055,-0.507l-0.32,-0.361l0.069,-0.507l-0.125,-0.724l0.083,-0.436l0.389,-0.435l-0.056,-0.435l1.07,-0.217l0.25,-0.509l-0.167,-0.582l-0.577,-0.472l-0.473,0.291h-0.583l-0.945,-0.582l-1.083,-0.292l-0.869,-0.984l-0.743,-0.474l-0.472,0.146l-0.473,0.146l-0.25,0.146l-0.271,0.183l0.014,0.656l-0.688,0.036l-0.41,-0.328l0.042,-0.364l-0.306,-0.584l-0.528,-0.292l-1.153,-0.657l-0.313,-0.402l-0.563,-1.134l-0.5,-0.439l-0.653,-0.219l0.319,-0.367l0.292,-0.587l0.681,-0.513l0.292,-0.661l0.056,-1.029l0.521,-0.037l0.833,0.588l0.354,-0.405l-0.042,-0.441l0.208,-0.294l-0.792,-0.368l-0.611,-0.663l0.083,-0.443l0.181,-0.073l0.069,-1.107l0.278,-0.739l0.028,-0.74l0.278,-0.74l0.417,-0.593l0.389,-0.445l0.466,-0.333l0.479,0.037l0.41,-0.037l-0.007,0.26l-0.375,0.371l0.382,0.259l0.563,-0.333l0.438,0.333l1.14,-0.148l0.09,0.26l0.326,0.037l0.146,-0.259l0.319,-0.074l-0.243,-0.705l-0.361,0.148l-0.111,0.148h-0.778l-0.195,0.297l-0.278,-0.148l-0.007,-0.26l-0.667,-0.445l-0.66,-0.037l-0.924,-0.854l-0.243,0.111l-0.139,-0.148l0.222,-0.297l0.639,0.297l0.354,-0.334l-0.098,-0.224l0.542,-0.595l-0.194,-0.446l0.535,0.111l0.056,-0.446l0.827,0.707l0.194,-0.224l-0.215,-0.186l0.028,-0.596l0.583,0.149l0.174,0.856l0.604,0.334l0.521,-0.037l0.028,-0.223l-0.493,-0.186l-0.327,-0.112l0.083,-0.446l0.438,0.261l0.299,-0.186l-0.111,-0.224l-0.799,-0.186l-0.5,-0.447l-0.528,-0.448l-1.306,0.149l-0.466,-0.335l0.111,-0.522l0.382,-0.187l0.229,0.037l0.66,-0.635l0.298,0.336l-0.18,0.224l0.083,0.299h0.153l0.278,-0.672l0.083,-0.374l0.174,-0.412l0.604,0.262l-0.972,-1.123l-0.438,0.262l-0.423,0.262l-0.458,0.075l-0.646,0.412l-0.507,0.86l-0.382,-0.112l-0.271,0.411l-0.229,0.187l-0.257,-0.037l0.055,-0.299l-0.194,-0.523l-0.549,-0.187l-0.215,0.336l-0.202,0.411l-0.132,-0.262l0.236,-0.448l-0.25,-0.299l-0.375,-0.225l-0.202,-0.412l0.327,-0.412l-0.375,-0.224l-0.014,-0.824l-0.222,-0.301l-0.292,0.076l-0.389,-0.375l0.16,-0.488l0.306,0.3l0.507,-0.038l0.327,0.188l0.438,-0.413l-0.465,-0.338l-0.833,-0.15l-0.202,-0.263l-0.688,-0.188l-0.611,0.301h-0.278l-0.521,-0.113l-0.458,0.827l-0.542,0.45l0.361,0.451l0.403,0.075l-0.264,0.824l0.486,0.374l0.194,0.599l0.139,0.823v0.747l-0.32,0.074l-0.027,0.224l0.333,0.597l0.792,0.373l-0.347,0.298l-0.056,0.373l0.799,0.93l-0.354,0.559l0.458,0.594v0.667l-0.208,0.52l0.486,1.186l-0.056,0.296l0.028,0.518l-0.111,0.666l-0.139,0.591l-0.195,0.295l-0.41,0.037l-0.41,-0.332l0.014,-0.222l-0.262,-0.002l0.109,0.962l0.374,0.218l-0.026,0.224l-0.326,0.185l-0.257,0.553l-0.521,0.331l-0.063,0.258l-1.299,1.067l-0.861,-0.294l-0.473,0.147l-0.167,0.294h-0.473l-0.604,-0.037l-0.07,-0.515l-0.389,-0.221l0.222,-1.178l-0.264,-0.959l-0.167,-1.477l0.319,-0.888l-0.083,-0.444l-0.215,-0.037l-0.243,-0.555l0.111,-1.335l0.347,-0.297l-0.027,-0.594l-0.333,-0.595h-0.153l-0.07,0.373l-0.243,-0.112l-0.055,-0.447l-0.174,-0.855l-1.125,-1.118l0.264,-0.672l-0.431,-0.821l-0.306,-0.748l0.055,-0.375l0.438,0.112l-0.035,-0.711l-0.215,-0.187l-0.556,0.15l-0.827,-0.786l-0.535,-1.013l0.104,-0.864l-0.319,-0.676l0.139,-0.678l0.743,0.565l0.194,-0.151l0.215,-0.188l-0.347,-0.527l0.222,-0.452l0.271,0.113l-0.063,-0.415l-0.382,-0.038l-0.507,-0.868l-0.264,-0.075l-0.194,-0.68l0.16,-0.491l0.785,0.416l0.403,0.151l-0.111,-1.134l-0.264,-0.075l-0.223,-0.53l0.139,-0.606l0.472,-0.151l0.348,-0.303l0.063,-0.341l0.048,-0.266l-0.458,-0.759l0.57,-0.607l-0.327,-0.342l-0.333,0.304l-0.493,-0.19l-0.285,-0.418l-0.743,-0.724l0.16,-0.342l0.174,0.267l0.431,0.076l0.535,0.419l-0.396,-1.181l-0.354,-0.19l-0.473,0.152l-0.528,-0.457l-1.139,-0.61l-0.327,-0.878l0.271,-0.038l0.5,0.611l0.202,-0.115l-0.07,-0.458l-0.264,-0.076l-0.236,-0.535l-0.549,-0.038l-0.215,-0.65l0.132,-0.268l0.799,0.115l-0.111,-0.383l-0.493,-0.191l0.222,-0.306l0.424,-0.115l0.938,0.115l0.417,-0.153h0.723l0.174,0.268l0.347,0.536l0.236,0.537h0.292l0.167,-0.23l-0.208,-0.459l0.25,-0.459l0.5,-0.307l0.438,-0.038l0.201,0.881l0.25,0.307l0.32,-0.153l-0.132,-0.575l0.611,0.307h0.528l0.827,1.034l-0.056,-0.536l0.007,-0.345l0.41,-0.191l-0.111,-0.23l-0.848,-0.23l-0.201,-0.421l-0.896,-0.422l-1.049,-0.652l-1.612,-0.461l-0.576,-0.346l-0.611,-0.769l0.083,-0.539l0.827,-0.655l0.139,-0.154l0.063,-0.578l0.271,-0.347l0.778,0.309l0.243,-0.424l-0.382,-0.193l-0.25,0.154L267.084,316.962zM267.056,309.358l-0.472,0.156l-0.75,-0.156h-0.361l-0.833,-0.156l-0.723,-0.78l-0.667,-0.156l0.055,-0.469l0.167,-0.156h0.194l-0.056,-0.782l0.584,0.157l-0.049,-0.587l0.215,-0.195l0.556,0.156l0.167,0.157l0.389,0.156l0.445,0.156l0.389,0.47l0.271,0.43l-0.104,0.507l-0.556,-0.156l0.056,0.156l0.389,0.78h0.278l-0.104,-0.273l0.188,-0.351l0.417,0.625l0.417,-0.156l0.16,0.195l-0.104,0.585l-0.306,-0.313H267.056zM267.167,311.383l0.577,0.816l0.111,0.388l0.063,0.194l0.473,0.311l0.222,0.155l0.271,1.202l-0.41,0.503l-0.278,-0.31l-0.611,0.155l-0.333,0.155l-0.118,0.581l-0.438,0.657l0.077,0.426l-0.438,0.039l-0.139,-0.464h-0.389h-0.444l-0.583,-0.309l-0.09,-0.58l-0.083,-0.387l-0.069,-0.387l0.576,-0.039l0.063,-0.116l0.319,-0.155l-0.299,-0.194l-0.389,0.155l-0.027,-0.309l-0.495,-0.505l0.243,-0.427h0.25l0.889,0.465l0.028,-0.31h-0.223l-0.16,-0.272l0.438,0.117l0.333,-0.155l0.049,-0.271l-0.994,-0.194l-0.417,-0.311l-0.528,-0.467l-0.104,-0.583l0.465,-0.194l1.056,0.623h0.417l-0.111,-0.311h-0.25l-0.271,-0.35l0.076,-0.428l0.611,0.312l0.445,0.155l0.583,-0.311l0.299,0.194L267.167,311.383zM388.014,337.232h0.223l0.223,0.301l0.277,0.751h0.5l0.306,0.45l-0.222,0.751h-0.39l-0.194,-0.601l-0.194,-0.3l-0.611,-0.15l-0.584,-0.751h-0.25l-0.722,0.751h-0.278l-1.278,0.15l-0.333,0.15l-0.361,0.15l-0.306,-0.15l-0.39,0.15l-0.25,-0.601l-0.354,-0.789l0.291,-0.452l-0.041,-0.376l0.159,-0.64l-0.118,-0.415l-0.11,-0.603l-0.236,-0.075l0.11,-0.378l0.271,-0.339l0.556,0.302l0.389,-0.151l0.861,0.453l0.445,-0.302l0.416,0.151l0.195,0.604l0.659,0.49l0.285,0.414l0.466,0.489l0.034,0.414L388.014,337.232zM390.57,354.637l0.306,0.441l-0.021,0.257l0.243,0.184l1.223,0.294l0.889,-0.147l0.584,-0.441h0.389l0.361,0.588h0.473l0.194,0.293l-0.194,0.44l0.917,0.44l0.472,0.293l0.306,0.146l0.334,0.147l-0.167,0.293l0.883,0.695l-0.327,0.329l0.216,0.402l-0.604,0.475l-0.035,0.548l-0.271,0.329l-0.5,0.292l-0.306,-0.292l-0.75,-0.146l-0.945,0.583l-0.5,0.146l-0.313,0.547l-0.604,0.473l-0.306,-0.146l-0.528,0.146l-0.034,-0.546l-0.299,-0.474l-1.528,-0.292l-0.361,-0.583l0.188,-0.767v-0.512l-0.216,-0.037l-0.194,-0.292l-0.299,-0.476v-0.513l0.236,-0.219l0.069,-1.101l0.41,0.11l0.521,-1.064l-0.16,-0.552l-0.549,-0.405l0.549,-0.037L390.57,354.637zM525.422,361.667l0.361,-0.146l0.444,-0.146l0.243,0.182l0.201,0.11l0.077,0.182l-0.14,0.656h-0.152l-0.396,-0.4l-0.188,0.4l0.188,0.036l0.084,0.292l-1.091,0.036l-0.549,0.255l0.188,0.545l-0.104,0.182l-0.34,0.109l-0.209,0.072l-0.117,0.545l-0.89,-0.145l-0.091,-0.545l-0.347,-0.364v-0.364l0.021,-0.182l-0.229,-0.837l-0.208,-0.073l0.104,-0.255l0.222,-0.146h0.667h0.444l0.111,0.291l1.028,-0.146L525.422,361.667zM501.72,365.882l0.438,-0.181l-0.104,-0.689l0.556,-0.29h0.694l1.001,0.29l-0.16,0.544l0.077,0.181l1.111,-0.145l0.882,0.326l0.285,-0.036l0.194,0.436l0.528,0.145l0.222,0.145l0.64,1.013l0.166,0.289l0.556,0.579l0.258,0.253l0.326,0.325l1.39,-0.145l0.722,0.289l0.056,0.289l0.14,0.145l0.416,-0.145h0.445h0.583l0.361,-0.433l0.584,-0.289l0.194,-0.145h0.25l0.361,0.289l0.417,-0.578l0.444,-0.145l0.466,0.325l0.194,0.794l-0.16,0.325l-1.084,0.721l-1,0.289l-0.583,0.288l-0.807,0.432l-0.639,0.72l-0.806,0.432l-0.035,0.396l-0.243,0.179l-0.222,-0.287l-0.223,0.287l-0.035,0.323l-0.139,0.359l-0.465,0.323l-0.243,-0.395l0.208,-0.071l0.139,-0.646l-0.41,-0.179l-0.222,-0.144l-0.361,-0.719l-0.778,-1.007l-0.583,-0.577l-0.056,-0.433l-0.361,-0.145h-0.444l-0.14,0.145h-1.389h-0.473h-0.611l-0.25,-0.145l-0.528,-0.289l-0.222,0.145l-0.091,0.541l-0.188,0.325l-0.277,0.288l-0.584,-0.144l-0.223,-0.289l-0.5,-0.289l-0.861,0.144l-0.444,0.289l-0.389,0.864l-0.723,0.576l-0.5,0.431l-0.258,0.252l-0.382,0.18l-0.139,0.574l-0.556,0.574l-0.723,0.287l-0.556,0.287l-0.528,-0.287l-0.861,-0.574h-1.445l-0.465,-0.61l0.021,-0.396l-0.222,-0.144v0.288h-0.223l-0.021,-0.396l0.215,-0.18l0.444,0.144l0.64,-0.287l0.5,-0.144h0.444l0.577,-0.611l0.313,-0.973l0.75,-0.289l0.16,-0.397l-0.104,-0.324l0.007,-0.397l0.326,-0.325l0.445,0.145l0.556,-0.145l1.084,-0.145l0.688,-0.253l0.451,-0.326l0.479,-0.108l0.431,-0.795l-0.027,-0.652l-0.41,-0.907l0.973,0.29l-0.049,0.254l0.243,0.181L501.72,365.882zM275.955,406.526l-0.056,-0.414l0.236,-0.551l-0.077,-0.517l-0.278,0.827l-0.215,-0.173l0.181,-0.275l-0.069,-0.345l-0.007,-0.448l-0.327,-0.586l0.097,-0.622l-0.215,-0.449l-0.361,-0.276l-0.5,-0.276l-0.667,0.276l-0.132,-0.173l-0.063,-0.242l-0.583,-0.969l-0.327,-0.174l-0.09,-0.658l-0.417,-0.277l-0.028,-0.278l-0.583,-0.139l-0.25,-0.139l-0.667,-0.277l-0.083,0.277l-0.25,0.694h-0.25l-0.278,0.555h-0.222l-0.444,-0.555l-0.333,-0.556l-0.215,-0.451l-0.111,-0.903l-0.229,-1.287l-0.257,-0.662l-0.319,-1.046l-0.083,-1.188l0.347,-0.349l0.111,-0.63l-0.493,-0.595l-0.577,-0.315v-0.701l-0.083,-0.421l-0.069,-1.194l-0.215,-0.457l-0.243,-0.035l-0.083,-0.353l0.153,-0.141l-0.215,-0.458l-0.465,-0.176l-0.458,-2.328l-0.347,-0.212l-0.083,-0.424l-0.257,-0.672l-0.091,-0.531l-0.569,-0.637l-0.278,-0.851l-0.153,-0.923l-0.327,-0.177l-0.354,-0.604l-0.028,-0.641l-0.202,-0.32l-0.361,-0.712l-0.306,-0.285l-0.306,-0.713l-0.333,-0.428l-0.104,-0.321l0.431,-1l-0.208,-0.358l0.375,-0.5l-0.125,-0.931l0.236,-0.574l-0.319,-0.502l-0.028,-0.574l0.208,-0.431l-0.083,-0.504l-0.931,-1.799l-0.063,-0.541l0.473,-0.145h0.528l0.417,0.577l0.5,0.289l1,-0.289l0.167,0.145l0.611,0.288l0.25,0.576l0.417,0.144l0.222,-0.144l1.112,1.007l0.444,1.15l0.611,0.144l0.09,0.538l0.347,0.358l-0.243,0.395l-0.639,-0.143l0.298,0.608l-0.243,0.537h-0.25l-0.028,-0.286l-0.549,0.179l0.348,0.286l-0.236,0.572l0.056,0.501l0.403,0.071l0.194,0.429l-0.153,0.214l0.66,1.177l-0.077,-0.535l0.215,-0.321l0.417,0.143h0.278l0.861,0.428l0.243,0.321l0.313,0.534l0.188,0.605l-0.348,0.498l0.354,0.463l0.243,0.035l-0.438,0.675h-0.223l-0.132,-0.249l0.104,-0.319l-0.528,-0.427l-0.41,0.604l0.236,0.355l-0.347,0.213l-0.202,0.532l-0.076,0.319l0.104,0.391l-0.048,0.744l-0.507,0.248l-0.243,0.035l0.465,0.672l0.389,-0.141l0.111,-0.425l0.243,0.177l0.278,0.779l-0.271,-0.248h-0.528l0.194,0.707h0.473l0.167,0.283h0.389l0.083,-0.283l0.167,-0.141l0.215,0.176l-0.104,0.53l-0.41,0.035l-0.174,0.248l-0.41,0.599l0.347,0.283l-0.048,0.528l0.215,0.035l0.028,0.774l-0.299,0.035l-0.049,0.247l0.16,0.175l0.361,-0.141l0.167,0.282h0.5l0.445,-0.282l0.063,0.669l0.264,0.07l-0.125,0.773l0.243,0.315l0.438,0.315l-0.181,0.352l0.215,0.456l0.243,0.035l0.055,0.491l-0.271,0.595l-0.271,0.035l-0.222,0.42l-0.118,0.804h0.222l0.389,-0.559l0.111,-0.42h0.222l0.028,0.28l0.389,0.14l0.445,-0.279l1.167,0.14l-0.063,0.664l-0.181,0.14l0.347,0.349l0.014,0.768l0.458,0.349l-0.098,0.627l0.236,0.07l0.396,1.08h0.473l0.222,0.695l0.444,0.139l-0.021,0.382l0.319,0.347l0.34,0.243l0.028,0.278l0.063,0.243l0.521,0.312l0.528,0.139l1.195,-0.139l0.382,0.312l-0.264,0.693l0.014,1.314l-0.153,0.069l-0.139,0.76l0.215,0.449l0.577,0.31l-0.125,0.759l0.903,1.446l-0.07,0.481l0.181,0.412l0.223,0.893l0.507,0.652l0.368,1.199l0.403,0.615l0.042,0.411l-0.306,0.888l0.326,0.581l0.007,0.512l0.597,0.886l-0.097,0.613l0.188,0.578l0.215,0.034l-0.132,0.646h-0.5l-0.25,-0.136l-0.444,-0.407l-0.556,-0.408h-0.445l-0.25,-0.545l-0.243,0.034l0.049,0.374h-0.361l-0.25,-0.136l-0.417,-0.545l-0.299,-0.716l-0.035,-0.375l-0.445,-0.956l-0.298,-0.17l0.333,-0.479l0.375,-0.479l-0.139,-1.438l-0.41,-0.72l-0.306,-0.137l-0.583,-0.824l-0.473,-0.138l-0.667,-0.687L275.955,406.526zM407.11,374.068l0.438,0.179l0.243,0.682l-0.243,0.609l-0.41,0.322l-0.646,1.966l-0.743,-0.464l-0.027,-0.357l0.347,-0.572l-0.319,-0.214l-0.118,-0.394l-0.104,-0.25l0.652,-0.215l0.091,-1.398h0.583L407.11,374.068zM480.073,386.063h-0.473l-0.473,0.423h-0.222l-0.139,-0.141l-0.361,-0.141l-0.361,0.141l-0.528,0.706l-0.188,-0.317l0.042,-0.777l-0.056,-0.777l-0.153,-0.566l-0.034,-0.389h-0.861l-0.223,-0.708l-0.611,-0.283l-0.41,-0.461l-0.646,-0.674l-0.445,-0.568l-0.104,-0.178l-0.111,-0.711l0.098,-0.925l-1.098,-2.496l0.027,-0.429l-0.111,-1.074l0.743,-0.322l0.334,-0.43h0.417l0.194,-0.43l0.139,-0.287h1.084l0.104,0.251l0.423,0.18l0.14,0.573l0.389,0.43l0.354,0.608l0.063,0.68l0.257,0.25l0.292,0.5l-0.098,0.357l0.14,0.285l0.458,0.499l0.223,0.713l0.146,0.25l0.306,0.285l0.361,0.569l0.188,0.178l0.139,0.356l0.563,0.746l0.701,0.249l0.743,0.177l-0.027,0.709l-0.118,0.249l-0.209,0.07l-0.041,0.708l-0.14,0.354l-0.159,0.46l-0.111,0.425l-0.056,0.424L480.073,386.063zM409.854,413.138l-0.389,-0.272l-0.389,0.272l-0.39,0.683l-1.056,0.272l-0.778,0.272h-0.361l-0.889,0.409l-0.584,-0.409l-0.583,0.137l-0.556,0.136l-0.556,0.408l-0.084,0.272l-0.167,0.408l-0.583,0.136l-0.64,0.68l-0.806,-0.271l-0.188,-0.714l-0.118,-0.646l-0.361,-0.136l-1.473,-0.137h-1l-0.528,0.272l-0.306,-0.136l-0.027,-0.409h0.389l0.132,-0.307l-0.347,-1.023l0.632,-0.17l0.299,-0.443l0.111,-0.752l-0.132,-1.266l-0.445,-0.686l-1.444,-0.274l-0.216,-0.308l0.521,-0.104l0.527,-0.137l0.334,0.137l0.215,-0.651l-0.041,-0.55l-0.091,-0.31h-0.306l-0.396,-0.584l-0.236,-0.412l0.152,-2.137l-0.354,-0.725l-0.466,-0.726l-0.098,-1.453l-0.771,-1.005l-0.75,-0.277l-0.778,-0.278l-1.278,-0.693l-0.861,-0.278l-0.611,-0.556l-0.632,-0.035l0.416,-1.601l0.223,-0.278l0.243,-0.314h0.556l0.584,-0.419l0.639,-0.279l0.944,-0.279l0.528,-0.279l0.444,-0.14l0.417,-0.14l0.861,-0.279l0.584,-0.419l0.583,-0.14l0.751,-0.141l0.944,-0.28l0.167,-0.42h2.361l0.39,-0.14l0.277,-0.14l0.14,-0.42l0.076,-0.175l0.284,-0.386l0.035,-0.526l-0.007,-0.175l-0.361,-0.843l-0.306,0.141l-0.243,-0.105l0.625,-0.492l0.201,-0.95h0.417l0.39,-0.282l0.389,-0.705l0.5,0.282h0.528l0.111,-0.282h0.222l0.223,0.423l0.215,0.035l-0.152,0.422l0.104,0.247l4.362,0.141v0.281l0.444,0.282l0.223,-0.142l0.473,0.282l0.306,0.562l0.611,-0.281v-0.704h0.36h0.473l0.167,-0.281l0.194,-0.141h0.306l0.389,-0.141h0.223l-0.299,0.668l0.326,0.035l0.14,0.282l0.444,-0.563l0.243,0.035l-0.25,0.704l-0.236,0.352l0.514,0.351l0.14,0.492l0.146,0.175l0.104,0.175l-0.076,0.246l-0.361,-0.141l-0.188,0.526l0.409,0.035l0.111,0.42l-0.528,0.28l-0.076,0.175l0.104,0.245l-0.076,0.455l0.041,1.049l-0.264,0.698l0.326,0.313h0.334l0.188,0.314l-0.264,0.767l0.521,0.592l0.66,0.592l0.277,1.112l0.056,0.277l-0.319,2.012l0.194,0.554l0.431,0.623l-0.236,0.691l0.056,0.621l0.493,1.001l-0.076,0.724v1.17l0.056,0.481l-0.139,0.481l0.104,0.171l0.465,0.034l-0.549,0.79h-0.277l-0.16,0.72l0.076,0.377l0.41,0.172l0.027,0.343l-0.444,0.821l-0.083,0.547l-0.403,0.341l-0.229,0.239l-0.25,0.273l-0.611,0.546l-0.389,0.137l-0.584,-0.272l-0.556,-0.137l-0.333,0.137l-0.389,0.136v-0.682h-0.584l-0.667,-0.138l-0.361,-0.137l-0.777,0.956H409.854zM423.582,468.699l-0.556,-0.89l-0.577,-0.286l0.132,-0.351l0.035,-0.413l-0.139,-0.701l0.549,-0.415h0.889l0.584,-0.511l-0.133,-0.99l0.334,-0.512l0.348,-0.896l-0.348,-0.704l-0.341,-0.354l-0.882,-1.443l-0.25,-0.386l0.056,-0.193l0.438,0.097l0.556,0.386l0.694,0.129l1.057,-0.386l0.806,-0.386l0.861,-0.257l0.076,-0.226l-0.215,-0.547l-0.445,0.129l-0.576,-0.29l0.076,-0.226l0.466,-0.161l-0.216,-0.612l-0.09,-0.29l-0.16,-0.354l-0.306,-0.258l-0.723,-0.13l-0.583,-0.129l-1.028,0.129l-0.466,0.807l0.181,0.58l-0.444,0.451l-0.236,-0.322l0.028,-0.838l0.152,-0.387l-0.111,-1.034l-0.938,-1.066l-0.466,-0.291l-0.646,-0.228l-0.611,-0.388l-0.473,-0.13l-0.132,0.227l0.264,0.648l-0.326,0.808l-0.444,0.518l-1.001,0.258l-0.277,0.388l-0.5,0.259l-0.035,0.483l-0.299,0.419l-0.25,-0.129l-0.639,0.129l-0.25,0.258l-0.556,0.773h-0.307l-0.229,0.097l-0.167,0.129l-0.264,0.321l-0.111,0.257l0.152,0.322l-0.326,0.546l-0.278,-0.129l-0.11,-0.385h-0.194l-0.188,0.225l-0.09,0.16l-0.223,0.258l-0.139,0.385l-0.5,0.257l-0.723,0.257l-1.695,-0.128l-0.722,-0.386h-0.334l-1,0.257l-0.611,0.257l-0.271,0.417l-0.201,0.353l-0.25,0.129l-1.334,0.512l-0.639,0.385l-1.278,1.023l-0.778,0.384l-0.861,0.255l-1.056,-0.383l-0.417,0.255l-0.694,0.128h-0.334l-0.299,-0.287l-0.083,-1.344l0.194,-0.896l0.167,-0.77l0.111,-0.385l0.097,-0.577l-0.111,-0.45l-0.632,-0.547l-0.076,-0.289l0.181,-0.579l0.451,-0.161l0.382,-0.29l-0.264,-1.096l0.319,-0.193l0.396,-1.13l0.25,-0.13l0.083,0.259l0.723,-0.129l0.806,-0.13l0.667,-0.388l0.604,-0.938l0.139,-0.454l0.056,-0.453l0.25,-1.882l-0.166,-1.301l0.083,-1.237l0.083,-1.305l0.153,-1.241l0.409,-1.08l0.535,-1.146l0.493,-0.951l0.091,-0.625l0.277,-0.788l0.383,-0.296l0.277,-0.396l0.083,-0.263l0.174,-0.495l0.271,-0.296l0.472,-0.264l0.111,-0.66l0.007,-0.297l0.028,-1.256l0.25,-1.059l0.188,-0.431l0.632,-0.298l-0.181,-0.929l-0.007,-0.232l-0.299,-0.697l-0.257,-0.365l-0.389,-0.665l-0.64,-0.399l-1.278,-0.533l-0.917,-0.133l-0.527,-0.4l-0.438,-0.699l-0.125,-0.868l-0.688,-1.103l-0.777,-0.536l-0.611,-0.535l-0.361,-0.134l-0.306,-0.269l-0.716,-1.106l-0.014,-0.47l-0.271,-0.437l-1.056,-0.537l0.188,-1.447l0.056,-0.472l0.313,-0.506l0.473,-0.54l0.917,-0.675l0.528,-0.405l1.167,-0.946l1.139,-0.542l0.5,0.136l1.084,-0.406l0.716,-0.848l0.063,-0.509l0.139,-0.406l0.723,0.135l0.528,0.136l0.444,-0.407l0.361,-0.271l0.306,0.408l0.527,-0.137l0.271,-0.305l-0.132,-0.782h0.5l0.75,-0.271l0.611,-0.137l0.64,0.137l0.534,0.169l0.243,0.103l0.834,0.136l0.694,0.136h0.528h0.333l1.167,-0.136l-0.382,0.441l0.188,0.374h0.39l0.583,0.136l0.473,-0.136v-0.407l0.194,-0.136l0.473,-0.137h0.389h0.694l0.39,0.137l0.694,-0.137l0.257,-1.054l0.354,-0.578l1.195,0.136l0.639,-0.272l0.25,-0.272l0.695,-0.409l2.056,-0.546l0.834,0.683l0.993,0.715l0.341,0.783l0.972,0.272l0.633,0.577l-0.014,1.155l0.902,1.694v1.15l-0.5,1.217l-0.792,1.281l0.542,0.674l-0.125,0.74l0.111,0.403l0.458,1.21l0.174,0.436l0.167,0.269l1.021,1.508l0.152,0.737l0.514,1.002l-0.027,0.468l-0.271,0.434l0.472,0.533l0.611,0.134l0.633,-0.101l0.25,0.733l-0.104,0.433l0.146,0.5l0.438,0.033l0.438,0.698l0.284,0.764l0.807,-0.266l0.242,0.166l0.369,0.896l0.556,0.133l-0.111,-0.398l-0.229,-0.764l-0.236,-0.398l0.41,-0.299h0.473l0.556,0.398l0.104,-0.632l-0.243,-0.565l-0.048,-0.366l0.854,-0.433l0.583,-0.134l0.167,0.4h0.333l0.306,-0.4h0.334h0.806l0.027,0.533h0.556l0.271,0.433l-0.292,0.399l0.243,0.232h1.251v-0.266h0.333l0.417,0.266l0.306,0.532l0.966,0.1l-0.251,1.526l-0.375,0.928l-0.146,0.365l-0.438,0.694l-0.584,1.454l-0.361,2.109l0.125,1.382l-0.25,0.854l0.674,1.148l0.466,0.557l-0.069,0.852l0.014,0.916l-0.882,2.121l-0.89,0.261l-0.306,0.131l-0.299,0.684l-0.069,1.496l-0.486,0.844v0.325l0.292,0.194l-0.056,0.843l-0.403,0.323l-0.368,0.097l-0.25,0.13l-0.194,0.776l-0.299,0.421l0.319,0.774l-0.11,0.969l-0.604,0.806l-0.771,0.29l-0.146,1.384l-0.611,-0.129l-0.299,0.418l-0.083,0.322l-0.056,1.026l0.125,0.577l-0.132,0.354l-0.667,0.384l-0.883,0.288l-0.194,0.832l0.542,0.256l-0.132,0.288l-0.278,0.383l-0.417,0.384l-0.667,0.383l-0.368,0.351l-0.319,0.447l0.181,0.191l-0.465,0.541l-0.223,-0.255h-0.334l-0.409,0.414l-0.007,0.351l-1.084,0.127l-0.723,1.526l-0.444,-0.127l-0.299,0.476l0.111,0.571l0.132,0.35l-0.91,0.031l0.049,0.349l0.466,0.349l-0.077,0.158h-0.389l-0.444,0.507l-0.278,0.38l-0.201,0.222l-0.132,0.411v0.505l-1.084,0.506l-0.778,0.127l-0.444,0.126l-0.528,0.378l-0.799,1.04l0.098,0.442l-0.326,0.534l-0.39,0.629l-0.611,0.126l-0.806,-0.503l-0.368,-0.85l-0.486,-1.387l0.083,-0.505l0.799,-0.79l0.035,-0.663l0.194,-0.57l0.334,-0.887l0.569,-0.443l0.167,-0.761l-0.042,-0.572L423.582,468.699zM460.845,508.831l-0.341,1.056l-0.598,0.784l-0.041,0.421l-0.473,0.843l-0.875,1.142l-0.508,0.93l-0.222,0.24l-0.452,0.809l-0.431,0.419l-0.723,1.913l-0.306,0.717l-0.306,0.716l0.125,0.298l-0.5,1.132l-0.139,0.416l-0.604,1.1l-0.433,0.277l-0.144,0.286l0.375,0.415l-0.084,0.298l-0.242,0.267l-0.584,0.354l-0.215,-0.385l-0.028,-1.127l0.542,-0.415l0.152,-1.249l0.611,-1.667l0.306,-0.477l0.32,-0.418l0.041,-0.418l0.778,-0.717l0.194,-0.479l0.361,-0.838l0.466,-0.748l0.361,-0.6l0.201,-0.21l0.598,-0.78l0.152,-0.66l0.084,-0.241l0.597,-0.781l0.403,-1.265l0.389,-0.604l0.167,-0.361l0.354,-0.513l0.333,-0.242h0.556L460.845,508.831zM375.711,626.352l0.883,0.338l0.243,0.338l-0.069,0.571l0.604,0.234l0.445,0.519l0.299,0.493l-0.084,0.569l-0.139,0.777l-0.083,0.311l-0.167,0.517l-0.604,0.853l-0.326,0.388l0.056,0.464l-0.07,0.877l-0.299,0.541l-0.861,-0.412l-0.048,0.489l0.235,0.052l0.028,0.36l-0.493,0.334l-1.174,-1.932l-0.598,-0.36l-0.229,-0.491l-0.472,-0.413l-0.361,-0.517l-0.521,-0.749l-0.167,-0.725l-0.041,-0.674l-0.486,-0.727l0.277,-0.83l0.633,-0.649l0.611,0.312l0.583,-0.207l0.139,-0.416h0.417h0.64l0.583,-0.104h0.167L375.711,626.352z"
				}
			]
		}
	}
};