﻿// (c) ammap.com | SVG (in JSON format) map of Sudan - High
// areas: {id:"SD-DC"},{id:"SD-DE"},{id:"SD-DN"},{id:"SD-DS"},{id:"SD-DW"},{id:"SD-GD"},{id:"SD-GK"},{id:"SD-GZ"},{id:"SD-KA"},{id:"SD-KH"},{id:"SD-KN"},{id:"SD-KS"},{id:"SD-NB"},{id:"SD-NO"},{id:"SD-NR"},{id:"SD-NW"},{id:"SD-RS"},{id:"SD-SI"}
AmCharts.maps.sudanHigh={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"21.838183",
				"topLatitude":"23.146564",
				"rightLongitude":"38.584046",
				"bottomLatitude":"8.676071"
			}
		},
		"g":{
			"path":[
				{
					"id":"SD-DC",
					"title":"Central Darfur",
					"d":"M57.819,415.263L60.819,414.281L65.062,411.077L65.486,410.565L67.069,410.372L68.6,411.496L69.19,411.482L71.121,412.687L71.432,412.079L72.824,411.883L74.494,412.492L74.538,413.868L74.029,415.143L74.25,415.871L73.742,417.165L74.558,417.459L75.488,417.698L76.296,416.942L76.293,413.504L78.091,414.631L78.721,416.356L80.383,417.768L83.09,417.547L83.854,417.288L85.527,417.592L87.015,417.378L87.641,417.613L88.951,417.23L89.846,417.879L88.124,418.84L90.248,419.618L90.497,420.421L93.277,423.341L94.434,422.191L99.357,422.507L100.053,418.968L109.132,416.48L111.831,416.647L112.647,416.436L116.751,416.141L117.933,417.592L114.088,424.255L111.981,425.501L110.578,426.842L109.438,427.284L107.861,427.306L106.646,427.634L106.133,428.036L106.133,428.036L105.469,428.687L104.655,430.026L104.263,433.694L102.939,436.771L98.771,442.755L95.736,446.042L94.238,447.361L99.198,457.132L100.912,458.786L101.892,464.231L101.462,467.793L100.911,467.623L100.17,467.776L99.255,466.636L94.62,467.141L93.823,468.018L90.501,469.585L90.502,470.385L89.688,471.795L89.04,470.844L88.167,471.094L85.893,471.039L86.262,472.126L85.156,472.305L82.529,473.987L81.289,474.183L80.667,475.335L79.031,476.021L77.454,478.465L77.33,481.815L76.064,489.388L77.256,498.394L70.769,506.929L68.155,508.528L48.319,528.555L48.319,528.555L47.321,527.852L46.413,525.647L44.18,522.836L44.146,522.163L42.701,520.836L42.373,519.898L44.854,512.871L45.138,512.728L46.815,508.24L46.652,504.249L45.896,503.694L45.478,503.593L45.15,499.24L42.126,499.34L38.772,499.822L38.722,498.367L37.352,496.847L33.595,495.175L31.167,492.685L29.675,490.822L29.209,487.781L32.653,473.128L32.487,472.71L31.508,473.015L30.505,472.794L30.125,472.969L29.464,472.936L29.464,472.936L32.2,471.116L32.265,470.3L32.557,469.714L33.863,468.605L34.299,467.033L34.779,466.639L35.385,465.125L36.057,464.618L36.502,463.844L36.45,463.367L35.224,460.407L34.302,459.276L34.52,454.771L33.607,452.763L33.413,451.295L32.567,450.125L31.678,447.718L31.705,447.032L39.666,439.629L40.105,439.462L41.128,438.138L41.646,437.839L42.367,438.132L42.873,437.031L42.464,435.998L42.516,434.74L45.982,431.059L45.585,430.749L44.856,429.406L44.975,428.969L48.132,425.644L48.84,423.514L52.895,423.746L54.381,421.796L55.652,418.602L55.742,417.266z"
				},
				{
					"id":"SD-DE",
					"title":"East Darfur",
					"d":"M135.787,435.367L137.826,434.811L138.529,434.828L139.861,435.608L141.229,435.415L143.148,435.449L147.292,435.822L148.165,435.362L149.324,435.398L150.372,436.217L152.557,436.099L152.766,436.365L152.524,439.058L152.697,439.668L153.116,440.24L158.822,443.015L160.231,444.194L163.576,444.321L173.158,455.8L173.292,456.448L173.201,458.334L172.898,458.907L172.024,458.985L170.636,458.568L169.914,458.569L168.947,459.448L168.225,459.717L167.046,459.585L166.419,459.263L165.337,460.294L165.11,460.732L167.778,464.289L168.068,466.459L169.799,467.388L171.167,467.461L171.037,468.566L172.449,471.57L176.385,472.799L176.539,473.617L177.757,474.661L177.891,475.155L177.664,475.745L183.889,480.157L192.795,481.39L196.381,482.402L200.789,485.343L202.048,485.882L203.34,485.814L206.14,484.728L210.178,483.819L214.673,483.875L216.888,484.444L218.567,485.929L219.96,486.771L219.96,486.771L220.746,499.922L221.528,508.23L223.873,517.504L247.353,574.049L247.353,574.049L242.824,574.502L237.256,573.854L226.954,573.735L222.401,573.454L215.661,573.813L211.697,574.602L199.187,579.021L196.02,578.785L184.884,575.378L181.743,571.6L178.566,561.431L173.41,556.327L172.721,554.635L171.583,552.946L168.815,551.178L166.881,550.629L166.999,542.359L166.672,542.153L165.978,541.122L163.653,540.298L163.653,540.298L162.37,528.892L160.354,520.892L156.241,508.512L152.241,502.808L156.944,500.854L158.506,497.794L153.208,495.281L149.057,493.083L136.208,483.359L132.256,479.616L128.026,476.04L127.295,475.167L127.444,468.713L142.733,467.31L144.785,466.06L145.784,465.005L146.131,464.36L145.953,462.171z"
				},
				{
					"id":"SD-DN",
					"title":"North Darfur",
					"d":"M129.004,137.091L231.03,137.246L231.03,283.645L231.03,283.645L208.034,283.711L210.437,309.217L214.848,348.875L216.345,356.77L219.257,358.824L228.702,387.574L228.702,387.574L230.748,393.613L229.208,402.816L230.598,404.423L232.124,407.235L232.15,410.815L231.3,413.133L231.434,413.535L226.391,419.725L226.19,423.95L225.395,425.232L225.283,426.36L225.722,426.856L216.659,437.534L215.814,442.556L215.749,448.012L216.153,450.356L215.777,452.893L215.153,454.248L212.672,458.217L212.238,459.761L212.698,461.76L213.461,463.187L213.865,465.604L213.396,468.728L213.287,470.936L214.355,473.293L215.442,474.852L219.96,486.771L219.96,486.771L218.567,485.929L216.888,484.444L214.673,483.875L210.178,483.819L206.14,484.728L203.34,485.814L202.048,485.882L200.789,485.343L196.381,482.402L192.795,481.39L183.889,480.157L177.664,475.745L177.891,475.155L177.757,474.661L176.539,473.617L176.385,472.799L172.449,471.57L171.037,468.566L171.167,467.461L169.799,467.388L168.068,466.459L167.778,464.289L165.11,460.732L165.337,460.294L166.419,459.263L167.046,459.585L168.225,459.717L168.947,459.448L169.914,458.569L170.636,458.568L172.024,458.985L172.898,458.907L173.201,458.334L173.292,456.448L173.158,455.8L163.576,444.321L160.231,444.194L158.822,443.015L153.116,440.24L152.697,439.668L152.524,439.058L152.766,436.365L152.557,436.099L150.372,436.217L149.324,435.398L148.165,435.362L147.292,435.822L143.148,435.449L141.229,435.415L139.861,435.608L138.529,434.828L137.826,434.811L135.787,435.367L135.787,435.367L132.584,436.33L130.113,436.335L128.745,435.994L126.403,434.013L123.895,433.77L122.981,433.484L121.115,431.292L119.459,430.226L117.73,430.478L114.518,429.7L113.739,429.97L109.536,428.641L107.218,428.607L106.133,428.036L106.133,428.036L106.646,427.634L107.861,427.306L109.438,427.284L110.578,426.842L111.981,425.501L114.088,424.255L117.933,417.592L116.751,416.141L112.647,416.436L111.831,416.647L109.132,416.48L100.053,418.968L99.357,422.507L94.434,422.191L93.277,423.341L90.497,420.421L90.248,419.618L88.124,418.84L89.846,417.879L88.951,417.23L87.641,417.613L87.015,417.378L85.527,417.592L83.854,417.288L83.09,417.547L80.383,417.768L78.721,416.356L78.091,414.631L76.293,413.504L76.296,416.942L75.488,417.698L74.558,417.459L73.742,417.165L74.25,415.871L74.029,415.143L74.538,413.868L74.494,412.492L72.824,411.883L71.432,412.079L71.121,412.687L69.19,411.482L68.6,411.496L67.069,410.372L65.486,410.565L65.062,411.077L60.819,414.281L57.819,415.263L57.819,415.263L58.054,409.094L60.661,407.477L58.788,406.234L57.759,404.35L56.434,401.754L56.602,400.188L55.97,398.727L55.928,395.282L56.563,392.877L56.685,390.197L57.916,387.146L57.11,385.911L55.609,385.474L54.377,386.764L50.867,383.586L52.596,378.39L47.59,368.727L42.588,371.803L39.535,368.585L39.11,365.395L39.961,366.018L42.131,354.935L39.4,351.946L37.328,351.407L37.328,351.407L37.879,350.629L39.799,348.742L41.351,347.679L42.106,346.489L43.011,346.013L44.159,346.056L44.937,345.464L44.597,343.016L45.212,342.377L46.376,341.735L46.844,340.682L47.257,340.256L47.372,340.014L46.845,338.911L47.026,337.964L47.54,337.015L47.019,335.668L46.99,334.403L47.258,333.234L46.981,332.498L44.538,330.424L44.205,329.44L44.451,328.358L44.294,327.914L44.369,327.258L45.521,325.649L46.95,325.565L47.576,325.196L48.847,324.003L49.739,322.347L50.869,321.866L52.374,320.122L53.648,320.027L54.308,320.322L55.483,320.366L56.146,320.174L56.633,320.5L57.229,320.484L58.552,320.821L61.773,321.115L64.394,320.825L65.5,320.438L68.391,318.972L70.977,318.272L74.398,318.109L76.981,318.629L80.27,318.739L86.721,320.374L88.263,320.333L88.193,137.246L129.004,137.246z"
				},
				{
					"id":"SD-DS",
					"title":"South Darfur",
					"d":"M106.133,428.036L107.218,428.607L109.536,428.641L113.739,429.97L114.518,429.7L117.73,430.478L119.459,430.226L121.115,431.292L122.981,433.484L123.895,433.77L126.403,434.013L128.745,435.994L130.113,436.335L132.584,436.33L135.787,435.367L135.787,435.367L145.953,462.171L146.131,464.36L145.784,465.005L144.785,466.06L142.733,467.31L127.444,468.713L127.295,475.167L128.026,476.04L132.256,479.616L136.208,483.359L149.057,493.083L153.208,495.281L158.506,497.794L156.944,500.854L152.241,502.808L156.241,508.512L160.354,520.892L162.37,528.892L163.653,540.298L163.653,540.298L160.795,540.958L160.183,541.452L157.775,541.411L155.979,541.782L154.633,541.782L148.797,543.555L146.634,543.514L145.328,543.802L144.553,544.173L143.083,544.296L142.349,544.708L140.104,544.873L138.717,544.379L138.227,544.461L137.941,544.708L137.533,544.791L137.084,544.626L135.411,545.12L134.309,544.997L132.228,545.697L131.898,545.971L131.208,547.511L130.473,548.541L130.228,549.529L129.575,550.601L129.575,552.083L130.106,553.236L130.106,554.225L129.657,555.419L128.922,556.448L127.902,559.248L127.045,560.153L126.474,561.266L125.943,561.883L123.862,563.199L122.638,564.27L121.944,564.64L121.005,564.722L120.638,564.969L119.577,567.562L119.005,568.466L118.526,568.724L119.007,570.144L119.019,573.761L119.444,575.264L119.46,577.166L118.56,579.17L116.865,580.296L113.33,583.075L113.395,584.091L113.99,585.799L112.828,587.917L111.828,591.406L110.838,596.155L112.053,600.244L111.858,601.487L111.061,602.434L110.333,602.872L109.226,604.743L108.521,605.482L103.02,608.273L98.713,612L98.845,611.018L98.505,610.661L98.212,610.615L97.356,610.947L96.596,611.627L95.322,610.877L94.907,610.822L93.572,611.457L89.727,610.735L87.967,610.816L86.89,610.124L85.769,609.911L83.03,610.469L80.766,609.631L79.345,609.787L77.54,610.482L76.512,610.205L75.004,610.108L73.079,609.317L72.203,609.331L70.951,609.479L70.137,610.481L68.609,610.037L68.597,608.729L68.124,608.197L68.264,607.299L68.137,606.433L68.36,605.97L69.291,605.522L69.684,605.125L70.628,603.801L71.095,602.828L71.409,601.535L71.31,598.943L70.94,598.54L70.629,598.495L69.064,600.332L67.915,600.394L66.987,599.749L66.383,599.602L66.293,598.641L65.782,598.408L65.658,598.135L66.34,596.962L66.288,596.104L66.771,594.961L66.634,594.028L66.821,593.005L67.381,592.676L67.461,591.741L68.008,591.72L68.176,591.445L68.914,591.696L69.658,591.541L71.649,589.767L72.316,589.367L72.379,588.744L72.697,588.186L73.195,587.684L73.78,587.756L73.959,587.623L74.126,587.104L73.486,585.54L73.465,584.736L73.944,582.649L74.47,582.138L75.03,580.813L74.838,580.162L74.639,580.069L73.979,580.252L73.659,580.526L73.238,579.367L73.56,577.647L74.141,576.795L74.018,576.645L73.034,576.563L73.201,575.893L73.917,575.332L74.083,574.745L74.5,574.167L74.642,573.438L75.863,571.398L74.654,562.19L59.703,538.169L58.15,537.346L57.232,536.024L55.928,535.246L55.181,534.18L53.894,533.116L52.687,531.352L50.954,530.396L50.361,529.765L48.319,528.555L48.319,528.555L68.155,508.528L70.769,506.929L77.256,498.394L76.064,489.388L77.33,481.815L77.454,478.465L79.031,476.021L80.667,475.335L81.289,474.183L82.529,473.987L85.156,472.305L86.262,472.126L85.893,471.039L88.167,471.094L89.04,470.844L89.688,471.795L90.502,470.385L90.501,469.585L93.823,468.018L94.62,467.141L99.255,466.636L100.17,467.776L100.911,467.623L101.462,467.793L101.892,464.231L100.912,458.786L99.198,457.132L94.238,447.361L95.736,446.042L98.771,442.755L102.939,436.771L104.263,433.694L104.655,430.026L105.469,428.687z"
				},
				{
					"id":"SD-DW",
					"title":"West Darfur",
					"d":"M37.328,351.407L39.4,351.946L42.131,354.935L39.961,366.018L39.11,365.395L39.535,368.585L42.588,371.803L47.59,368.727L52.596,378.39L50.867,383.586L54.377,386.764L55.609,385.474L57.11,385.911L57.916,387.146L56.685,390.197L56.563,392.877L55.928,395.282L55.97,398.727L56.602,400.188L56.434,401.754L57.759,404.35L58.788,406.234L60.661,407.477L58.054,409.094L57.819,415.263L57.819,415.263L55.742,417.266L55.652,418.602L54.381,421.796L52.895,423.746L48.84,423.514L48.132,425.644L44.975,428.969L44.856,429.406L45.585,430.749L45.982,431.059L42.516,434.74L42.464,435.998L42.873,437.031L42.367,438.132L41.646,437.839L41.128,438.138L40.105,439.462L39.666,439.629L31.705,447.032L31.678,447.718L32.567,450.125L33.413,451.295L33.607,452.763L34.52,454.771L34.302,459.276L35.224,460.407L36.45,463.367L36.502,463.844L36.057,464.618L35.385,465.125L34.779,466.639L34.299,467.033L33.863,468.605L32.557,469.714L32.265,470.3L32.2,471.116L29.464,472.936L29.464,472.936L29.076,472.912L28.25,473.243L26.638,474.259L25.807,474.306L25.233,474.014L25.814,473.876L26.516,471.774L26.427,471.289L26.67,468.951L26.413,467.551L26.048,466.704L25.979,466.002L25.576,465.63L24.69,463.825L24.636,463.129L23.665,460.146L23.869,459.39L23.791,459.019L22.646,457.67L22.005,457.531L21.744,457.122L21.76,456.79L23.719,453.984L25.279,449.204L24.98,448.911L23.573,448.618L21.241,447.656L18.303,446.194L14.648,443.966L14.533,445.764L14.079,446.343L13.287,446.932L12.133,447.47L7.913,448.661L4.959,448.568L4.168,448.73L3.123,447.52L1.994,446.614L1.687,445.672L1.099,445.239L0.777,444.631L0.853,443.771L0.178,442.478L0.025,441.539L0.383,440.372L0.591,438.496L1.623,436.725L2.437,434.334L2.954,433.477L3.534,433.193L3.75,432.809L3.839,432.085L3.539,431.622L4.082,431.273L4.422,430.744L5.139,430.547L5.84,429.767L6.708,429.3L7.127,427.899L9.5,427.613L9.944,426.911L11.026,426.894L12.068,426.589L12.551,425.549L13.606,424.616L14.091,423.366L15.162,422.283L15.611,422.116L15.977,421.355L16.519,420.958L17.229,419.916L18.171,419.01L18.114,417.669L17.939,417.306L17.167,416.631L16.697,416.566L16.388,416.195L16.296,415.391L15.592,414.754L15.407,413.954L15.626,413.245L15.416,412.396L15.628,410.695L15.295,409.971L14.579,409.335L13.514,408.73L13.134,407.86L12.76,407.892L12.538,407.664L12.096,406.353L11.487,405.734L11.318,405.017L11.855,403.736L11.633,403.46L11.629,403.038L10.658,402.203L10.278,401.66L10.336,401.217L12.666,397.874L15.127,395.379L16.035,394.067L18.479,392.921L19.964,391.408L21.201,391.137L22.6,389.779L24.164,389.732L27.129,387.288L28.461,386.911L30.092,384.505L30.205,384.158L29.158,383.129L29.352,382.263L27.664,381.672L26.131,382.167L24.188,379.984L24.084,379.216L24.34,378.8L25.326,378.32L25.42,378.107L25.159,376.946L24.675,376.586L24.577,374.327L24.921,372.103L24.84,371.68L23.309,370.722L22.252,370.665L23.352,366.932L24.18,366.876L24.648,366.544L24.821,366.542L25.017,366.887L25.177,366.472L26.243,365.762L27.919,365.312L31.764,364.651L35.842,363.135L35.984,362.932L35.602,360.952L33.959,356.328L34.527,355.239L35.303,354.57L36.188,354.296L36.806,354.398L37.469,354.059L37.563,353.451L37.182,352.624z"
				},
				{
					"id":"SD-GD",
					"title":"Al Qaḑārif",
					"d":"M503.792,319.216L504.313,319.906L507.119,322.053L507.896,322.373L509.217,322.554L509.76,323.416L511.197,324.838L515.956,325.76L516.694,325.68L518.248,326.061L518.946,325.9L520.015,326.562L523.064,327.903L524.986,329.046L525.045,330.908L524.598,334.592L524.151,335.132L525.55,335.853L529.454,338.475L530.871,338.654L537.028,342.135L537.3,342.415L537.746,344.574L539.844,349.83L540.66,350.71L542.951,353.985L547.281,353.534L558.371,353.155L563.366,352.691L565.815,346.961L565.977,344.935L567.461,344.079L568.186,343.905L569.291,341.488L569.448,340.548L568.355,338.048L567.387,336.752L567.429,336.029L567.963,335.446L568.41,336.491L569.227,337.416L570.287,338.257L571.145,340.821L571.634,341.536L572.817,342.082L573.92,343.805L574.817,344.099L575.226,344.855L575.797,345.443L576.123,346.241L576.45,346.493L576.613,347.418L577.052,348.126L579.756,350.807L581.381,350.693L581.993,349.731L582.319,348.711L583.256,348.731L586.45,346.943L595.907,343.839L595.907,343.839L597.025,352.201L597.181,356.045L597.587,358.655L598.544,370.446L598.766,371.342L598.766,372.595L599.422,378.102L600.297,380.649L600.697,380.875L600.808,380.729L600.844,380.97L600.347,381.404L600.082,381.386L599.978,383.586L596.807,393.082L598.286,398.27L596.1,401.724L594.342,406.763L593.482,410.856L592.786,411.715L589.417,417.91L586.03,430.672L585.238,433.238L584.333,435.115L584.165,436.346L584.493,437.081L585.226,437.914L585.308,438.84L585.103,442.824L584.821,444.369L584.299,445.781L584.337,446.606L584.11,446.776L582.324,446.639L582.23,446.179L581.856,445.71L580.889,445.264L580.004,445.135L579.292,445.318L578.255,445.313L577.984,445.711L568.63,447.691L568.193,447.342L567.623,447.825L567.152,447.749L566.534,447.285L565.57,447.475L565.57,447.475L563.804,446.535L561.684,445.954L561.474,445.586L560.76,445.423L560.076,444.628L557.798,445.345L556.885,445.14L555.902,445.381L551.919,444.747L550.455,444.349L549.384,443.056L547.782,442.051L546.755,441.808L546.409,441.159L544.906,440.88L543.872,439.356L542.325,437.893L541.526,437.782L540.312,438.094L537.602,435.871L536.767,436.295L535.757,435.842L535.448,434.849L534.364,434.683L532.304,433.163L532.415,432.589L532.032,432.056L529.363,430.48L529.609,429.479L528.765,428.591L528.799,427.73L528.492,427.157L527.959,427.084L527.424,426.417L526.358,426.153L525.789,426.386L525.445,426.082L523.108,426.533L522.671,426.42L521.578,424.513L521.785,423.957L520.663,423.866L520.09,423.275L519.349,423.299L511.072,413.861L507.96,406.96L510.806,405.72L510.168,403.326L508.153,403.527L507.277,403.225L506.726,403.246L506.347,403.459L504.937,402.775L504.707,402.374L502.902,402.728L501.91,401.927L501.161,400.281L500.533,400.15L499.593,398.391L499.072,396.723L498.99,395.63L497.504,394.927L496.338,393.359L496.338,393.359L495.781,392.286L495.836,391.691L494.921,391.254L494.686,389.738L493.901,388.629L493.744,387.727L493.191,387.211L493.604,386.172L493.372,385.27L499.973,375.427L499.796,374.984L507.551,363.742L508.472,361.068L505.309,355.286L496.96,342.235L484.158,337.838L481.648,337.792L481.019,333.353L479.586,331.832L478.139,331.24L478.139,331.24L478.435,329.5L480.078,327.191L480.86,323.803L483.416,321.45L484.199,322.143L484.958,321.945L485.277,321.035L491.619,319.34L493.235,319.39L496.099,317.712z"
				},
				{
					"id":"SD-GK",
					"title":"West Kurdufān",
					"d":"M228.702,387.574L242.916,387.2L254.835,388.979L257.554,389.761L273.702,396.401L275.754,396.819L277.184,398.561L286.742,398.062L286.67,400.63L297.497,407.064L301.439,411.632L303.551,412.546L302.716,413.332L307.605,415.714L313.004,416.966L313.366,417.233L314.873,429.466L323.644,443.901L323.644,443.901L317.89,455.66L314.588,458.105L313.186,459.957L312.448,461.634L312.643,463.805L311.66,466.357L310.542,467.999L307.962,470.383L304.57,475.413L302.028,477.518L301.587,480.824L301.672,481.925L300.408,483.094L300.081,484.292L300.193,486.454L301.912,488.203L304.983,488.139L309.675,498.165L310.227,503.636L310.741,504.541L310.609,506.72L308.378,508.671L305.791,510.605L304.996,511.824L304.493,514.252L306.116,517.946L308.628,520.517L322.298,533.443L325.84,538.136L329.537,545.601L329.537,545.601L328.09,547.236L313.482,554.859L313.55,568.504L295.011,568.871L293.144,569.51L292.646,570.475L289.255,574.687L283.809,579.555L281.963,582.828L282.413,584.988L252.822,585.093L247.353,574.049L247.353,574.049L223.873,517.504L221.528,508.23L220.746,499.922L219.96,486.771L219.96,486.771L215.442,474.852L214.355,473.293L213.287,470.936L213.396,468.728L213.865,465.604L213.461,463.187L212.698,461.76L212.238,459.761L212.672,458.217L215.153,454.248L215.777,452.893L216.153,450.356L215.749,448.012L215.814,442.556L216.659,437.534L225.722,426.856L225.283,426.36L225.395,425.232L226.19,423.95L226.391,419.725L231.434,413.535L231.3,413.133L232.15,410.815L232.124,407.235L230.598,404.423L229.208,402.816L230.748,393.613z"
				},
				{
					"id":"SD-GZ",
					"title":"Al Jazīrah",
					"d":"M478.139,331.24L479.586,331.832L481.019,333.353L481.648,337.792L484.158,337.838L496.96,342.235L505.309,355.286L508.472,361.068L507.551,363.742L499.796,374.984L499.973,375.427L493.372,385.27L493.604,386.172L493.191,387.211L493.744,387.727L493.901,388.629L494.686,389.738L494.921,391.254L495.836,391.691L495.781,392.286L496.338,393.359L496.338,393.359L485.408,389.802L484.992,388.152L482.504,387.711L482.463,389.318L482.096,389.82L480.603,390.095L480.464,390.447L481.524,392.244L481.565,392.746L480.994,393.331L479.933,393.331L479.416,393.47L479.28,393.749L479.484,394.125L480.464,394.835L480.668,395.211L480.636,396.686L476.316,396.909L474.575,398.644L473.418,399.052L472.618,398.711L472.329,398.002L474.074,397.111L474.204,396.555L469.888,396.287L469.292,391.411L466.99,390.523L465.998,389.837L465.162,389.822L464.594,390.286L463.793,389.828L462.938,389.909L461.04,390.571L460.526,390.516L460.635,389.325L458.64,389.412L458.19,391.084L458.194,391.833L457.687,393.025L458.08,395.787L458.07,397.821L459.066,399.408L459.735,400.153L457.854,400.604L456.451,401.301L454.804,402.689L453.884,405.07L454.491,408.959L454.491,408.959L446.641,409.284L444.835,409.216L443.827,405.215L444.732,403.601L444.612,402.354L442.808,398.565L443.008,396.607L440.766,396.772L440.017,395.394L439.277,395.724L438.019,394.789L438.558,392.272L438.19,390.949L437.23,388.899L437.321,388.131L438.271,387.935L437.603,387.285L438.029,385.035L435.65,384.336L434.836,385.069L434.033,384.19L435.734,381.991L438.357,381.921L438.762,382.957L439.273,382.743L438.49,380.277L437.283,379.889L436.896,378.43L438.457,378.884L438.797,378.479L438.509,377.846L439.031,375.632L440.317,374.376L438.564,373.422L436.843,375.123L435.126,373.861L436.185,372.702L435.44,372.129L434.399,373.115L432.816,372.064L433.117,371.255L432.773,370.872L434.512,368.728L438.661,369.689L439.396,368.377L442.476,368.228L443.65,367.472L446.33,367.324L446.827,367.88L447.396,367.569L448.177,367.758L448.724,366.87L447.518,365.066L447.194,365.184L446.257,363.744L445.905,361.781L447.424,361.254L448.048,360.596L448.787,360.168L448.214,359.497L448.27,359.266L449.352,358.952L450.403,360.18L450.673,360.93L451.206,361.081L451.559,359.153L450.832,358.271L450.715,357.616L449.871,356.967L449.383,357.392L448.734,357.028L447.749,357.63L444.965,355.736L444.319,356.048L442.375,354.823L443.32,353.836L440.173,351.364L441.817,349.447L442.041,348.501L445.895,351.375L446.607,349.327L446.698,348.439L446.448,347.688L445.396,346.401L445.046,344.705L442.988,343.673L442.453,343L440.932,342.969L440.758,342.468L439.064,342.051L438.721,341.725L437.646,342.135L434.307,340.275L434.307,340.275L437.339,340.581L456.549,338.846L461.464,338.894L463.578,339.752L466.906,335.932L476.539,330.591z"
				},
				{
					"id":"SD-KA",
					"title":"Kassalā",
					"d":"M568.396,258.874L582.709,263.912L585.792,264.25L618.955,262.445L618.955,262.445L618.813,262.697L619.275,263.229L619.441,264.93L619.266,265.276L618.528,265.697L618.135,266.225L618.057,266.899L618.898,268.073L618.958,268.451L618.67,269.258L619.271,271.256L618.81,272.788L619.959,274.224L619.557,274.44L619.156,275.055L618.566,275.169L618.303,275.449L618.022,276.197L618.435,277.012L616.924,278.874L616.388,279.123L614.589,279.429L614.397,280.183L614.882,280.81L614.899,281.082L614.136,284.846L614.634,286.92L615.596,287.979L616.24,289.126L617.202,289.496L617.355,289.773L616.646,292.434L616.021,292.938L616.032,293.325L616.585,294.658L616.563,295.551L617.097,295.594L617.2,295.823L615.939,296.792L614.343,298.836L614.16,299.878L611.708,307.891L611.199,309.079L611.237,309.641L610.113,312.115L609.261,315.073L608.398,316.29L606.474,319.991L603.988,328.037L603.688,329.244L603.641,330.306L603.012,331.416L602.954,332.613L601.95,334.881L601.642,336.087L600.474,338.982L600.3,339.918L600.021,340.399L599.364,340.911L598.883,341.075L598.217,341.008L597.416,341.432L595.825,343.4L595.907,343.839L595.907,343.839L586.45,346.943L583.256,348.731L582.319,348.711L581.993,349.731L581.381,350.693L579.756,350.807L577.052,348.126L576.613,347.418L576.45,346.493L576.123,346.241L575.797,345.443L575.226,344.855L574.817,344.099L573.92,343.805L572.817,342.082L571.634,341.536L571.145,340.821L570.287,338.257L569.227,337.416L568.41,336.491L567.963,335.446L567.429,336.029L567.387,336.752L568.355,338.048L569.448,340.548L569.291,341.488L568.186,343.905L567.461,344.079L565.977,344.935L565.815,346.961L563.366,352.691L558.371,353.155L547.281,353.534L542.951,353.985L540.66,350.71L539.844,349.83L537.746,344.574L537.3,342.415L537.028,342.135L530.871,338.654L529.454,338.475L525.55,335.853L524.151,335.132L524.598,334.592L525.045,330.908L524.986,329.046L523.064,327.903L520.015,326.562L518.946,325.9L518.248,326.061L516.694,325.68L515.956,325.76L511.197,324.838L509.76,323.416L509.217,322.554L507.896,322.373L507.119,322.053L504.313,319.906L503.792,319.216L503.792,319.216L511.705,320.764L511.026,318.171L505.899,308.722L504.714,306.861L504.714,306.861L505.289,305.807L505.162,305.58L509.331,297.422L510.412,294.994L511.586,295.028L513.668,292.622L516.835,291.061L549.228,292.733L551.384,291.861L553.568,292.167L564.624,284.246z"
				},
				{
					"id":"SD-KH",
					"title":"Khartoum",
					"d":"M407.67,281.21L421.934,291.953L443.594,294.801L447.826,298.368L458.903,300.304L473.719,304.526L476.682,307.018L481.023,308.863L487.091,310.396L497.208,308.733L504.714,306.861L504.714,306.861L505.899,308.722L511.026,318.171L511.705,320.764L503.792,319.216L503.792,319.216L496.099,317.712L493.235,319.39L491.619,319.34L485.277,321.035L484.958,321.945L484.199,322.143L483.416,321.45L480.86,323.803L480.078,327.191L478.435,329.5L478.139,331.24L478.139,331.24L476.539,330.591L466.906,335.932L463.578,339.752L461.464,338.894L456.549,338.846L437.339,340.581L434.307,340.275L434.307,340.275L433.287,341.578L432.81,342.949L429.942,342.848L429.942,342.848L419.706,320.519L410.173,308.699L407.341,304.396L406.45,304.466L406.791,302.867L402.5,291.691L400.431,288.815L399.294,285.578L399.294,285.578z"
				},
				{
					"id":"SD-KN",
					"title":"North Kurdufān",
					"d":"M231.03,283.645L277.641,283.641L332.398,284.208L338.402,284.366L374.005,286.432L393.985,286.233L399.294,285.578L399.294,285.578L400.431,288.815L402.5,291.691L406.791,302.867L406.45,304.466L407.341,304.396L410.173,308.699L419.706,320.519L429.942,342.848L429.942,342.848L417.212,348.35L416.646,349.278L416.535,350.07L417.819,352.262L417.84,352.57L416.948,352.825L416.722,353.231L413.242,353.094L411.055,361.178L399.469,371.551L396.407,379.354L396.47,384.85L398.458,391.197L406.185,396.86L409.752,407.678L417.102,414.1L417.123,414.598L417.522,414.748L417.733,415.054L417.07,415.421L415.459,420.444L415.411,422.531L415.546,422.836L417.164,423.422L417.378,424.263L414.77,427.547L411.637,428.518L408.098,431.709L403.964,434.022L401.359,442.117L401.574,443.281L400.256,446.113L400.452,447.258L402.073,452.479L402.073,452.479L391.161,448.429L390.403,448.967L389.356,448.666L389.19,449.735L389,449.832L388.484,449.186L388.558,448.65L386.847,448.792L384.592,450.158L384.578,451.304L384.349,451.189L383.965,450.353L383.434,450.526L383.053,450.452L382.979,450.872L382.561,450.816L382.502,450.436L381.589,450.459L381.591,450.936L381.268,450.938L381.152,450.442L376.333,450.258L375.925,450.696L375.759,451.766L375.783,452.872L376.285,454.434L376.471,457.676L376.306,458.802L375.398,460.026L375,460.161L372.202,459.354L370.065,461.977L368.616,460.859L366.178,463.959L366.484,464.453L356.412,465.187L353.81,461.578L352.553,457.255L352.074,456.38L349.785,454.808L349.268,454.028L351.877,450.944L349.277,451.968L341.053,453.667L338.853,454.535L336.465,456.321L335.479,456.783L335.118,456.728L334.945,456.442L335.257,450.088L335.139,449.172L334.319,448.699L334.326,446.007L331.76,445.106L330.104,443.831L323.644,443.901L323.644,443.901L314.873,429.466L313.366,417.233L313.004,416.966L307.605,415.714L302.716,413.332L303.551,412.546L301.439,411.632L297.497,407.064L286.67,400.63L286.742,398.062L277.184,398.561L275.754,396.819L273.702,396.401L257.554,389.761L254.835,388.979L242.916,387.2L228.702,387.574L228.702,387.574L219.257,358.824L216.345,356.77L214.848,348.875L210.437,309.217L208.034,283.711z"
				},
				{
					"id":"SD-KS",
					"title":"South Kurdufān",
					"d":"M323.644,443.901L330.104,443.831L331.76,445.106L334.326,446.007L334.319,448.699L335.139,449.172L335.257,450.088L334.945,456.442L335.118,456.728L335.479,456.783L336.465,456.321L338.853,454.535L341.053,453.667L349.277,451.968L351.877,450.944L349.268,454.028L349.785,454.808L352.074,456.38L352.553,457.255L353.81,461.578L356.412,465.187L366.484,464.453L366.178,463.959L368.616,460.859L370.065,461.977L372.202,459.354L375,460.161L375.398,460.026L376.306,458.802L376.471,457.676L376.285,454.434L375.783,452.872L375.759,451.766L375.925,450.696L376.333,450.258L381.152,450.442L381.268,450.938L381.591,450.936L381.589,450.459L382.502,450.436L382.561,450.816L382.979,450.872L383.053,450.452L383.434,450.526L383.965,450.353L384.349,451.189L384.578,451.304L384.592,450.158L386.847,448.792L388.558,448.65L388.484,449.186L389,449.832L389.19,449.735L389.356,448.666L390.403,448.967L391.161,448.429L402.073,452.479L402.073,452.479L407.453,468.451L411.064,468.396L418.913,475.729L421.793,479.029L421.793,479.029L430.719,487.806L430.852,508.359L431.623,511.386L433.97,515.336L421.244,527.583L414.547,531.767L408.346,542.697L406.622,545.068L396.228,556.771L388.097,567.064L387.01,567.604L384.832,568.286L369.961,568.276L366.98,569.607L357.64,560.857L350.839,556.949L332.924,545.829L330.685,545.879L329.537,545.601L329.537,545.601L325.84,538.136L322.298,533.443L308.628,520.517L306.116,517.946L304.493,514.252L304.996,511.824L305.791,510.605L308.378,508.671L310.609,506.72L310.741,504.541L310.227,503.636L309.675,498.165L304.983,488.139L301.912,488.203L300.193,486.454L300.081,484.292L300.408,483.094L301.672,481.925L301.587,480.824L302.028,477.518L304.57,475.413L307.962,470.383L310.542,467.999L311.66,466.357L312.643,463.805L312.448,461.634L313.186,459.957L314.588,458.105L317.89,455.66z"
				},
				{
					"id":"SD-NB",
					"title":"Blue Nile",
					"d":"M463.217,486.696L488.79,470.084L501.267,467.187L510.653,461.396L510.704,460.548L510.5,459.635L509.766,458.971L509.012,458.577L514.525,452.785L516.355,453.768L517.057,453.384L523.585,454.955L524.522,456.171L526.865,457.171L533.474,475.624L532.854,477.235L539.093,486.483L539.093,486.483L539.377,487.874L540.23,489.793L540.292,494.929L539.82,495.833L538.689,499.305L538.095,500.557L536.692,502.552L535.594,504.698L535,505.087L534.543,506.113L534.077,506.434L534.238,506.746L535.532,506.738L536.967,508.281L537.119,509.024L535.913,514.49L535.337,518.262L536.388,520.679L532.604,523.844L531.688,524.399L531.675,525.758L531.294,526.546L528.344,528.466L528.03,528.471L528.562,527.21L528.553,526.583L527.534,526.598L526.023,524.974L524.36,523.743L521.184,520.732L520.711,520.583L520.092,521.141L518.92,521.314L517.998,522.581L516.906,522.911L515.275,523.875L512.896,528.348L511.918,529.798L510.383,531.777L508.442,533.59L508.26,534.639L507.705,535.809L507.716,536.513L508.814,536.809L509.617,538.127L508.26,540.987L508.741,542.362L509.493,545.636L510.639,548.626L510.272,549.427L510.428,550.78L509.896,551.882L509.913,553.054L508.444,554.169L506.892,554.816L505.812,555.77L505.209,559.339L505.147,561.738L502.261,569.325L501.683,572.531L500.409,576.215L500.549,578.8L491.88,578.921L491.854,576.802L491.396,574.669L491.52,572.51L492.903,568.421L494.367,566.319L495.806,560.632L495.583,559.357L495.706,557.064L495.457,556.654L494.802,553.975L494.993,552.619L494.331,550.88L491.409,550.858L487.521,544.024L482.598,540.566L475.025,531.55L465.564,528.444L467.981,524.104L461.136,492.369z"
				},
				{
					"id":"SD-NO",
					"title":"Northern",
					"d":"M390.649,49.833L390.685,49.967L412.339,50.028L415.623,50.182L432.257,50.136L432.257,50.136L432.303,51.449L427.533,138.459L427.641,152.202L425.177,186.991L440.509,202.649L437.739,218.35L442.604,233.063L434.371,244.394L408.832,281.055L407.67,281.21L407.67,281.21L399.294,285.578L399.294,285.578L393.985,286.233L374.005,286.432L338.402,284.366L332.398,284.208L277.641,283.641L231.03,283.645L231.03,283.645L231.03,137.246L129.004,137.091L129.004,137.091L129.004,50.358L134.687,50.129L189.241,50.003L319.442,50.077L328.048,50.12L333.056,50.358L333.056,50.095L386.866,50.043L388.432,45.29L389.69,43.568L390.175,43.149L390.613,42.378L393.231,40.465L393.602,40.719L394.148,41.679L394.62,41.923L394.797,42.408L393.821,43.939L392.859,44.837L391.64,46.769L390.71,49.113z"
				},
				{
					"id":"SD-NR",
					"title":"River Nile",
					"d":"M478.339,62.269L478.998,62.272L478.998,62.272L477.777,63.446L466.418,71.956L467.2,73.125L468.873,74.781L469.281,75.827L469.322,78.006L469.813,80.141L469.813,81.273L469.804,81.876L469.444,83.102L468.71,84.277L467.363,85.887L467.282,86.714L467.608,89.498L467.567,90.976L467.322,92.324L466.588,94.063L466.384,95.409L467.065,97.286L470.343,99.405L472.669,102.705L473.543,103.622L474.832,104.223L476.668,104.527L477.525,104.917L477.893,105.438L478.668,107.824L479.484,109.341L480.219,110.078L481.647,112.766L483.075,116.231L483.198,116.924L482.79,119.955L482.817,122.083L479.977,134.372L480.012,135.322L481.921,138.459L483.73,151.114L482.734,162.717L482.94,166.238L487.664,174.149L500.727,208.538L514.186,213.055L520.877,216.657L530.695,226.482L536.049,235.443L543.473,247.092L545.856,249.306L552.434,252.425L568.396,258.874L568.396,258.874L564.624,284.246L553.568,292.167L551.384,291.861L549.228,292.733L516.835,291.061L513.668,292.622L511.586,295.028L510.412,294.994L509.331,297.422L505.162,305.58L505.289,305.807L504.714,306.861L504.714,306.861L497.208,308.733L487.091,310.396L481.023,308.863L476.682,307.018L473.719,304.526L458.903,300.304L447.826,298.368L443.594,294.801L421.934,291.953L407.67,281.21L407.67,281.21L408.832,281.055L434.371,244.394L442.604,233.063L437.739,218.35L440.509,202.649L425.177,186.991L427.641,152.202L427.533,138.459L432.303,51.449L432.257,50.136L432.257,50.136L462.283,50.052z"
				},
				{
					"id":"SD-NW",
					"title":"White Nile",
					"d":"M434.307,340.275L437.646,342.135L438.721,341.725L439.064,342.051L440.758,342.468L440.932,342.969L442.453,343L442.988,343.673L445.046,344.705L445.396,346.401L446.448,347.688L446.698,348.439L446.607,349.327L445.895,351.375L442.041,348.501L441.817,349.447L440.173,351.364L443.32,353.836L442.375,354.823L444.319,356.048L444.965,355.736L447.749,357.63L448.734,357.028L449.383,357.392L449.871,356.967L450.715,357.616L450.832,358.271L451.559,359.153L451.206,361.081L450.673,360.93L450.403,360.18L449.352,358.952L448.27,359.266L448.214,359.497L448.787,360.168L448.048,360.596L447.424,361.254L445.905,361.781L446.257,363.744L447.194,365.184L447.518,365.066L448.724,366.87L448.177,367.758L447.396,367.569L446.827,367.88L446.33,367.324L443.65,367.472L442.476,368.228L439.396,368.377L438.661,369.689L434.512,368.728L432.773,370.872L433.117,371.255L432.816,372.064L434.399,373.115L435.44,372.129L436.185,372.702L435.126,373.861L436.843,375.123L438.564,373.422L440.317,374.376L439.031,375.632L438.509,377.846L438.797,378.479L438.457,378.884L436.896,378.43L437.283,379.889L438.49,380.277L439.273,382.743L438.762,382.957L438.357,381.921L435.734,381.991L434.033,384.19L434.836,385.069L435.65,384.336L438.029,385.035L437.603,387.285L438.271,387.935L437.321,388.131L437.23,388.899L438.19,390.949L438.558,392.272L438.019,394.789L439.277,395.724L440.017,395.394L440.766,396.772L443.008,396.607L442.808,398.565L444.612,402.354L444.732,403.601L443.827,405.215L444.835,409.216L446.641,409.284L454.491,408.959L454.491,408.959L454.865,411.602L454.433,412.58L455.409,414.165L454.817,417.596L453.542,421.373L453.172,423.518L460.253,433.506L463.903,437.598L458.836,447.362L463.159,457.13L465.904,466.764L465.904,466.764L444.224,466.026L444.469,466.731L444.265,468.806L444.387,470.63L445.271,473.692L445.122,475.315L444.469,476.435L444.102,477.471L444.224,479.004L421.793,479.029L421.793,479.029L418.913,475.729L411.064,468.396L407.453,468.451L402.073,452.479L402.073,452.479L400.452,447.258L400.256,446.113L401.574,443.281L401.359,442.117L403.964,434.022L408.098,431.709L411.637,428.518L414.77,427.547L417.378,424.263L417.164,423.422L415.546,422.836L415.411,422.531L415.459,420.444L417.07,415.421L417.733,415.054L417.522,414.748L417.123,414.598L417.102,414.1L409.752,407.678L406.185,396.86L398.458,391.197L396.47,384.85L396.407,379.354L399.469,371.551L411.055,361.178L413.242,353.094L416.722,353.231L416.948,352.825L417.84,352.57L417.819,352.262L416.535,350.07L416.646,349.278L417.212,348.35L429.942,342.848L429.942,342.848L432.81,342.949L433.287,341.578z"
				},
				{
					"id":"SD-RS",
					"title":"Red Sea",
					"d":"M678.262,214.446l0.352,0.652l-0.227,0.463l-0.432,-0.237l-0.136,0.296l0.59,0.237l0.805,1.162l-0.136,0.486l-0.216,-0.119l0.125,-0.415l-0.696,-0.844l-0.432,-0.144l-0.244,0.004l-0.328,0.711l-0.432,-0.119l0.317,-0.178l0.171,-0.51l-0.193,-0.166l-0.419,-0.498l0.124,-0.261l0.635,0.225l0.352,-0.178L678.262,214.446zM672.129,213.272l1.451,0.32l0.113,0.237l-0.521,0.332l-0.431,-0.024l-0.612,-0.332l-0.17,-0.225l-0.091,-0.214L672.129,213.272zM673.523,212.264l1.19,0.724l0.203,0.439l-0.589,-0.024l-0.283,-0.379l-0.341,-0.071l-0.385,-0.498L673.523,212.264zM670.723,210.543l0.794,0.641l0.964,0.582l-0.964,0.119l-0.057,-0.249l-0.238,-0.095v-0.226L670.723,210.543zM659.557,189.103l1.032,0.393l0.215,0.428l-0.045,0.393l-1.281,-0.155l-0.317,-0.548l0.158,-0.13l-0.033,-0.298L659.557,189.103zM666.234,187.114l0.51,0.202l-0.193,0.762l0.034,-0.238l-0.102,0.072l-0.136,-0.298l-0.851,0.06L666.234,187.114zM629.788,100.357l0.657,0.386l0.012,0.338l-0.204,0.205l-0.284,2.64l-0.328,0.494l-0.352,0.12l-0.068,0.302l-0.306,-1.085l0.079,-2.122l0.216,-0.325l-0.068,-0.338L629.788,100.357zM604.168,38.088l0.93,0.804l-1.021,-0.098l0.079,0.451l-0.306,-0.11l-0.172,0.249l-0.124,-0.078l0.228,-0.281l-0.136,-0.402l0.283,-0.536H604.168zM568.118,10.472l0.193,0.869l-0.079,0.294l-0.396,0.129l0.056,-0.925l-0.476,-0.22l0.079,-0.416l0.477,0.22L568.118,10.472zM567.246,9.848l0.011,0.783l-0.896,-0.293l0.068,-0.306L567.246,9.848zM670.405,211.493l-0.192,0.344l0.736,0.558l-0.271,0.297l-0.068,0.451l-0.589,0.712l0.261,0.368l0.521,0.189l0.771,0.071l0.272,0.261l0.011,0.367l0.578,0.048l0.386,0.344l0.726,0.237l1.156,-0.273l-0.022,-0.391l-0.229,0.083l-0.226,-0.452l-0.271,-0.047l0.079,-0.119l0.317,-0.201l0.691,0.13l0.317,0.13l0.794,1.115l-0.034,0.392l-0.295,-0.083l-0.125,0.166l0.204,0.202l-0.215,0.462l0.352,0.332l-0.022,0.604l0.203,0.237l0.228,0.154l0.317,0.071l0.419,0.178l0.125,0.13l0.192,0.095l0.261,-0.095l0.182,-0.083l-0.068,-0.249l0.227,-0.379l0.341,-0.071l0.011,0.367l0.442,0.332l0.215,-0.036l0.148,0.285l-0.397,0.213l-0.726,-0.403l-0.079,0.202l0.249,0.202l-0.124,0.593l0.351,-0.083l0.352,-0.012l0.261,0.344l0.386,0.261l-0.147,0.486l0.374,0.237l0.487,-0.178l0.567,-1.339l-0.406,-0.389l-0.218,-0.168l-0.022,-0.023l-0.079,-0.486l0.17,-0.059l0.259,0.424l0.24,0.133l1.043,0.865l0.691,1.398l0.091,0.355l-0.147,0.272l-0.137,0.143l0.216,0.106l0.51,-0.047l0.295,0.521l-5.315,5.098l-2.548,6.063l-0.097,1.03l-1.604,3.31l-2.01,0.629l-0.76,0.593l-0.195,1.393l-0.633,1.45l-0.681,0.181l-1.268,-0.374l-0.708,0.767l-0.231,-0.854l-0.523,-0.712l-0.421,0.38l-1.466,-0.007l-0.875,0.606l-0.103,1.097l-0.205,0.454l0.215,1.783l-1.466,-0.065l-0.125,-2.988l-0.245,-0.483l-0.196,-0.045l-0.645,0.464l-0.63,0.2l-0.887,-0.341l-1.278,1.749l-0.155,0.443l0.27,0.717l-0.671,0.533l-0.66,0.182l-1.02,0.629l-1.938,0.192l-0.341,-0.383l-0.201,-1.041l-0.814,-0.596l-2.026,0.166l-0.511,0.667l0.293,1.673l-0.372,0.341l-0.301,2.087l-0.666,-0.121l-0.403,0.264l-5.184,0.275l-3.96,1.584l-0.377,1.259l-0.556,0.015l0.22,0.941l0.748,0.293l0.202,0.297l0.028,0.331l-0.181,0.18l-0.896,0.414l0.106,0.349l-0.24,0.894l0.246,0.491l0.448,0.359l-0.256,0.299l-0.65,0.104l-0.436,0.489l-0.416,0.869l0.034,0.575l-0.315,0.222l-0.904,1.574l-0.644,-0.032l-0.277,0.164l-0.81,2.214l-1.815,-0.897l-0.75,-0.759l-0.847,-0.348l-2.403,0.796l-1.309,-0.13l-0.405,0.148l-0.521,0.501l-2.798,0.263l-0.721,-1.052l-0.708,-0.253l-0.55,0.181l-0.95,-0.168l-0.706,-0.516l-0.343,-0.047l-0.412,0.205l-0.642,0.93l0,0l-33.163,1.806l-3.083,-0.339l-14.313,-5.038l0,0l-15.962,-6.449l-6.577,-3.119l-2.384,-2.214l-7.424,-11.648l-5.354,-8.961l-9.818,-9.825l-6.691,-3.603l-13.459,-4.517l-13.063,-34.389l-4.724,-7.912l-0.206,-3.521l0.996,-11.603l-1.81,-12.655l-1.909,-3.137l-0.035,-0.951l2.841,-12.289l-0.027,-2.128l0.408,-3.031l-0.123,-0.693l-1.428,-3.465l-1.429,-2.688l-0.734,-0.737l-0.816,-1.518l-0.775,-2.386l-0.367,-0.521l-0.857,-0.391l-1.836,-0.304l-1.289,-0.602l-0.874,-0.917l-2.326,-3.299l-3.277,-2.12l-0.682,-1.876l0.204,-1.347l0.734,-1.739l0.245,-1.348l0.041,-1.479l-0.326,-2.784l0.081,-0.827l1.347,-1.61l0.734,-1.175l0.359,-1.225l0.009,-0.604v-1.132l-0.49,-2.134l-0.041,-2.179l-0.408,-1.046l-1.673,-1.657l-0.782,-1.168l11.359,-8.51l1.221,-1.174l0,0l17.513,-1.994l6.345,-19.025l21.682,-3.981l10.586,-24.595l10.645,3.094l16.739,-15.758l0.204,0.932l0.386,0.343l-0.17,0.294l0.102,0.564l0.238,0.22l-0.158,0.405l0.34,0.232l0.182,-0.196l0.283,0.612l-0.057,0.662l0.34,1.556l-0.125,0.784l0.692,1.31l-0.068,0.062l-0.261,-0.025V7.498l-0.295,0.037l-0.147,0.269l0.091,0.588l0.51,0.465l0.046,-0.453l0.386,-0.012l0.057,0.123l0.158,0.771l0.703,0.71l0.147,0.171v0.196l0.476,0.771l0.341,0.232l-0.023,0.318l0.352,0.208l0.816,1.223l0.17,-0.147l-0.317,-0.966l0.907,-0.257l0.408,1.26l0.124,0.098l0.556,0.954l0.17,0.354l-0.022,0.22l0.657,1.162l1.859,1.846h0.317l0.566,0.354l0.057,0.196l-0.215,0.134l0.17,0.183l0.465,0.098l0.045,0.147l1.01,0.22l0.328,-0.122l0.624,0.269l0.011,0.135l-0.295,0.024l-0.158,0.904l0.669,-0.159l0.204,-0.245l0.204,-0.525l0.578,0.708h0.839l0.736,0.367l0.193,-0.11l0.453,0.122l0.272,0.049l0.611,-0.024l1.849,0.721l1.7,-0.146l0.453,0.416l1.111,-0.134l0.238,0.098l0.102,0.647l0.204,0.024l0.17,0.305l1.304,0.232l0.521,0.843l0.544,0.037l0.012,0.513l0.283,0.5l0.681,0.476l0.465,1.501l0.181,1.281l0.658,1.184l1.292,1.208l1.519,0.963l0.806,0.354l0.419,-0.183l0.511,0.463l-0.147,1.097l0.261,0.951l0.51,0.914l2.426,1.414l0.578,0.049l2.256,1.182l0.431,0.548l0.681,0.329l-0.068,0.183l0.612,0.365l0.68,0.877l0.749,0.219l-0.034,0.475l0.181,0.329l0.794,0.414l0.521,0.767l0.624,-0.012l0.17,0.499l0.873,0.852l0.896,0.292l0.771,-0.158l0.249,0.122l0.137,-0.377l0.408,0.365l0.521,0.34l0.068,0.621l0.103,0.523l1.201,0.767l0.59,0.949l1.235,0.377l0.556,0.511l0.272,-0.024l-0.023,1.836l-0.714,1.653l-0.556,0.462l0.238,0.134l-0.068,0.292l0.374,0.182l0.068,0.45l0.295,0.328l0.022,0.705h-0.851l0.329,0.146l0.068,0.644l-0.193,0.194l0.408,0.255l0.046,1.069l-0.238,0.741l0.295,0.23l0.102,0.741l-0.386,0.146l0.057,0.097l0.499,0.061l-0.022,0.558l-0.283,1.093l0.227,1.092l0.295,0.813l0.271,1.104l0.046,0.182l-0.068,1.517l0.283,0.679l-0.067,0.885l-0.182,0.182l-0.283,-0.085l-0.057,0.182l0.396,0.23l0.079,-0.279l0.227,-0.097l0.295,0.437l0.046,0.509l-0.238,0.46l0.317,0.254l-0.034,0.534l0.386,0.121l0.295,0.375l-0.103,0.255l0.137,0.363l0.192,0.509l0.714,0.788l0.091,0.909l0.363,0.497l-0.228,0.012l-0.158,0.048l-0.076,0.417l-0.298,-0.115l-0.125,0.485l0.283,0.133l0.307,-0.145l0.158,-0.484l0.159,-0.122l0.182,0.109l0.431,0.57l0.612,1.744l0.691,0.775l-0.795,0.607l-0.543,0.192l0.136,0.218l-0.329,0.024l-0.045,0.279l0.657,-0.133l0.3,-0.476l0.539,-0.42l0.42,0.75l0.805,0.799l0.566,1.053l-0.646,0.218l-0.748,-0.061l-0.386,-0.411l-0.091,0.302l-0.204,0.254l-0.158,0.484l0.635,-0.314l0.146,0.278l-0.227,0.23l0.193,0.242l0.237,-0.375l0.182,-0.327l0.374,0.072h0.182l0.272,-0.061l0.2,-0.209l0.196,-0.009l1.235,1.343l1.429,2.226l0.736,0.617l0.703,0.907l1.349,0.75l0.205,0.653l0.453,0.169l0.68,0.967l0.352,0.181l0.521,0.967l0.329,0.386l0.736,0.677l0.545,1.788l1.235,0.954l-0.057,0.254l-0.396,0.314l0.057,0.338l-0.397,0.688l-0.192,0.386l-0.42,0.108l-0.884,-0.181l-0.295,0.157l0.091,0.761l-0.204,0.217l-0.329,-1.038l-0.374,-0.556l-0.147,-0.266l-0.646,-1.546l-0.307,-0.181l0.113,-0.338l-0.102,-0.447l0.386,-0.206l0.748,1.522l1.678,1.002l-0.034,-0.338l-0.477,-0.773l-0.566,-0.314l-0.431,-0.665l-0.022,-0.411l-0.317,-0.278v-0.495l0.34,-0.109l-0.216,-0.689l-0.669,0.109l-0.192,-0.423l-0.329,-0.048l-0.158,0.193l0.192,0.181l-0.079,0.145l-0.477,-0.157l0.137,-0.326l0.011,-0.797l-0.589,0.06l-0.17,0.351l0.158,0.29l-0.091,0.254l-0.669,-0.435l-0.022,-0.604l-0.17,-0.193l0.363,-0.471l0.192,-0.786l-0.396,-0.762l-0.953,-0.387l-0.736,-0.024l-0.329,0.302l-0.113,0.399l-0.136,0.181l-0.034,0.157l-0.465,0.471l0.204,0.363l-0.227,0.338l0.362,0.266l-0.192,0.351l0.952,0.314l-0.136,0.459v0.266l0.362,0.29l-0.441,0.797l0.34,0.327l-0.022,0.592v0.266l0.011,0.362l-0.521,0.266l-0.487,-0.435l-0.352,0.278l0.057,1.485l0.612,0.302l0.046,0.857l0.294,0.048l0.511,0.64l0.102,0.736l0.317,0.374l0.204,0.917l0.396,0.446l0.034,0.169l-0.022,0.422l0.182,0.012l0.136,0.458l-0.17,0.711l0.386,0.35l0.192,1.93l-0.182,0.434l0.125,1.616l0.204,0.386l0.045,0.253l0.113,0.808l-0.022,0.434l-0.102,0.397l0.249,0.362l0.045,0.482l-0.26,0.747l0.158,0.434l-0.125,0.434l0.317,0.181l0.329,0.988l0.295,0.12l0.204,0.337l0.034,0.975l0.181,0.337l-0.157,0.274l0.645,0.798l0.715,2.215l-0.057,0.878l-0.431,1.648l0.295,1.035l-0.806,0.072l-0.759,-0.192l-0.397,0.433l0.137,0.974l0.283,0.229l0.34,1.25l-0.261,0.697l-0.499,0.517l0.159,0.685l0.102,0.926l-0.067,1.25l0.476,0.925l0.046,1.189l-0.137,1.249l0.193,1.645l0.215,0.264l0.17,4.333l-0.192,1.044l-0.59,1.008l0.171,-0.924l-0.477,0.564l-0.159,0.084l-0.17,0.492v0.036l0.442,0.839l0.102,0.408l-0.022,0.795l0.182,0.488l0.317,0.276l0.192,0.767l0.261,0.312l0.17,1.139h0.228l0.124,0.42l-0.182,0.181l0.341,0.298l0.283,0.408l0.408,0.599l0.17,0.491l-0.17,0.372l0.295,0.18l0.237,0.027l0.159,0.093l-0.192,0.299l0.102,1.426l-0.045,0.826l0.045,1.197l-0.249,0.695l0.124,1.376l-0.34,0.683l0.227,0.395l-0.702,1.101l0.136,-1.089l-0.295,-0.072l-0.022,0.802l-0.238,0.359l0.182,0.359l0.113,1.065l-0.113,0.813l0.182,1.064l-0.068,0.251l0.283,0.933l1.825,2.774l0.057,0.514l-0.158,0.609l0.271,1.219l0.216,0.669l0.215,0.442l0.012,0.382l0.295,1.35l0.249,0.334l0.012,1.134l-0.091,0.323l0.125,0.668l0.034,0.358l0.227,0.203l-0.159,1.6l0.511,2.291l-0.261,0.704l0.374,1.193l-0.046,1.049l0.454,0.549l0.158,-0.358l0.204,0.072l0.045,0.155l-0.113,0.645l0.442,0.882l-0.034,0.656l0.374,0.56l0.283,0.775l-0.113,0.298l0.499,0.644l0.079,1.132l0.556,0.262l-0.328,0.62l-0.25,0.727l0.182,0.727l0.487,0.441l-0.079,0.369l0.17,0.286l0.17,0.357l-0.238,0.596l0.147,0.595l-0.113,0.286l0.544,0.619l0.137,0.679l0.702,0.714l0.748,0.702l0.307,0.786l0.453,0.357l0.397,1.106l0.385,0.417l0.295,-0.059l1.179,1.32l0.477,0.19l0.556,-0.024l0.283,0.321l0.51,-0.273l0.431,0.071l2.54,-0.523l0.782,-0.559l0.237,0.702l0.715,0.488l0.442,0.178l0.532,-0.036l0.136,-0.167l0.602,0.06l0.487,0.749l-0.216,0.083l-0.067,0.452l0.306,0.107l0.136,0.024l0.59,0.487l-0.091,0.726l0.612,0.286l0.635,0.903l3.582,1.118l2.041,0.987l0.963,0.832l1.395,2.246l0.782,0.855l0.998,0.855l3.208,1.853l0.181,0.249l-0.067,0.285l-1.031,0.297l-0.272,0.25l-0.227,0.629l-0.057,1.306l0.362,0.487l-0.17,0.546l0.578,0.605l-0.158,0.38l0.306,0.558l0.283,0.32l0.408,0.617l1.19,0.296l0.51,-0.023l0.103,0.142l-0.25,0.558l0.341,0.166h0.556l0.294,0.297l0.806,-0.119l0.227,0.285l1.031,-0.121l0.76,-0.484l0.102,-0.546l-0.408,-0.19l-0.102,-0.261l0.317,-0.617h0.261h0.34l0.079,0.154L670.405,211.493z"
				},
				{
					"id":"SD-SI",
					"title":"Sennar",
					"d":"M496.338,393.359L497.504,394.927L498.99,395.63L499.072,396.723L499.593,398.391L500.533,400.15L501.161,400.281L501.91,401.927L502.902,402.728L504.707,402.374L504.937,402.775L506.347,403.459L506.726,403.246L507.277,403.225L508.153,403.527L510.168,403.326L510.806,405.72L507.96,406.96L511.072,413.861L519.349,423.299L520.09,423.275L520.663,423.866L521.785,423.957L521.578,424.513L522.671,426.42L523.108,426.533L525.445,426.082L525.789,426.386L526.358,426.153L527.424,426.417L527.959,427.084L528.492,427.157L528.799,427.73L528.765,428.591L529.609,429.479L529.363,430.48L532.032,432.056L532.415,432.589L532.304,433.163L534.364,434.683L535.448,434.849L535.757,435.842L536.767,436.295L537.602,435.871L540.312,438.094L541.526,437.782L542.325,437.893L543.872,439.356L544.906,440.88L546.409,441.159L546.755,441.808L547.782,442.051L549.384,443.056L550.455,444.349L551.919,444.747L555.902,445.381L556.885,445.14L557.798,445.345L560.076,444.628L560.76,445.423L561.474,445.586L561.684,445.954L563.804,446.535L565.57,447.475L565.57,447.475L565.072,448.184L565.335,448.912L565.02,449.786L564.301,450.168L563.533,449.991L554.647,465.305L555.113,465.962L554.969,466.928L554.396,467.422L553.46,467.405L550.652,472.341L550.993,472.716L551.115,473.151L550.975,474.139L550.301,474.566L549.449,474.465L548.346,477.594L547.602,477.834L541.085,482.797L539.011,486.079L539.093,486.483L539.093,486.483L532.854,477.235L533.474,475.624L526.865,457.171L524.522,456.171L523.585,454.955L517.057,453.384L516.355,453.768L514.525,452.785L509.012,458.577L509.766,458.971L510.5,459.635L510.704,460.548L510.653,461.396L501.267,467.187L488.79,470.084L463.217,486.696L463.217,486.696L463.545,485.785L464.92,475.777L466.104,468.991L467.977,466.696L465.904,466.764L465.904,466.764L463.159,457.13L458.836,447.362L463.903,437.598L460.253,433.506L453.172,423.518L453.542,421.373L454.817,417.596L455.409,414.165L454.433,412.58L454.865,411.602L454.491,408.959L454.491,408.959L453.884,405.07L454.804,402.689L456.451,401.301L457.854,400.604L459.735,400.153L459.066,399.408L458.07,397.821L458.08,395.787L457.687,393.025L458.194,391.833L458.19,391.084L458.64,389.412L460.635,389.325L460.526,390.516L461.04,390.571L462.938,389.909L463.793,389.828L464.594,390.286L465.162,389.822L465.998,389.837L466.99,390.523L469.292,391.411L469.888,396.287L474.204,396.555L474.074,397.111L472.329,398.002L472.618,398.711L473.418,399.052L474.575,398.644L476.316,396.909L480.636,396.686L480.668,395.211L480.464,394.835L479.484,394.125L479.28,393.749L479.416,393.47L479.933,393.331L480.994,393.331L481.565,392.746L481.524,392.244L480.464,390.447L480.603,390.095L482.096,389.82L482.463,389.318L482.504,387.711L484.992,388.152L485.408,389.802z"
				}
			]
		}
	}
};