﻿// (c) ammap.com | SVG (in JSON format) map of St Helena - Low
// areas: {id:"SH-HL-AF"},{id:"SH-HL-BH"},{id:"SH-HL-HT"},{id:"SH-HL-JM"},{id:"SH-HL-LV"},{id:"SH-HL-LW"},{id:"SH-HL-SB"},{id:"SH-HL-SP"}
AmCharts.maps.stHelenaLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"-5.789367",
				"topLatitude":"-15.903696",
				"rightLongitude":"-16.030665",
				"bottomLatitude":"-5.631441"
			}
		},
		"g":{
			"path":[
				{
					"id":"SH-HL-AF",
					"title":"Alarm Forest",
					"d":"M383.992,292.103L382.248,290.516L381.484,288.947L380.999,285.711L379.819,282.709L374.423,273.664L372.744,270.311L371.946,267.304L370.459,265.461L369.394,265.001L368.824,265.271L364.789,270.486L362.382,272.555L360.607,273.024L359.535,272.176L356.223,253.95L355.318,245.27L353.493,238.41L352.493,224.019L348.845,211.905L347.711,203.297L347.711,203.297L348.651,200.358L351.453,194.806L354.791,186.559L364.935,159.762L367.106,152.479L368.415,145.31L369.156,137.067L369.295,111.795L375.742,111.805L375.742,111.805L375.581,113.184L377.839,113.783L378.801,115.185L381.718,116.329L383.946,117.631L394.736,126.185L400.365,129.92L404.811,134.341L411.561,142.602L414.503,146.869L415.957,149.474L417.752,155.517L421.403,171.817L423.655,179.366L427.229,188.267L431.348,195.18L434.226,203.058L436.061,211.103L436.381,214.726L436.287,217.958L435.47,222.361L433.488,227.363L430.322,232.573L426.671,237.337L418.698,246.612L416.219,267.944L415.143,272.726L414.425,273.281L411.229,272.952L409.282,273.817L408.168,274.84L407.158,276.201L404.529,282.516L403.808,283.516L402.739,284.116L395.376,285.314L392.069,286.41L389.152,288.429L386.902,291.873z"
				},
				{
					"id":"SH-HL-BH",
					"title":"Blue Hill",
					"d":"M291.618,323.009l8.562,6.338l11.899,7.004l2.61,2.249l0.929,1.849l1.129,4.706l0.277,3.516l-0.196,8.334l-5.899,57.729l-1.555,10.973l-0.896,3.872l-3.97,11.404l-3.054,11.081l-12.656,54.792l-4.404,17.186l0,0l-0.353,0.026l-0.096,-0.604l-1.384,1.063l-0.512,-0.027l1.613,-1.47l0.229,-0.811l-0.802,-0.208l0.359,-0.522l-0.061,-0.767l-1.479,-1.397l-0.787,1.839l-0.052,-1.73l-1.048,0.099l-0.559,0.884l-0.685,0.054l-1.072,1.227l-0.02,-1.361l-1.555,-0.072l-1.158,0.694l-0.124,0.532l0.822,1.37l-0.386,1.28l-1.313,0.505l-0.578,-0.424l-0.542,1.361l-1.65,0.613l-2.734,0.424l-1.236,0.749l0.333,0.865l-0.802,2.624l-1.042,-0.803l-0.085,-0.559l-0.622,0.829l0.497,0.532l-0.201,0.829l0.534,0.433l-0.065,0.568l-0.478,-0.036l-0.135,-0.405l-0.822,0.648l-0.257,-0.234l-0.344,1.389l-1.062,-0.189l-1.044,1.308l-2.651,0.668l0.615,2.128l-0.312,0.144l-0.421,-0.324l0.026,-0.487l-0.395,-0.297l-0.628,0.324l0.035,1.136l-0.772,0.181l-0.102,0.324l-1.781,-0.36l-1.104,0.496l-0.624,0.829l0.709,0.73l1.286,-0.09l-0.257,0.64l-4.308,-0.297l-0.767,1.001l-1.339,0.315l-0.471,-0.775l0.106,-0.686l-0.586,-0.162l-1.798,1.046l-0.541,0.965l0.011,2.642l-0.611,0.596l-0.041,0.567l0.758,2.479l-0.32,0.072l-0.748,-0.703l-0.931,1.064l0.255,0.955l0.875,0.316l0.087,0.793l-0.486,1.019l-1.271,-0.081l-0.813,1.064l-1.572,0.279l-0.247,-0.522l-1.637,-0.063l-1.903,1.163l0.098,0.415l1.367,0.767l0.246,1.262l-0.451,2.245L236.996,560l-1.487,0.622l-2.507,0.162l-1.644,1.434l-1.19,1.632l-1.286,0.523l-1.548,-0.081l-0.357,1.055l-2.568,1.731l-1.886,2.443l-2.664,1.064l-2.728,2.786l-3.24,1.416l-2.507,-0.775l-0.835,1.604l-1.515,1.397l-4.177,0.884l-2.769,-0.099l-0.26,2.073l-2.821,4.933l-2.239,0.532l-1.46,-1.01l0.048,-4.437l1.472,-2.534l-1.57,-1.073l-3.039,-5.41l-2.208,-1.073l-0.589,-2.633l-1.029,-1.56l-3.728,0.198l-2.551,-0.343l-0.393,-1.758l0.687,-1.605l-7.014,-0.496l0.312,-2.993l-7.131,-1.966l0.704,-3.643l-0.506,-3.273l-3.889,-4.454l-4.794,-1.163l-2.605,-2.634l-0.144,-2.857l-1.938,-3.066l-2.441,-0.216l-3.661,-3.778l-4.884,-8.494l1.208,-5.879l-1.945,-2.578l-1.524,-3.706l0.065,-4.066l2.045,-2.561l0.793,-3.408l-2.771,-4.851l-2.706,-1.569l-1.979,-0.396l-1.755,-1.623l-0.519,-1.776l-1.04,-1.316l-1.33,-0.658l-1.847,0.884l-0.571,1.208l-2.701,0.415l-0.647,-3.065l-1.903,-0.208l-2.664,-2.254l-0.042,-1.975l-0.46,-1.821l-3.707,0.046l-2.444,1.92l-2.599,0.207l-2.693,-0.271l-1.868,-1.379l-1.038,-2.416l-1.38,-0.884l-2.919,2.092l-4.949,0.486l-1.842,-0.721L93.961,475l-2.03,-2.93l-1.395,-3.372l-2.625,0.838l-3.091,0.172l-1.694,1.1l-2.455,0.884l-0.042,1.253l-1.609,0.424l-0.552,1.894l-4.029,-0.099l-0.052,-1.137l-1.657,0.108l0.105,1.127l-4.358,0.379l-5.161,-0.433l-0.314,-7.411l-2.788,-5.87l-4.705,-3.498l-4.535,0.352l-4.145,-0.405l-1.452,-2.092l-3.312,-0.396l-1.657,-2.61l-3.369,-3.972l-2.834,-0.929l-3.024,0.189l-1.997,1.92l-1.5,3.003l-1.652,0.004l-0.709,-4.67l-4.334,-9.891l-1.092,-0.789l-1.267,-0.135l-1.731,0.627l-1.511,2.172l-0.527,1.511l-2.605,0.617l-2.616,-0.896l-1.306,-0.897l-1.674,0.897l-6.203,-0.158L0,437.354l2.193,-1.785l1.33,1.848l2.858,-2.443l0.467,-4.16l-2.063,-3.701l2.59,-1.975l1.463,-2.101l2.115,-0.243l1.869,-3.557l4.798,-0.727l2.845,-0.888l2.115,-4.12l-0.164,-5.657l3.244,-0.591l2.39,-1.753l3.349,-1.335l2.775,-4.439l7.642,-16.322l15.771,-8.245l2.409,-0.946l2.599,-0.266l-0.189,-4.404l-2.063,-1.258l-0.471,-2.073l-0.87,-1.177l0.196,-1.925l0.674,-0.788l1.72,-1.046l1.264,-1.839l2.13,-1.523l0.388,-3.484l1.518,-1.533l0.654,-1.379l-0.868,-1.068l-1.114,-0.122l-1.034,1.028l-1.565,-1.758l0.322,-2.272l1.304,-2.533l2.671,-1.05l2.049,1.42l2.174,-1.23l0.682,-2.223l-1.925,-4.57l2.518,-1.835l7.541,-0.176l5.35,-2.434l0.192,-0.193l-0.957,-3.138l-0.464,-2.997l1.696,-1.104l2.481,-0.266l0.449,-4.232l3.512,-0.37l1.145,1.275l2.677,-0.951l1.435,-1.329l0.765,-1.568l3.539,-0.951l1.149,-2.114l1.289,-0.311l-0.955,-8.456l0.652,-3.989l1.229,-4.624l6.981,-0.396l0.837,-4.94l-0.707,-6.689l-3.682,-6.283l1.088,-4.886l-0.395,-4.899l1.284,-5.39l1.938,-3.836l16.534,-24.261l6.181,-5.823l-1.518,-6.035l2.599,-5.841l6.809,-2.727l0.885,-3.759l5.887,-3.493l40.682,-21.66l15.638,-15.075l1.655,0.266l1.029,-0.32l0.811,0.275l0.249,-0.378l0.628,0.365l0.748,-0.041l0.759,0.761L212,172.75l-0.329,-0.379l0.216,1.257l0.527,0.198l-0.043,0.415l1.723,0.504l0.641,0.861l2.522,1.068l1.308,-0.131l0,0l1.587,0.991l1.981,-0.248l0.194,0.271l1.029,6.232l2.089,6.12l-0.144,1.393l-1.26,3.006l0.018,1.808l1.147,2.416l2.668,3.448l3.438,12.402l-0.87,6.391l-1.101,3.898l-1.291,2.664l-3.39,4.385l-1.576,3.677l-1.275,5.255l-0.682,6.936l0.111,4.449l0.608,4.065l2.756,8.559l2.701,12.841l2.154,5.62l2.368,3.782l2.479,2.803l2.607,2.313l5.213,3.754l1.853,1.798l2.122,2.731l3.242,5.292l3.393,4.286l4.92,5.066l3.314,2.573l3.347,1.312l3.591,0.365l4.508,-0.572l5.662,-1.727l3.636,-0.009l3.449,1.294l4.33,3.776L291.618,323.009zM75.835,311.605l1.334,1.501l1.277,-1.154l3.713,0.465l1.625,1.384l0.349,1.901l1.681,0.632l0.174,2.019l-2.436,0.749l-3.541,-0.289l-5.047,-3.11l-1.799,-0.518l-0.231,-1.442l1.044,-0.465v-1.901L75.835,311.605zM67.849,331.794l-3.541,0.072l0.329,-2.759l1.397,-0.73l1.382,0.415L67.849,331.794zM166.456,599.864L163.927,600l-2.174,-1.506l-1.655,-2.228l-1.009,-2.119l0.118,-1.975l1.138,-0.884l3.996,0.749l1.842,2.461l1.119,2.724L166.456,599.864z"
				},
				{
					"id":"SH-HL-HT",
					"title":"Half Tree Hollow",
					"d":"M336.612,189.763L336.503,189.542L326.049,188.537L319.723,188.528L315.761,189.799L309.648,193.936L308.743,194.018L307.884,193.31L306.679,190.457L305.885,186.014L305.501,180.222L305.434,168.793L304.492,163.706L299.405,152.191L291.046,137.009L289.176,131.335L284.498,122.813L283.468,118.303L283.468,118.303L283.867,118.204L283.843,117.83L284.434,117.942L283.724,117.104L283.894,115.689L284.635,115.423L285.688,116.577L286.268,115.599L287.665,116.149L287.992,116.667L288.611,116.491L288.749,115.355L290.004,115.671L290.216,115.067L292.706,113.697L292.621,112.917L293.754,111.809L294.278,110.633L296.336,108.803L298.869,107.839L299.506,108.208L300.362,107.298L301.625,106.613L302.933,106.032L304.575,105.82L307.333,104.203L306.52,103.855L307.721,102.891L309.964,101.873L309.75,101.134L310.346,100.899L310.954,101.224L311.464,100.732L311.519,99.187L312.19,98.484L312.478,98.547L312.587,97.75L314.368,96.83L315.316,97.087L316.06,96.641L316.816,97.15L316.967,96.181L317.848,97.02L317.848,97.02L322.437,112.53L327.588,124.796L331.964,133.232L335.252,138.667L342.667,148.505L343.744,150.596L344.417,152.899L344.664,156.752L344.214,162.534L341.995,176.793L338.755,188.397z"
				},
				{
					"id":"SH-HL-JM",
					"title":"Jamestown",
					"d":"M336.612,189.763L338.755,188.397L341.995,176.793L344.214,162.534L344.664,156.752L344.417,152.899L343.744,150.596L342.667,148.505L335.252,138.667L331.964,133.232L327.588,124.796L322.437,112.53L317.848,97.02L317.848,97.02L319.025,98.182L321.759,97.587L325.74,94.383L327.575,92.049L327.695,89.616L326.762,87.899L326.769,85.475L327.277,85.073L326.808,84.596L327.144,83.848L326.614,83.226L326.703,80.396L326.948,79.423L328.648,79.396L328.733,77.877L328.53,76.557L327.381,75.732L327.961,75.178L327.863,74.448L327.414,74.304L327.621,73.457L329.784,72.573L331.417,73.2L332.784,75.84L334.493,76.376L335.799,75.822L334.958,74.673L335.84,73.601L336.8,74.858L337.667,75.25L339.021,73.123L339.078,72.596L338.742,72.465L339.059,71.875L338.563,71.546L338.947,71.109L338.886,70.446L339.688,69.833L339.434,68.914L340.286,68.455L341.626,68.766L342.287,68.576L342.571,69.352L343.046,68.901L343.534,68.95L343.157,70.496L345.309,70.455L345.052,70.757L345.662,71.059L345.619,71.397L346.188,71.154L347.097,71.875L346.97,72.159L349.203,72.627L352.347,73.988L354.18,73.335L357.407,70.406L359.896,63.232L359.521,63.259L359.306,62.583L359.914,60.983L360.062,59.46L359.685,58.433L358.92,58.163L357.902,56.941L356.439,56.739L355.924,56.031L356.502,55.792L356.36,55.5L355.612,55.748L355.12,53.765L356.822,52.278L356.979,51.962L356.707,51.823L357.311,50.908L357.645,49.538L358.51,48.245L358.981,48.087L359.238,48.389L360.943,47.316L376.507,32.253L375.722,15.757L391.147,2.654L404.882,0L414.384,1.284L414.384,1.284L412.293,7.133L408.438,21.804L401.66,42.049L393.864,63.466L385.84,83.397L378.328,107.961L377.02,110.746L375.742,111.805L375.742,111.805L369.295,111.795L369.156,137.067L368.415,145.31L367.106,152.479L364.935,159.762L354.791,186.559L351.453,194.806L348.651,200.358L347.711,203.297L347.711,203.297L340.53,196.514L338.721,193.986z"
				},
				{
					"id":"SH-HL-LV",
					"title":"Levelwood",
					"d":"M701.626,327.151l0.227,1.063l-1.33,0.856l-0.157,0.455l0.325,0.83l-0.283,1.203l-0.486,-0.041l-0.724,-0.896l-1.59,1.983l-0.667,0.216l-0.934,-1.298l-0.77,0.288l-0.31,1.006l-0.446,-0.05l-0.127,-0.865l-0.403,0.424l-0.432,-0.072l-0.604,-0.438l0.083,-0.893l-1.006,-0.703l-0.78,0.167l-0.168,0.383l-1.236,-0.004l-0.195,-0.546l-0.424,0.374l-1.414,0.279l0.163,0.573l0.569,0.063l-0.088,0.383l-0.69,-0.14l-0.82,-1.153l0.007,0.369l-0.831,0.667l-0.549,-0.081l0.549,-0.726l-1.088,-0.843l-0.103,-1.938l-0.375,0.406l-0.2,1.582l-0.739,-0.198l0.375,1.032l-1,0.893l-0.443,0.964l-0.54,0.275l-0.979,0.108l0.709,-0.577l-0.014,-0.465l-1.744,0.708l0.297,-0.726l-0.331,-0.451l-0.188,0.451l-1.298,-0.568l-1.19,1.771l-1.589,-0.036l-2.767,0.983l-1.845,-0.117l0.059,0.681l-2.141,-0.275l0.039,-1.136l-1.847,-1.406l-0.549,0.748l-0.691,-0.09l-0.41,-0.491l-2.352,-0.312l-0.493,0.938l-0.456,-0.807l-2.96,-1.46l-3.314,1.982l-0.745,0.942l0.009,0.622l-0.493,-0.546l-0.902,0.267l-1.572,-1.916l-1.807,-0.293l0.351,0.523l-0.037,1.055l-0.72,-0.186l0.29,-0.495l-0.554,-0.73l-1.314,-0.005l-1.569,1.394l0.023,0.815l0.467,0.374l-0.063,1.884l0.386,0.532l-0.551,1.041l0.078,0.55l-0.842,0.027l-1.401,-0.852l-1.574,1.573l-2.782,-0.839l-0.861,0.55l-0.126,1.086l-0.895,1.687l-0.902,0.212l-0.734,-0.338l-0.63,-0.902l-1.795,-0.207l-0.957,0.469l-0.724,1.168l-0.22,2.632l1.646,0.248l0.713,1.677l0.421,0.262l-0.069,2.294l-0.387,0.388l-0.922,0.167l0.157,0.369l1.14,0.433l1.524,-0.049l-0.355,0.784l-0.853,-0.01l0.044,0.56l0.527,0.681l0.106,0.847l0.962,0.767l-0.55,0.627l1.105,1.703l-0.329,0.339l0.316,0.252l-0.24,0.284l0.469,0.478l0.338,-0.063l-0.324,1.546l0.492,0.148l0.113,0.388l-0.479,0.329l0.286,0.41l0.669,0.117l-0.761,0.189l-0.366,1.821l0.071,1.654l1.348,0.455l-0.313,1.153l-0.272,-0.608l-1.344,-0.55l-0.126,0.384l0.469,0.392l-0.331,-0.009l-0.09,0.478l-0.349,-0.262l-0.432,0.253l-0.198,0.455l0.379,0.1l-0.039,0.396l-1.578,-0.189l-0.491,1.122l0.314,0.555l-0.6,-0.185l-1.236,0.653l-0.314,-0.343l-0.048,1.718l0.633,0.689l0.133,1.172l-1.661,0.234l0.163,2.862l-0.58,0.388l0.33,0.46l-0.971,0.825l-0.481,1.284l-0.988,-0.266l-2.278,1.06l0.157,-1.466l-0.981,0.487l-1.304,-0.036l-0.853,0.347l-0.669,-0.554l-0.035,-0.627l-0.771,0.36l-1.799,2.29l0.085,1.776l-0.31,1.186l-0.357,0.509l-0.97,-0.374l-1.105,2.931l-1.178,0.193l0.192,0.415l-0.306,0.437l-3.096,0.293l-1.792,0.618l-2.974,0.162l-1.093,0.924l-1.334,0.221l-0.831,0.758l-0.013,0.712l-0.924,1.28l0.272,1.813l-0.957,0.036l-0.21,0.514l0.053,0.414l0.761,0.186l0.316,1.312l-0.219,0.14l-0.545,-0.771L603.938,397l0.314,0.491l0.828,-0.563l0.124,1.109l-0.51,0.072l-0.545,2.222l-0.313,0.022v-1.091l-0.398,-0.221l-0.748,0.438l0.303,0.906l-0.281,0.541l0.685,0.658l-0.599,1.384l-0.969,0.022l-0.063,0.648l-2.163,0.889l-1.16,1.046l-0.517,-0.248l-0.303,0.519l-1.684,-0.307l-1.207,-0.934v-0.703l-2.069,-0.87l-1.437,0.226l-2.418,-0.365l-0.883,0.767l0.17,0.383l1.469,0.536l0.525,0.677l-0.687,-0.36l-0.142,0.306l-1.04,-0.216l-0.041,0.604l-1.008,1.416l-1.142,0.009l-0.571,-0.383l-0.016,-0.586l0.396,-0.203l-0.954,-0.658l0.531,-0.334l0.63,-1.496l-1.389,-0.555l-0.734,0.126l-0.274,-0.518l-0.801,-0.234l-0.146,-0.753l-0.639,0.14l-0.175,1.01l-0.691,-0.149l-0.393,0.316l0.295,-0.568l-0.357,-0.829l-0.391,-0.041l-1.589,0.946l-1.247,1.84l-0.177,-2.038l-1.36,-1.744l-1.001,-0.217l-2.529,1.064l0.857,2.146l-1.064,1.677l-1.5,0.1l-1.79,1.198l-1.981,0.072l-4.236,-1.375l-0.621,1.502l0.048,1.456l0.312,0.107l-1.255,1.001l-0.236,0.734l-0.333,1.673l0.436,0.532l-1.016,-0.334l0.032,0.6l0.946,1.063l-0.115,0.582l0.9,-0.108l0.934,0.622l-2.388,0.429l-0.726,0.893l0.039,0.698l-0.442,0.262l-3.201,0.572l-0.349,-0.541l-1.251,0.522l-0.447,-0.188L553.445,416l-1.665,-0.807l-0.642,-0.838l-2.864,-1.966l-0.619,0.298l-0.658,1.406l-0.923,0.288l-0.188,0.582l0,0l-3.814,-2.687l-1.372,-1.461l-2.677,-1.384l-3.38,-2.331l-14.36,-2.975l-10.412,-2.988l-21.732,-7.771l-5.448,-2.416l-3.691,-2.105l-2.843,-2.24l-2.015,-2.236l-1.955,-2.983l-5.01,-9.358l-2.089,-2.447l-2.856,-2.281l-9.403,-6.161l-25.549,-9.331l-4.047,-1.785l-2.038,-1.514l-4.166,-5.112l-3.482,-6.518l-0.856,-3.817l0.396,-2.29l0.87,-2.28l-0.941,-0.934l0,0l0.607,-0.319l0.548,-1.56l1.665,-2.182l6.842,-6.491l3.144,-2.073l2.974,-0.617l3.235,-1.393l7.926,-6.41l18.032,-17.042l7.209,-8.022l2.154,-1.745l3.386,-2.019l5.878,-2.348l8.86,-2.344l5.431,-1.889l11.802,-5.85l5.871,-2.285l5.988,-1.582l12.828,-2.407l4.457,-1.221l3.025,-1.555l5.32,-3.844l1.853,-0.744l2.368,1.185l4.07,2.894l3.188,1.623l12.147,4.264l13.813,6.986l21.384,8.595l13.844,6.346l39.764,19.71l21.813,10.092l24.038,12.999l1.502,0.577l0.626,-0.267L701.626,327.151zM701.354,340.178l-0.327,0.126l-0.142,0.771l-0.644,0.303l-0.646,-0.433l-0.782,-1.735l-0.279,-3.521l0.246,-0.474l1.445,0.496l0.517,0.496l0.101,1.172l0.792,1.519L701.354,340.178zM721.468,367.917l-0.105,0.238l-1.354,-0.18l-1.217,-1.776l-0.979,-0.807l-0.676,-1.825l-0.693,-0.537l0.362,-2.032l0.377,-0.045l1.231,1.181l1.114,0.536l1.969,1.961l0.467,1.434L721.468,367.917z"
				},
				{
					"id":"SH-HL-LW",
					"title":"Longwood",
					"d":"M701.626,327.151l-1.019,-0.532l-0.626,0.267l-1.502,-0.577l-24.038,-12.999l-21.813,-10.092l-39.764,-19.71l-13.844,-6.346l-21.384,-8.595l-13.813,-6.986l-12.147,-4.264l-3.188,-1.623l-4.07,-2.894l-2.368,-1.185l-1.853,0.744l-5.32,3.844l-3.025,1.555l-4.457,1.221l-12.828,2.407l-5.988,1.582l-5.871,2.285l-11.802,5.85l-5.431,1.889l-8.86,2.344l-5.878,2.348l-3.386,2.019l-2.154,1.745l-7.209,8.022l-18.032,17.042l-7.926,6.41l-3.235,1.393l-2.974,0.617l-3.144,2.073l-6.842,6.491l-1.665,2.182l-0.548,1.56l-0.607,0.319l0,0l-3.249,-0.775l-25.471,-10.092l0.015,-0.46l-4.057,0.019l0,0l1.428,-0.158l2.83,-20.81l-0.022,-1.925l-0.497,-1.253l0,0l0,0l0,0l2.911,-0.23l2.25,-3.443l2.917,-2.019l3.307,-1.096l7.363,-1.199l1.068,-0.6l0.722,-1l2.629,-6.314l1.01,-1.361l1.114,-1.023l1.946,-0.865l3.196,0.329l0.718,-0.555l1.076,-4.782l2.479,-21.332l7.973,-9.275l3.651,-4.764l3.166,-5.21l1.981,-5.002l0.817,-4.403l0.094,-3.231l-0.32,-3.624l-1.835,-8.044l-2.878,-7.878l-4.119,-6.914l-3.573,-8.9l-2.252,-7.549l-3.651,-16.3l-1.795,-6.043l-1.454,-2.604l-2.942,-4.268l-6.75,-8.261l-4.446,-4.42l-5.629,-3.736l-10.79,-8.553l-2.228,-1.302l-2.917,-1.145l-0.961,-1.402l-2.259,-0.599l0.162,-1.379l0,0l1.277,-1.059l1.308,-2.785l7.513,-24.564l8.023,-19.931l7.796,-21.417l6.778,-20.245l3.854,-14.671l2.091,-5.849l0,0l4.971,-0.158l1.437,0.811l1.668,4.29l0.54,2.05l-0.196,0.437l0.884,1.315l-0.345,1.609l0.835,2.388l1.716,2.343l0.098,1.023l-0.54,0.973l-0.146,1.658l0.833,1.072l0.687,0.244l0.395,1.271l0.587,0.388l0.983,0.049l0.49,1.51l1.273,0.441l2.11,2.631l1.604,-0.13l-0.541,-2.095l0.458,-0.311l0.096,-0.78l-0.44,-1.41l2.011,2.438l1.177,0.338l2.161,2.487l0.98,2.78l1.374,0.437l0.538,1.073l1.631,0.14l0.857,-0.419l0.505,0.816l-0.344,0.779l2.354,0.879l1.031,2.239l2.893,-0.049l2.405,1.027l2.402,0.288l1.751,-0.518l1.927,0.032l1.769,1.122l1.617,2.731l1.914,1.708l1.767,0.338l0.98,1.316l3.238,1.271l4.02,0.387l3.911,-0.811l0.203,-0.757l-0.285,-1.208l0.782,-0.099L479.542,43l1.243,1.396l1.029,2.096l2.28,0.085l0.276,-0.87l-0.069,-2.609l0.604,-1.19l1.077,2.83l0.787,0.486L487.391,45l2.061,-3.753l0.541,-1.951l0.31,-0.455l1.504,-0.568l-0.425,2.519l0.98,0.631l0.637,-0.388l-0.752,2.028l0.752,0.261l0.428,-1.104l0.405,1.447l2.11,0.635l0.231,-1.447l0.455,1.591l0.82,-1.784l0.503,0.031l-0.244,1.852l0.443,1.266h0.342l0.672,-2.127l0.065,-1.726l0.687,1.608l-0.196,0.929l0.476,-0.424l0.357,1.397l0.98,0.779l0.589,-0.144l0.279,-0.568l0.589,0.293l-0.133,0.811l1.212,-1.834l1.555,0.671l0.865,1.014l0.573,-0.176L507.699,45l0.909,-0.721l6.702,2.952l-6.218,20.75l4.493,7.994l11.576,-1.249l6.044,-18.957l13.892,-9.436l11.146,-4.448l5.926,-7.372l19.543,-4.912l7.456,5.38l16.639,1.757l5.298,14.352l12.316,11.815l0.052,3.316l1.245,2.744l1.932,0.297l2.019,1.771l1.127,1.586l0.012,0.788l0.285,0.37l0.619,0.059l0.177,2.136l0.683,0.392l0.026,0.284l-0.979,0.847l-0.373,-0.144l-0.531,0.694l-2.522,0.248l-1.367,0.766l-0.218,0.469l-1.311,0.108l-0.519,0.712l-3.17,1.915l-0.561,-0.131l-1.774,2.875l0.15,0.924l-2.106,4.123l-0.14,1.257l0.295,0.577l-0.138,1.361l0.488,3.2l1.184,4.123l1.058,0.951l0.152,-0.379l1.221,0.05l1.433,-0.762l-0.639,1.33l-1.151,-0.032l-0.135,0.55l0.248,0.577l0.447,0.077l0.14,1.465l0.632,0.266l0.417,0.951l0.527,0.032l-0.03,0.617l1.293,1.667l1.748,0.802l0.059,-0.726l0.443,0.027l0.363,0.645l0.644,-0.054l-0.216,1.091l0.946,0.667l-0.929,0.703l-0.011,0.527l3.736,0.302l1.563,0.527l-0.977,1.293l1.94,0.045l0.176,-0.356l0.393,0.009l0.083,0.825l1.093,0.022l-0.081,0.423l0.283,0.145l0.53,-0.812l2.35,0.933l-0.724,0.225l-0.345,0.595l-2.079,0.671l-0.598,0.725l0.398,0.248l-0.729,0.928l0.625,0.59l-0.131,-0.604l0.65,0.022l0.593,0.288l-0.184,0.343l0.916,0.14l-0.106,1.532l1.07,0.64l0.148,0.438l0.784,0.225l-1.221,0.879l1.145,0.239l0.124,0.541l-0.51,0.482l1.445,0.171l0.606,1.158l-0.055,0.775l-0.541,0.243l-0.071,0.608l-0.764,0.527l0.362,0.491l-0.258,0.635l-0.481,0.329l-1.01,-0.18l-1.162,1.041l-0.32,-0.532l-0.165,0.464l-1.071,0.703l-0.039,0.861l-0.364,0.072l-0.071,0.383l0.881,0.532l-0.067,0.951l-1.326,-0.541l-0.303,0.306l0.386,0.424l-0.069,1.622l-0.543,0.239l-1.714,-0.226l-0.421,0.464l-0.231,0.482l0.403,0.32l-0.335,0.482l1.048,0.027l0.358,0.302l-1.116,0.392l-0.397,0.766l0.934,0.667l1.04,0.243l-0.787,0.392l0.032,1.249l-0.538,-0.591l-0.58,0.505l-0.7,-0.352l-0.756,1.681l0.239,2.46l-0.388,0.73l-0.582,-0.23l-0.401,0.532l0.981,0.707l-1.038,0.05l-0.02,0.645l0.556,1.072l0.453,0.311l1.356,-0.194l-0.257,0.392l0.457,0.762l0.946,-0.203l0.103,2.05l-0.754,-0.144l-0.467,0.572l0.61,1.568l2.477,2.586l0.606,-0.049l-0.205,0.532l1.397,0.59l0.249,1.532l0.906,1.532l0.639,0.6l0.711,-0.532l1.273,1.956l1.072,0.721l-0.276,0.487l0.299,0.482l-0.07,1.023l2.041,1.69l-0.026,1.253l0.837,0.072l0.145,1.5l0.492,0.73l0.766,0.915l1.576,0.888l0.888,-0.441l1.131,0.383l0.824,-0.572l0.87,0.099l0.447,0.442l0.787,0.117l-0.063,0.802l0.44,0.83l1.012,0.653l2.472,0.974h2.599l1.054,-0.438l0.577,-1.171l0.789,-0.032l0.408,-1.537l0.78,0.067l0.116,-0.991l0.807,0.734l1.233,-0.022l1.036,0.423l0.724,-0.649l0.66,0.262l0.561,0.892l0.416,-0.054l-0.359,-1.383l1.611,-0.396l0.188,-0.428l1.205,-0.153l1.415,0.284l1.956,-0.636l0.481,0.834l1.758,1.23l-0.401,0.428l0.944,0.563l1.155,3.52l0.605,0.279l-0.17,2.799l-0.536,-0.415l-0.297,0.171l0.774,0.635l0.449,1.384l0.773,0.171l2.043,2.159l0.227,-0.077l0.735,1.321l-0.377,1.063l0.6,1l-0.87,0.441l-1.562,-0.18l-0.741,-0.514l-0.15,0.333l-0.527,-0.401l-0.665,0.365l-0.127,0.455l1.178,0.563l0.161,1.303l0.559,0.518l-0.772,0.149l0.055,0.536l2.724,0.919l1.688,2.113l-0.267,0.861l-1.449,-0.108l0.506,1.438l-0.373,0.158l-0.534,-0.338l-0.011,0.829l0.338,0.847l0.503,-0.167l0.316,0.424l-0.229,0.441l-0.82,0.167l-0.442,0.91l2.043,-0.852l1.535,1.5l0.604,0.347l0.486,-0.18l0.859,1.663l1.499,0.419l0.145,0.487l0.842,0.392l0.17,-0.401l0.991,-0.113l0.162,0.298l-0.591,0.243l-0.051,0.383l0.479,0.27l0.596,1.808l-0.425,0.41l-0.044,0.83l-0.43,0.077l-0.181,0.964l0.595,0.338l0.689,0.153l1.323,-0.689l1.005,0.171l0.748,-0.293l-0.009,-0.829l1.382,1.356l0.698,-0.451l1.382,0.924l0.32,-0.298l0.615,0.059l-0.111,-0.514l1.215,-0.117l0.32,0.455l0.412,-1.307l1.17,0.82l1.762,-0.244l0.033,0.744l1.532,0.261l-0.639,0.703l0.43,-0.099l0.368,0.478l-1.136,0.441l0.484,0.78l-0.306,0.293l0.288,0.297l0.545,-0.329l0.615,0.541l1.938,0.771l0.097,-0.338l1.111,0.73l-0.061,0.352l0.804,1.145l-1.244,0.658l0.407,0.365l-0.117,0.401l-0.19,-0.203l-0.621,0.572l1.491,1.293l1.027,0.271v-0.473l0.261,-0.022l0.262,0.545l0.761,2.844l-0.566,2.231l-1.659,1.446l-0.955,1.51l-1.844,0.284l0.172,0.32l-1.374,0.293l-0.266,1.393l-1.288,-0.207l-1.005,-0.681l-0.646,-0.992l-1.005,1.226l-1.174,0.748l0.079,1.853l1.778,2.654l-0.602,0.456l-0.501,-0.375l-0.449,0.438l-1.567,-0.054l-0.724,-0.343l-0.642,-1.108l-0.543,0.113l-1.73,-1.005l-0.6,0.095l-1.604,-1.019l-2.052,0.189l0.305,1.762l-1.048,-0.735l0.872,2.56l-1.376,-0.234v0.645l1.293,1.478l-0.063,0.591l-1.73,-1.361l-0.316,0.338l0.605,0.915l-0.259,0.667l0.501,0.266l0.357,1.429l1.599,1.861l0.205,0.608l-0.284,0.347l1.574,0.946l-0.765,1.78l-0.934,0.446l-1.428,-0.464l-1.073,0.261l1.413,1.001l0.925,2.501l-0.604,0.911l-1.735,-0.487l-0.835,0.388l-0.654,-0.388l-0.501,0.203l0.009,0.41l1.157,0.866l-0.575,0.292l0.525,1.235l-0.405,0.915l0.773,0.392l-2.725,1.474l-0.079,0.73l-1.604,0.216l-0.142,0.964l0.936,-0.148l0.678,0.41l-0.678,0.815l-0.628,-0.32l-0.301,0.221l0.301,0.37l-0.12,0.73l-0.842,0.964l0.665,1.109l-1.482,1.356l0.177,1.537l0.63,1.086l0.734,0.208l0.022,0.482l2.023,1.641l1.306,0.262l1.092,1.158l-0.023,0.721l-0.838,0.685l0.236,5.679l-0.432,0.176l-0.162,0.87l-0.427,0.284l1.086,1.465l0.059,0.527l0.532,0.307l0.27,-0.658l0.532,0.87l-0.085,0.734l-0.612,0.37l-0.173,1.821l-0.451,0.559l-0.336,-0.167l-0.752,0.532l-1.065,-1.551l-1.372,1.627l-1.162,0.356l-0.227,0.928l1.489,4.097l1.062,1.586l0.152,1.51l0.532,-0.176l0.155,0.401l-0.262,0.631l0.8,2.258l0.506,0.022l0.103,3.079l-0.506,0.482l0.007,0.55l2.57,3.259l1.286,3.543l0.271,0.252l0.44,-0.415l1.145,0.645l0.198,1.483l1.511,1.848l1.749,1.294l1.783,0.802l0.438,1.186l-0.136,1.897l0.377,0.87l3.384,4.053l0.77,2.839l1.387,1.682l-0.255,0.789l-0.929,0.469l0.161,0.729l0.669,0.37l0.311,1.365L701.626,327.151z"
				},
				{
					"id":"SH-HL-SB",
					"title":"Sandy Bay",
					"d":"M415.024,468.689l-1.162,-0.866l-1.092,-0.307l-2.296,0.92l-0.532,1.019l-0.639,0.091l-2.2,2.082l-0.534,-0.829l-1.251,-0.072l-0.898,-2.128l-1.04,-0.884l-0.815,-2.001l-1.663,-1.614l-2.662,-0.595l-0.458,0.379l-0.091,0.929l-1.969,1.515l0.146,3.011l-0.41,1.218l-0.584,0.261l-2.786,0.181l-0.519,0.631l-0.506,0.091l-1.441,-0.189l-0.656,-0.496l0.042,-0.288l-0.419,-0.036l-0.281,0.369l-0.595,-0.45l0.434,-0.442l-0.12,-0.478l-0.471,-0.055l-0.192,-0.505l0.748,-1.145l1.212,-0.667l-2.725,0.153l-0.576,-0.469l-0.43,0.658l-1.862,0.784l0.305,1.623l-1.277,-1.515l-1.975,1.027l-0.264,-0.793l-1.203,0.396l-0.624,-0.532l0.103,-0.369l-3.931,-2.102v0.451l0.973,0.703l-0.964,1.091l-1.149,0.523l-2.991,-0.83l-2.128,-0.009l-0.783,0.46l-0.449,-0.451l-0.833,0.848l-0.183,0.686l-1.226,0.676l0.362,0.739l-0.783,0.28l-0.462,0.721l-0.898,-0.469h-1.692l-0.647,-0.307l0.188,1.163l-0.323,0.496h-0.549l-0.111,0.901l-0.955,-0.46l-0.469,-1.019l-0.685,-0.604l-1.038,-2.534l-1.419,-1.803l-0.841,0.045l-0.096,-0.541h-0.785l-0.462,1.172l0.286,0.514l0.569,-0.045l0.342,0.604l0.157,1.289l-0.432,0.334l0.656,3.426l-0.357,0.532L353,474.405l-0.17,0.36l-0.057,0.479l0.7,1.108l-0.643,0.442l0.039,2.173l-0.298,0.018l-0.24,-0.946l-0.514,-0.072l-0.868,1.154l-1.034,0.612l0.065,-0.423l-0.774,-0.127l-2.932,-2.308l-0.332,-1.064l0.41,-1.442l-1.877,-0.884l-1.945,0.1l-0.501,0.324l-2.368,3.174l0.229,1.975l1.021,1.1l-1.066,0.334l-0.113,1.56l0.338,0.307l-0.563,0.352l0.584,1.704l1.707,0.019l1.884,1.217h0.484l-0.022,0.703l0.842,0.856l-0.785,1.389l0.125,0.677l3.018,-0.992l0.442,-0.586l1.167,0.198l0.534,0.812l0.399,-0.406l0.776,0.244l-0.011,0.884l-2.015,1.965l-1.781,1.101l-0.499,-0.334l-0.756,0.279l-1.147,0.893l-0.055,0.767l-0.99,0.965l0.837,-0.252l0.024,0.522l-1.561,0.784l-0.146,0.334l0.951,-0.379l-0.613,1.38l0.059,0.685l-0.767,0.289l-0.225,0.667l-1.005,0.207l-1.049,0.775l-4.666,0.153l-4.199,1.831l-0.281,-2.155l0.312,-0.388l-0.386,-0.559l0.586,-1.623l-0.209,-0.523l-1.45,-0.18l-0.43,0.171l-0.301,0.974l-1.927,1.244l-0.29,0.072l-0.467,-0.676l-0.966,-0.046l-2.237,0.496l-0.658,2.074l-1.228,1.1l-0.661,0.126l-0.277,0.577l-0.929,0.334l-0.957,-0.315l-0.589,-2.651l-1.447,-2.218l-2.516,-1.532l0.172,1.244l-0.761,1.226l0.116,2.309l-1.554,2.073l-0.053,1.993l-0.549,1.821l-1.332,0.686l-0.333,-0.081l-0.164,-0.866l-1.576,0.749l-1.552,1.271l0.181,1.182l0.639,-0.352l0.639,0.379l0.024,0.676l-0.427,0.324l0.244,1.109l-0.393,0.514l0.436,0.875l-0.53,0.478l0.406,0.406l-0.708,0.532l-0.377,0.955l0.491,0.73l-0.704,0.055l-0.26,0.739l-0.863,0.117l-0.863,-0.893l-1.021,0.388l-1.188,-1.254l-1.469,2.137l-0.905,-1.722l-0.768,1.668l0.188,1.659l-0.503,0.604l-2.292,-1.731l-0.99,0.396l-0.863,-0.315l-1.295,0.622l-0.783,-0.856l-0.155,-0.631l-3.78,4.282l-0.647,0.271l-0.203,2.805l-0.323,-1.316l-1.731,1.46l0.087,-0.974l-1.055,-0.063l0,0l4.404,-17.186l12.656,-54.792l3.054,-11.081l3.97,-11.404l0.896,-3.872l1.555,-10.973l5.899,-57.729l0.196,-8.334l-0.277,-3.516l-1.129,-4.706l-0.929,-1.849l-2.61,-2.249l-11.899,-7.004l-8.562,-6.338l0,0l0.473,-2.29l5.845,-2.06l5.363,-0.965l5.699,0.072l5.289,0.951l4.164,1.42l3.726,1.961l5.036,3.755l1.762,0.771l1.452,0.157l1.43,-0.41l1.24,-0.941l3.015,-4.273l1.622,-1.708l1.714,-1.041l2.149,-0.677l6.543,-0.604l24.097,-0.207l8.015,-0.672l0,0l4.057,-0.019l-0.015,0.46l25.471,10.092l3.249,0.775l0,0l0.941,0.934l-0.87,2.28l-0.396,2.29l0.856,3.817l3.482,6.518l4.166,5.112l2.038,1.514l4.047,1.785l25.549,9.331l9.403,6.161l2.856,2.281l2.089,2.447l5.01,9.358l1.955,2.983l2.015,2.236l2.843,2.24l3.691,2.105l5.448,2.416l21.732,7.771l10.412,2.988l14.36,2.975l3.38,2.331l2.677,1.384l1.372,1.461l3.814,2.687l0,0l-0.628,0.14l-0.464,0.586l-0.249,-0.591l-1.603,-0.856l-0.754,0.816l-1.208,-0.258l-1.907,0.348l-0.405,1.208l1.306,0.55l0.028,0.491l-0.798,0.672l-2.283,0.284l-0.08,0.496l-2.229,1.316l-0.525,0.657l1.086,0.73l0.558,1.182l1.438,0.974l-0.028,0.852l0.521,0.37l0.476,1.082l-1.075,-0.28l-0.02,0.56l0.768,0.495l0.118,1.15l5.836,-0.189l0.515,4.341l-1.317,-0.248l-1.366,1.122l-0.074,2.178l0.745,1.249l-0.366,0.838l-1.725,-0.329l-0.379,0.97l-1.153,0.775l-1.326,2.984l-0.747,0.188l-0.118,0.916l-0.436,0.022l-0.256,0.636l-2.022,-0.446l0.198,1.708l-1.358,0.36l-0.028,0.758l-1.079,1.082l-0.028,0.536l1.016,1.479l-0.699,0.577l0.804,0.027l2.503,1.167l0.951,0.059l0.469,0.893l0.004,1.83l-0.66,0.023l0.193,0.626l-0.543,1.068l0.603,0.677l0.142,0.694l-0.26,0.505l-1.7,1.641l-1.176,0.352l-3.357,-0.009l-0.229,0.478l-1.313,-0.045l-1.509,0.586l-0.748,0.613l0.277,0.522l-0.693,1.569l-0.037,1.596l0.274,0.054l-0.364,0.839l-1.895,1.73l-1.789,-0.964l-1.952,-0.226l-0.457,-0.947l-1.006,-0.072l-0.357,-0.369l-0.188,-0.379l0.275,-0.396l-1.321,-0.694l-0.426,-0.622l-0.384,-2.759l-0.329,-0.271l0.053,-0.974l-0.817,-1.208l0.287,-0.289l0.168,-2.475l-2.625,-2.543l-2.278,0.866l-0.695,0.658l-0.571,2.366l-0.994,-0.226l-0.338,-0.595l-0.913,-0.234l-1.599,-1.208l-1.391,-0.172l0.124,0.744l-0.941,1.375l-0.124,3.327l0.695,-0.153l0.281,2.128l-0.527,1.244l-0.831,0.865l-0.2,1.046l-1.616,1.523l0.238,-0.622l-1.507,-2.254l-2.392,-2.569l-0.318,0.243l-4.053,0.019l-1.397,-0.262l-0.658,0.649l-0.199,0.775l0.476,0.667l-0.274,1.063l-1.229,0.226l-1.27,-0.676l-1.397,0.495l-0.366,1.65l-1.847,-0.73l-0.966,0.027l0.249,1.244l-0.382,0.226l-0.992,-1.109l-0.841,0.271l0.366,0.532l-0.207,2.299l-0.696,0.649l-0.54,0.063l-0.868,-1.488l-0.604,0.036l-0.124,0.73l-0.447,0.234l-1.038,-0.441l0.362,-0.568l-0.384,-0.217l-0.803,0.081l-0.283,-0.514l-1.127,-0.009l-1.184,-1.19l-0.249,-1.072l-2.926,-3.661l-0.665,-1.604l-1.523,-1.109l-1.164,-0.072l-0.764,0.983l-0.473,1.379l0.396,1.137l1.472,0.82l1.145,1.316l0.085,1.28l-0.386,0.153l-0.009,0.721l-0.773,0.379l0.823,0.667l0.051,3.841l0.602,0.956l-0.144,0.667l0.444,0.126l0.188,0.479l-0.109,0.514l-1.256,0.288l-1.283,-0.216l0.067,0.946l0.848,0.784l-0.412,3.273l-0.536,0.929l0.391,0.234l-0.256,0.73l-1.053,0.567l-0.998,1.515l0.02,1.605l-0.295,0.234l0.406,2.867l-0.205,1.091l-1.04,1.154l-1.448,-0.379l-1.423,-1.055l-0.608,-1.235l-2.354,-1.713l-4.151,-0.361l-1.075,0.803l-0.536,0.019l0.07,0.55l-0.676,-0.172l-0.502,0.388l0.148,0.253l-1.291,0.965l-1.603,-1.506l-0.563,-1.389l-0.706,0.126l-0.628,-1.361l-2.601,-3.598l-2.734,-2.19l-1.718,-0.667l-1.166,-0.208l-0.936,1.01l-2.777,-0.306l-1.857,0.198l-1.147,1.434l-1.615,0.486l-2.394,0.226l-2.326,-0.451l-0.725,-0.694l-0.425,-1.487l-1.796,-2.488l-0.38,-1.804l-1.7,-1.677l-1.369,-0.126L418,471.926l-1.983,-3.002L415.024,468.689z"
				},
				{
					"id":"SH-HL-SP",
					"title":"Saint Paul's",
					"d":"M383.992,292.103L384.489,293.355L384.511,295.28L381.681,316.09L380.253,316.248L380.253,316.248L372.238,316.92L348.141,317.127L341.598,317.73L339.449,318.407L337.735,319.448L336.113,321.156L333.098,325.43L331.857,326.371L330.427,326.781L328.975,326.624L327.213,325.854L322.177,322.099L318.451,320.138L314.287,318.718L308.998,317.767L303.299,317.694L297.936,318.659L292.091,320.719L291.618,323.009L291.618,323.009L289.49,321.963L285.16,318.187L281.711,316.893L278.075,316.901L272.413,318.628L267.904,319.2L264.313,318.835L260.967,317.523L257.653,314.95L252.732,309.884L249.34,305.598L246.098,300.306L243.977,297.574L242.124,295.776L236.911,292.021L234.303,289.709L231.824,286.906L229.457,283.124L227.303,277.504L224.602,264.663L221.846,256.104L221.237,252.039L221.126,247.59L221.809,240.654L223.084,235.399L224.66,231.722L228.05,227.336L229.341,224.673L230.442,220.774L231.312,214.383L227.874,201.981L225.206,198.533L224.059,196.118L224.041,194.31L225.301,191.304L225.445,189.912L223.356,183.792L222.328,177.559L222.133,177.289L220.152,177.536L218.564,176.545L218.564,176.545L219.816,176.108L220.984,174.706L220.919,173.606L222.458,172.142L223.315,171.43L225.12,170.691L225.016,169.555L227.373,168.83L227.512,168.221L226.16,165.603L226.234,164.805L227.436,165.499L228.212,166.283L228.253,166.729L229.869,167.216L230.377,166.554L233.444,166.125L234.89,165.283L234.792,164.832L235.808,162.89L236.119,160.641L237.048,159.744L238.099,157.671L238.716,157.252L238.055,156.563L238.334,156.139L238.857,156.049L240.377,153.548L239.961,152.471L240.207,151.759L241.049,151.141L240.999,150.524L240.333,150.641L241.19,149.546L241.794,150.163L242.875,149.866L243.205,150.695L244.895,150.614L244.995,149.483L246.698,150.227L246.676,150.452L247.539,149.735L248.96,149.6L250.482,148.834L251.472,148.744L252.856,147.712L252.205,146.5L252.349,145.774L252.739,145.17L253.925,144.566L253.888,143.714L254.502,143.597L254.714,142.976L256.951,142.381L257.684,141.597L257.365,140.655L259.277,137.712L259.055,137.333L259.776,135.179L260.265,135.296L260.934,134.463L260.657,133.832L261.259,133.543L261.359,132.773L261.858,132.385L261.959,132.746L262.349,132.593L262.683,131.822L264.172,130.786L264.791,130.961L266.147,130.366L266.251,129.627L267.394,128.478L267.843,128.447L267.553,127.446L268.517,126.369L269.755,126.175L270.529,125.648L270.178,125.188L270.387,124.679L270.799,124.566L270.974,123.846L271.515,123.49L271.85,123.638L272.38,122.345L272.851,122.241L273.161,120.056L273.804,119.803L274.296,120.231L274.8,119.371L274.401,118.388L276.119,117.767L277.815,119.452L278.82,119.06L279.483,118.379L279.365,117.586L279.788,117.023L282.099,118.442L283.468,118.303L283.468,118.303L284.498,122.813L289.176,131.335L291.046,137.009L299.405,152.191L304.492,163.706L305.434,168.793L305.501,180.222L305.885,186.014L306.679,190.457L307.884,193.31L308.743,194.018L309.648,193.936L315.761,189.799L319.723,188.528L326.049,188.537L336.503,189.542L336.612,189.763L336.612,189.763L336.612,189.763L336.612,189.763L338.721,193.986L340.53,196.514L347.711,203.297L347.711,203.297L348.845,211.905L352.493,224.019L353.493,238.41L355.318,245.27L356.223,253.95L359.535,272.176L360.607,273.024L362.382,272.555L364.789,270.486L368.824,265.271L369.394,265.001L370.459,265.461L371.946,267.304L372.744,270.311L374.423,273.664L379.819,282.709L380.999,285.711L381.484,288.947L382.248,290.516z"
				}
			]
		}
	}
};