﻿// (c) ammap.com | SVG (in JSON format) map of Senegal - Low
// areas: {id:"SN-DK"},{id:"SN-DB"},{id:"SN-FK"},{id:"SN-KE"},{id:"SN-KA"},{id:"SN-KL"},{id:"SN-KD"},{id:"SN-LG"},{id:"SN-MT"},{id:"SN-SE"},{id:"SN-SL"},{id:"SN-TC"},{id:"SN-TH"},{id:"SN-ZG"}
AmCharts.maps.senegalLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"-17.531313",
				"topLatitude":"16.691273",
				"rightLongitude":"-11.341837",
				"bottomLatitude":"12.307237"
			}
		},
		"g":{
			"path":[
				{
					"id":"SN-DK",
					"title":"Dakar",
					"d":"M37.765,531.05l0.498,0.462l0.396,4.828l1.902,4.375l0.765,4.366l1.203,0.642l0.198,1.3l-0.174,1.208l-2.41,1.292l0.325,1.066l-0.493,2.504l1.133,0.989l-0.707,4.654l0.673,1.922l-1.87,1.126l0,0l-1.386,-2.947l-3.44,-4.147l-6.909,-4.872l-1.647,-0.146l-7.838,-2.911l-5.31,0.591l-1.543,1.509l0.134,0.958l1.133,0.164l0.068,0.57l-0.754,0.65l0.376,1.291l-0.79,-0.704l-0.334,0.253l-0.027,0.563l1.179,0.647l-1.069,1.017l-0.219,1.885l-1.426,-2.569l-1.069,-0.191l-0.137,-0.506l-1.015,0.45l0.097,-1.048l-0.837,-0.811l0.384,-0.508l-1.398,-0.93l-0.274,-0.845l-1.234,-0.366l-1.206,-1.943l-1.48,-0.282l0.384,-1.183l0.676,0.366l1.078,-0.732l1.299,0.05l1.415,-1.205l1.042,0.451l2.775,-0.535l9.863,-3.862L37.765,531.05z"
				},
				{
					"id":"SN-DB",
					"title":"Diourbel",
					"d":"M101.156,561.749l-0.571,-1.517l-4.896,0.453l-2.245,-0.642l-2.246,-3.071l-2.041,-1.132l0.255,-0.972l-0.678,-0.167l0.108,-1.629l2.549,-3.529l1.178,-0.517l0.562,-1.851l-0.541,-0.984l0.878,-2.5l-5.154,-4.347l0.549,-1.286l1.885,-1.671l-0.335,-2.032l-5.759,-6.712l0.522,-0.628l3.942,-2.872l10.647,-2.84l0.526,-0.213l-0.102,-0.691l3.128,-0.163l2.473,-1.621l2.85,-0.82l7.443,0.744l0.705,-1.018l0.024,1.164l1.931,0.601l1.127,-0.57l0.602,1.367l7.139,2.383l0.746,0.513l0.04,1.968l1.103,-0.371l1.282,0.557l4.052,-1.1l0,0l5.504,0.505l3.827,-0.286l3.716,-1.371l4.693,1.918l1.369,-2.146l3.841,0.165l1.536,-1.62l1.148,-0.332l1.705,0.351l-0.256,0.72l6.167,-0.918l1.368,1.681l3.894,1.746l2.804,5.108l1.261,1.023l1.805,-0.166l1.551,-0.873l2.435,-3.345l1.462,-0.394l3.61,4.975l-0.497,1.731l4.06,1.536l-0.403,0.444l5.955,3.67l5.413,-1.66l5.093,1.626l-0.068,2.41l1.441,0.823l0,0l-2.871,5.188l-0.834,3.201l-4.985,1.1l-4.162,3.498l-0.851,-0.029l0,0l-0.813,-2.155l-0.996,-0.894l-0.521,1.345l-0.461,-0.035l-2.089,-0.716l0.147,-1.709l-1.586,0.604l-1.477,-1.219l0.244,-1.572l-4.454,0.963l-0.515,2.714l-9.445,-5.051l-1.09,0.645l-0.757,3.952l0.663,7.257l-1.11,3.352l-4.427,3.741l-4.353,1.344l-3.486,2.019l-5.872,0.351l-2.139,-0.575l-1.909,-0.725l-0.661,-1.019l-0.07,-1.564l-2.863,0.274l-0.562,0.953l-3.156,0.042l-5.397,-1.061l-0.522,-0.749l-0.844,0.316l-1.137,-0.398l-0.299,-0.885l-1.234,0.303l-2.993,-1.542l-0.784,0.719l-7.625,-0.158l-2.392,-0.818l-1.613,-0.995l-0.253,-0.953l-1.42,-0.418l-1.699,0.914l-0.655,-0.431l-2.496,0.875l-3.229,-0.004l-1.548,0.725l-1.672,-0.574L101.156,561.749z"
				},
				{
					"id":"SN-FK",
					"title":"Fatick",
					"d":"M101.156,561.749l2.84,-0.25l1.672,0.574l1.548,-0.725l3.229,0.004l2.496,-0.875l0.655,0.431l1.699,-0.914l1.42,0.418l0.253,0.953l1.613,0.995l2.392,0.818l7.625,0.158l0.784,-0.719l2.993,1.542l1.234,-0.303l0.299,0.885l1.137,0.398l0.844,-0.316l0.522,0.749l5.397,1.061l3.156,-0.042l0.562,-0.953l2.863,-0.274l0.07,1.564l0.661,1.019l1.909,0.725l2.139,0.575l5.872,-0.351l3.486,-2.019l4.353,-1.344l4.427,-3.741l1.11,-3.352l-0.663,-7.257l0.757,-3.952l1.09,-0.645l9.445,5.051l0.515,-2.714l4.454,-0.963l-0.244,1.572l1.477,1.219l1.586,-0.604l-0.147,1.709l2.089,0.716l0.461,0.035l0.521,-1.345l0.996,0.894l0.813,2.155l0,0l0.258,5.007l2.305,1.812l-1.906,1.067l-0.431,-0.48l-6.715,5.424l0.095,2.646l-0.763,0.61l-3.714,-0.785l-0.304,0.837l0.745,0.931l-0.649,0.241l0,0l-1.737,-1.141l-3.249,0.448l-1.181,4.078l-0.798,0.951l-3.281,0.662l-2.368,6.82l-0.57,0.083l-8.556,-0.188l0.045,-6.605l-0.396,-0.67l-1.307,-0.161l-1.254,1.716l-2.121,-1.89l-1.315,-0.328l-1.706,1.493l-1.015,1.973l-1.58,0.275l-0.109,1.733l-1.38,1.467l0.161,0.858l-0.498,0.461l-2.856,0.792l-3.844,-1.066l-3.481,1.704l-4.729,-0.029l-1.768,1.654l-0.517,2.148l-5.006,-0.493l-1.446,3.111l-1.748,-0.512l-4.233,3.371l-2.119,-0.27l-1.38,2.765l0.219,0.442l-0.958,0.339l0.864,0.556l-0.112,0.584l-0.685,0.327l-0.66,-0.449l0.126,2.895l1.442,1.03l-1.296,0.684l0.732,0.947l-0.948,-0.456l-0.885,1.454l-0.725,-0.011l0.531,0.712l4.644,-0.688l2.958,0.212l3.82,2.095l3.143,2.66l0.328,5.295l-3.274,2.607l-1.315,3.048l1.164,1.049l2.845,-0.444l1.575,0.481l-0.323,1.577l1.468,0.129l-0.066,1.562l0.704,1.019l0.529,5.412l-2.826,5.581l-2.302,0.104l0.868,0.973l-0.663,3.465l1.973,1.106l4.736,4.716l0.555,-0.552l0.717,0.29l0.912,7.033l1.746,2.27l-0.108,0.908l1.295,0.161l-0.258,1.301l-1.413,0.706l0.102,0.678l1.119,0.649l-1.087,1.518l0,0l-35.125,0.161l-4.728,-0.235l-0.517,-0.905l-0.91,0.536l-0.762,-1.555l-1.691,-1.316l0.174,-0.617l-0.92,-1.152l-1.943,-0.702l-2.663,-3.508l0.502,-4.347l-1.569,-2.552l-3.184,-2.89l-1.15,0.112l-0.795,-1.458l-1.551,-0.82l-2.824,-0.737l-0.45,-0.665l-0.658,1.185l-0.411,-6.201l0.384,-2.722l0.39,-3.434l-0.845,-0.227l-0.204,-0.662l-0.959,-11.684l0,0l0.931,-1.238l1.15,-0.06l-0.09,-2.131l-1.389,-1.517l0.094,-0.608l-2.238,-1.448l-0.217,-0.995l0.657,-0.972l3.083,-0.129l-0.968,-2.011l3.9,-3.394l0.004,-1.377l-2.082,-1.647l-0.071,-2.117l2.158,-1.385l-1.059,-0.678l2.542,-3.719l-0.153,-5.056l1.25,-6.896l0.659,-0.775l5.515,-0.062l1.744,-1.875l2.222,-0.907l4.318,-3.648l1.495,-2.658L101.156,561.749z"
				},
				{
					"id":"SN-KE",
					"title":"Kédougou",
					"d":"M436.241,758.746L433.834,757.064L433.188,756.2L433.196,755.045L436.054,753.229L439.615,752.334L438.094,750.467L436.935,746.009L436.9,744.632L438.415,742.973L437.177,741.608L438.43,740.762L437.791,739.771L435.879,739.787L433.278,738.906L433.076,738.022L433.883,736.764L431.354,735.473L431.606,733.561L430.287,732.575L432.981,732.571L434.097,731.336L433.84,729.697L432.748,729.004L431.918,726.786L430.497,725.452L429.542,726.131L427.33,721.956L424.793,721.213L424.962,720.635L425.65,720.814L428.092,719.13L427.79,717.258L429.13,717.295L430.043,716.386L429.993,716.955L430.545,717.033L431.684,715.827L432.516,716.862L431.973,717.289L433.608,716.814L434.358,717.342L435.257,716.759L440.044,719.521L440.811,719.194L443.213,715.843L444.01,716.644L445.967,716.775L446.217,715.508L448.11,715.371L449.357,714.264L450.032,714.926L451.2,714.727L451.774,715.413L453.147,714.205L454.095,715.012L455.408,714.35L454.856,715.776L456.879,716.669L457.151,718.149L458.244,717.088L460.365,718.662L460.596,719.947L461.305,719.601L462.102,720.16L461.804,720.906L463.392,721.667L464.531,720.812L465.366,722.559L466.896,722.828L467.163,722.242L466.296,721.443L466.393,720.726L467.728,720.874L467.018,719.496L468.411,719.337L468.468,718.582L470.728,718.759L470.681,717.065L472.318,716.999L471.919,715.934L472.255,714.823L473.066,715.231L473.652,714.465L475.658,715.14L476.436,714.623L476.138,713.305L477.873,713.126L478.315,712.078L479.435,711.748L479.293,710.538L480.7,709.612L480.578,708.637L481.295,708.76L480.43,707.66L480.876,706.914L480.5,704.901L483.933,704.189L484.938,702.7L487.457,703.189L488.413,702.57L488.607,701.298L489.453,701.559L489.762,702.432L490.983,702.086L492.312,703.746L494.08,703.418L494.591,703.843L495.372,703.375L496.082,703.803L496.718,702.781L499.005,702.6L500.422,698.96L501.779,698.273L501.664,697.261L503.883,695.459L505.426,695.05L506.133,693.747L507.364,693.969L509.977,692.921L512.635,694.615L514.118,696.377L515.204,695.785L515.197,694.398L516.395,692.927L516.758,690.427L521.907,691.046L524.34,689.945L525.178,687.969L521.46,682.663L521.261,680.836L522.414,679.623L522.526,676.515L523.334,675.988L532.831,680.693L533.877,682.663L534.968,682.949L536.757,684.615L540.013,685.19L541.836,686.412L544.44,685.043L544.069,686.995L544.467,687.948L543.779,689.385L544.233,690.867L545.594,691.102L546.76,689.631L548.597,689.148L551.638,685.584L553.286,685.745L558.344,683.729L558.344,683.729L559.935,684.019L560.842,685.661L562.616,686.896L563.392,688.757L564.337,689.233L563.972,691.117L566.749,691.104L567.854,688.619L570.173,687.932L570.841,685.307L572.429,683.264L572.289,681.168L573.227,680.503L576.739,680.688L577.708,681.804L577.762,683.056L580.349,683.08L582.37,682.426L584.339,682.671L584.438,684.183L583.254,685.598L585.263,685.94L587.266,685.415L587.488,688.577L588.292,689.978L588.037,691.114L589.378,691.628L590.277,692.897L592.197,693.143L592.859,694.008L592.64,694.797L594.606,696.347L592.797,699.299L592.655,701.12L593.342,702.299L596.08,702.423L596.887,703.036L596.571,705.082L595.056,706.457L595.261,707.426L596.642,707.853L597.23,710.232L598.643,710.981L599.184,712.322L602.441,712.471L604.217,714.204L603.205,716.672L605.557,718.675L605.178,720.337L607.068,721.3L607.03,722.106L605.148,722.511L606.048,724.093L605.85,724.858L607.932,725.54L608.162,722.875L610.01,723.153L610.948,724.297L611.064,726.393L611.995,728.346L611.575,729.175L610.581,729.519L607.625,730.226L607.216,729.507L606.788,729.801L606.662,731.112L607.905,731.491L607.92,732.279L606.642,733.503L606.347,734.664L607.238,736.565L605.761,737.861L606.543,738.609L606.456,739.764L608.479,739.427L607.897,741.155L608.581,742.442L608.404,744.565L606.949,745.175L608.901,747.166L608.318,748.197L609.741,748.499L610.282,749.638L604.283,749.984L604.329,752.931L603.493,753.286L602.943,752.522L602.96,754.491L601.911,755.366L602.316,756.225L604.398,756.144L605.355,757.515L605.953,760.108L604.434,761.765L606.355,763.705L605.806,765.362L604.691,766.34L602.604,766.184L602.08,767.863L603.639,767.635L604.077,769.828L605.019,770.117L605.563,768.39L607.921,768.724L607.542,770.135L608.779,770.746L608.454,773.359L609.059,774.089L608.808,773.107L609.585,771.538L610.749,771.881L611.051,772.683L611.19,774.113L610.824,773.886L610.479,774.547L611.297,775.107L611.443,776.214L610.631,776.31L610.144,777.359L609.162,777.405L610.003,779.173L609.667,780.8L606.538,780.889L604.483,779.007L599.994,778.41L599.073,777.724L596.687,777.871L587.672,778.8L584.976,779.881L583.625,779.204L580.934,779.824L577.091,782.517L575.439,782.473L574.068,783.648L570.201,784.162L569.404,783.205L567.479,783.063L566.762,782.162L565.875,782.789L563.883,782.326L562.234,783.055L560.626,780.862L557.965,780.024L557.163,777.792L550.905,781.693L546.125,782.438L543.161,779.957L541.074,779.341L536.034,781.11L534.133,783.933L532.426,784.342L529.555,786.742L525.044,786.975L523.567,787.854L522.732,787.454L511.991,792L511.094,789.15L510.271,788.607L508.571,785.18L507.207,784.194L504.752,784.084L502.848,782.74L498.551,781.922L496.55,782.223L493.848,785.016L491.516,786.01L489.828,783.934L489.804,781.943L488.249,782.368L485.548,779.305L483.709,778.965L481.432,779.474L479.338,778.883L471.771,779.245L472.709,776.037L471.641,775.345L471.015,775.688L469.078,774.409L466.931,775.103L463.975,773.374L464.772,771.119L460.681,769.697L460.013,768.604L460.413,767.764L459.288,767.371L454.089,769.088L453.709,769.869L454.327,770.451L454.53,771.929L453.871,775.128L452.177,775.228L451.43,776.054L449.284,775.554L448.505,774.683L442.614,774.351L441.946,773.521L442.191,771.059L441.752,769.309L443.141,768.067L443.212,766.423L444.266,765.037L444.141,762.584L443.439,761.479L443.734,760.337L442.243,759.38L442.425,758.352L441.181,758.314L440.907,759.077L439.374,760.071L437.896,759.096L436.971,759.12L436.981,758.533z"
				},
				{
					"id":"SN-KA",
					"title":"Kaffrine",
					"d":"M209.269,541.355L210.94,541.137L213.924,543.528L219.085,550.507L221.321,552.711L226.133,555.608L248.748,559.858L249.405,557.314L259.943,550.51L263.974,555.259L265.855,555.262L265.855,555.262L268.744,558.479L270.394,558.984L276.059,562.574L278.441,562.576L279.395,561.592L281.102,561.322L285.524,561.387L286.126,562.739L288.297,562.147L290.662,563.005L290.696,563.439L290.696,563.439L290.115,564.711L287.991,564.873L287.665,577.371L287.211,578.072L286.512,591.126L290.941,595.761L292.014,607.257L291.277,611.87L292.324,612.591L291.267,614.056L292.176,620.9L289.378,622.908L291.886,623.117L290.159,627.814L281.418,633.33L278.632,640.021L270.522,640.831L267.232,645.003L267.232,645.003L261.018,642.221L256.308,641.69L253.332,642.166L244.877,639.062L239.006,641.108L229.772,646.854L227.39,646.872L224.171,644.12L219.792,643.197L214.883,644.448L211.128,647.093L211.128,647.093L211.127,646.436L209.69,646.307L208.585,643.978L208.424,643.451L209.179,643.441L209.164,641.896L203.207,641.597L202.589,640.802L201.971,641.887L200.295,641.871L198.297,640.916L198.218,639.96L197.23,640.155L193.755,638.623L192.583,639.312L189.562,643.83L187.983,644.21L186.24,642.652L185.34,640.606L184.555,640.6L181.477,638.128L182.418,636.518L180.947,635.145L182.536,633.739L183.699,631.379L181.043,626.053L179.729,625.417L178.195,625.982L175.353,623.829L173.379,623.306L173.9,620.592L173.219,616.365L170.966,615.851L167.769,613.516L167.753,612.887L166.597,612.721L166.039,610.644L167.082,609.702L166.71,608.501L167.028,603.859L170.044,597.054L175,596.403L176.122,592.132L182.579,592.411L183.217,585.912L182.11,578.613L182.948,573.476L183.798,573.23L184.487,571.622L184.487,571.622L185.136,571.381L184.391,570.45L184.695,569.613L188.41,570.398L189.173,569.788L189.078,567.142L195.792,561.718L196.223,562.198L198.129,561.131L195.824,559.319L195.566,554.313L195.566,554.313L196.417,554.342L200.579,550.844L205.564,549.744L206.398,546.543z"
				},
				{
					"id":"SN-KL",
					"title":"Kaolack",
					"d":"M184.487,571.622L183.798,573.23L182.948,573.476L182.11,578.613L183.217,585.912L182.579,592.411L176.122,592.132L175,596.403L170.044,597.054L167.028,603.859L166.71,608.501L167.082,609.702L166.039,610.644L166.597,612.721L167.753,612.887L167.769,613.516L170.966,615.851L173.219,616.365L173.9,620.592L173.379,623.306L175.353,623.829L178.195,625.982L179.729,625.417L181.043,626.053L183.699,631.379L182.536,633.739L180.947,635.145L182.418,636.518L181.477,638.128L184.555,640.6L185.34,640.606L186.24,642.652L187.983,644.21L189.562,643.83L192.583,639.312L193.755,638.623L197.23,640.155L198.218,639.96L198.297,640.916L200.295,641.871L201.971,641.887L202.589,640.802L203.207,641.597L209.164,641.896L209.179,643.441L208.424,643.451L208.585,643.978L209.69,646.307L211.127,646.436L211.128,647.093L211.128,647.093L211.13,647.828L210.086,647.684L208.878,649.028L206.818,652.568L204.316,662.887L138.351,662.809L138.351,662.809L139.438,661.291L138.32,660.642L138.218,659.964L139.631,659.258L139.889,657.957L138.594,657.796L138.702,656.888L136.957,654.618L136.044,647.585L135.327,647.295L134.772,647.847L130.037,643.131L128.064,642.024L128.727,638.56L127.859,637.587L130.162,637.483L132.988,631.902L132.458,626.49L131.754,625.472L131.821,623.91L130.353,623.781L130.676,622.204L129.101,621.723L126.255,622.167L125.092,621.118L126.407,618.07L129.681,615.463L129.354,610.168L126.211,607.508L122.391,605.413L119.433,605.201L114.79,605.889L114.259,605.177L114.983,605.188L115.868,603.733L116.816,604.189L116.083,603.242L117.379,602.559L115.938,601.528L115.812,598.634L116.471,599.083L117.156,598.756L117.268,598.172L116.404,597.616L117.362,597.277L117.143,596.835L118.522,594.07L120.642,594.34L124.875,590.969L126.623,591.48L128.069,588.369L133.076,588.862L133.593,586.714L135.36,585.06L140.09,585.089L143.571,583.385L147.415,584.451L150.271,583.659L150.77,583.198L150.608,582.34L151.988,580.873L152.098,579.14L153.678,578.864L154.693,576.892L156.398,575.398L157.714,575.727L159.834,577.616L161.089,575.9L162.396,576.062L162.792,576.731L162.748,583.337L171.303,583.524L171.874,583.441L174.242,576.621L177.522,575.959L178.321,575.008L179.502,570.93L182.75,570.481z"
				},
				{
					"id":"SN-KD",
					"title":"Kolda",
					"d":"M264.066,677.539L265.659,677.48L267.718,679.302L270.44,680.502L274.752,680.357L275.896,682.661L277.734,684.717L284.685,688.091L288.799,688.263L294.365,685.876L298.124,690.796L299.734,691.553L304.313,692.129L306.549,695.139L308.189,696.38L310.403,697.827L314.398,699.283L323.785,698.258L324.558,699.615L326.572,700.735L328.953,700.517L331.14,699.605L334.48,700.61L336.682,699.985L337.982,698.453L338.452,695.515L337.739,694.665L338.515,694.104L339.579,693.746L340.167,694.408L341.615,694.12L342.397,693.04L343.342,693L343.272,693.682L345.805,694.027L345.838,693.339L349.313,693.078L354.559,690.039L360.136,690.615L362.965,690.153L367.071,687.502L369.486,683.665L370.28,678.253L367.878,676.144L365.911,672.445L363.61,670.923L363.61,670.923L366.309,671.583L366.251,669.672L367.345,667.288L370.666,667.493L370.923,668.218L369.889,669.687L369.796,671.531L368.789,673.852L369.213,675.212L370.095,675.355L372.379,673.403L375.523,674.184L377.846,675.454L377.281,676.664L373.876,678.798L373.896,679.763L374.605,680.525L374.524,682.059L372.283,684.591L375.124,685.014L380.145,683.889L382.156,684.068L382.085,685.047L379.151,688.084L379.576,688.92L383.15,688.158L380.688,693.282L381.814,694.57L384.564,694.148L385.584,695.024L385.011,697.604L386.584,698.035L387.702,697.421L388.585,698.358L388.931,699.415L388.46,699.213L388.307,700.05L389.208,700.156L389.666,700.97L389.262,702.223L389.018,701.605L387.9,702.134L388.983,702.596L387.65,704.974L388.776,705.58L388.172,705.91L389.172,706.914L388.781,707.338L388.165,706.855L387.938,707.632L388.666,708.014L387.801,708.284L387.715,708.951L390.035,709.422L389.538,709.608L389.369,710.844L390.384,711.83L390.928,711.443L391.036,713.852L391.786,712.894L392.533,713.036L391.903,713.152L392.28,713.787L391.605,714.521L391.93,715.856L393.139,715.928L392.982,714.92L393.66,714.725L394.606,715.615L393.623,716.479L393.711,717.055L394.594,716.657L395.299,717.468L394.792,718.174L395.796,718.891L396.198,718.419L396.266,719.016L397.407,718.556L397.502,719.665L396.384,720.044L396.862,720.391L396.287,720.508L396.023,721.767L396.586,722.084L397.811,721.022L398.93,721.998L398.61,723.023L397.652,723.58L398.514,724.545L398.431,725.315L399.479,725.135L399.482,725.806L398.179,726.093L397.403,727.089L397.979,728.022L399.042,728.077L399.186,727.557L399.728,728.307L399.048,729.403L398.245,729.293L398.876,731.492L399.857,731.665L401.18,732.87L402.724,732.922L402.233,734.284L402.74,734.757L401.615,735.163L403.643,736.78L403.929,737.6L403.363,738.049L401.82,737.293L401.107,737.647L402.147,738.091L402.346,739.138L400.989,740.058L401.349,742.018L402.658,742.121L402.897,742.688L401.884,744.483L402.848,744.125L403.22,745.565L402.805,746.307L403.245,747.577L402.548,747.448L402.138,748.073L403.266,749.836L402.813,750.473L401.854,750.239L402.592,750.714L402.896,751.841L402.126,752.99L403.848,751.702L405.005,752.252L404.56,753.013L405.507,752.793L404.992,753.49L406.06,753.784L405.907,754.73L406.685,755.28L408.086,754.522L409.809,754.843L410.065,754.072L411.725,752.996L413.602,753.488L413.602,753.488L412.846,756.661L399.002,755.108L327.101,754.721L326.793,755.104L303.685,754.492L277.329,754.813L239.109,754.091L239.109,754.091L237.325,752.94L235.708,748.71L237.563,745.489L237.494,744.168L238.47,743.524L238.623,742.333L239.653,741.12L239.986,732.725L235.727,728.158L234.619,725.605L235.618,722.895L235.262,720.958L228.814,717.422L226.766,714.311L226.59,709L226.017,707.119L224.374,706.965L224.127,703.831L222.062,703.143L219.016,703.231L219.039,702.385L216.476,700.098L216.11,695.461L217.68,692.698L217.945,686.195L217.945,686.195L221.87,685.479L228.56,680.296L229.753,677.531L231.699,669.182L236.921,664.853L237.21,663.84L242.232,662.106L244.409,666.593L249.799,671.929L258.259,676.371L261.028,677.329z"
				},
				{
					"id":"SN-LG",
					"title":"Louga",
					"d":"M89.211,460.708L80.81,473.52l0,0l2.822,1.716l0.707,2.077l-2.967,4.292l-2.411,7.909l2.914,1.361l1.248,1.73l6.495,4.809l0.37,1.919l1.126,0.424l0.674,1.357l-0.093,3.272l-0.681,1.113l1.997,-1.38l2.988,-3.565l3.838,-7.436l1.695,-0.729l-0.172,-1.269l1.401,-2.185l4.985,-5.165l4.189,3.618l5.867,0.381l1.488,2.45l-1.104,2.174l1.241,1.668l1.871,0.926l0.768,-2.07l1.126,-0.396l1.003,0.412l1.237,1.565l0.508,5.386l2.924,4.764l0.112,2.952l3.91,3.175l0.238,4.872l1.583,4.027l0.13,4.357l0,0l5.504,0.505l3.827,-0.286l3.716,-1.371l4.693,1.918l1.369,-2.146l3.841,0.165l1.536,-1.62l1.148,-0.332l1.705,0.351l-0.256,0.72l6.167,-0.918l1.368,1.681l3.894,1.746l2.804,5.108l1.261,1.023l1.805,-0.166l1.551,-0.873l2.435,-3.345l1.462,-0.394l3.61,4.975l-0.497,1.731l4.06,1.536l-0.403,0.444l5.955,3.67l5.413,-1.66l5.093,1.626l-0.068,2.41l1.441,0.823l0,0l1.671,-0.219l2.984,2.392l5.162,6.979l2.235,2.204l4.812,2.897l22.615,4.25l0.658,-2.544l10.538,-6.805l4.03,4.749l1.881,0.003l0,0l2.664,-3.183l1.866,-7.29l3.405,-2.357l0.421,-7.032l-1.188,-12.769l-2.669,-7.22l-0.781,-6.39l0.677,-0.709l6.648,-1.504l0.467,-0.725l11.951,-0.347l4.898,-6.408l2.025,-0.865l1.883,-6.606l-0.109,-3.739l3.798,-5.485l-4.097,-0.082l-7.814,1.66l-12.567,-6.625l-3.169,-0.884l-1.016,-0.925l-0.274,-1.199l-0.055,-0.808l1.63,0.019l3.449,-4.242l-0.909,-2.443l0.054,-3.193l-1.567,-0.48l4.159,-11.636l2.197,-1.781l2.566,-1.004l-0.556,-4.588l13.229,-8.91l0,0l-6.03,-10.261l-1.511,1.258l-3.966,-0.593l0.367,-3.041l-0.868,-1.8l-2.84,3.105l-5.811,3.066l-1.832,1.949l-5.13,2.393l-2.632,-4.43l-2.317,-1.374l-7.005,-7.293l-3.58,2.395l-12.749,1.08l-2.946,2.117l-1.157,-0.116l-5.229,-1.629l-2.142,-4.534l-2.539,-2.039l-4.104,-2.193l-3.429,1.601l-3.139,0.253l-2.415,-2.542l-1.227,2.08l-0.112,1.883l0.692,1.811l-2.382,0.041l-2.633,1.396l1.656,4.499l-0.288,3.137l-3.162,-0.987l-5.195,2.088l-4.245,-0.316l1.358,-3.2l-1.47,-2.167l-7.488,-3.857l-11.076,-10.155l-8.732,-9.661l-4.613,2.892l-4.741,4.237l-0.812,1.481l-17.434,8.224l-3.639,1.147l-2.708,4.644l-8.418,6.05l-1.812,3.383l-0.243,-0.33l-1.587,1.755l-2.687,1.011l-0.875,1.612l-0.769,0.104l-0.56,-0.917l-3.374,0.852l-8.64,-0.423l-2.832,1.03l-3.159,2.284l-1.235,0.204l-0.486,0.953l0,0l-1.042,4.205L89.211,460.708z"
				},
				{
					"id":"SN-MT",
					"title":"Matam",
					"d":"M400.844,405.389L399.156,405.896L397.699,407.457L397.876,408.986L399.167,410.249L400.576,410.073L401.486,408.405L403.008,407.376L404.527,409.946L411.396,413.041L411.151,417.115L412.439,418.686L412.777,422.328L414.658,424.888L417.507,426.132L415.938,429.571L418.812,431.735L419.04,436.98L422.165,439.803L421.864,440.553L420.763,439.918L420.014,440.103L419.589,442.285L427.88,449.541L426.771,451.688L424.141,451.327L423.496,451.985L423.554,453.625L425.881,458.012L427.252,458.301L428.584,456.855L429.998,456.678L439.781,461.154L439.087,462.047L439.893,464.208L438.062,468.854L438.542,469.911L443.704,471.702L446.426,471.418L448.382,469.944L451.933,469.386L452.228,474.886L455.778,475.336L453.631,477.804L453.495,482.918L453.987,484.023L455.941,485.738L459.308,486.052L462.841,487.946L464.676,490.975L464.654,492.607L463.27,494.441L460.635,492.985L459.096,492.941L458.412,493.705L458.684,495.113L461.911,497.314L463.295,499.961L464.351,499.936L465.951,498.546L467.381,498.392L468.513,498.963L469.488,500.723L468.748,503.432L469.144,504.934L472.557,506.379L475.446,509.153L478.131,510.235L478.587,511.456L479.215,511.555L479.215,511.555L482.861,516.586L483.295,516.533L485.442,520.222L485.779,521.922L486.494,522.358L485.977,523.123L486.269,523.826L488.227,525.977L487.382,527.392L488.923,530.999L482.709,550.269L476.06,559.472L468.616,562.826L453.28,565.073L444.82,562.84L424.346,559.691L413.792,567.371L398.766,579.521L397.794,580.022L387.549,580.384L371.086,580.003L361.381,564.549L353.706,563.157L342.114,564.337L338.098,569.131L330.483,566.565L327.862,566.215L328.107,565.771L322.258,562.363L313.557,560.729L311.188,558.429L301.591,562.431L300.253,563.149L299.267,564.644L295.585,564.853L293.277,563.431L290.696,563.439L290.696,563.439L290.662,563.005L288.297,562.147L286.126,562.739L285.524,561.387L281.102,561.322L279.395,561.592L278.441,562.576L276.059,562.574L270.394,558.984L268.744,558.479L265.855,555.262L265.855,555.262L268.519,552.079L270.385,544.789L273.79,542.432L274.21,535.399L273.022,522.631L270.353,515.411L269.572,509.021L270.249,508.313L276.897,506.809L277.364,506.084L289.315,505.737L294.213,499.329L296.238,498.464L298.122,491.857L298.013,488.118L301.811,482.633L297.714,482.551L289.899,484.211L277.333,477.586L274.163,476.702L273.147,475.777L272.874,474.578L272.818,473.771L274.448,473.789L277.897,469.547L276.988,467.104L277.042,463.91L275.476,463.43L279.635,451.794L281.832,450.013L284.398,449.009L283.842,444.421L297.07,435.511L297.07,435.511L300.756,440.52L300.035,443.308L300.878,447.568L300.494,449.425L303.502,450.938L304.888,452.908L305.1,454.234L309.531,454.264L310.359,455.152L308.573,461.607L306.003,461.611L306.431,469.313L306.005,474.904L310.336,480.177L309.675,481.8L310.063,482.482L314.551,481.418L324.568,481.359L330.13,478.262L331.751,474.252L331.439,473.01L329.857,473.004L329.936,471.616L328.528,470.248L328.705,468.593L332.457,467.901L331.814,464.101L347.288,464.661L349.97,453.044L353.969,429.015L356.293,428.11L360.825,423.365L361.882,422.942L364.414,419.608L365.098,417.72L375.254,413.758L377.58,404.62L377.58,404.62L379.091,407.103L381.465,408.842L383.142,407.379L386.157,407.535L392.49,404.735L396.88,405.775L400.272,403.449L401.532,404.765z"
				},
				{
					"id":"SN-SE",
					"title":"Sédhiou",
					"d":"M202.913,682.848L206.669,684.597L213.551,686.649L217.945,686.195L217.945,686.195L217.68,692.698L216.11,695.461L216.476,700.098L219.039,702.385L219.016,703.231L222.062,703.143L224.127,703.831L224.374,706.965L226.017,707.119L226.59,709L226.766,714.311L228.814,717.422L235.262,720.958L235.618,722.895L234.619,725.605L235.727,728.158L239.986,732.725L239.653,741.12L238.623,742.333L238.47,743.524L237.494,744.168L237.563,745.489L235.708,748.71L237.325,752.94L239.109,754.091L239.109,754.091L237.967,754.583L233.878,754.191L227.781,756.707L224.436,758.807L217.926,761.327L214.777,764.863L208.251,769.368L183.81,780.286L163.384,777.678L163.384,777.678L162.83,776.047L161.629,775.602L160.049,776.333L159.656,775.447L159.509,774.651L160.332,774.155L160.137,771.677L159.416,770.546L157.221,769.293L157.059,767.041L155.865,765.311L156.567,763.143L155.653,760.097L152.865,757.192L150.64,757.115L150.167,754.41L151.211,750.873L150.412,749.839L150.048,747.849L152.658,746.083L153.321,743.501L152.155,741.59L152.061,740.109L154.335,738.238L154.959,736.698L154.378,734.842L154.983,733.327L153.827,733.028L154.257,732.326L153.822,731.202L152.721,730.837L153.593,729.88L154.066,727.645L155.546,726.762L156.126,724.646L157.653,724.02L158.777,722.395L160.045,718.093L162.212,715.184L162.143,713.102L159.485,712.742L158.77,711.116L160.118,709.12L162.657,707.65L162.913,705.571L162.913,705.571L162.826,704.186L171.802,704.2L171.846,687.381L179.252,687.011L183.857,685.106L193.267,687.191L196.038,686.221L199.652,682.921z"
				},
				{
					"id":"SN-SL",
					"title":"Saint-Louis",
					"d":"M256.93,353.988L259.661,352.231L259.885,353.611L261.127,354.058L262.277,351.39L263.103,351.025L264.78,353.496L266.614,353.079L267.957,353.664L268.756,351.96L269.455,351.672L271.769,354.186L274.193,351.501L275.354,352.457L275.439,354.404L277.11,355.264L276.891,353.984L277.936,353.772L278.075,352.386L279.245,353.239L285.957,352.102L286.529,352.588L286.469,353.486L285.374,354.208L286.657,355.446L287.623,354.333L288.799,354.22L290.184,355.397L290.99,354.76L291.992,355.132L293.227,354.73L294.809,355.419L295.984,352.707L297.459,354.189L300.602,355.745L302.725,354.498L305.524,354.779L308.181,351.812L309.628,353.848L316.888,353.044L317.426,354.077L316.688,359.466L317.146,360.671L320.256,360.172L321.151,358.878L322.141,358.73L323.068,359.59L322.481,361.986L323.951,365.166L325.326,362.712L327.952,362.903L329.972,364.178L329.529,365.331L329.899,366.41L333.216,368.101L334.733,370.254L336.574,369.764L335.803,371.123L336.051,372.127L337.946,372.712L339.187,374.816L342.34,376.707L345.663,380.495L346.635,382.513L349.707,382.997L352.839,384.665L353.858,386.997L352.055,386.725L350.604,387.414L350.968,390.369L353.625,390.371L354.456,390.978L352.818,392.798L352.265,395.645L355.388,394.502L356.542,395.284L357.541,394.993L357.911,397.884L358.575,398.647L359.407,399.024L361.082,398.19L361.905,398.5L362.776,399.864L361.852,401.213L361.746,402.826L362.874,405.179L363.935,405.481L364.579,407.534L365.146,407.578L366.829,405.536L369.622,403.947L372.088,404.06L374.646,403.159L377.177,400.203L378.09,399.912L378.889,400.271L379.117,401.223L377.479,403.437L377.58,404.62L377.58,404.62L375.254,413.758L365.098,417.72L364.414,419.608L361.882,422.942L360.825,423.365L356.293,428.11L353.969,429.015L349.97,453.044L347.288,464.661L331.814,464.101L332.457,467.901L328.705,468.593L328.528,470.248L329.936,471.616L329.857,473.004L331.439,473.01L331.751,474.252L330.13,478.262L324.568,481.359L314.551,481.418L310.063,482.482L309.675,481.8L310.336,480.177L306.005,474.904L306.431,469.313L306.003,461.611L308.573,461.607L310.359,455.152L309.531,454.264L305.1,454.234L304.888,452.908L303.502,450.938L300.494,449.425L300.878,447.568L300.035,443.308L300.756,440.52L297.07,435.511L297.07,435.511L291.04,425.25L289.529,426.508L285.563,425.915L285.93,422.874L285.062,421.074L282.222,424.18L276.411,427.246L274.579,429.195L269.449,431.588L266.817,427.158L264.5,425.784L257.495,418.491L253.915,420.886L241.166,421.966L238.22,424.083L237.063,423.967L231.833,422.338L229.691,417.804L227.152,415.765L223.048,413.571L219.619,415.172L216.479,415.425L214.064,412.883L212.837,414.963L212.725,416.846L213.417,418.656L211.035,418.697L208.402,420.094L210.058,424.593L209.77,427.729L206.608,426.742L201.413,428.83L197.168,428.514L198.526,425.313L197.056,423.146L189.568,419.289L178.492,409.134L169.76,399.473L165.146,402.364L160.405,406.602L159.593,408.083L142.159,416.307L138.521,417.454L135.812,422.098L127.394,428.147L125.582,431.53L125.339,431.2L123.752,432.955L121.065,433.966L120.19,435.578L119.421,435.683L118.862,434.766L115.488,435.617L106.848,435.194L104.016,436.225L100.857,438.509L99.623,438.713L99.136,439.666L99.136,439.666L100.644,433.762L101.979,412.183L104.596,412.132L106.709,408.974L108.065,408.232L108.128,407.563L106.775,405.943L107.26,404.778L107.01,399.727L108.177,397.697L109.227,396.572L110.977,395.881L112.691,396.606L113.762,396.269L116.967,391.137L117.045,390.051L115.683,388.065L115.859,386.418L116.821,384.749L118.357,384.046L119.165,382.931L119.242,377.979L119.98,377.051L121.41,376.585L121.829,371.49L123.836,369.813L124.027,366.615L125.947,364.964L128.24,364.322L131.205,365.488L133.498,365.337L137.342,362.222L141.131,361.639L142.429,362.692L142.474,365.059L144.808,366.591L146.932,369.54L148.659,369.349L152.082,367.058L153.674,367.473L155.572,368.932L156.176,366.585L158.079,363.189L161.377,361.04L160.941,364.194L159.772,366.433L162.929,365.599L165.29,365.922L166.149,366.678L166.265,368.207L168.728,366.826L170.972,366.485L173.841,367.798L178.915,368.5L181.923,370.244L183.024,369.368L186.869,369.003L188.527,368.311L189.034,367.414L188.609,365.508L189.472,364.426L191.927,364.376L195.602,366.104L199.865,365.132L200.738,364.387L199.65,362.694L200.077,360.935L204.67,357.905L206.452,358.192L207.731,359.25L209.18,362.918L211.595,363.576L215.406,361.209L217.533,361.186L220.502,359.814L225.684,360.479L227.864,362.054L233.121,359.543L234.053,358.375L238.328,359.48L239.635,359.281L242.767,356.376L241.678,353.967L239.265,353.311L239.347,351.612L241.389,349.248L243.351,349.74L245.945,354.327L250.803,352.738L251.417,348.66L252.062,347.851L253.081,347.896L255.683,349.295L255.496,351.925L0,NaNz"
				},
				{
					"id":"SN-TC",
					"title":"Tambacounda",
					"d":"M267.232,645.003l3.291,-4.172l8.11,-0.81l2.786,-6.691l8.741,-5.516l1.727,-4.697l-2.508,-0.209l2.798,-2.008l-0.909,-6.845l1.057,-1.465l-1.047,-0.721l0.737,-4.613l-1.073,-11.496l-4.429,-4.635l0.699,-13.054l0.453,-0.701l0.326,-12.498l2.125,-0.162l0.581,-1.271l0,0l2.582,-0.009l2.308,1.422l3.682,-0.209l0.986,-1.494l1.337,-0.719l9.597,-4.002l2.369,2.301l8.701,1.634l5.85,3.408l-0.245,0.443l2.621,0.351l7.614,2.565l4.017,-4.794l11.592,-1.18l7.675,1.392l9.705,15.454l16.463,0.381l10.245,-0.361l0.972,-0.502l15.026,-12.149l10.554,-7.68l20.475,3.148l8.46,2.233l15.336,-2.247l7.443,-3.354l6.649,-9.203l6.214,-19.27l-1.541,-3.607l0.845,-1.415l-1.958,-2.15l-0.292,-0.703l0.518,-0.765l-0.715,-0.437l-0.337,-1.7l-2.147,-3.688l-0.434,0.053l-3.646,-5.031l0,0l0.617,-1.929l2.143,-0.243l5.153,2.474l5.599,5.303l5.785,1.716l3.037,3.216l1.237,6.895l-0.409,2.154l5.617,4.914l4.183,1.662l2.761,0.319l4.482,5.27l3.881,0.869l0.707,2.662l2.18,0.687l0.32,1.237l-0.571,1.361l0.604,0.681l4.82,1.193l-1.766,2.243l3.063,1.215l-0.235,2.952l-0.528,0.609l-1.686,0.286l-0.077,2.866l-1.384,1.927l-0.087,1.252l-2.133,-0.122l-0.846,0.813l0.366,2.282l-0.758,3.437l2.118,1.313l-0.694,2.197l1.649,1.617l-1.222,1.829l0.048,1.763l1.919,0.982l1.167,-0.397l1.487,1.631l2.422,-0.18l0.462,-0.776l-0.388,1.317l0.519,1.039l0.714,0.372l1.374,-0.895l0.868,0.842l0.017,1.274l-0.943,0.634l1.363,1.25l-0.459,0.519l-1.09,-0.473l-0.247,0.384l1.725,0.739l-1.172,1.46l2.107,0.438l0.69,0.83l1.341,-0.2l1.81,1.055l1.057,-0.099l-0.051,0.464l0.642,-0.18l0.603,0.645l2.353,6.663l0.959,0.854l0.016,1.363l1.407,0.939l-0.251,3.748l-1.095,2.354l0.558,3.615l-1.398,0.363l0.26,2.104l-1.391,1.405l0.104,1.752l-0.753,0.512l1.019,2.081l-0.286,1.187l6.555,-0.289l0.829,7.39l-1.449,6.932l-0.365,4.804l-2.469,1.532l-0.682,1.463l-2.793,2.92l-5.023,2.439l-0.604,0.792l-0.773,-0.253l3.329,5.828l0.201,3.963l3.669,3.169l0.27,2.444l1.436,0.698l1.378,2.59l1.693,1.299l2.377,0.796l0.785,1.351l2.402,1.303l0.58,1.211l2.091,1.401l0.418,2.32l-1.316,1.69l-0.821,3.846l0,0l-5.058,2.017l-1.648,-0.161l-3.041,3.564l-1.837,0.482l-1.166,1.471l-1.36,-0.234l-0.454,-1.482l0.688,-1.437l-0.397,-0.953l0.371,-1.952l-2.604,1.369l-1.823,-1.222l-3.256,-0.575l-1.789,-1.666l-1.091,-0.286l-1.046,-1.97l-9.497,-4.705l-0.808,0.526l-0.112,3.108l-1.153,1.213l0.199,1.827l3.718,5.306l-0.838,1.977l-2.433,1.101l-5.149,-0.619l-0.363,2.5l-1.197,1.472l0.007,1.387l-1.086,0.592l-1.483,-1.762l-2.658,-1.694l-2.612,1.048l-1.231,-0.222l-0.707,1.303l-1.543,0.409l-2.219,1.802l0.115,1.013l-1.357,0.687l-1.417,3.64l-2.287,0.182l-0.636,1.021l-0.71,-0.428l-0.781,0.468l-0.511,-0.425l-1.769,0.328l-1.328,-1.66l-1.222,0.346l-0.309,-0.873l-0.846,-0.261l-0.194,1.272l-0.956,0.619l-2.52,-0.489l-1.005,1.489l-3.433,0.712l0.376,2.013l-0.446,0.746l0.865,1.1l-0.717,-0.123l0.122,0.976l-1.407,0.926l0.142,1.21l-1.119,0.33l-0.442,1.048l-1.735,0.179l0.298,1.318l-0.777,0.517l-2.006,-0.675l-0.586,0.767l-0.812,-0.408l-0.336,1.11l0.399,1.065l-1.638,0.066l0.047,1.693l-2.26,-0.177l-0.057,0.755l-1.394,0.159l0.71,1.378l-1.335,-0.148l-0.097,0.718l0.867,0.799l-0.268,0.586l-1.529,-0.27l-0.835,-1.747l-1.14,0.855l-1.588,-0.761l0.298,-0.746l-0.797,-0.56l-0.709,0.347l-0.23,-1.285l-2.121,-1.574l-1.093,1.062l-0.272,-1.48l-2.022,-0.893l0.552,-1.427l-1.313,0.662l-0.947,-0.807l-1.373,1.208l-0.574,-0.687l-1.168,0.199l-0.675,-0.662l-1.247,1.107l-1.894,0.137l-0.25,1.268l-1.957,-0.132l-0.797,-0.801l-2.402,3.352l-0.767,0.327l-4.787,-2.763l-0.898,0.583l-0.75,-0.527l-1.636,0.475l0.543,-0.427l-0.832,-1.035l-1.139,1.206l-0.552,-0.078l0.05,-0.569l-0.913,0.909l-1.34,-0.037l0.302,1.872l-2.441,1.685l-0.688,-0.18l-0.169,0.578l2.537,0.743l2.212,4.175l0.955,-0.679l1.421,1.334l0.83,2.218l1.092,0.693l0.257,1.639l-1.115,1.235l-2.694,0.004l1.319,0.985l-0.253,1.912l2.529,1.291l-0.807,1.259l0.202,0.884l2.601,0.881l1.912,-0.016l0.639,0.99l-1.253,0.847l1.238,1.364l-1.515,1.659l0.034,1.377l1.159,4.458l1.521,1.867l-3.562,0.895l-2.857,1.816l-0.008,1.155l0.646,0.864l2.407,1.682l0,0l-1.261,-0.496l-0.16,0.914l-1.717,-0.814l-0.295,0.681l-1.166,-0.267l-0.704,0.968l-2.425,-1.387l-0.388,-1.095l-1.079,0.249l-1,1.042l-0.873,-0.94l-0.879,0.424l-3.59,-1.037l-0.927,0.488l0.172,0.564l-4.279,0.155l0.267,-1.018l-0.474,-0.378l-0.599,0.669l-0.439,-0.527l0.052,-2.678l-0.224,-0.673l-0.652,-0.103l0,0l-1.877,-0.492l-1.659,1.076l-0.257,0.771l-1.723,-0.32l-1.401,0.758l-0.777,-0.55l0.152,-0.946l-1.067,-0.294l0.515,-0.697l-0.947,0.22l0.445,-0.761l-1.157,-0.55l-1.722,1.288l0.771,-1.149l-0.305,-1.127l-0.737,-0.475l0.958,0.233l0.453,-0.637l-1.128,-1.763l0.41,-0.625l0.697,0.129l-0.44,-1.271l0.415,-0.741l-0.372,-1.44l-0.964,0.358l1.014,-1.796l-0.239,-0.566l-1.31,-0.104l-0.359,-1.96l1.356,-0.92l-0.198,-1.047l-1.04,-0.443l0.713,-0.354l1.543,0.756l0.565,-0.449l-0.286,-0.819l-2.027,-1.617l1.125,-0.406l-0.507,-0.473l0.49,-1.362l-1.544,-0.052l-1.322,-1.205l-0.981,-0.173l-0.631,-2.199l0.803,0.11l0.68,-1.097l-0.542,-0.75l-0.144,0.521l-1.063,-0.055l-0.575,-0.934l0.775,-0.996l1.304,-0.287l-0.004,-0.671l-1.048,0.181l0.083,-0.771l-0.861,-0.965l0.958,-0.557l0.319,-1.025l-1.119,-0.976l-1.225,1.062l-0.563,-0.317l0.264,-1.259l0.575,-0.117l-0.479,-0.347l1.118,-0.379l-0.095,-1.109l-1.142,0.46l-0.067,-0.597l-0.402,0.472l-1.004,-0.717l0.507,-0.706l-0.705,-0.811l-0.883,0.397l-0.088,-0.575l0.983,-0.864l-0.946,-0.891l-0.678,0.195l0.156,1.008l-1.209,-0.071l-0.324,-1.336l0.675,-0.733l-0.377,-0.635l0.63,-0.116l-0.747,-0.143l-0.75,0.958l-0.108,-2.408l-0.544,0.387l-1.015,-0.986l0.169,-1.235l0.497,-0.187l-2.32,-0.471l0.086,-0.667l0.865,-0.271l-0.728,-0.382l0.227,-0.776l0.616,0.482l0.391,-0.424l-1,-1.004l0.604,-0.33l-1.126,-0.606l1.333,-2.378l-1.083,-0.462l1.117,-0.528l0.244,0.617l0.404,-1.253l-0.458,-0.813l-0.901,-0.106l0.153,-0.837l0.471,0.202l-0.346,-1.057l-0.883,-0.938l-1.118,0.614l-1.573,-0.431l0.573,-2.58l-1.02,-0.876l-2.75,0.422l-1.126,-1.288l2.462,-5.124l-3.574,0.762l-0.425,-0.836l2.934,-3.037l0.071,-0.979l-2.012,-0.18l-5.021,1.125l-2.841,-0.423l2.241,-2.532l0.081,-1.533l-0.71,-0.763l-0.02,-0.965l3.405,-2.134l0.564,-1.21l-2.322,-1.271l-3.145,-0.78l-2.284,1.952l-0.882,-0.144l-0.424,-1.36l1.007,-2.32l0.093,-1.845l1.034,-1.469l-0.257,-0.725l-3.321,-0.205l-1.094,2.384l0.058,1.911l-2.698,-0.66l0,0l-3.024,-4.089l-6.687,-2.686l-1.486,-0.116l-2.167,0.644l-3.184,1.958l-6.124,-0.123l-4.611,1.812l-2.269,0.225l-4.112,2.356l-3.677,3.721l-3.528,0.282l-4.736,1.678l-4.702,-1.421l-2.533,-1.981l-3.236,-1.295l-1.606,-2.206l-2.469,-1.716l-0.748,-4.445l-1.974,-3.197l-5.079,-3.271l-7.756,-0.695l-3.202,1.223l-4.048,2.845l-0.925,0.083l-7.045,-3.779l-0.409,-1.542l-0.776,-0.086l-0.115,-0.608l0.677,-0.59l-0.13,-1.469l-0.61,-2.283l-1.02,-0.702l0.22,-1.162L267.232,645.003z"
				},
				{
					"id":"SN-TH",
					"title":"Thiès",
					"d":"M80.81,473.52L83.632,475.235L84.339,477.313L81.372,481.604L78.96,489.514L81.875,490.875L83.122,492.605L89.617,497.414L89.987,499.333L91.113,499.757L91.788,501.114L91.694,504.387L91.014,505.5L93.011,504.12L95.999,500.555L99.836,493.119L101.532,492.39L101.359,491.121L102.76,488.937L107.745,483.771L111.935,487.39L117.801,487.771L119.289,490.221L118.185,492.395L119.426,494.063L121.297,494.988L122.065,492.918L123.191,492.522L124.194,492.935L125.432,494.5L125.939,499.886L128.863,504.649L128.976,507.602L132.885,510.776L133.124,515.648L134.706,519.676L134.836,524.033L134.836,524.033L130.784,525.133L129.502,524.576L128.399,524.947L128.36,522.979L127.614,522.467L120.476,520.084L119.874,518.717L118.747,519.287L116.816,518.687L116.792,517.522L116.087,518.54L108.644,517.796L105.793,518.616L103.321,520.237L100.192,520.4L100.294,521.092L99.768,521.305L89.121,524.145L85.178,527.017L84.656,527.645L90.416,534.356L90.751,536.389L88.866,538.06L88.317,539.346L93.471,543.692L92.592,546.192L93.133,547.177L92.571,549.027L91.394,549.544L88.844,553.073L88.736,554.702L89.414,554.869L89.158,555.841L91.199,556.973L93.445,560.044L95.69,560.686L100.585,560.232L101.156,561.749L101.156,561.749L101.156,561.749L101.156,561.749L99.399,569.112L97.904,571.771L93.586,575.419L91.364,576.326L89.62,578.201L84.104,578.263L83.445,579.038L82.196,585.934L82.349,590.989L79.807,594.708L80.866,595.386L78.708,596.771L78.779,598.888L80.861,600.535L80.857,601.912L76.957,605.306L77.925,607.316L74.841,607.445L74.184,608.417L74.401,609.412L76.639,610.86L76.544,611.469L77.933,612.985L78.023,615.116L76.873,615.176L75.942,616.414L75.942,616.414L74.928,612.074L73.173,608.132L71.29,607.746L71.353,607.025L70.785,607.099L67.718,603.379L66.775,602.913L65.621,597.539L62.196,593.103L60.589,592.675L60.37,586.867L58.606,583.032L56.663,580.489L52.95,577.426L47.868,575.491L47.271,574.058L46.472,573.763L44.79,571.513L43.033,566.29L40.437,564.123L39.205,561.784L39.205,561.784L41.075,560.658L40.401,558.736L41.108,554.082L39.975,553.093L40.468,550.589L40.143,549.522L42.553,548.23L42.727,547.022L42.529,545.723L41.326,545.081L40.562,540.715L38.659,536.34L38.263,531.512L37.765,531.05L37.765,531.05L40.959,529.358L43.015,525.016L54.302,512.233L63.393,500.597z"
				},
				{
					"id":"SN-ZG",
					"title":"Ziguinchor",
					"d":"M90.072,705.396L91.49,705.754L93.572,705.284L96.572,705.851L133.301,706.043L162.913,705.571L162.913,705.571L162.657,707.65L160.118,709.12L158.77,711.116L159.485,712.742L162.143,713.102L162.212,715.184L160.045,718.093L158.777,722.395L157.653,724.02L156.126,724.646L155.546,726.762L154.066,727.645L153.593,729.88L152.721,730.837L153.822,731.202L154.257,732.326L153.827,733.028L154.983,733.327L154.378,734.842L154.959,736.698L154.335,738.238L152.061,740.109L152.155,741.59L153.321,743.501L152.658,746.083L150.048,747.849L150.412,749.839L151.211,750.873L150.167,754.41L150.64,757.115L152.865,757.192L155.653,760.097L156.567,763.143L155.865,765.311L157.059,767.041L157.221,769.293L159.416,770.546L160.137,771.677L160.332,774.155L159.509,774.651L159.656,775.447L160.049,776.333L161.629,775.602L162.83,776.047L163.384,777.678L163.384,777.678L156.912,778.467L148.58,775.568L145.61,775.669L136.455,777.958L132.446,776.665L125.795,779.577L115.577,785.14L114.896,786.572L110.958,786.221L101.979,787.766L98.678,786.766L92.681,788.161L89.26,787.116L84.365,786.897L81.438,788.829L80.305,787.373L79.685,784.926L76.141,782.343L74.403,776.996L74.215,774.228L75.821,770.237L76.826,762.705L74.512,753.073L75.694,748.56L75.13,747.772L74.299,747.826L74.244,745.788L75.531,742.147L78.683,727.816L79.671,719.554L79.529,717.944L78.476,715.943L78.95,715.029L80.177,714.588L79.883,713.124L80.591,712.739L79.592,711.323L80.302,710.821L80.965,711.432L80.689,710.183L81.937,710.134L82.311,708.92L83.094,708.979L82.285,707.354L82.646,706.715L83.291,706.973L83.025,706.115L84.013,706.323L84.341,705.525L86.026,705.539L87.247,704.896z"
				}
			]
		}
	}
};