﻿// (c) ammap.com | SVG (in JSON format) map of DR Congo - Low
// areas: {id:"CD-BC"},{id:"CD-BN"},{id:"CD-EQ"},{id:"CD-HK"},{id:"CD-HL"},{id:"CD-KE"},{id:"CD-KN"},{id:"CD-KW"},{id:"CD-LB"},{id:"CD-MA"},{id:"CD-NK"},{id:"CD-OR"},{id:"CD-SK"},{id:"CD-TG"}
AmCharts.maps.congoDRLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"12.205166",
				"topLatitude":"5.384675",
				"rightLongitude":"31.307673",
				"bottomLatitude":"-13.457585"
			}
		},
		"g":{
			"path":[
				{
					"id":"CD-BC",
					"title":"Bas-Congo",
					"d":"M8.799,550.617l-0.397,0.518l-1.709,0.613l-0.107,-0.587l0.472,-0.443L8.799,550.617zM70.435,497.397l-0.504,0.575l1.648,2.276l1.393,0.78l-1.58,1.796l-0.036,0.859l-1.605,0.15l-1.038,1.252l1.034,1.018l0.124,1.336l0.918,-0.033l0.48,0.586l-0.622,2.199l0.222,1.888l-0.497,0.744l0.483,2.908l2.36,-1.575l2.171,0.549l1.101,1.215l1.738,0.632l1.417,-0.189l1.567,-1.323l2.794,-1.262l1.366,-1.675l1.38,-3.246l4.012,-4.325l2.232,-1.7l1.369,-2.218l0,0l3.229,4.855l2.307,2.244l1.138,0.506l1.15,-0.372l0.496,-1.092l-0.17,-1.525l1.275,-1.135l1.573,-0.222l3.079,0.877l3.028,-0.133l0.134,0.719l-1.051,1.872l2.963,1.508l0.195,1.107l-1.095,4.543l-1.032,0.745l-1.958,0.274l-0.375,0.745l0.705,1.137l2.723,1.979l2.784,0.789l1.647,-0.195l0.73,-1.028l0.301,-2.725l3.534,2.92l8.804,0.088l0,0l-0.83,2.29l0.33,4.562l-1.301,6.108l0.535,6.387l-0.25,2.202l-1.406,3.403l-2.338,1.591l-0.65,1.296l0,0l-36.196,-0.007l-8.456,0.245l-3.33,0.935l-2.755,-0.635l-1.618,0.345l-5.236,-0.604l-2.038,0.222l-1.741,-0.884l-3.149,0.145l-1.308,0.578l-1.661,-1.362l-5.03,1.07l-13.889,-0.147l-1.174,0.968l-3.566,-1.138l-4.008,1.144l-1.379,-0.901l-1.038,-0.071l-7.074,3.253l-2.325,0.168l-1.736,1.034l-2.521,0.252l-5.376,2.005l-0.561,-1.399l1.024,-0.231l0.916,-1.075l-0.071,-0.577l-2.99,0.293l0.106,1.235l-2.047,-3.271l-1.478,-0.996l-2.18,-2.576l-0.62,-1.353l1.892,-0.831l8.632,-0.302l0.075,-19.075l-1.393,-0.515l-0.742,-1.03l0.272,-0.624l1.595,-0.043l3.2,-1.467l0.339,-2.271l2.501,-0.045l0.395,-1.487l2.251,-1.815l-0.198,-0.625l1.456,-2.277l7.033,-2.446l1.236,0.342l0.387,-0.662l-0.233,-2.161l0.772,-0.455l3.411,2.976l1.015,1.506l-0.316,0.36l0.956,1.058l2.823,0.867l0.469,1.557l-0.263,0.624l1.777,1.686l-0.307,-1.623l2.021,0.045l0.724,-1.295l2.681,-0.508l1.307,-2.371l1.76,0.921l0.269,-0.861l-0.437,-0.946l1.417,-0.085l0.034,-0.874l-0.515,-0.197l-0.15,-0.778l1.305,-2.979l-0.707,-2.238l0.326,-1.25l2.59,-0.831l1.076,0.819l0.983,1.693l2.441,0.542l2.119,-2.982l4.081,-0.993l0.809,0.188l3.582,-2.379l2.18,-0.347l0.269,-0.787l1.299,-0.328L70.435,497.397z"
				},
				{
					"id":"CD-BN",
					"title":"Bandundu",
					"d":"M138.244,418.68L140.188,420.88L141.565,423.364L150.456,423.364L150.35,419.871L149.808,419.11L147.626,418.066L147.822,416.643L154.344,417.694L156.107,417.297L159.089,414.856L170.764,408.029L175.418,406.641L178.142,404.935L183.454,403.448L187.975,399.727L189.23,398.196L190.416,395.606L197.224,396.517L199.332,398.719L202.01,399.965L204.271,399.947L207.671,398.913L211.621,398.833L213.883,395.668L211.211,392.202L211.141,389.302L211.916,388.188L215.616,386.27L216.933,383.344L217.708,383.132L218.669,384.174L219.685,386.553L220.386,391.371L224.535,397.524L227.694,400.115L229.473,405.35L232.9,410.479L234.188,416.606L236.985,416.925L239.593,413.485L241.31,412.309L243.828,413.963L246.161,420.242L247.058,421.295L249.845,421.728L255.691,421.666L257.399,422.56L258.777,424.603L260.408,424.674L263.131,426.178L267.26,424.408L270.436,424.691L271.512,423.364L281.658,435.511L282.11,438.916L282.11,438.916L280.431,442.447L280.315,445.412L276.317,450.386L270.766,464.992L270.311,472.236L270.989,477.95L271.375,491.328L270.063,492.357L269.429,493.52L266.065,495.193L264.223,495.105L263.922,496.134L262.936,495.938L261.74,496.506L261.173,499.059L260.559,499.777L259.437,499.315L258.165,499.706L256.935,497.773L255.441,497.703L254.256,496.24L253.09,495.877L253.09,495.877L250.992,495.982L250.992,495.982L251.008,498.342L252.568,500.734L252.7,502.127L253.555,503.067L251.738,506.1L251.488,511.635L252.37,512.947L253.225,516.939L254.497,518.75L254.285,520.231L255.006,521.066L255.887,524.093L255.663,526.445L256.038,527.75L255.378,528.194L254.436,530.307L254.372,535.715L255.531,539.357L255.512,540.884L255.051,541.258L256.218,548.854L258.816,551.016L260.98,551.881L262.712,554.043L265.743,556.206L268.774,562.264L271.372,564.428L273.969,564.428L277.433,571.354L277.433,575.685L275.702,580.884L272.671,581.75L269.644,581.077L269.644,581.077L269.838,580.235L259.901,580.223L259.412,582.948L235.129,582.993L235.738,584.854L234.791,585.838L233.585,588.714L233.889,589.718L233.315,593.067L233.548,594.815L235.16,597.674L233.275,599.136L233.53,600.113L232.883,601.198L229.916,601.26L229.518,601.715L230.821,605.503L230.096,608.13L229.294,609.069L229.134,612.309L229.657,614.961L211.307,615.113L210.6,613.947L210.645,612.594L202.725,612.555L202.565,615.113L198.2,615.113L198.436,615.538L197.706,615.992L195.418,615.558L195.527,614.915L195.087,614.733L192.622,614.774L190.58,615.388L190.001,616.231L188.817,616.405L188.474,617.299L188.886,618.297L185.67,618.25L185.093,618.736L183.745,617.762L181.984,617.652L179.162,618.678L176.736,618.228L173.218,619.243L171.585,619.21L169.828,617.776L170.203,616.609L170.696,616.525L169.132,615.113L169.263,613.538L167.805,612.779L168.21,611.368L167.241,610.923L167.458,610.051L166.543,610.026L166.023,609.357L166.077,608.442L163.932,607.355L164.242,606.019L162.953,605.14L163.282,603.184L160.699,601.561L159.976,600.111L160.037,599.034L158.639,598.252L158.754,597.582L159.659,597.275L159.568,596.877L158.281,596.021L157.894,596.642L157.163,596.571L157.146,594.117L156.083,594.007L154.612,592.565L153.81,592.636L153.268,590.413L152.15,589.533L152.684,588.47L151.334,585.389L151.679,584.959L152.116,585.51L152.609,585.397L153.081,583.759L152.765,582.566L151.671,581.924L151.641,578.844L149.669,578.102L149.523,576.77L148.404,575.681L148.213,573.89L147.026,572.838L146.476,569.999L145.665,569.524L146.039,567.899L144.895,567.016L145.126,566.154L144.378,565.267L145.06,564.601L144.446,564.029L143.813,564.112L143.622,562.537L144.733,562.378L144.354,558.522L145.011,557.188L144.712,556.29L143.693,555.449L142.277,555.058L142.354,554.174L141.034,553.723L140.472,549.913L140.81,548.374L137.989,547.09L135.8,547.657L134.554,547.407L133.909,546.742L124.57,546.935L124.57,546.935L125.22,545.639L127.558,544.048L128.964,540.645L129.214,538.442L128.679,532.056L129.98,525.947L129.65,521.386L130.48,519.096L130.48,519.096L129.865,512.45L131.867,509.869L135.353,503.661L137.375,503.263L138.451,500.212L138.957,499.839L138.736,499.404L139.197,498.359L138.691,497.313L139.002,496.373L137.836,494.564L136.458,493.82L134.231,490.248L128.218,486.951L125.325,486.278L120.314,486.624L118.465,485.483L118.465,485.483L123.459,474.609L125.213,472.295L125.838,470.398L127.59,467.806L128.721,464.644L127.493,463.184L127.769,461.54L127.308,458.455L127.854,455.709L127.37,451.218L129.201,443.245L127.5,435.541L127.73,430.514L129.35,427.25L133.104,424.567z"
				},
				{
					"id":"CD-EQ",
					"title":"Équateur",
					"d":"M236.998,196.167L240.02,196.12L244.146,197.383L244.884,197.997L245.703,199.823L247.026,201.021L250.513,201.459L252.7,203.359L254.771,204.333L256.035,205.885L260.737,208.316L264.27,212.269L264.546,216.243L266.042,217.096L266.818,218.172L269.168,219.417L273.075,218.856L275.199,219.082L277.473,218.065L284.196,219.771L285.592,221.565L288.552,223.133L289.373,222.865L289.81,221.784L290.823,221.508L292.496,222.912L295.49,223.974L296.797,223.712L299.877,224.399L302.625,222.429L303.465,222.859L305.315,222.596L306.509,223.672L307.56,223.676L309.311,224.633L312.523,225.152L314.034,224.67L314.822,225.219L316.873,225.536L319.066,227.374L322.354,228.643L328.082,228.32L328.651,227.949L328.651,227.949L331.797,229.057L335.836,232.354L338.124,232.566L338.349,235.322L341.151,236.739L342.494,237.085L345.563,236.013L346.998,236.739L348.556,235.889L350.573,235.605L357.355,238.37L358.653,237.546L360.995,238.175L362.356,237.847L361.456,240.638L357.702,244.544L356.92,244.801L355.487,243.756L353.207,243.712L352.506,242.932L351.339,242.56L347.059,246.723L345.636,247.139L343.57,246.705L341.462,247.989L335.205,249.911L333.799,251.78L333.889,253.073L334.85,254.073L337.947,254.817L339.335,255.906L338.8,262.139L339.22,263.715L339.921,264.299L340.712,264.369L341.507,263.794L345.893,259.022L347.479,258.678L348.481,259.483L348.271,261.705L346.793,264.91L346.668,266.485L345.367,268.707L345.982,271.911L344.576,274.619L345.021,275.84L347.078,278.256L348.331,279.415L349.917,280.025L355.728,278.981L357.372,279.344L359.394,281.636L363.219,283.494L365.961,285.493L366.727,289.899L365.24,290.12L362.536,288.988L356.875,288.023L352.284,291.341L348.751,293.039L347.629,292.58L345.082,290.165L344.995,290.951L343.766,291.296L343.855,292.261L343.24,292.933L342.228,292.933L342.254,293.738L341.507,294.048L341.397,294.57L338.079,295.701L336.236,294.941L334.965,292.783L332.527,292.19L332.107,292.915L332.678,294.481L330.374,298.691L328.968,305.775L327.231,307.694L323.787,310.118L322.996,311.842L327.722,312.275L331.21,314.176L332.963,316.14L333.818,316.351L335.4,320.304L337.153,322.505L338.694,326.36L339.921,327.978L339.814,329.834L340.251,330.639L339.949,331.161L341.312,334.167L341.132,337.526L343.785,341.522L344.115,344.466L344.977,346.535L346.533,348.93L348.511,350.813L350.263,354.694L353.752,358.547L358.938,366.317L359.003,367.644L356.545,368.43L355.273,369.783L350.368,368.492L344.887,372.588L352.835,373.213L353.646,375.149L354.482,375.449L359.769,373.664L361.135,373.895L363.854,378.154L366.021,379.922L365.125,380.842L361.415,381.929L357.266,385.377L362.731,390.743L369.235,394.165L370.616,397.215L372.635,397.958L376.258,401.273L381.284,403.758L386.884,403.652L387.631,404.023L389.935,408.666L391.36,416.475L391.36,416.475L379.026,414.839L377.424,415.996L372.278,415.971L370.945,417.19L370.678,420.72L368.223,421.162L368.088,423.948L361.876,423.665L354.81,425.045L352.941,426.071L349.363,421.621L346.908,421.057L343.83,422.144L342.955,420.614L341.702,419.659L340.1,418.845L338.274,418.694L335.596,417.19L334.414,417.518L333.863,417.014L332.723,419.349L330.149,422.037L324.117,421.444L319.747,420.269L319.151,421.507L320.317,424.107L321.288,429.646L323.146,435.528L323.021,437.536L321.875,438.218L320.183,437.606L319.686,436.448L319.926,433.325L319.462,432.608L318.296,432.148L315.377,435.156L312.279,436.581L310.584,438.969L310.584,438.969L308.269,440.2L303.748,437.952L302.492,436.775L301.041,436.448L299.573,435.033L296.831,434.024L296.325,438.341L295.905,438.651L293.913,438.58L289.651,439.678L282.11,438.916L282.11,438.916L281.658,435.511L271.512,423.364L270.436,424.691L267.26,424.408L263.131,426.178L260.408,424.674L258.777,424.603L257.399,422.56L255.691,421.666L249.845,421.728L247.058,421.295L246.161,420.242L243.828,413.963L241.31,412.309L239.593,413.485L236.985,416.925L234.188,416.606L232.9,410.479L229.473,405.35L227.694,400.115L224.535,397.524L220.386,391.371L219.685,386.553L218.669,384.174L217.708,383.132L216.933,383.344L215.616,386.27L211.916,388.188L211.141,389.302L211.211,392.202L213.883,395.668L211.621,398.833L207.671,398.913L204.271,399.947L202.01,399.965L199.332,398.719L197.224,396.517L190.416,395.606L189.23,398.196L187.975,399.727L183.454,403.448L178.142,404.935L175.418,406.641L170.764,408.029L159.089,414.856L156.107,417.297L154.344,417.694L147.822,416.643L147.626,418.066L149.808,419.11L150.35,419.871L150.456,423.364L141.565,423.364L140.188,420.88L138.244,418.68L138.244,418.68L140.466,415.234L147.091,402.042L148.693,399.902L152.889,396.331L157.202,393.877L158.895,393.155L161.242,393.013L164.564,391.21L169.413,386.388L175.535,378.632L176.369,376.893L177.4,371.812L176.549,367.097L176.498,363.765L178.347,359.688L177.918,359.112L178.468,356.264L179.941,352.827L183.212,349.637L184.39,347.316L184.231,344.097L181.707,340.772L182.316,335.022L181.927,333.013L180.702,330.436L180.869,327.467L181.302,326.197L183.805,322.629L184.911,317.098L186.429,313.438L187.848,311.267L188.491,306.282L187.534,301.727L188.635,297.235L187.763,295.169L188.517,293.177L188.701,288.442L189.067,287.538L191.607,285.041L193.416,279.882L196.525,276.956L199.542,271.251L199.942,269.833L199.752,267.92L200.66,265.508L202.231,263.729L202.74,261.936L204.938,260.526L206.23,257.516L206.006,255.874L206.49,253.64L205.935,251.868L206.17,249.877L204.481,240.222L204.948,235.615L206.568,232.997L206.458,229.854L203.261,222.2L205.11,220.879L206.09,221.232L208.646,220.928L210.466,219.601L211.657,217.586L212.32,214.474L214.695,211.356L215.531,211.034L218.02,208.247L220.16,203.726L221.101,202.639L224.194,202.215L225.438,200.148L229.206,198.037L230.63,196.499L233.969,196.368L235.487,195.712z"
				},
				{
					"id":"CD-HK",
					"title":"Haut-Katanga",
					"d":"M558.913,623.194L561.198,621.138L561.883,617.939L560.741,614.514L558.686,613.371L554.802,612.229L553.888,611.087L552.061,609.259L549.319,608.803L545.893,611.087L541.78,611.544L539.496,612.457L536.983,614.514L534.928,615.655L532.187,615.427L530.358,612.914L528.531,609.259L526.247,607.203L522.363,606.062L519.165,606.975L518.023,609.031L520.308,611.315L521.449,613.6L520.536,618.396L519.622,624.107L517.566,626.62L515.51,625.707L513.226,626.849L511.398,629.818L508.657,630.732L507.058,627.763L503.859,624.336L500.661,622.737L496.55,621.823L491.296,622.052L486.727,622.509L483.071,625.021L480.33,626.393L476.447,631.189L474.848,634.616L473.706,637.586L471.193,640.099L466.853,640.784L464.568,643.068L463.197,648.779L462.056,653.348L460.456,656.546L459.314,660.658L456.573,665.455L454.517,667.739L452.918,672.309L453.832,674.136L456.116,675.507L460.685,675.278L463.197,675.278L464.797,677.334L467.995,677.563L471.649,677.334L473.021,675.964L476.219,677.334L477.36,680.532L475.99,685.101L475.762,689.67L477.589,691.954L478.503,695.152L478.274,699.265L475.762,701.868L473.021,700.27L471.878,698.214L469.594,696.157L466.396,696.157L463.197,696.386L461.142,697.071L459.771,697.985L460.913,700.955L462.056,702.554L462.056,706.209L461.142,708.722L459.314,711.691L458.857,714.433L458.172,716.26L457.029,717.859L455.431,718.772L453.375,717.402L453.832,714.89L453.604,711.006L453.375,708.95L451.318,708.722L449.72,709.179L448.349,711.006L444.923,711.006L443.78,711.691L441.496,713.519L440.125,716.031L438.526,719.458L438.983,723.57L437.841,725.854L436.471,726.997L434.871,729.967L432.587,733.85L430.919,735.744L431.637,737.319L432.959,738.428L436.32,738.83L438.141,737.93L439.373,740.341L440.677,740.438L441.556,741.106L441.278,742.238L441.639,742.491L448.114,742.438L448.762,742.066L452.544,743.32L455.063,741.821L456.207,741.663L459.883,743.746L461.244,743.495L464.125,744.169L464.642,744.716L466.789,743.232L468.49,744.206L470.276,743.921L474.248,739.441L473.966,738.461L474.27,736.856L475.563,734.617L474.801,733.1L474.915,731.783L479.039,731.414L480.599,730.39L481.256,733.23L481.441,737.484L483.319,738.235L488.847,742.075L488.982,745.547L489.938,746.6L490.502,749.544L492.096,751.257L493.652,751.719L494.233,753.39L495.033,753.77L498.294,753.844L500.194,752.877L500.227,751.91L501.738,752.371L503.408,752.253L504.549,754.65L504.61,755.946L505.705,755.453L508.471,755.911L510.029,758.604L510.715,758.362L510.758,757.665L511.625,756.889L513.578,758.189L516.133,758.071L518.978,760.737L520.192,761.237L520.313,762.774L522.808,765.085L522.349,766.556L520.655,767.188L520.957,768.348L522.979,770.525L523.474,772.336L524.387,773.538L526.113,771.161L526.953,771.111L529.312,772.997L530.26,775.018L532.544,777.387L533.179,781.773L534.992,782.323L536.34,786.979L538.199,790.628L541.975,789.12L543.219,790.151L543.936,791.517L546.029,789.877L547.667,789.3L548.207,787.883L549.255,788.414L549.784,787.704L552.236,787.291L554.999,784.472L556.954,784.016L558.428,784.821L559.557,784.432L559.941,785.681L559.023,786.466L559.331,787.175L558.979,788.483L557.453,788.911L557.646,790.396L558.793,791.331L559.857,791.115L560.905,791.931L562.971,791.318L563.999,791.913L563.935,749.518L562.498,749.643L561.251,750.618L559.455,751.17L556.51,750.701L553.756,752.19L552.695,755.282L553.962,757.254L555.197,757.517L555.3,758.182L554.083,759.727L553.296,759.778L549.812,757.869L547.551,757.745L547.563,757.107L546.634,756.283L544.2,756.491L542.227,757.297L541.521,756.776L539.581,756.952L536.385,751.323L530.982,746.227L530.373,744.109L529.145,744.121L526.549,742.866L525.737,741.584L524.516,741.521L522.187,740.5L521.48,738.796L520.099,738.914L520.369,736.921L519.323,735.507L519.969,734.66L519.428,733.942L519.854,732.903L518.262,730.938L518.666,727.345L519.475,726.415L519.715,724.432L520.732,723.983L520.404,722.494L521.642,719.862L521.956,717.85L521.293,715.359L522.309,712.941L522.326,711.13L523.272,710.094L523.778,706.507L525.38,704.411L525.59,703.051L527.256,702.832L528.368,701.005L527.377,699.597L527.549,697.702L526.359,696.335L526.639,693.711L525.961,691.718L526.432,689.464L524.535,687.022L525.965,684.644L526.434,680.28L526.066,678.183L527.552,673.784L528.376,673.304L527.452,671.691L526.641,671.563L526.036,670.844L526.205,668.801L525.67,667.747L525.75,666.706L524.804,665.993L524.301,663.13L522.563,661.605L523.15,659.646L522.932,658.938L522.275,658.703L520.906,660.295L519.4,660.836L517.622,659.431L517.694,657.228L519.426,654.453L528.33,648.4L534.768,640.688L536.259,638.237L536.925,635.586L536.424,633.405L534.939,630.376L556.676,627.228L558,625.021z"
				},
				{
					"id":"CD-HL",
					"title":"Haut-Lomami",
					"d":"M503.631,619.479L503.859,616.736L502.032,614.681L499.748,613.539L497.235,612.168L494.722,611.254L493.58,608.741L493.123,603.259L492.666,601.203L486.27,600.746L480.102,601.66L478.503,603.259L473.249,603.716L467.995,603.487L466.167,602.345L463.654,601.432L458.857,601.66L455.431,600.061L453.375,596.405L454.06,593.664L455.431,591.38L454.06,588.182L451.775,586.354L448.577,585.669L445.836,584.07L444.009,582.928L442.866,579.501L441.725,576.988L439.896,573.562L439.212,570.363L440.354,566.709L441.496,564.652L443.323,563.968L444.009,562.597L444.268,559.352L443.117,559.312L441.694,560.689L440.903,560.841L440.288,560.334L440.217,558.866L439.557,558.19L435.171,557.069L430.767,560.823L428.139,561.258L426.637,562.308L422.081,561.561L419.803,561.667L418.617,562.655L418.121,563.892L421.325,567.895L422.737,568.545L426.477,568.242L426.637,569.391L424.794,570.316L424.964,571.5L423.913,573.822L419.604,575.452L416.927,573.359L414.924,572.532L411.794,572.051L408.32,572.3L406.925,574.081L407.109,576.164L402.144,579.842L398.665,581.018L396.969,582.84L394.074,583.065L393.532,584.598L392.427,585.311L389.749,584.802L385.726,582.824L385.229,582.228L385.049,579.886L384.393,579.146L382.79,578.88L382.245,579.654L382.905,580.67L381.819,581.355L382.61,582.191L382.159,582.78L382.7,583.306L382.415,584.365L381.714,584.989L379.933,585.443L378.296,588.276L376.713,589.818L377.254,591.289L376.623,593.525L378.001,594.773L377.234,595.576L376.328,599.472L375.582,600.079L375.322,606.332L376.418,608.124L376.443,609.722L372.849,609.838L372.118,610.4L371.833,611.552L371.016,612.034L370.226,612.061L369.351,610.668L367.679,612.132L363.549,612.034L365.197,615.823L367.024,618.793L367.024,627.017L366.111,632.042L366.796,638.438L370.223,640.494L374.335,642.094L379.36,643.235L384.614,646.205L388.27,650.089L387.127,654.886L385.528,657.399L383.473,662.196L382.787,671.105L381.416,674.532L381.645,679.786L383.473,681.385L385.3,679.558L389.641,680.015L391.468,681.613L396.95,680.928L401.747,682.07L405.402,684.354L409.515,684.126L412.713,682.756L418.652,680.015L424.363,677.73L427.333,675.674L427.333,662.882L429.617,662.882L438.983,668.821L446.064,671.563L452.918,672.309L454.517,667.739L456.573,665.455L459.314,660.658L460.456,656.546L462.056,653.348L463.197,648.779L464.568,643.068L466.853,640.784L471.193,640.099L473.706,637.586L474.848,634.616L476.447,631.189L480.33,626.393L483.071,625.021L486.727,622.509L491.296,622.052L496.55,621.823L500.661,622.737L501.575,620.392z"
				},
				
				{
					"id":"CD-KE",
					"title":"Kasai-Oriental",
					"d":"M310.584,438.969L312.279,436.581L315.377,435.156L318.296,432.148L319.462,432.608L319.926,433.325L319.686,436.448L320.183,437.606L321.875,438.218L323.021,437.536L323.146,435.528L321.288,429.646L320.317,424.107L319.151,421.507L319.747,420.269L324.117,421.444L330.149,422.037L332.723,419.349L333.863,417.014L334.414,417.518L335.596,417.19L338.274,418.694L340.1,418.845L341.702,419.659L342.955,420.614L343.83,422.144L346.908,421.057L349.363,421.621L352.941,426.071L354.81,425.045L361.876,423.665L368.088,423.948L368.223,421.162L370.678,420.72L370.945,417.19L372.278,415.971L377.424,415.996L379.026,414.839L391.36,416.475L391.36,416.475L392.334,421.4L392.334,421.4L393.292,426.045L397.463,431.82L400.276,437.846L403.659,438.306L413.226,437.58L412.354,442.659L413.581,448.182L410.263,455.59L411.009,457.229L410.753,457.617L409.933,457.423L410.458,458.166L410.112,458.928L410.548,459.565L409.827,461.194L408.971,461.654L408.525,463.638L406.64,464.098L407.104,464.683L406.908,466.692L405.563,467.171L404.316,469.642L402.823,470.093L403.586,471.997L402.384,472.671L402.999,475.638L403.544,475.966L403.464,477.18L401.327,479.846L401.504,480.784L402.554,481.236L402.358,481.937L403.871,482.132L403.435,482.813L404.486,484.399L405.232,484.222L405.188,485.188L406.64,486.172L406.508,487.342L407.299,488.325L408.27,488.086L409.061,488.609L409.15,490.204L409.933,490.966L409.433,491.729L410.263,492.446L409.871,494.547L410.308,496.001L408.945,499.228L410.112,500.93L410.128,501.648L408.029,503.502L407.449,505.098L405.893,506.011L405.277,507.607L405.633,509.284L406.293,509.718L406.908,511.333L408.686,512.646L410.112,514.518L410.394,516.31L411.909,519.034L450.508,519.008L450.508,519.008L450.331,520.772L448.557,524.403L445.645,528.292L444.522,531.47L446.625,535.147L444.552,537.5L444.122,539.614L444.692,540.805L447.621,543.933L447.157,546.793L447.531,551.868L446.305,553.798L447.756,557.452L447.096,558.991L446.395,559.427L443.117,559.312L441.694,560.689L440.903,560.841L440.288,560.334L440.217,558.866L439.557,558.19L435.171,557.069L430.767,560.823L428.139,561.258L426.637,562.308L422.081,561.561L419.803,561.667L418.617,562.655L418.121,563.892L421.325,567.895L422.737,568.545L426.477,568.242L426.637,569.391L424.794,570.316L424.964,571.5L423.913,573.822L419.604,575.452L416.927,573.359L414.924,572.532L411.794,572.051L408.32,572.3L406.925,574.081L407.109,576.164L402.144,579.842L398.665,581.018L396.969,582.84L394.074,583.065L393.532,584.598L392.427,585.311L389.749,584.802L385.726,582.824L385.229,582.228L385.049,579.886L384.393,579.146L382.79,578.88L382.245,579.654L382.905,580.67L381.819,581.355L382.61,582.191L382.159,582.78L382.7,583.306L382.415,584.365L381.714,584.989L379.933,585.443L378.296,588.276L376.713,589.818L377.254,591.289L376.623,593.525L378.001,594.773L377.234,595.576L376.328,599.472L375.582,600.079L375.322,606.332L376.418,608.124L376.443,609.722L372.849,609.838L372.118,610.4L371.833,611.552L371.016,612.034L370.226,612.061L369.351,610.668L367.679,612.132L363.549,612.034L361.094,612.802L358.093,611.989L356.164,612.168L355.024,611.552L353.877,613.007L353.047,613.185L351.829,612.177L350.923,608.58L350.923,608.58L351.686,600.623L352.685,595.272L352.566,589.274L351.935,586.968L353.752,581.409L351.474,578.87L348.556,577.481L346.533,574.205L344.202,572.7L343.455,571.224L343.5,569.72L346.598,563.696L347.193,560.076L348.856,557.435L348.466,556.233L346.488,554.999L344.95,552.553L344.381,550.171L344.426,546.073L345.217,544.137L346.338,543.461L354.828,542.715L358.077,541.275L358.478,541.471L357.952,543.044L358.628,543.63L361.085,542.582L362.623,540.796L367.322,538.727L369.19,538.922L369.585,538.229L369.431,531.816L369.146,531.088L360.408,527.67L359.304,525.814L355.469,527.058L353.512,527.04L350.698,523.507L344.558,518.359L344.442,514.952L345.457,513.169L350.308,511.839L351.604,510.614L350.903,505.771L349.872,503.813L341.087,502.633L335.465,496.391L333.469,494.937L330.31,493.625L326.991,491.161L323.396,486.712L318.626,488.175L316.438,486.385L314.371,486.101L315.402,484.515L320.013,484.115L320.317,483.222L318.101,477.552L313.971,475.966L313.119,474.831L312.814,472.866L312.984,471.139L315.031,468.826L315.777,465.665L317.665,462.505L320.058,454.917L319.132,452.104L317.485,449.403L313.475,445.014L312.52,440.501z"
				},
				{
					"id":"CD-KN",
					"title":"Kinshasa",
					"d":"M118.465,485.483L120.314,486.624L125.325,486.278L128.218,486.951L134.231,490.248L136.458,493.82L137.836,494.564L139.002,496.373L138.691,497.313L139.197,498.359L138.736,499.404L138.957,499.839L138.451,500.212L137.375,503.263L135.353,503.661L131.867,509.869L129.865,512.45L130.48,519.096L130.48,519.096L121.676,519.008L118.142,516.088L117.841,518.813L117.111,519.841L115.464,520.036L112.68,519.247L109.957,517.269L109.252,516.132L109.627,515.387L111.584,515.112L112.616,514.367L113.711,509.824L113.516,508.717L110.553,507.209L111.604,505.337L111.469,504.618L108.441,504.751L105.362,503.874L103.79,504.096L102.514,505.23L102.684,506.756L102.188,507.848L101.038,508.22L99.9,507.714L97.593,505.47L94.364,500.614L94.364,500.614L95.277,499.677L95.784,498.177L98.085,497.173L99.24,496.072L102.284,496.651L104.417,495.685L105.704,493.497L105.576,491.846L106.039,490.484L107.548,488.582L112.429,486.896L116.999,486.223z"
				},
				{
					"id":"CD-KW",
					"title":"Kasai-Occidental",
					"d":"M269.644,581.077L272.671,581.75L275.702,580.884L277.433,575.685L277.433,571.354L273.969,564.428L271.372,564.428L268.774,562.264L265.743,556.206L262.712,554.043L260.98,551.881L258.816,551.016L256.218,548.854L255.051,541.258L255.512,540.884L255.531,539.357L254.372,535.715L254.436,530.307L255.378,528.194L256.038,527.75L255.663,526.445L255.887,524.093L255.006,521.066L254.285,520.231L254.497,518.75L253.225,516.939L252.37,512.947L251.488,511.635L251.738,506.1L253.555,503.067L252.7,502.127L252.568,500.734L251.008,498.342L250.992,495.982L250.992,495.982L253.09,495.877L253.09,495.877L254.256,496.24L255.441,497.703L256.935,497.773L258.165,499.706L259.437,499.315L260.559,499.777L261.173,499.059L261.74,496.506L262.936,495.938L263.922,496.134L264.223,495.105L266.065,495.193L269.429,493.52L270.063,492.357L271.375,491.328L270.989,477.95L270.311,472.236L270.766,464.992L276.317,450.386L280.315,445.412L280.431,442.447L282.11,438.916L282.11,438.916L289.651,439.678L293.913,438.58L295.905,438.651L296.325,438.341L296.831,434.024L299.573,435.033L301.041,436.448L302.492,436.775L303.748,437.952L308.269,440.2L310.584,438.969L310.584,438.969L312.52,440.501L313.475,445.014L317.485,449.403L319.132,452.104L320.058,454.917L317.665,462.505L315.777,465.665L315.031,468.826L312.984,471.139L312.814,472.866L313.119,474.831L313.971,475.966L318.101,477.552L320.317,483.222L320.013,484.115L315.402,484.515L314.371,486.101L316.438,486.385L318.626,488.175L323.396,486.712L326.991,491.161L330.31,493.625L333.469,494.937L335.465,496.391L341.087,502.633L349.872,503.813L350.903,505.771L351.604,510.614L350.308,511.839L345.457,513.169L344.442,514.952L344.558,518.359L350.698,523.507L353.512,527.04L355.469,527.058L359.304,525.814L360.408,527.67L369.146,531.088L369.431,531.816L369.585,538.229L369.19,538.922L367.322,538.727L362.623,540.796L361.085,542.582L358.628,543.63L357.952,543.044L358.478,541.471L358.077,541.275L354.828,542.715L346.338,543.461L345.217,544.137L344.426,546.073L344.381,550.171L344.95,552.553L346.488,554.999L348.466,556.233L348.856,557.435L347.193,560.076L346.598,563.696L343.5,569.72L343.455,571.224L344.202,572.7L346.533,574.205L348.556,577.481L351.474,578.87L353.752,581.409L351.935,586.968L352.566,589.274L352.685,595.272L351.686,600.623L350.923,608.58L350.923,608.58L348.44,610.168L341.817,612.079L339.841,611.275L338.224,611.463L336.141,610.945L335.224,609.517L334.778,607.233L333.549,606.028L329.864,608.473L321.875,609.026L316.294,607.92L314.229,606.885L312.709,605.448L308.245,603.77L308.245,603.77L308.964,602.262L309.119,600.779L308.578,599.695L309.235,598.251L309.196,597.207L308.046,593.519L306.791,592.118L267.1,592.039L267.162,587.632L268.632,583.204L269.56,582.228z"
				},
				{
					"id":"CD-LB",
					"title":"Lualaba",
					"d":"M434.871,729.967L436.471,726.997L437.841,725.854L438.983,723.57L438.526,719.458L440.125,716.031L441.496,713.519L443.78,711.691L444.923,711.006L448.349,711.006L449.72,709.179L451.318,708.722L453.375,708.95L453.604,711.006L453.832,714.89L453.375,717.402L455.431,718.772L457.029,717.859L458.172,716.26L458.857,714.433L459.314,711.691L461.142,708.722L462.056,706.209L462.056,702.554L460.913,700.955L459.771,697.985L461.142,697.071L463.197,696.386L466.396,696.157L469.594,696.157L471.878,698.214L473.021,700.27L475.762,701.868L478.274,699.265L478.503,695.152L477.589,691.954L475.762,689.67L475.99,685.101L477.36,680.532L476.219,677.334L473.021,675.964L471.649,677.334L467.995,677.563L464.797,677.334L463.197,675.278L460.685,675.278L456.116,675.507L453.832,674.136L452.918,672.309L446.064,671.563L438.983,668.821L429.617,662.882L427.333,662.882L427.333,675.674L424.363,677.73L418.652,680.015L412.713,682.756L409.515,684.126L405.402,684.354L401.747,682.07L396.95,680.928L391.468,681.613L389.641,680.015L385.3,679.558L383.473,681.385L381.645,679.786L381.416,674.532L382.787,671.105L383.473,662.196L385.528,657.399L387.127,654.886L388.27,650.089L384.614,646.205L379.36,643.235L374.335,642.094L370.223,640.494L366.796,638.438L366.111,632.042L367.024,627.017L367.024,618.793L365.197,615.823L363.549,612.034L361.094,612.802L358.093,611.989L356.164,612.168L355.024,611.552L353.877,613.007L353.047,613.185L351.829,612.177L350.923,608.58L348.44,610.168L341.817,612.079L339.841,611.275L338.224,611.463L336.141,610.945L335.224,609.517L334.778,607.233L333.549,606.028L329.864,608.473L321.875,609.026L316.294,607.92L314.229,606.885L312.709,605.448L308.245,603.77L306.389,607.961L306.473,611.695L305.666,612.801L309.907,621.454L310.492,624.472L311.775,625.547L311.234,626.576L312.531,631.096L311.341,634.411L310.759,639.774L309.604,643.05L308.785,649.912L309.352,655.066L307.186,660.851L308.529,662.288L308.371,663.332L309.597,665.539L309.845,668.362L311.714,669.448L314.216,673.613L316.162,675.608L319.951,677.205L320.17,679.533L321.028,681.858L320.954,684.698L321.387,686.337L322.796,687.999L322.859,689.324L323.649,690.164L324.326,692.021L322.717,696.267L323.961,697.154L323.884,701.444L324.519,704.087L323.482,705.204L321.24,705.865L319.612,707.141L319.404,707.878L320.423,710.16L320.896,715.326L322.27,717.321L322.119,719.306L322.532,719.922L323.422,719.854L325.073,717.664L327.82,717.609L329.676,715.848L329.759,713.609L331.831,712.93L336.992,715.508L339.239,715.551L339.795,714.637L341.605,713.945L344.532,715.126L346.314,715.188L348.55,715.96L350.733,714.963L352.366,715.254L359.812,709.936L362.055,710.197L364.608,711.719L366.011,711.633L367.39,712.204L369.741,711.688L371.983,712.842L373.154,712.837L376.12,710.479L377.242,708.595L378.212,708.216L381.895,709.033L381.789,710.151L382.571,711.197L382.092,712.71L382.428,713.12L383.158,713.397L383.883,712.883L386.963,713.318L390.164,714.938L390.283,717.639L390.738,718.251L390.492,721.216L389.095,723.828L387.369,724.089L387.145,724.567L388.115,725.165L390.155,725.218L391.851,726.421L392.165,727.377L395.535,726.428L396.589,726.749L397.073,725.522L398.216,725.044L400.291,722.764L401.366,722.605L401.545,721.867L405.226,721.444L405.881,720.442L406.92,720.694L409.472,720.063L412.189,720.206L417.168,719.319L419.665,718.147L421.203,718.292L420.179,720.243L420.675,721.123L419.4,721.971L419.905,723.246L418.847,723.951L419.621,725.436L419.679,727.184L420.399,728.137L419.205,728.709L419.872,729.245L419.704,730.307L420.379,730.925L420.72,732.292L423.626,733.889L425.229,734.265L425.771,735.07L425.434,737.017L425.869,737.434L428.432,736.668L428.952,735.85L430.919,735.744L432.587,733.85z"
				},
				{
					"id":"CD-MA",
					"title":"Maniema",
					"d":"M498.469,377.295L499.3,382.033L498.001,388.485L496.269,390.635L492.805,392.786L485.444,392.356L483.28,394.076L484.579,396.228L484.579,398.809L481.548,399.669L479.384,400.959L481.98,402.68L484.146,406.121L488.908,410.854L498.001,421.18L496.701,425.054L496.701,425.054L495.835,425.054L495.835,425.054L490.64,425.484L488.476,426.344L486.311,428.496L485.877,431.51L481.548,433.23L474.62,431.079L472.022,431.079L469.425,431.938L468.126,438.826L468.992,443.562L477.651,464.232L475.486,476.297L476.353,482.763L478.518,484.918L481.98,486.643L490.64,487.073L497.135,488.367L499.732,491.816L503.196,493.11L504.929,494.403L512.288,493.541L514.453,496.129L517.483,498.717L520.948,503.03L524.411,510.797L529.117,519.008L529.117,519.008L516.224,519.008L516.224,519.008L450.508,519.008L450.508,519.008L411.909,519.034L410.394,516.31L410.112,514.518L408.686,512.646L406.908,511.333L406.293,509.718L405.633,509.284L405.277,507.607L405.893,506.011L407.449,505.098L408.029,503.502L410.128,501.648L410.112,500.93L408.945,499.228L410.308,496.001L409.871,494.547L410.263,492.446L409.433,491.729L409.933,490.966L409.15,490.204L409.061,488.609L408.27,488.086L407.299,488.325L406.508,487.342L406.64,486.172L405.188,485.188L405.232,484.222L404.486,484.399L403.435,482.813L403.871,482.132L402.358,481.937L402.554,481.236L401.504,480.784L401.327,479.846L403.464,477.18L403.544,475.966L402.999,475.638L402.384,472.671L403.586,471.997L402.823,470.093L404.316,469.642L405.563,467.171L406.908,466.692L407.104,464.683L406.64,464.098L408.525,463.638L408.971,461.654L409.827,461.194L410.548,459.565L410.112,458.928L410.458,458.166L409.933,457.423L410.753,457.617L411.009,457.229L410.263,455.59L413.581,448.182L412.354,442.659L413.226,437.58L403.659,438.306L400.276,437.846L397.463,431.82L393.292,426.045L392.334,421.4L392.334,421.4L403.791,422.037L410.263,421.207L410.663,422.161L412.281,423.409L411.714,425.391L412.221,426.434L416.785,426.876L418.717,426.637L420.585,425.762L425.391,420.375L427.652,418.721L429.189,418.394L432.368,419.526L434.102,418.766L435.973,418.889L436.783,417.412L437.511,411.628L437.155,407.879L437.421,403.933L439.878,406.331L439.833,406.941L441.925,407.162L442.47,406.765L443.152,405.395L442.71,403.936L444.202,403.21L444.247,400.486L445.984,399.788L446.33,396.234L447.326,395.429L446.375,394.094L447.15,390L449.889,388.992L451.235,387.64L450.485,379.118L454.569,375.193L454.944,374.344L453.689,372.099L450.2,369.81L448.467,367.838L444.639,364.744L446.775,362.605L448.183,362.977L450.94,365.637L451.911,365.813L452.677,367.644L453.184,367.538L454.304,368.846L455.47,369.217L455.967,370.676L456.893,371.506L460.17,371.33L462.384,369.606L464.866,369.261L467.014,367.75L468.507,367.953L468.882,367.449L468.49,366.512L468.907,366.052L470.332,367.034L471.098,366.866L472.325,367.865L473.908,368.015L475.688,369.279L476.32,371.002L477.637,371.851L478.233,372.815L479.748,373.469L484.205,374.141L485.96,375.67L489.206,374.928L490.48,376.28L493.05,376.218L496.939,377.739L498.455,377.306L498.455,377.306z"
				},
				{
					"id":"CD-NK",
					"title":"Nord-Kivu",
					"d":"M496.701,425.054L498.001,421.18L488.908,410.854L484.146,406.121L481.98,402.68L479.384,400.959L481.548,399.669L484.579,398.809L484.579,396.228L483.28,394.076L485.444,392.356L492.805,392.786L496.269,390.635L498.001,388.485L499.3,382.033L498.469,377.295L498.469,377.295L498.936,376.961L498.936,376.961L501.969,374.062L503.872,370.526L508.707,368.104L509.453,366.972L509.982,364.591L508.883,359.069L509.39,356.214L510.351,355.648L510.636,354.649L509.845,353.668L509.935,352.642L508.242,351.484L507.701,349.628L507.807,347.931L507.211,347.427L507.477,346.119L506.906,345.836L506.666,344.987L505.938,344.439L504.844,344.634L503.331,343.979L502.12,344.395L500.938,344.068L497.66,342.326L497.795,341.407L502.626,340.708L504.817,338.623L508.047,337.375L517.267,336.112L518.539,336.527L522.277,340.346L524.331,341.106L532.174,339.577L538.456,340.214L539.773,339.904L542.887,337.853L544.8,338.048L546.447,339.162L547.914,338.684L551.208,340.099L553.575,338.446L553.165,337.659L550.397,336.704L549.605,335.634L549.785,334.432L550.986,332.425L551.804,332.319L554.456,333.557L556.147,333.733L556.719,333.062L556.478,332.363L556.834,331.639L561.37,331.727L563.105,329.958L565.304,329.004L567.086,331.488L569.706,332.774L569.706,332.774L568.889,334.807L569.323,335.954L568.657,339.193L569.438,343.149L566.015,347.343L564.446,354.126L562.707,354.4L561.624,355.644L561.61,356.774L561.036,357.261L561.455,362.579L558.929,374.343L559.557,374.703L559.429,376.91L559.947,377.529L558.109,382.055L558.479,388.242L556.686,388.403L556.954,393.112L556.503,395.524L556.812,396.379L556.392,397.355L557.52,398.487L557.032,400.038L557.484,401.52L556.95,403.791L554.722,404.879L552.638,407.479L550.363,407.503L549.666,407.892L548.091,410.433L546.586,411.831L545.916,413.928L542.561,418.517L542.561,418.517L538.699,418.168L535.669,416.877L535.235,415.156L531.771,414.727L529.607,418.168L526.144,421.61L524.845,423.762L521.813,424.192L520.515,422.041L518.783,420.75L514.021,425.914L509.69,427.205L505.793,426.774L504.063,425.054L498.866,425.054L498.866,425.054z"
				},
				{
					"id":"CD-OR",
					"title":"Orientale",
					"d":"M427.715,188.338L428.561,188.38L429.063,189.327L429.88,189.266L429.919,190.097L431.036,189.887L432.644,190.875L433.936,192.805L435.029,192.332L434.602,191.943L435.322,191.654L436.207,192.512L436.713,194.4L437.07,193.598L438.246,193.381L438.927,195.093L439.323,194.783L439.071,193.968L440.122,193.766L440.814,194.242L440.9,193.242L441.495,192.71L442.268,193.069L442.321,193.716L444.146,194.167L444.431,193.556L445.159,193.716L446.339,191.934L447.126,192.107L447.099,192.954L448.635,192.795L449.122,193.758L450.101,194.042L450.125,194.888L452.929,195.675L454.494,195.657L456.675,197.329L456.824,198.498L458.281,198.966L458.848,198.957L459.073,198.221L460.374,198.344L460.396,197.785L463.425,197.897L465.996,197.062L466.717,197.119L467.86,198.801L468.609,198.476L469.911,199.29L470.52,198.017L471.195,197.81L471.929,196.081L476.146,193.95L479.05,193.99L481.434,195.502L487.833,197.885L488.305,198.679L488.139,199.667L490.64,201.178L491.075,202.73L492.395,203.905L495.071,203.841L495.92,204.573L496.736,206.37L496.551,206.854L496.872,207.208L498.314,207.052L499.233,208.791L499.266,209.775L498.771,210.45L499.119,213.237L500.669,213.626L501.824,214.807L503.808,214.933L504.098,214.162L507.388,214.809L507.068,217.048L508.455,219.185L509.511,218.22L510.281,218.377L510.617,218.864L510.275,219.723L512.486,221.202L517.292,221.136L518.177,223.528L520.714,223.188L522.388,220.515L524.534,220.342L525.335,219.068L527.26,218.901L528.358,216.864L528.104,216.216L528.789,216.021L528.874,215.309L530.316,215.081L530.974,214.482L531.85,215.325L531.88,216.641L532.634,217.174L537.293,217.125L538.384,216.573L539.184,216.901L539.604,217.733L540.655,217.85L540.563,218.613L542.368,218.756L542.351,219.336L544.638,221.495L545.947,221.29L545.978,219.96L548.379,220.019L549.556,217.564L551.177,216.869L552.111,215.573L552.162,214.45L553.197,213.39L552.933,211.022L554.055,210.286L554.886,211.401L555.807,211.032L557.156,211.607L557.775,211.199L560.766,212.622L561.763,214.077L562.699,213.693L563.201,214.314L564.361,214.461L563.571,218.343L563.659,220.54L564.982,221.548L566.697,221.244L568.255,222.247L568.952,223.441L568.45,224.804L569.712,225.063L571.341,226.268L571.7,227.621L572.647,228.694L574.165,228.672L575.106,229.197L575.199,230.536L576.562,232.058L576.59,233.445L577.251,234.287L578.885,233.683L579.707,234.491L582.517,235.209L585.267,236.775L587.631,236.497L588.858,242.49L588.017,245.176L589.082,245.231L591.502,243.888L593.652,244.273L594.835,242.667L595.728,245.354L597.737,246.225L597.226,247.972L597.466,248.671L600.134,247.947L600.164,251.277L598.554,253.292L598.716,254.14L598.015,255.226L596.976,255.774L595.569,261.963L594.725,262.512L595.132,263.444L597.608,265.388L598.639,268.683L598.446,270.088L597.647,271.381L596.479,272.142L596.601,272.795L595.044,276.794L594.151,277.349L594.526,279.776L593.855,281.685L594.201,282.655L595.043,282.051L596.791,282.734L598.375,285.169L599.974,285.357L600.694,283.271L601.83,283.086L604.493,284.998L604.879,286.12L604.377,286.301L606.157,287.54L606.678,286.999L607.41,287.169L608.66,286.651L608.664,288.989L611.95,291.026L611.947,292.318L603.058,304L594.147,311.071L587.731,319.389L586.771,319.392L584.626,321.436L582.615,321.798L581.653,321.332L580.872,322.964L579.492,322.268L578.896,322.471L577.666,323.566L577.805,324.667L577.152,327.274L575.097,331.426L573.148,331.496L569.706,332.774L569.706,332.774L567.086,331.488L565.304,329.004L563.105,329.958L561.37,331.727L556.834,331.639L556.478,332.363L556.719,333.062L556.147,333.733L554.456,333.557L551.804,332.319L550.986,332.425L549.785,334.432L549.605,335.634L550.397,336.704L553.165,337.659L553.575,338.446L551.208,340.099L547.914,338.684L546.447,339.162L544.8,338.048L542.887,337.853L539.773,339.904L538.456,340.214L532.174,339.577L524.331,341.106L522.277,340.346L518.539,336.527L517.267,336.112L508.047,337.375L504.817,338.623L502.626,340.708L497.795,341.407L497.66,342.326L500.938,344.068L502.12,344.395L503.331,343.979L504.844,344.634L505.938,344.439L506.666,344.987L506.906,345.836L507.477,346.119L507.211,347.427L507.807,347.931L507.701,349.628L508.242,351.484L509.935,352.642L509.845,353.668L510.636,354.649L510.351,355.648L509.39,356.214L508.883,359.069L509.982,364.591L509.453,366.972L508.707,368.104L503.872,370.526L501.969,374.062L498.936,376.961L498.936,376.961L498.455,377.306L498.455,377.306L496.939,377.739L493.05,376.218L490.48,376.28L489.206,374.928L485.96,375.67L484.205,374.141L479.748,373.469L478.233,372.815L477.637,371.851L476.32,371.002L475.688,369.279L473.908,368.015L472.325,367.865L471.098,366.866L470.332,367.034L468.907,366.052L468.49,366.512L468.882,367.449L468.507,367.953L467.014,367.75L464.866,369.261L462.384,369.606L460.17,371.33L456.893,371.506L455.967,370.676L455.47,369.217L454.304,368.846L453.184,367.538L452.677,367.644L451.911,365.813L450.94,365.637L448.183,362.977L446.775,362.605L444.639,364.744L448.467,367.838L450.2,369.81L453.689,372.099L454.944,374.344L454.569,375.193L450.485,379.118L451.235,387.64L449.889,388.992L447.15,390L446.375,394.094L447.326,395.429L446.33,396.234L445.984,399.788L444.247,400.486L444.202,403.21L442.71,403.936L443.152,405.395L442.47,406.765L441.925,407.162L439.833,406.941L439.878,406.331L437.421,403.933L437.155,407.879L437.511,411.628L436.783,417.412L435.973,418.889L434.102,418.766L432.368,419.526L429.189,418.394L427.652,418.721L425.391,420.375L420.585,425.762L418.717,426.637L416.785,426.876L412.221,426.434L411.714,425.391L412.281,423.409L410.663,422.161L410.263,421.207L403.791,422.037L392.334,421.4L392.334,421.4L391.36,416.475L391.36,416.475L389.935,408.666L387.631,404.023L386.884,403.652L381.284,403.758L376.258,401.273L372.635,397.958L370.616,397.215L369.235,394.165L362.731,390.743L357.266,385.377L361.415,381.929L365.125,380.842L366.021,379.922L363.854,378.154L361.135,373.895L359.769,373.664L354.482,375.449L353.646,375.149L352.835,373.213L344.887,372.588L350.368,368.492L355.273,369.783L356.545,368.43L359.003,367.644L358.938,366.317L353.752,358.547L350.263,354.694L348.511,350.813L346.533,348.93L344.977,346.535L344.115,344.466L343.785,341.522L341.132,337.526L341.312,334.167L339.949,331.161L340.251,330.639L339.814,329.834L339.921,327.978L338.694,326.36L337.153,322.505L335.4,320.304L333.818,316.351L332.963,316.14L331.21,314.176L327.722,312.275L322.996,311.842L323.787,310.118L327.231,307.694L328.968,305.775L330.374,298.691L332.678,294.481L332.107,292.915L332.527,292.19L334.965,292.783L336.236,294.941L338.079,295.701L341.397,294.57L341.507,294.048L342.254,293.738L342.228,292.933L343.24,292.933L343.855,292.261L343.766,291.296L344.995,290.951L345.082,290.165L347.629,292.58L348.751,293.039L352.284,291.341L356.875,288.023L362.536,288.988L365.24,290.12L366.727,289.899L365.961,285.493L363.219,283.494L359.394,281.636L357.372,279.344L355.728,278.981L349.917,280.025L348.331,279.415L347.078,278.256L345.021,275.84L344.576,274.619L345.982,271.911L345.367,268.707L346.668,266.485L346.793,264.91L348.271,261.705L348.481,259.483L347.479,258.678L345.893,259.022L341.507,263.794L340.712,264.369L339.921,264.299L339.22,263.715L338.8,262.139L339.335,255.906L337.947,254.817L334.85,254.073L333.889,253.073L333.799,251.78L335.205,249.911L341.462,247.989L343.57,246.705L345.636,247.139L347.059,246.723L351.339,242.56L352.506,242.932L353.207,243.712L355.487,243.756L356.92,244.801L357.702,244.544L361.456,240.638L362.356,237.847L360.995,238.175L358.653,237.546L357.355,238.37L350.573,235.605L348.556,235.889L346.998,236.739L345.563,236.013L342.494,237.085L341.151,236.739L338.349,235.322L338.124,232.566L335.836,232.354L331.797,229.057L328.651,227.949L328.651,227.949L331.455,225.418L331.187,223.729L332.058,222.001L333.665,221.108L333.686,220.241L332.581,219.531L333.018,217.238L333.913,216.824L335.052,216.954L335.611,217.556L336.214,217.238L336.453,215.834L337.326,214.546L337.513,212.349L338.919,209.81L339.74,209.147L340.911,209.895L341.558,209.702L341.85,208.731L342.738,208.126L342.259,207.253L342.868,206.186L343.978,206.265L344.807,205.55L346.267,208.246L348.423,209.455L349.489,209.696L351.354,208.73L352.533,210.198L354.284,211.107L354.844,212.327L356.469,213.074L357.401,212.89L358.116,213.498L359.344,213.497L359.665,211.541L360.751,210.797L361.897,210.804L364.506,208.897L368.577,207.32L370.548,207.407L372.561,205.817L373.127,206.413L374.442,205.713L376.288,206.455L376.61,204.293L377.133,204.962L380.787,203.233L383.036,203.725L385.467,201.661L386.019,201.909L385.983,202.447L386.733,202.381L386.703,200.967L387.452,200.274L389.92,200.101L391.057,199.37L390.653,198.658L389.865,198.924L389.362,198.451L390.583,196.768L391.805,198.478L392.229,198.313L391.963,197.262L392.438,197.048L395.015,197.796L396.007,199.211L397.551,199.396L398.169,201.165L399.485,201.343L398.978,202.94L400.991,202.799L401.435,203.363L403.257,203.341L404.26,202.308L406.039,202.359L406.434,201.593L407.808,201.61L408.437,200.806L409.933,200.368L414.303,200.368L414.871,199.465L416.058,200.248L416.395,199.813L420.119,199.211L421.313,195.604L420.576,195.371L420.248,194.137L421.378,191.221L422.244,190.784L421.713,190.285L423.683,190.124L425.531,188.676L426.313,189.38L427.475,189.038L427.134,188.134z"
				},
				{
					"id":"CD-SK",
					"title":"Sud-Kivu",
					"d":"M542.561,418.517L542.237,420.958L543.729,426.398L543.483,428.06L540.895,432.269L538.383,432.603L536.773,435.278L534.641,435.49L533.813,437.414L534.586,438.731L533.494,440.225L534.718,441.552L534.741,444.483L538.605,446.402L539.157,447.516L538.132,448.302L538.272,449.357L539.688,449.466L541.059,451.254L541.181,452.67L543.456,453.916L543.457,455.087L544.586,455.932L545.642,456.011L546.385,457.367L546.431,458.863L545.401,460.258L545.2,461.505L545.762,463.77L544.519,465.038L545.813,473.078L545.509,480.402L545.918,483.108L546.546,485.254L549.226,488.404L550.218,492.695L550.715,503.213L548.563,509.391L548.883,514.331L549.974,519.025L549.974,519.025L533.008,519.008L533.008,519.008L529.117,519.008L529.117,519.008L524.411,510.797L520.948,503.03L517.483,498.717L514.453,496.129L512.288,493.541L504.929,494.403L503.196,493.11L499.732,491.816L497.135,488.367L490.64,487.073L481.98,486.643L478.518,484.918L476.353,482.763L475.486,476.297L477.651,464.232L468.992,443.562L468.126,438.826L469.425,431.938L472.022,431.079L474.62,431.079L481.548,433.23L485.877,431.51L486.311,428.496L488.476,426.344L490.64,425.484L495.835,425.054L495.835,425.054L498.866,425.054L498.866,425.054L504.063,425.054L505.793,426.774L509.69,427.205L514.021,425.914L518.783,420.75L520.515,422.041L521.813,424.192L524.845,423.762L526.144,421.61L529.607,418.168L531.771,414.727L535.235,415.156L535.669,416.877L538.699,418.168z"
				},
				{
					"id":"CD-TG",
					"title":"Tanganyika",
					"d":"M593.783,618.643L591.897,615.114L590.995,614.492L587.426,604.233L583.666,596.429L581.617,590.961L577.763,583.711L576.006,581.099L572.844,577.756L563.443,570.479L559.067,564.216L557.141,559.055L556.642,555.679L556.605,549.792L557.539,543.568L557.263,540.242L555.054,532.271L552.135,525.481L549.974,519.025L533.008,519.008L516.224,519.008L450.508,519.008L450.331,520.772L448.557,524.403L445.645,528.292L444.522,531.47L446.625,535.147L444.552,537.5L444.122,539.614L444.692,540.805L447.621,543.933L447.157,546.793L447.531,551.868L446.305,553.798L447.756,557.452L447.096,558.991L446.395,559.427L444.268,559.352L444.009,562.597L443.323,563.968L441.496,564.652L440.354,566.709L439.212,570.363L439.896,573.562L441.725,576.988L442.866,579.501L444.009,582.928L445.836,584.07L448.577,585.669L451.775,586.354L454.06,588.182L455.431,591.38L454.06,593.664L453.375,596.405L455.431,600.061L458.857,601.66L463.654,601.432L466.167,602.345L467.995,603.487L473.249,603.716L478.503,603.259L480.102,601.66L486.27,600.746L492.666,601.203L493.123,603.259L493.58,608.741L494.722,611.254L497.235,612.168L499.748,613.539L502.032,614.681L503.859,616.736L503.631,619.479L501.575,620.392L500.661,622.737L503.859,624.336L507.058,627.763L508.657,630.732L511.398,629.818L513.226,626.849L515.51,625.707L517.566,626.62L519.622,624.107L520.536,618.396L521.449,613.6L520.308,611.315L518.023,609.031L519.165,606.975L522.363,606.062L526.247,607.203L528.531,609.259L530.358,612.914L532.187,615.427L534.928,615.655L536.983,614.514L539.496,612.457L541.78,611.544L545.893,611.087L549.319,608.803L552.061,609.259L553.888,611.087L554.802,612.229L558.686,613.371L560.741,614.514L561.883,617.939L561.198,621.138L558.913,623.194L558,625.021L556.676,627.228L570.119,625.28L574.069,625.147L594.924,622.326z"
				}
			]
		}
	}
};